
// Persistence of Vision Ray Tracer Scene Description File
// File: jars.inc
// Vers: 3
// Desc: a basic jar with several hight fields for writing on jars
// Date: 02/11/97
// Auth: Benny Wilkie
//


#declare solid_jar=

merge{

////////////////////////////this makes the sides of the jar///////////////////////

cylinder
{
  -1*y,  1*y,  .5
  translate z*.5
  translate x*.5


}

cylinder
{
  -1*y,  1*y,  .5
  translate z*-.5
  translate x*-.5
}

cylinder
{
  -1*y,  1*y,  .5
  translate z*-.5
  translate x*.5
}

cylinder
{
  -1*y,  1*y,  .5
  translate z*.5
  translate x*-.5
}


// connects the cylinders togeather
box
{
  <-.5, -1, -.5>  // one corner position <X1 Y1 Z1>
  < .5,  1,  .5>  // other corner position <X2 Y2 Z2>
  translate z*.5
}

// create a box that extends between the 2 specified points
box
{
  <-.5, -1, -.5>  // one corner position <X1 Y1 Z1>
  < .5,  1,  .5>  // other corner position <X2 Y2 Z2>
  translate z*-.5
}
// create a box that extends between the 2 specified points
box
{
  <-.5, -1, -.5>  // one corner position <X1 Y1 Z1>
  < .5,  1,  .5>  // other corner position <X2 Y2 Z2>
  translate x*.5
}
// create a box that extends between the 2 specified points
box
{
  <-.5, -1, -.5>  // one corner position <X1 Y1 Z1>
  < .5,  1,  .5>  // other corner position <X2 Y2 Z2>
  translate x*-.5
}
///////////////////////////top and bottom curves for the jar///////////////////////////////

// create a sphere shape
sphere
{
  <.5, 1, .5>
  0.5

}

// create a sphere shape
sphere
{
  <-.5, 1, -.5>
  0.5

}

// create a sphere shape
sphere
{
  <-.5, 1, .5>
  0.5

}

// create a sphere shape
sphere
{
  <.5, 1, -.5>
  0.5

}

///////////////////////


// create a sphere shape
sphere
{
  <.5, -1, .5>
  0.5

}

// create a sphere shape
sphere
{
  <-.5, -1, -.5>
  0.5

}

// create a sphere shape
sphere
{
  <-.5, -1, .5>
  0.5

}

// create a sphere shape
sphere
{
  <.5, -1, -.5>
  0.5

}
/////////////////////cylinders to connect the spheres togeather/////////////

 cylinder
{
  -.5*x,  .5*x,  .5
  translate z*.5
  translate y*1


}


 cylinder
{
  -.5*x,  .5*x,  .5
  translate z*-.5
  translate y*1


}


 cylinder
{
  -.5*z,  .5*z,  .5
  translate x*.5
  translate y*1


}


 cylinder
{
  -.5*z,  .5*z,  .5
  translate x*-.5
  translate y*1


}

///////////////////////////

 cylinder
{
  -.5*x,  .5*x,  .5
  translate z*.5
  translate y*-1


}


 cylinder
{
  -.5*x,  .5*x,  .5
  translate z*-.5
  translate y*-1


}


 cylinder
{
  -.5*z,  .5*z,  .5
  translate x*.5
  translate y*-1


}


 cylinder
{
  -.5*z,  .5*z,  .5
  translate x*-.5
  translate y*-1


}
////////////////////////////cylinder for the jar mouth////////////////////

 cylinder
{
  -.5*y,  .5*y,  .65
    translate y*1.5


}
//////////////////cylinder to fix glitch at bottom of the jar////////////////////

 cylinder
{
  -1.5*y,  0*y,  .65


}

}//end merge

//////////////////////////complete jar//////////////////////////////////////

#declare Jar=
merge{
difference{
object {solid_jar}
object {solid_jar
scale <.98,.98,.98>
}
 cylinder
{
  -.51*y,  .51*y,  .61
    translate y*1.5

}


}//diff

/////////////////////Peach Juice??? maybe pickle juice//////////////////


#declare Juice=

difference{
object {solid_jar
scale <.98,.98,.98>
}

box
{
  <-2, 0, -2>  // one corner position <X1 Y1 Z1>
  < 2,  2,  2>  // other corner position <X2 Y2 Z2>
}

texture {T_Dark_Green_Glass}
}//end merge

///////////////////////////////////end juice//////////////////////////////////
////////////////////////this is the lip below the threads ////////////////////

torus
{
  0.68,
  0.05

   scale <1, .5, 1>
  translate y*1.6

}

///////////////////////////////threads//////////////////////////////////////

merge{

difference{
torus{1, .03}

box
{
  <0, -2, -2>  // one corner position <X1 Y1 Z1>
  < 2,  2,  2>  // other corner position <X2 Y2 Z2>
}

translate z*-1
rotate x*2

}//end diff


difference{
torus{1, .03}

box
{
  <0, -2, -2>  // one corner position <X1 Y1 Z1>
  < 2,  2,  2>  // other corner position <X2 Y2 Z2>
}
rotate y*180
translate x*-.000000001  //this is to eliminate the "seam"
translate z*-1
rotate x*-2


}//end diff

//////////these spheres will round the ends of the threads///////////////////

sphere
{
  <0, 0, 0>
  0.03
  scale <2, 1, 1>
 translate z*-2
 rotate x*2

}


sphere
{
  <0, 0, 0>
  0.03
  scale <2, 1, 1>
 translate z*-2
 rotate x*-2

}


scale <.66, 1, .66>
translate y*1.8
translate z*.65


}//merge

}//end merge

/////////////////////////end thread///////////////////////////

//////////////////hight field for writing on jar///////////////
#declare Mason=

height_field
{
  gif
  "mason.gif"
translate <-.5, -1, -.5>

clipped_by
{
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <1.5, .1, 1.5>
rotate x*-90
translate z*-1.015

}


///////////////////////////end hight field/////////////////////////

#declare Ball=

height_field
{
  gif
  "ball.gif"
translate <-.5, -1, -.5>

clipped_by
{

box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <1.5, .1, 1.5>
rotate x*-90
translate z*-1.015

}


///////////////////////////end hight field/////////////////////////

#declare Kerr=

height_field
{
  gif
  "kerr.gif"
translate <-.5, -1, -.5>

clipped_by
{
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <1.5, .1, 1.5>
rotate x*-90
translate z*-1.015

}


///////////////////////////end hight field/////////////////////////

#declare Atlas=

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "atlas.gif"     // the file name to read
translate <-.5, -1, -.5>

clipped_by
{

box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate y*.5
}
}
scale <1.5, .1, 1.5>
rotate x*-90
translate z*-1.015

}


///////////////////////////end hight field/////////////////////////


//////////////////////////////////end jar//////////////////////////////

///////////////////////////make the lid for the jar////////////////////

#declare Lid=

difference{
object {Jar
scale <1.01, 1.01, 1.01>
}
object {Jar}
box
{
  <-1.5, -1.65, -1.5>  // one corner position <X1 Y1 Z1>
  < 1.5,  2,  1.5>  // other corner position <X2 Y2 Z2>

}
pigment {Green}//texture
}//end diff

////////////////////////////end lid//////////////////////////////


#declare Mason_Jar=

merge{
object {Jar}//basic jar no writing on side
object {Mason}///hight field for golden harvest mason

}

#declare Atlas_Jar=

merge{
object {Jar}//basic jar no writing on side
object {Atlas}///hight field for atlas ez seal



}

#declare Ball_Jar=

merge{
object {Jar}//basic jar no writing on side
object {Ball}///hight field for atlas ez seal



}

#declare Kerr_Jar=

merge{
object {Jar}//basic jar no writing on side
object {Kerr}///hight field for atlas ez seal



}






