


//Begin "Ashtray" object centered on 0,0 for x,z and from 0 to 1.2 high or in y  Dim: 6x6 square 1.2 high
//Begin "Smoke" object Dim: around 5 x 5 and 10 high ; centered on origin
//Begin "BeerBottle" object bottom centered on 0,0,0  limits: 12 units high  4.1 units wide (ie.. radius 2.05 units)
//Begin "CBottle" object bottom centered on 0,0,0  limits: 6.6 units high  2.25 units wide (ie.. radius 1.125 units)
//Begin "ColaLabel" object bottom centered on 0,0,0  limits: 9 units high  2.25 units wide (ie.. radius 1.125 units)
//Begin "CokeBottle" object bottom centered on 0,0,0  limits: 6.6 units high  2.25 units wide (ie.. radius 1.125 units)
//Begin "Candle" Object  Dim: 6x6.7x6   Bottom centered on origin
//Begin "Plant" object,  potted house plant roughly bounded by cylinder with height 36 radius 18 and bottom centered
//       on origin, need "stones.inc"
//Begin "TV" object Dim: 25x21x14 bottom at y=0 centered on xz 0,0
//Begin "TVStand" object  Dim: 30.8x20x17.6   bottom at origin with xz centered on origin  requires "woods.inc"
//Begin "Table" Object with Bottom of Legs at Y=0 the table then goes -30<x<30,-12<z<12,0<y<18
//begin "LRoom" object.  Dim: x= -90 to 90 ; y= 0 to 96 ; z= 0 to 180
//Begin "Couch" object   Dim: -40<x<40, 0<y<22, 0<z<34
//Begin "Person" object  S/He goes on the couch
//Begin "Speaker" object Dim: 24x36x16 bottom centered on the origin
//Begin "Stereo" object Dim: 18x5x12  Bottom centered on the origin
//Begin "Book" object Dim: 4.75x1.125x9.5 bottom centered on origin
//object "Poster" Dim: 52x39x1 bottom and back edge on origin








//******************************************************************************************************
//Begin "Ashtray" object centered on 0,0 for x,z and from 0 to 1.2 high or in y  Dim: 6x6 square 1.2 high
#declare Ashtray =

difference {

// extrude a closed 2-D shape along an axis
prism {
       conic_sweep // or conic_sweep for tapering to a point
       linear_spline // linear_spline | quadratic_spline | cubic_spline
       0.7,        // height 1
       1,        // height 2
       5,          // number of points
       <4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>

       sturm
       translate <0,-.7,0>
       scale <1,4,1>

}

// extrude a closed 2-D shape along an axis
prism {
       conic_sweep // or conic_sweep for tapering to a point
       cubic_spline // linear_spline | quadratic_spline | cubic_spline
       0.7,        // height 1
       1,        // height 2
       7,          // number of points
       <4,-4>,<4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>,<-4,4>

       sturm
       translate <0,-.65,0>
       scale <.8,4,.8>
      }

cylinder {<6,1.2,0> <-6,1.2,0> ,.4
          rotate 45*y}

cylinder {<6,1.2,0> <-6,1.2,0> ,.4
          rotate -45*y}

texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color Turquoise filter 1}
         }
scale <3/4,1,3/4>

}
//End Ashtray Object
//**************************************************************************



//********************************************************************************************************
//Begin "Ashes" object Dim: .3 high height field 2.2 radius, laid on y plane at y=0 centered on the origin

#declare Ashes =

intersection {
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>


height_field
{
  tga "HFash.tga"
  texture
  {
    pigment
           {
            image_map { tga "Bmash.tga" map_type 0 interpolate 2 once }
            rotate x*90 // lay X-Y image map down onto X-Z height field plane
           }
    finish {crand .1}
  }
  translate <-.5,0,-.5>
 scale  <8,.3,8>
 //rotate -90*x
}

cylinder {<0,0,0>,<0,3,0>,2.2 }
}

//End Ashes object
//*******************************************************



//*********************************************************************
//Begin "Smoke" object Dim: around 5 x 5 and 10 high ; centered on origin

#declare Smoke =
   sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 2
      color_map {
        [ 0 color rgbt <1, 1, 1, 1> ]
        [ 1 color rgbt <1, 1, 1, 0> ]
      }
      samples 10
      scale .5
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence <3,2,3>
      color_map {
        [ 0 color rgbt <1, 1, 1, 1> ]
        [ 1 color rgbt <1, 1, 1, 0> ]
      }
      samples 10
      scale <1/3,.5,1/3>
      rotate 150*y
    }
    hollow
    scale <.5,1,.5>
    scale 5
  }

//End Smoke object
//***********************************************************************



//***********************************************************************************************************
//Begin "BeerBottle" object bottom centered on 0,0,0  limits: 12 units high  4.1 units wide (ie.. radius 2.05 units)

//Begin Front Half

#declare Dangle = 0  //angle in degrees
#declare BotRadius = 75   //bottle radius (not really)

#declare BeerBottleF = union{     //union{

difference {  //Bottom of the bottle
             cylinder {<0,-70,0> <0,-75,0>, BotRadius*.7
                      }


             sphere {<0,0,0>,45         //inverted dome on bottom of bottle, nobody sees it but it's there
                     scale <1,.1,1>
                     translate <0,-75,0>
                    }
             hollow     //keeps label from filling the bottle
           }



torus { 49,5     //bottom of bottle
        translate <0,-73,0>
      }

lathe    //body and neck of bottle
{
     cubic_spline
     12, // # of points
    <52.5,-184>
    <52.5,-145>
    <52.5,1.4>
    <48,35>
    <28,55>
    <20,105>
    <17,128>
    <19,129>
    <19,133>
    <18,137>
    <17,140>
    <17,175>
    translate <0,70,0>
}

torus {17,3    //top of bottle
       translate <0,213,0>
      }



hollow


texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color rgbf <0.85, 0.85, 0.8, 0.8> }
         }

texture { pigment {image_map      //attempt to put on a label
                            {
                             gif "nakedlbl.gif"
                             map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                             interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                             //filter 0, 1.0// [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
                             // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
                             once  // [once]
                            }
                   translate <-.5,0,0>
                   scale <70,70,.1>
                   scale <5/4,1,1>
                   translate <0,-10,0>
                  }
         }

translate <0,78,0>     //place on y=0 plane
scale .042             //size to approximately 9x4
}


//}

//End Front Half


//Begin "BeerBottleBack" object bottom centered on 0,0,0  limits: 12 units high  4.1 units wide (ie.. radius 2.05 units)

#declare Dangle = 0  //angle in degrees
#declare BotRadius = 75   //bottle radius (not really)

#declare BeerBottleB = union{   //union{

difference {  //Bottom of the bottle
             cylinder {<0,-70,0> <0,-75,0>, BotRadius*.7
                      }


             sphere {<0,0,0>,45         //inverted dome on bottom of bottle, nobody sees it but it's there
                     scale <1,.1,1>
                     translate <0,-75,0>
                    }
             hollow     //keeps label from filling the bottle
           }



torus { 49,5     //bottom of bottle
        translate <0,-73,0>
      }

lathe    //body and neck of bottle
{
     cubic_spline
     12, // # of points
    <52.5,-184>
    <52.5,-145>
    <52.5,1.4>
    <48,35>
    <28,55>
    <20,105>
    <17,128>
    <19,129>
    <19,133>
    <18,137>
    <17,140>
    <17,175>
    translate <0,70,0>
}

torus {17,3    //top of bottle
       translate <0,213,0>
      }



hollow


texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color rgbf <0.85, 0.85, 0.8, 0.8> }
         }

texture { pigment {image_map      //attempt to put on a label
                            {
                             gif "Backlbl.gif"
                             map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                             interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                             //filter 0, 1.0// [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
                             // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
                             once  // [once]
                            }
                   translate <-.5,0,0>
                   scale <70,70,.1>
                   scale <5/4,1,1>
                   translate <0,-10,0>
                  }
         }

translate <0,78,0>     //place on y=0 plane
scale .042             //size to approximately 9x4
}



//}
//End Back half

#declare BeerBottle = union {
       difference {
                   object {BeerBottleF}
                   plane {-z,-0.1 pigment {Clear}}
                  }
       difference {
                   object {BeerBottleB}
                   plane {z,-0.1 pigment {Clear}}
                  }
       difference {   //This is the Bug Powder Lager
                   cylinder {<0,-30,0> <0,-75,0>, BotRadius*.7*.95
                            }

                   sphere {<0,0,0>,45
                           scale <1,.1,1>
                           translate <0,-74,0>
                          }
                   translate 78*y
                   pigment {
                            granite
                            color_map {
                                       [ .95 rgbft <1,1,0,1,.3>]
                                       [1 Clear]
                                      }
                            scale .1
                           }
                   finish {
                           ambient 0.1
                           diffuse 0.1
                           reflection .25
                           refraction 1
                           ior 1.33
                           specular 1
                           roughness 0.001
                          }

                   scale .042
                  }

}
//End BeerBottle object
//****************************************************************************


//***********************************************************************************************************
//Begin "CBottle" object bottom centered on 0,0,0  limits: 6.6 units high  2.25 units wide (ie.. radius 1.125 units)

#declare Dangle = 0  //angle in degrees
#declare BotRadius = 75   //bottle radius (not really)

#declare CBottle = union{

difference {     //  main body
             cylinder {<0,70,0> <0,-75,0>, BotRadius*.7
                       hollow
                      }
             #while (Dangle<360)

                 #declare Angle = radians(Dangle)
                 #declare X = cos(Angle)*BotRadius
                 #declare Z = sin(Angle)*BotRadius
                 #declare Y = 0


                 // Sphere object
                 sphere { 0, 100
                         scale <.3,1,.3>
                         translate <X,Y,Z>
                        }


                 #declare Dangle = Dangle + 18
             #end

             sphere {<0,0,0>,45
                     scale <1,.1,1>
                     translate <0,-75,0>
                    }
           }

torus { 49,5     //bottom of bottle
        translate <0,-73,0>
      }

lathe    //neck of bottle
{
    cubic_spline
    12, // # of points
    <BotRadius*.7,-14>
    <BotRadius*.7,-5>
    <BotRadius*.7,1.4>
    <40,35>
    <28,63>
    <20,105>
    <17,128>
    <19,129>
    <19,133>
    <18,137>
    <17,140>
    <17,175>
    translate <0,70,0>
}

torus {17,3    //top of bottle
       translate <0,213,0>
      }

hollow
texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color rgbf <0.4, 0.9, 0.4, 0.8> }
         }


translate <0,78,0>     //place on y=0 plane
scale .042             //size to approximately 6.6x2
scale <.55,.55,.55>
}

//End CBottle
//******************************************************************************

//***********************************************************************************************************
//Begin "ColaLabel" object bottom centered on 0,0,0  limits: 9 units high  2.25 units wide (ie.. radius 1.125 units)

#declare Dangle = 0  //angle in degrees
#declare BotRadius = 75   //bottle radius (not really)
#declare Neck = lathe    //neck of bottle
            {
             cubic_spline
             12, // # of points
             <BotRadius*.7,-14>
             <BotRadius*.7,-5>
             <BotRadius*.7,1.4>
             <40,35>
             <28,63>
             <20,105>
             <17,128>
             <19,129>
             <19,133>
             <18,137>
             <17,140>
             <17,175>
            }
#declare Label =    //Lettering
       intersection {
                     text
                         {
                          ttf          // font type (only TrueType format for now)
                          "pixiefon.ttf",  // Microsoft Windows-format TrueType font file name
                          "K&K Cola",   // the string to create
                          60,           // the extrusion depth
                          0            // offset
                          translate <-2.5,0,-60>
                          rotate 15*z
                          scale <17,17,1>
                          translate 27*y
                         }
                     object {Neck}
                     translate -1*z
                    }

#declare ColaLabel =

difference {  //neck of bottle

            union {
                   object {Label}
                   object {Label rotate 120*y}
                   object {Label rotate 240*y}
                  }

            object {Neck scale .99}
            translate <0,70,0>
            texture {pigment {White}}
            translate <0,78,0>     //place on y=0 plane
            scale .042             //size to approximately 9x2
            scale <.55,.55,.55>
           }

//End ColaLabel
//******************************************************************************




//***********************************************************************************************************
//Begin "CokeBottle" object bottom centered on 0,0,0  limits: 6.6 units high  2.25 units wide (ie.. radius 1.125 units)


#declare CokeBottle = union {
                             object {CBottle}
                             object {ColaLabel}
                            }

//End CokeBottle
//******************************************************************************

//******************************************************************
//Begin "Candle" Object  Dim: 6x6.7x6   Bottom centered on origin

#declare Hex=            //Part of the Soccer Ball
prism {
  conic_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  0.3,        // height 1
  1,        // height 2
  7,          // number of points

    <cos(radians(30)),sin(radians(30))>,<cos(radians(90)),sin(radians(90))>,
    <cos(radians(150)),sin(radians(150))>,<cos(radians(210)),sin(radians(210))>,
    <cos(radians(270)),sin(radians(270))>,<cos(radians(330)),sin(radians(330))>,
    <cos(radians(30)),sin(radians(30))>

translate <0,-1,0>
scale <1,.5,1>
translate <.5*sqrt(3),0,0>
rotate (90-degrees(asin(1/sqrt(3))))*z
translate <.5,0,0>
}


#declare Square=         //Part of the Soccer Ball
prism {
  conic_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  0.5,        // height 1
  1,        // height 2
  5,          // number of points

    <cos(radians(45)),sin(radians(45))>,<cos(radians(135)),sin(radians(135))>,
    <cos(radians(225)),sin(radians(225))>,<cos(radians(315)),sin(radians(315))>,
    <cos(radians(45)),sin(radians(45))>

translate <0,-1,0>
scale <sqrt(2)/2,.5,sqrt(2)/2>
}

#declare Candle = union {

union {                     //Lead Crystal Soccer Ball Sphere
       union {
              object {Hex}
              object {Hex  rotate 90*y}
              object {Hex  rotate 180*y}
              object {Hex  rotate 270*y}
              object {Square}
              object {Square
                      rotate 180*x
                      translate -.5*y
                     }
             }


       union {
              object {Hex}
              object {Hex  rotate 90*y}
              object {Hex  rotate 180*y}
              object {Hex  rotate 270*y}
              rotate 180*x
              translate 2*sqrt(2)*y
             }
       translate .5*y
       texture {
                pigment { color rgbf <0.95, 0.95, 0.98, 0.9> }
                finish  {
                         ambient 0.01
                         diffuse 0.01
                         reflection 0.01
                         refraction 1
                         ior 1.45
                         irid
                             {
                              .25           // amount of iridescence saturation (0...1) [0]
                              thickness 0.2
                              turbulence 0.7
                             }
                         specular .01//0.8
                         roughness 0.003
                         phong 1
                         phong_size 400
                        }
              }
      }
        union {
               sphere {0,.5
                       scale <1,1,.2>
                       translate <0,sqrt(2),sqrt(2)>
                       rotate 45*y
                      }
               sphere {0,.5
                       scale <1,1,.2>
                       translate <0,sqrt(2),sqrt(2)>
                       rotate 135*y
                      }
               sphere {0,.5
                       scale <1,1,.2>
                       translate <0,sqrt(2),sqrt(2)>
                       rotate 225*y
                      }
               sphere {0,.5
                       scale <1,1,.2>
                       translate <0,sqrt(2),sqrt(2)>
                       rotate 315*y
                      }
               texture {
                        pigment { agate
                                  color_map {
                                             [ .9 rgbf <.8,.8,.98,.9> ]
                                             [ .9 rgbf <0.5, 0.98, 0.5, 0.5>]
                                             [1.0 rgbf <0.5, 0.98, 0.5, 0.5>]
                                            }
                                 scale .1
                                }
                        finish  {
                                 ambient 0.01
                                 diffuse 0.01
                                 reflection 0.1
                                 refraction 1
                                 ior 1.45
                                 irid
                                     {
                                      .2            // amount of iridescence saturation (0...1) [0]
                                      thickness 0.1
                                      turbulence 0.7
                                     }
                                 specular 0.8
                                 roughness 0.003
                                 phong 1
                                 phong_size 400
                                 caustics .2
                                }
                        }
                translate .5*y
               }

sphere { 0, 1                     //Flame
        pigment { color rgbt <1, 1, 1, 1> }
        halo {
              emitting
              spherical_mapping
              linear
              turbulence 1
              color_map {
                         [ 0 color rgbt <1, 0, 0,  1.0> ]
                         [ 1 color rgbt <1, 1, 0, -1.0> ]
                        }
              samples 10
              scale 0.5
              rotate 180*y
             }
        halo {
              emitting
              spherical_mapping
              linear
              turbulence 1
              color_map {
                         [ 0 color rgbt <1, 0, 0,  1.0> ]
                         [ 1 color rgbt <1, 1, 0, -1.0> ]
                        }
              samples 10
              scale <0.5,.25,.5>
             }
        hollow
        scale <.25,1.5,.25>
        translate 1.5*y
       }

light_source {<0, 1.5, 0>
              color White*.1
              fade_distance 45
              fade_power 1
             }

cylinder {<0,.5,0> <0,1.25,0>,.35
          pigment {radial
                   frequency 2
                  }
         }
scale 2
}

//End Candle object
//*********************************************************


//**********************************************************
//Begin "Plant" object,  potted house plant roughly bounded by cylinder with height 36 radius 18 and bottom centered on origin
//need "stones.inc"
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now set all of the variables for the tree. read "ptd_tree.txt" to
// find out what all these things do!

        #declare TREE_RAND = seed(0)
        #declare Wiggle_Flag = on
        #declare Branches_On_End_Flag = on

        #declare Number_Of_Large_Branches = 4
        #declare Number_Of_Medium_Branches = 3
        #declare Number_Of_Small_Branches = 16

        #declare Large_Branch_Minimum_Angle = 45
        #declare Large_Branch_Maximum_Angle = 90

        #declare Medium_Branch_Minimum_Angle = 45
        #declare Medium_Branch_Maximum_Angle = 135

        #declare Small_Branch_Minimum_Angle = 45
        #declare Small_Branch_Maximum_Angle = 135

        #declare Tree_Trunk_Size = 45

        #declare Large_Branch_Size_Min = 10
        #declare Large_Branch_Size_Max = 20

        #declare Medium_Branch_Size_Min = 1
        #declare Medium_Branch_Size_Max = 10

        #declare Small_Branch_Size_Min = 10
        #declare Small_Branch_Size_Max = 20

        #declare Leaf_Type = 0


        #declare Leaf_Texture = texture { T_Stone21 scale 0.5 }
        #declare Bark_Texture = texture { pigment {DarkGreen}//T_Stone18
                normal { bumps 2.0 scale 0.1 } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now go and build the tree, then show it.

        #include "ptd_tree.inc"

#declare Plant = union {

object { Complete_Tree rotate y * 180 scale .15}


cone { 0,1.5,<0,2,0>,2
       open
       pigment {rgb <.9,.4,.25>}
       finish { phong 0.1 phong_size 1 crand .1}
     }


difference {
cone { <0,2,0>,2.15,<0,2.25,0>,(2.15+.25*.25)
     }
cone { <0,1.9,0>,2,<0,2.35,0>,(2.15+.25*.25)
       scale <2/2.15,1,2/2.15>
     }
       pigment {rgb <.9,.4,.25>}
       finish { phong 0.1 phong_size 1 crand .1}
           }

cone { <0,2,0>,2,<0,2.15,0>,2.15
       scale <2/2.15,1,2/2.15>
       texture {T_Stone10}
       normal {bumps scale .1}
     }

scale 3
}

//End Plant object
//*********************************************************

//*****************************************************************
// Begin "TV" object Dim: 25x21x14 bottom at y=0 centered on xz 0,0

#declare TV= union {

difference {

superellipsoid { <0.3, 0.3>
                 texture { pigment { Black }
                           finish { ambient 0.2
                                    diffuse 0.4
                                    phong 0.5
                                    phong_size 5 }
                                   }
                 scale <1.35,1.5,1>
               }

box {<1,1,2>,<-1,-1,-2>
     translate -1*z
    }

prism {
  conic_sweep
  linear_spline
  1,        // height 1
  2,        // height 2
  5,          // number of points
  // the <u,v> points
  <-1,-1>,<1,-1>,<1,1>,<-1,1>,<-1,-1>

  rotate -90*x
  translate .125*z
}

           }



superellipsoid { <0.3, 0.3>
                 texture { pigment {
                                    image_map
                                             {
                                               tga "tvpic.tga" // the file to read (iff/gif/tga/png/sys)
                                               map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                               interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                                               once
                                              }
                                    translate <-.5,-.5,0>
                                    scale 1.7
                                   }
                           finish { ambient 1
                                   }
                          }
                  scale <1.2,1.2,.9>
               }


superellipsoid { <0.3, 0.3>
                 texture { pigment { Black }
                           finish { ambient 0.2
                                    diffuse 0.4
                                    phong 0.5
                                    phong_size 5 }
                         }
                 scale <1.35,0.2,1>
                 translate -1.4*y
               }

#declare Button =
sphere { 0,.0375
         translate <.25,-1.4,-1>
         texture { pigment { Black }
                   finish { ambient 0.2
                            diffuse 0.4
                            phong 0.5
                            phong_size 5
                          }
                 }
       }

#declare Cuba = 0
#while (Cuba<=.5)
       object{Button translate Cuba*x}
       #declare Cuba=Cuba+.1
#end


scale <11/8,1,1>
translate 1.6*y
scale 7
}

//End TV object
//**********************************************************


//***********************************************************************************************************
//Begin "TVStand" object  Dim: 30.8x20x17.6   bottom at origin with xz centered on origin  requires "woods.inc"

#declare TVStand = union {

union {
box {<-14,0,-8> <14,1,8>  //bottom
     scale <1.1,1,1.1>
    }
box {<-14,0,-8> <14,1,8>  //top
     translate 19*y
    }
box {<-13,0,-7> <13,1,7>   //shelf
     translate 10*y
    }
texture {T_Wood8
         rotate 90*y
        }
}

union {
box {<-14,1,-8> <-13,19,8> }  //left side
box {<-14,1,-8> <-13,19,8>    //right side
     translate 27*x
    }
texture {T_Wood8
         rotate 90*y
         rotate 90*z
        }
}

box {<-13,1,7> <13,19,8> pigment {MediumWood}}  //Back


box {<-12.75,1.25,.125> <-.125,18.75,-.125>    //left pane of glass
     texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .1//.25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color rgbf <.8,.8,.8,.8>}//<0.85, 0.85, 0.8, 0.8> }
         }
      translate -7.875*z
     }

box {<-.125,18.75,-.13> <-1.125,17.25,.13>
     texture {T_Gold_5E}
     translate -7.875*z
    }


box {<-12.75,1.25,.125> <-.125,18.75,-.125>     //right pane of glass
     texture {     //glass  texture
         finish {
                 ambient 0.1
                 diffuse 0.1
                 reflection .1//.25
                 refraction 1
                 ior 1.5
                 specular 1
                 roughness 0.001
                }

          pigment { color rgbf <.8,.8,.8,.8>}//<.85, 0.85, 0.8, 0.8> }
         }
      rotate 180*y
      translate -7.875*z
     }

box {<-.125,18.75,-.13> <-1.125,17.25,.13>
     texture {T_Gold_5E}
     rotate 180*y
     translate -7.875*z
    }


cylinder {<-12.75,1,0> <-12.75,19,0> , .25     //Swivel rods for glass
          texture {T_Gold_5E}
          translate -7.875*z
         }
cylinder {<12.75,1,0> <12.75,19,0> , .25
          texture {T_Gold_5E}
          translate -7.875*z
         }

}

//End TVStand object
//*****************************************************************

//*****************************************************************************************
//Begin "Table" Object with Bottom of Legs at Y=0 the table then goes -30<x<30,-12<z<12,0<y<18

#declare Leg = union {    //define Legs
     box
        {<-30,-12,.5>
         <-27,-9,4>
         texture {
                  pigment { rgb <.66,.66,.66> }
                  finish {
                          ambient 0.1
                          diffuse .3
                          reflection .3
                          brilliance 6
                          specular 0.8
                          roughness .1
                          phong 1
                          phong_size 400
                         }
                 }
        }
     sor
       {
        11, // # of points
        <0, 0> // list of <u,v> points
        <.7, 0>
        <.7, 5>
        <1.5, 6>
        <1,7>
        <1.1, 9>
        <1.2, 10.5>
        <1.3, 11>
        <1.45,12>
        <1.45,17>
        <1.45,17>
        sturm
        translate -18*y
        rotate -90*x
        translate <-28.5,-10.5,0>
        texture {T_Copper_1A}

    }
}

// create a Surface of Revolution shape (like lathe, but faster)


#declare Table = union {
merge {   //define table top
       box                         //Glass Top
          {
           <-28, -10, 0>  // one corner position <X1 Y1 Z1>
           < 28,  10,  .5>  // other corner position <X2 Y2 Z2>
           texture {
                    finish {
                            ambient 0.1
                            diffuse 0.1
                            reflection .45//.25
                            refraction 1
                            ior 1.5
                            specular 1
                            roughness 0.001
                           }
                    pigment { color rgbf <0.8, 0.85, 0.85, 0.85> }
                   }
          }

       difference {                     //Chrome Table
                   box
                      {
                       <-30, -12, 0>  // one corner position <X1 Y1 Z1>
                       < 30,  12,  3>  // other corner position <X2 Y2 Z2>
                      }
                   box
                      {
                       <-27, -9, -1>  // one corner position <X1 Y1 Z1>
                       < 27,  9,  4>  // other corner position <X2 Y2 Z2>
                      }
                   texture {
                            pigment { rgb <.66,.66,.66> }
                            finish {
                                    ambient 0.1
                                    diffuse .3//0.7
                                    reflection .3//0.45
                                    brilliance 6
                                    specular 0.8
                                    roughness .1//0.001
                                  }
                          }

                  }
      }



//Add Legs
object {Leg}
object {Leg translate y*21}
object {Leg translate x*57}
object {Leg translate <57,21,0>}
rotate 90*x
translate 18*y
}

//End Table Object
//************************************************************************



//*******************************************************************
//begin "LRoom" object.  Dim: x= -90 to 90 ; y= 0 to 96 ; z= 0 to 180

#declare LRoom = union {
difference {   //The living room walls
box {<-100,-60,-100> <140,60,100>}

box {<-90,-48,-90> <90,48,90>
    }


box {<80,-48,85> <140,32,53>
    }

pigment {White*.6}//.5}
translate <0,48,90>

}


difference {     //A border around the bottom of the living room walls

box {<-100,-60,-100> <140,-43,100>}

difference {
            box {<-89,-48,-89> <89,48,89>}
            cylinder {<-90,-44,89> <90,-44,89>,.5}
            cylinder {<-90,-44,89> <90,-44,89>,.5 rotate 90*y}
            cylinder {<-90,-44,89> <90,-44,89>,.5 rotate 180*y}
            cylinder {<-90,-44,89> <90,-44,89>,.5 rotate 270*y}
           }

difference {
            box {<80,-48,84> <140,32,54>}
            cylinder {<80,-44,84><140,-44,84>,.5}
            cylinder {<80,-44,54><140,-44,54>,.5}
           }


pigment {MediumWood}
translate <0,48,90>

}

plane {-y,-95.5
       texture {
                pigment {
                         brick White*.2, White*.5
                         brick_size <12, 12, 5>
                         mortar .5
                        }
                rotate 90*x
               }
      }

plane {y,.025             //Floor
       texture {
                pigment {
                         image_map
                                  {
                                   tga "carpet2.tga" // the file to read (iff/gif/tga/png/sys)
                                   map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                   interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                                  } // image_map
                         rotate 90*x
                         scale 20
                        }
                 finish { crand .3}
                }
       }
}


//End Lroom object
//*****************************************************************



//********************************************************************
//Begin "Couch" object   Dim: -40<x<40, 0<y<22, 0<z<34

#declare Couch = union {


union {
superellipsoid { <0.3,  // east-west exponent (0.0 ... 1.0)  //side
                 0.3>  // north-south exponent (0.0 ... 1.0)
                 scale <2.5,11,17>
                 translate <-37.5,0,15.5>
               }
superellipsoid { <0.3,  // east-west exponent (0.0 ... 1.0)    //side
                 0.3>  // north-south exponent (0.0 ... 1.0)
                 scale <2.5,11,17>
                 translate <37.5,0,15.5>
               }
pigment {
         image_map {
                    tga "wbrown16.tga" // the file to read (iff/gif/tga/png/sys)
                    map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                    interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                   } // image_map
         rotate 90*y
         scale 5
        }
}


union {
superellipsoid { <0.2,  // east-west exponent (0.0 ... 1.0)    //Back
                 0.2>  // north-south exponent (0.0 ... 1.0)
                 scale <35,11,1.5>
               }
superellipsoid { <0.2,  // east-west exponent (0.0 ... 1.0)  //bottom
                 0.2>  // north-south exponent (0.0 ... 1.0)
                 scale <35,4,17>
                 translate <0,-7,17>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)  //pillow middle
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,5,4>
                 translate <0,6,5.5>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)   //pillow right
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,5,4>
                 translate <23.33,6,5.5>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)  //pillow left
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,5,4>
                 translate <-23.33,6,5.5>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)   //seat cushion middle
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,4,15.5>
                 translate <0,-1,17>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)    //seat cushion right
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,4,15.5>
                 translate <23.33,-1,17>
               }
superellipsoid { <0.5,  // east-west exponent (0.0 ... 1.0)    //seat cushion left
                 0.5>  // north-south exponent (0.0 ... 1.0)
                 scale <11.5,4,15.5>
                 translate <-23.33,-1,17>
               }
pigment {
         image_map {
                    tga "wbrown16.tga" // the file to read (iff/gif/tga/png/sys)
                    map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                    interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                   } // image_map
         scale 5
        }
}

translate <0,11,1.5>
}


//End Couch object
//*******************************************************************************



//*******************************************************************************
//Begin "Person" object  S/He goes on the couch


#declare Person =
union {
      blob { threshold .5
            cylinder { <-4,3,37.5><-4,15,34.5>, 4, 1   //left calf
                     }
            cylinder { <4,3,37.5><4,15,34.5>, 4, 1     //right calf
                     }
            cylinder {<-4,18,33.5><-3,12,18.5>,5,1     //left thigh
                     }
            cylinder {<4,18,33.5><3,12,18.5>,5,1     //right thigh
                     }
            pigment {
                     image_map
                              {
                               tga "jeans.tga" // the file to read (iff/gif/tga/png/sys)
                               map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                               interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                               // [once]
                              } // image_map
                      scale <4,18,1>
                      translate <2,2,0>
                    }
           }
      blob { threshold .5   //shoes
             sphere {0,3,1
                     scale <1,1,4>
                     translate <-4,.5,39.5>
                    }
             cylinder {<-4,0,37.5> <-4,4,37.5>, 3, 1}
             sphere {0,3,1
                     scale <1,1,4>
                     translate <4,.5,39.5>
                    }
             cylinder {<4,0,37.5> <4,4,37.5>, 3, 1}
             pigment {Brown}
           }
      blob { threshold .5
            cylinder {<0,15,18.5><0,28,18.5>,6,1     //body
                      scale <1.5,1,1>
                     }
            cylinder {<-5,28,17.5><-10,19,18.5>,3,1  //upper left arm
                     }
            cylinder {<5,28,17.5><10,19,18.5>,3,1  //upper right arm
                     }
            pigment {
                     image_map
                              {
                               tga "shirt.tga" // the file to read (iff/gif/tga/png/sys)
                               map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                               interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                               // [once]
                              } // image_map
                      scale <6,15,1>
                      translate <3,0,0>
                     }
           }
      blob { threshold .5
            cylinder {<-10,19,18.5><-10,16,27>,2,1  //lower left arm
                       pigment {Flesh}
                      }
            cylinder {<10,19,18.5><10,16,27>,2,1   //lower right arm
                      pigment {Flesh}
                     }
           }

      cylinder {<0,30,18.5><0,33,18.5>,2    //neck
                pigment {Flesh}
               }

      sphere { 0,4                //head
               scale <.8,1,.8>
               rotate -10*x
               pigment {
                        image_map
                                 {
                                  tga "face.tga" // the file to read (iff/gif/tga/png/sys)
                                  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                                  once
                                 } // image_map
                        translate <-.5,-.5,0>
                        scale <8,8,1>
                        scale <.8,1,1>
                       }
              translate <0,36,20>
            }
//rotate -90*y
}

//End Person object
//************************************



//*********************************************************************
//Begin "Speaker" object Dim: 24x36x16 bottom centered on the origin

#declare Speaker = union {

box {<-12,0,-8> <12,36,8>
     texture {T_Wood8
              finish {ambient .7}
              rotate 90*y
              rotate 90*z
             }
    }

prism {
       conic_sweep
       linear_spline
       1,        // height 1
       .85,        // height 2
       5,          // number of points
       // the <u,v> points
       < -1, -1.5>, < 1, -1.5>, < 1, 1.5>, < -1, 1.5>, < -1, -1.5>
       sturm
       translate -1*y
       rotate  90*x
       scale <12,12,13.3>
       translate <0,18,-8>
       pigment {White*.05}
       normal {bump_map
                       {
                        tga "screen.tga"
                        map_type 0
                        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                       }
               scale 50
              }
      }

}

//End of Speaker object
//********************************************************************************




//*******************************************************************
//Begin "Stereo" object Dim: 18x5x12  Bottom centered on the origin

#declare Stereo = union {

box {<-9,0,-6> <9,5,6> pigment {Black} }

cylinder {<-6.5,2.5,-7> <-6.5,2.5,0>, 1.5
          texture {T_Brass_3C}
         }

#declare Button =
sphere { 0,.3
         translate <-1,4,-6>
         texture {T_Brass_3C}
       }

#declare Cuba = 0
#while (Cuba<=8)
       object{Button translate Cuba*x}
       #declare Cuba=Cuba+1
#end

box {<-4,1,-6.125> <-1,2.5,-5>
     texture {  // pigment {Red}}  //glass  texture
              finish {
                      ambient 0.1
                      diffuse 0.1
                      reflection .1
                      specular 1
                      roughness 0.001
                     }

              pigment { color rgbf <.8,.8,.8,.8>}
             }

    }


// create a TrueType text shape
text
{
  ttf          // font type (only TrueType format for now)
  "timrom.ttf",  // Microsoft Windows-format TrueType font file name
  "105.9",   // the string to create
  2,           // the extrusion depth
  0            // offset
  translate <-3.6,1.375,-6.126>
  finish {ambient 1}
  pigment {Red}
}

#declare R1= seed(0)
#declare Cuba = 0
#while (Cuba < 9)

#declare Italy = (1/16)*Cuba*Cuba+(-1/2)*Cuba+1.5+rand(R1)/2
box {0, 1
     scale <.5,Italy,1>
     translate <Cuba-.25,1,-6.125>
     pigment {
              gradient y // specify color_map direction(s)
              color_map {
                         [0 color rgb <0,1,0>]
                         [1 color rgb <1,0,0>]
                        }
              scale 2
              translate 1*y
             }
     finish { ambient 1 }
    }
#declare Cuba = Cuba + 1
#end

}

//*******************************************************************************




//****************************************************************************
//Begin "Book" object Dim: 4.75x1.125x9.5 bottom centered on origin

#declare Book = union {

difference {
union {
       difference {
                   box { -1,1
                         scale <3.875,.0625,4.75>
                         translate -0.0625*x
                       }
                   cylinder {<-3.8125,1.0625,-5>,<-3.8125,1.0625,5>,.0625
                             translate -1.15625*y
                            }
                  }

       difference {
                   box { -1,1
                         scale <3.875,.0625,4.75>
                         translate 1*y
                         translate -0.0625*x
                       }
                   cylinder {<-3.8125,1.0625,-5>,<-3.8125,1.0625,5>,.0625
                             translate 0.03125*y
                            }
                  }


       difference {
                   prism {
                          linear_sweep // or conic_sweep for tapering to a point
                          cubic_spline // linear_spline | quadratic_spline | cubic_spline
                          0,        // height 1
                          1,        // height 2
                          9,          // number of points
                          // the <u,v> points
                          <0,-.57>, <-.2,0>, <0,.57>, <-.3,.4>, <-.4,0>, <-.3,-.4>, <0, -.57>, <-.2,0>, <0,.57>
                          rotate 90*x
                          scale <1,1,9.75>
                          translate <-3.875,.5,-4.75>
                         }

                   cylinder {<0,.5,-5>, <0,.5,5>,.4375
                             scale <.6,1,1>
                             translate -3.875*x
                            }
                  }
       pigment {Brown}
       normal {bumps
               scale .001
              }

      }

union {
#declare Depth = .45
       text
           {
            ttf          // font type (only TrueType format for now)
            "timrom.ttf",  // Microsoft Windows-format TrueType font file name
            "Through",   // the string to create
            Depth,           // the extrusion depth
            0            // offset
            scale <1.5,1.5,1>
            rotate 90*x
            translate <-2.5,1.5,2>
           }

       text
           {
            ttf          // font type (only TrueType format for now)
            "timrom.ttf",  // Microsoft Windows-format TrueType font file name
            "the",   // the string to create
            Depth,           // the extrusion depth
            0            // offset
            scale <1.5,1.5,1>
            rotate 90*x
            translate <-0.75,1.5,.5>
           }

       text
           {
            ttf          // font type (only TrueType format for now)
            "timrom.ttf",  // Microsoft Windows-format TrueType font file name
            "Looking",   // the string to create
            Depth,           // the extrusion depth
            0            // offset
            scale <1.5,1.5,1>
            rotate 90*x
            translate <-2.5,1.5,-1>
           }

       text
           {
            ttf          // font type (only TrueType format for now)
            "timrom.ttf",  // Microsoft Windows-format TrueType font file name
            "Glass",   // the string to create
            Depth,           // the extrusion depth
            0            // offset
            scale <1.5,1.5,1>
            rotate 90*x
            translate <-1.5,1.5,-2.5>
           }
       text
           {
            ttf          // font type (only TrueType format for now)
            "timrom.ttf",  // Microsoft Windows-format TrueType font file name
            "Lewis Carroll",   // the string to create
            Depth,           // the extrusion depth
            0            // offset
            scale <.5,.5,1>
            rotate 90*x
            translate <0,1.5,-4>
           }
      texture {T_Gold_3C}
     }

}

difference {
            union {
                   cylinder {<0,.5,-4.625>, <0,.5,4.625>,.4375
                             scale <.6,1,1>
                             translate -3.875*x
                            }

                   box { -1,1
                         scale <3.8125,.4375,4.625>
                         translate <-.0625,.5,0>
                       }
                  }

           cylinder {<0,.5,-5>, <0,.5,5>,.5
                     scale <.6,1,1>
                     translate 3.875*x
                    }
           pigment {
                    gradient y
                    color_map {
                               [0 color White]
                               [1 color White*.25]
                              } // requires a color map
                    scale .1
                   }
          }
 translate 0.0625*y
}


//End Book object
//*********************************************************************




//********************************************************
//object "Poster" Dim: 52x39x1 bottom and back edge on origin


#declare Poster = difference {

box {-0.5,0.5
     scale <52,39,1>
     texture {
              pigment { rgb <.66,.66,.66> }
              finish {
                      ambient 0.1
                      diffuse .3
                      reflection .3
                      brilliance 6
                      specular 0.8
                      roughness .1
                      phong 1
                      phong_size 400
                     }
             }
    }

box {-0.5,0.5
     texture {
              pigment { 
                       image_map
                                {
                                 tga "daliwar.tga" // the file to read (iff/gif/tga/png/sys)
                                 map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                 interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                                 once
                                } // image_map
                       translate <-.5,-.5,0>
                      }
             }
     scale <50.5,37.5,1>
     translate -.5*z
    }
translate <0,19.5,-.5>    
}


//End Poster object
//***************************************************************************************         

