
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth:

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "METALS.INC"
#include "STONES.INC"
#include "WOODS.INC"
#include "glass.inc"
#include "golds.inc"
#include "objects.inc"


camera {
   location  <0, 32,34>
   look_at   <0, 21, 65>
}

light_source {<-60, 50,20>
              color White
              fade_distance 110
              fade_power 1
             }
light_source {<60, 50,20>
              color White
              fade_distance 110
              fade_power 1
             }
light_source {<0,90,90>
              color White
             }


object {LRoom}

object {Table
        translate 65*z
       }


union {
       object {Ashtray}

       #declare CigLength = 40
       #include "Cigaret.inc"

       object {Cigaret
               rotate -45*y
               translate <-2.5,1.2,-2.5>
              }

       #declare CigLength = 20
       #include "Cigaret.inc"

       object {Cigaret
               rotate -135*y
               translate <2.5,1.2,-2.5>
              }

       #declare CigLength = 5
       #include "Cigaret.inc"

       object {CigBut
               rotate -15*y
               translate <0,.3,1>
              }

       object {Ashes
               translate .25*y
              }

        object {Smoke
               translate 12*y
              }

       translate <7,18,59>
      }

object {Candle
        rotate 32*y
        scale 1.3
        translate <-5,18,65>
       }

object {BeerBottle
        rotate 20*y
        translate <15,18,68>
       }

object {CokeBottle
        rotate -45*y
        translate <-14,18,61>
       }


#declare Full = .75
#include "shot.inc"

object {Shot
        translate <-1,18,57>
       }

#declare Full = .25
#include "shot.inc"

object {Shot
        translate <14,18,59>
       }

object {Book
        scale .75
        rotate -40*y
        translate <-10,18,57>
       }

union {
       object {TVStand}
       object {TV
               translate 20*y
              }
       object {Stereo
               translate <0,11,0>}
       translate 163*z
      }


object {Plant
        translate <-40,0,160>
       }

union {
       object {Couch}
       object {Person}
       object {Person
               translate 23*x
              }
      }

object {Speaker
        scale .75
        rotate -45*y
        translate <-74,0,164>
       }

object {Speaker
        scale .75
        rotate 45*y
        translate <60,0,164>
       }

object {Poster
        scale <3/4,3/4,1>
        translate <40,40,180>
       }
