// ***
// *** CENTER PIECE
// ***


// **********************************************************************************************************************

#declare nail =
difference {
	sphere { <20, 50, 0>, 35 scale <1, 1, (8/35)> }
	union {
		sphere { <15, 50, 0>, 35 scale <1, 1, (10/35)> }
		cylinder { <0, 50, -20>, <0, 50, 20>, 40 }
		box { <0, 0, -20>, <60, 50, 20> }
	}
	texture { NAIL_1 }
}

#declare finger =
blob {
	threshold 0.3
	sphere { <30, 10, -3>, 13, 1 }
	sphere { <30, 10, 3>, 13, 1 }
	sphere { <33, 13, 0>, 10, 1 }
	sphere { <35, 16, 0>, 10, 1 }
	sphere { <38, 20, 0>, 10, 1 }
	sphere { <40, 24, 0>, 10, 1 }
	sphere { <42, 27, 0>, 10, 1 }
	sphere { <44, 30, 0>, 10, 1 }
	sphere { <47, 31, -2>, 10, 1 }
	sphere { <47, 31, 2>, 10, 1 }
	sphere { <45, 34, 0>, 10, 1 }
	sphere { <46, 38, 0>, 10, 1 }
	sphere { <47, 42, 0>, 10, 1 }
	sphere { <47, 46, 0>, 10, 1 }
	sphere { <47, 50, 0>, 10, 1 }
	sphere { <47, 54, 0>, 10, 1 }
	sphere { <49, 50, -2>, 10, 1 }
	sphere { <49, 50, 2>, 10, 1 }
}

#declare Finger =
union {
	object { nail }
	object { finger
		texture { gradient y
			texture_map {
				[ 0.3 HardMetal ]
				[ 0.9 SKIN_1 ]
			}
			scale 60
		}
	}
}

#declare Palm =
difference {
	union {
		cone { <0, 0, 0>, 30, <0, 10, 0>, 20 }
		cylinder { <0, 0, 0>, <35, 0, 0>, 10 rotate <0, 60, 0> }
		cylinder { <0, 0, 0>, <35, 0, 0>, 10 rotate <0, 180, 0> }
		cylinder { <0, 0, 0>, <35, 0, 0>, 10 rotate <0, -60, 0> }
		sphere { <35, 0, 0>, 8 rotate <0, 60, 0> }
		sphere { <35, 0, 0>, 8 rotate <0, 180, 0> }
		sphere { <35, 0, 0>, 8 rotate <0, -60, 0> }
		#declare i = 0
		#while (i<16)
			box { <-30, 1, -4>, <0, 9, 4> rotate <0, (22.5*i), 0> }
		#declare i = i+1
		#end
		texture { HardMetal }
	}
	union {
		#declare i = 0
		#while (i<16)
			sphere { <0, 0, 0>, 3 scale <0.5, 1, 1> translate <-30, 5, 0> rotate <0, (22.5*i), 0> }
		#declare i = i+1
		#end
		texture { Iridium }
	}
}

#declare MagicOrb =
sphere { <0, 85, 0>, 20 texture { CRYSTAL_55 } }

#declare SpecialGlow =
sphere { <0, 0, 0>, 4
	halo {
		emitting
		spherical_mapping
		linear
		color_map {
			[ 0.15 color rgbt <1, 0, 0, 1> ]
			[ 0.44 color rgbt <1, 1, 0, 0.65> ]
		}
		samples 10
		turbulence 0.05
		scale 3.5
	}
	halo {
		emitting
		spherical_mapping
		linear
		color_map {
			[ 0 color rgbt <1, 0, 0, 1> ]
			[ 0.75 color rgbt <1, 1, 0, -1> ]
		}
		samples 10
		turbulence 0.1
		scale 0.6
		translate <2, -0.1, 0> rotate <0, -60, 0>
	}
	halo {
		emitting
		spherical_mapping
		linear
		color_map {
			[ 0 color rgbt <1, 0, 0, 1> ]
			[ 1 color rgbt <1, 1, 0, -1> ]
		}
		samples 10
		turbulence 0.1
		scale 0.5
		translate <2, -0.1, 0> rotate <0, 60, 0>
	}
	pigment { color rgbt <1, 1, 1, 1> }
	hollow
	scale 10 translate <0, 85, 0>
}


// **********************************************************************************************************************

#declare Hand =
union {
	#if (REDLIGHT = 1)
		light_source { <0, 85, 0> color rgb <1, 1, 1>
			fade_distance 100 fade_power 2
		}
	#end
	object { MagicOrb }
	#if (PREVIEW = 0)
		object { SpecialGlow }
	#end
	object { Palm }
	object { Finger rotate <0, 60, 0> }
	object { Finger rotate <0, 180, 0> }
	object { Finger rotate <0, -60, 0> }
}

