// ***
// *** SWORD
// ***


// **********************************************************************************************************************

#declare sidebar =
blob {
	threshold 0.2

	#declare i = 0
	#while (i<12)
		sphere { <3, 3, 0>, 5, 1 rotate <(30*i), 0, 0> texture { GOLD_1 } }
	#declare i = i+1
	#end

	#declare i = 0
	#while (i<102)
		sphere { <0, 0, 0>, 5, 1
			translate <(3+(i*0.5)), 3, 0> rotate <(30*i), 0, 0> texture { HardMetal } }
	#declare i = i+1
	#end

	#declare i = 0
	#while (i<12)
		sphere { <54, 3, 0>, 5, 1 rotate <(30*i), 0, 0> texture { GOLD_1 } }
	#declare i = i+1
	#end
}

#declare holders =
difference {
	union {
		sphere { <0, 0, 0>, 10 scale <1, 1, (2/10)> }
		sphere { <0, 0, 0>, 10 scale <1, (2/10), 1> }
	}
	sphere { <2, 0, 0>, 8.01 }
	texture { GOLD_1 }
}

#declare SideWind =
union {
	object { sidebar }
	object { holders translate <62, 0, 0> }
	sphere { <65, 0, 0>, 8 texture { CRYSTAL_54 } }
}

#declare MainHold =
difference {
	union {
		cone { <0, 5, 0>, 20, <0, 25, 0>, 0 }
		cylinder { <0, 5, 0>, <0, -5, 0>, 20 }
		cone { <0, -5, 0>, 20, <0, -70, 0>, 0 }
	}
	union {
		sphere { <0, 0, 0>, 15.1 }
		box { <-25, -60, -25>, <25, 30, -9> }
		box { <-25, -60, 25>, <25, 30, 9> }
	}
	texture { HardMetal }
}

#declare Circular =
difference {
	union {
		cone { <0, 0, 0>, 9, <60, 0, 0>, 0 scale <1, (7/9), 1> rotate <0, 0, 30> }
		cone { <0, 0, 0>, 9, <60, 0, 0>, 0 scale <1, (7/9), 1> rotate <0, 0, -30> }
		cone { <0, 0, 0>, 9, <60, 0, 0>, 0 scale <1, (7/9), 1> rotate <0, 0, 150> }
		cone { <0, 0, 0>, 9, <60, 0, 0>, 0 scale <1, (7/9), 1> rotate <0, 0, -150> }
		cylinder { <0, 0, -10>, <0, 0, 10>, 15 }
	}
	union {
		cylinder { <0, 0, -11>, <0, 0, 11>, 12 }
		sphere { <0, 0, 0>, 15.01 }
		#declare i = 0
		#while (i<12)
			box { <-1, -1, -1>, <1, 1, 1> translate <13.5, 0, -9> rotate <0, 0, (30*i)> }
			box { <-1, -1, -1>, <1, 1, 1> rotate <0, 0, 45> translate <13.5, 0, -9> rotate <0, 0, (30*i)> }
			box { <-1, -1, -1>, <1, 1, 1> rotate <0, 0, 45> translate <13.5, 0, 9> rotate <0, 0, (30*i)> }
			box { <-1, -1, -1>, <1, 1, 1> translate <13.5, 0, 9> rotate <0, 0, (30*i)> }
		#declare i = i+1
		#end
	}
	texture { GOLD_1 }
}

#declare Thing234 =
difference {
	cylinder { <0, 0, 0>, <0, 8, 0>, 13 }
	torus { 13, 6 translate <0, 8, 0> }
	texture { HardMetal }
}

#declare Thing432 =
union {
	object { Thing234 }
	cylinder { <0, 8, 0>, <0, 88, 0>, 7 texture { Ribbon } }
	object { Thing234 rotate <0, 0, 180> translate <0, 96, 0> }
	union {
		object { Finger rotate <0, 90, 0> }
		object { Finger rotate <0, 180, 0> }
		object { Finger rotate <0, -90, 0> }
		object { Finger }
		translate <0, -50, 0>
		scale (12/40)
		translate <0, 109, 0>
	}
	sphere { <0, 109, 0>, 13 texture { GreenCrys } }
}

#declare Blade =
difference {
	box { <-2.5*sqrt(2), 0, -2.5*sqrt(2)>, <2.5*sqrt(2), -1000, 2.5*sqrt(2)>
		rotate <0, 45, 0> scale <(13/5), 1, (3.25/5)>
	}
	union {
		box { <-4, 1, -1>, <4, -1001, -5> }
		box { <-4, 1, 1>, <4, -1001, 5> }
		box { <-20, 1, -2>, <20, -1001, -5> }
		box { <-20, 1, 2>, <20, -1001, 5> }
	}
	texture { Iridium }
}

// **********************************************************************************************************************

#declare Sword =
union {
	object { SideWind translate <15, 0, 0> }
	object { SideWind rotate <0, 0, 180> translate <-15, 0, 0> }
	object { Circular }
	object { MainHold }
	object { Thing432 translate <0, 17, 0> }
	sphere { <0, 0, 0>, 15 texture { CRYSTAL_54 } }
	object { Blade translate <0, -15, 0> }
	union {
		sphere { <-7.5, -22, -5.5>, 5  }
		sphere { <7.5, -22, -5.5>, 5 }
		sphere { <0, -35, -5.5>, 5 }
		sphere { <-7.5, -22, 5.5>, 5  }
		sphere { <7.5, -22, 5.5>, 5 }
		sphere { <0, -35, 5.5>, 5 }
		texture { GOLD_1 }
	}		
}

