/* background {color rgb <1,1,1>}

camera{
location <0,-50,-100>
   angle 30
   look_at <0,0,0>
}

light_source{ <20,-100,-150>
   color rgb <1,1,1>
} */

#declare RADI05 = .8
#declare STRE05 = 2
#declare DENS05 = STRE05*pow((1-pow(RADI05,2)),2)
#declare SECT05 = 4
#declare ANGL05 = 180/SECT05
#declare ANGL00 = 0
#declare L05A=
blob{
   threshold DENS05
      cylinder {<0,0,0><0,0,10>1,STRE05 scale <5/RADI05,5/RADI05,1/RADI05>}
      sphere {0,1,-2 scale <3,5,5> translate <0,.3,-3>}
         #while (SECT05>0)
         sphere{0,1,STRE05 scale <7/RADI05,6/RADI05,2/RADI05,>
                                translate x*10
                                rotate z*(ANGL00+ANGL05/2)}

         sphere{0,1,STRE05 scale <9/RADI05,7/RADI05,2/RADI05,>
                                translate x*11
                                rotate z*(180+ANGL00+ANGL05/2)}
         #declare SECT05 = SECT05-1
         #declare ANGL00 = ANGL00 + ANGL05
   #end
   #declare SECT05 =8
   #while (SECT05>0)
         sphere{0,1,-.2 scale <10,2,1>
                                rotate y*2
                                translate <.5,0,-1.5>
                                rotate z*(ANGL00)
                                translate y*-.3}
         #declare SECT05 = SECT05-1
         #declare ANGL00 = ANGL00 + ANGL05
   #end
sturm
scale <.9,1,1.2>
 texture{
      finish {
       ambient <0.3,0.25,0.20>
       diffuse 0.5
       phong 0.1
       phong_size 20
       }
    normal {bumps .1 scale.2}
    pigment { //rgb <.53,1,.47>
       spiral1 8 ramp_wave
       turbulence <0, 0, .01>
          octaves 3
          lambda 10
          omega 4
       color_map {
          [0.0, 0.47  color rgb <.53,1,.47>
                      color rgb <.53,1,.47>]
          [0.47, 0.53 color rgb <.53,1,.47>*1.5
                      color rgb <.53,1,.47>*1.5]
          [0.53, 1.0  color rgb <.53,1,.47>
                      color rgb <.53,1,.47>]}
       rotate z*degrees(pi/8)
       scale 150
    }
 }
 texture{
   pigment { //rgb <.53,1,.47>
      spiral1 16 ramp_wave
      turbulence <0, 0, .01>
         octaves 3
         lambda 12
         omega 5
      color_map {
         [0.0, 0.48  color rgbf <.53,1,.47,1>
                     color rgbf <.53,1,.47,1>]
         [0.48, 0.52 color rgbf <.53,1,.47,.2>*1.5
                     color rgbf <.53,1,.47,.2>*1.5]
         [0.52, 1.0  color rgbf <.53,1,.47,1>
                     color rgbf<.53,1,.47,1>]}
      rotate z*degrees(pi/8)
      scale 150
   }
 }
}
#declare L05B=
difference{
   object {L05A}
   object {L05A scale 1.05 translate z*.7}
}
//object {L05B}
