/*
background {color rgb <1,1,1>}

camera{
location <0,-200,0>
   angle 30
   look_at <0,0,0>
}

light_source{ <20,-150,-350>
   color rgb <1,1,1>
}
*/

#declare RADI06 = .8
#declare STRE06 = 2
#declare DENS06 = STRE06*pow((1-pow(RADI06,2)),2)
#declare SECT06 = 9
#declare ANGL06 = 180/SECT06
#declare ANGL16 = 0
// #declare RAND01 = seed(0)
#declare L06A=
blob{
   threshold DENS06
      sphere {0,1,STRE06 scale <10/RADI06,10/RADI06,4/RADI06>}
      sphere {0,1,STRE06 scale <8/RADI06,8/RADI06,5/RADI06>}
      sphere {0,1,STRE06 scale <5/RADI06,5/RADI06,12/RADI06>}
      sphere {0,1,STRE06 scale <3/RADI06,3/RADI06,25/RADI06>}

         #while (SECT06>0)
         sphere{0,1,STRE06 scale <15/RADI06,7/RADI06,2.2/RADI06,>
                                rotate y*(-15+SECT06*1.5)
                                translate <10,0,0>
                                rotate z*(ANGL16+ANGL06/2)
                                translate <0,6.5,0>}
                              
         #declare SECT06 = SECT06-1
         #declare ANGL16 = ANGL16 + ANGL06
         #end
         sturm
scale <.7,1,1.5>

}

#declare L06B=
difference{
   object {L06A}
   cylinder {<0,0,6><0,0,50>,50}
   box {<-20,0.6,50><20,-20,-50>}
   object {L06A scale <1.02,1.01,1.05> translate <0,-.3,.6>}

 texture{
      finish {
       ambient <.53,.6,.47>*.95
       diffuse 0.9
       phong 0.1
       phong_size 20
       }
    normal {bumps .9 scale <3,3,10>}
    pigment { // rgb <1,.5,0.2>
       gradient z
       color_map {
         [0.0 color rgbf <1,.5,0.2,.1>]
         [0.1 color rgbf <1,.5,0.2,.1>]
         [0.4 color rgbf <1,.98,.2,.1>]
         [1 color rgbf <1,.98,.2,.05>]}
         scale 40
 }
 }
 texture{
    pigment {
      spiral1 20 ramp_wave
      turbulence <0, 0, .01>
         octaves 3
         lambda 12
         omega 4
      color_map {
         [0.0, 0.46  color rgbf <1,.5,0.2,1>
                     color rgbf <1,.5,0.2,1>]
         [0.46, 0.54 color rgbf <1,.9,.3,.1>*1.5
                     color rgbf <1,.9,.3,.1>*1.5]
         [0.54, 1.0  color rgbf <1,.5,0.2,1>
                     color rgbf<1,.5,0.2,1>]}
      scale 150
   }
}
translate z*25*1.5
rotate x*-17
translate y*1.5
}

#declare SECT06 = 5
#declare ANGL06 = 360/SECT06
#declare ANGL16 = 0

// object {L06B}

#declare L06C=
union{
#while (SECT06>0)
   object {L06B
   rotate z*(ANGL16+ANGL06/2)}
   #declare SECT06 = SECT06-1
   #declare ANGL16 = ANGL16 + ANGL06
#end
}
// object {L06C}

#declare RADI06 = .8
#declare STRE06 = 2
#declare DENS06 = STRE06*pow((1-pow(RADI06,2)),2)
#declare SECT06 = 5
#declare ANGL06 = 360/SECT06
#declare ANGL16 = 0
#declare L06D=
blob{
   threshold DENS06
      sphere {0,1,-2 scale <7/RADI06,10/RADI06,10/RADI06> translate x*5}
      
      #while (SECT06>0)
      sphere{0,1,STRE06 scale <22/RADI06,4.4/RADI06,8/RADI06> translate z*-.9
      rotate x*(ANGL16+ANGL06/4)}    
      #declare SECT06 = SECT06-1
      #declare ANGL16 = ANGL16 + ANGL06
      #end

#declare R6=2
#declare X06=0
#declare Y06=0
#declare XS6=0
#declare YS6=0
#declare r6=2.5
#declare RC6=50
#declare A06=pi/2-pi/12
#declare n6=.95
#declare LX06=(RC6*cos(A06))
#declare LY06=(RC6*sin(A06))
#declare Count6=30
#declare Countn6=((Count6+1)/2)

     sphere {<0,0,0>,1,STRE06 scale <R6*.7/RADI06, R6/RADI06, R6*.5/RADI06>
                      rotate z*(degrees(A06)) translate<XS6,YS6,0>
                      translate <-25,1,0>}
        #while (Count6>=1)
           #declare R6=(R6*n6)
           #declare A6=(A06+(2*asin(R6/(RC6*r6))))
           #declare LX6=(RC6*cos(A6))
           #declare LY6=(RC6*sin(A6))
           #declare X6=(X06+(LX6-LX06))
           #declare Y6=(Y06+(LY6-LY06))
           #declare X16=(X6+XS6)
           #declare Y16=(Y6+YS6)
           #declare AA6=degrees(A6)
           sphere { <0,0,0>,1,STRE06 scale <R6*.7/RADI06, R6/RADI06, R6*.5/RADI06>
                      rotate z*AA6 translate<X16,Y16,0>
                      translate <-25,1,0>}
           #declare A06=A6
           #declare Y06=Y6
           #declare X06=X6
           #declare LX06=LX6
           #declare LY06=LY6
           #declare Count6=Count6-1
        #end
}
#declare L06E=
difference{
   object {L06D}
sphere {0,1 scale <22,8,8> translate x*.5}
cylinder{<1,0,0><30,0,0>15}
translate x*20
scale <1.2,1,1>
rotate y*-90
texture {
   finish {
       ambient <.53,.6,.47>*.8
       diffuse 0.5
       phong 0.1
       phong_size 20
       }
    normal {bumps .2 scale <.5,.5,100>}
    pigment { color rgbf <1,.98,.3,.05>}
}
}
#declare L06F=
union{
   object {L06E}
   object {L06C}
}
