#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

#declare Glass_Texture1 =
texture {
    pigment { color rgbf<0.5,0.5,1,0.7> }
    finish  { F_Glass1 }
}

#declare Glass_Texture2 =
texture {
    pigment { color rgbf<0,0,1,1.0> }
    finish  { F_Glass2 }
}

//Courtesy of Claire Amundsen
#declare Shag =
texture {
    pigment {
        marble
        color_map {
            [ 0.000  color rgb<0.875, 0.514, 0.165> ]
            [ 0.277  color rgb<0.800, 0.413, 0.120> ]
            [ 0.586  color rgb<0.875, 0.514, 0.165> ]
            [ 0.875  color rgb<0.800, 0.413, 0.120> ]
            [ 1.000  color rgb<0.875, 0.514, 0.165> ]
        }
        turbulence 2.000
        scale     <0.2500, 0.2500, 0.2500>
    }
    normal {
        wrinkles 1.0000
        omega 2.000
        lambda 0.500
        scale 0.1000
    }
    finish {
        diffuse 0.500
        ambient 0.300
        specular 0.400
        roughness 0.0100
    }
}

camera { location <47,36,-12> look_at <0,36,47> }

light_source { <1,95,0> color Gray65 }
light_source { <-1,95,0> color Gray65 }
light_source { <0,95,72> color Gray75 }

//
// Room with wood trim and baseboards
//
difference {
    box { <-49,-1,-49>, <49,97,49> }
    union {
        box { <-48, 0,-48>, <48,96,48> }
        box { <-40, 0,48>,  <-10,78,50> }
    }
    pigment { LightBlue }
}

difference {
    box { <-97,-1,49>, <97,97,97> }
    union {
        box { <-96,0,50>, <96,96,96> }
        box { <-40,0,48>, <-10,78,50> }
    }
    pigment { White }
}
box { <-43,0,47.5>,  <-40,78,48>  texture { T_Wood4 rotate <89,0,0> } }
box { <-10,0,47.5>,  <-7,78,48>   texture { T_Wood4 rotate <89,0,0> } }
box { <-43,78,47.5>, <-7,81,48>   texture { T_Wood4 } }
box { <-48,0,-48>,   <-47.5,5,48> texture { T_Wood4 } }
box { <-7,0,47.5>,   <48,5,48>    texture { T_Wood4 } }
box { <-48,0,47.5>,  <-43,5,48>   texture { T_Wood4 } }

//
// Carpet
//
#declare Carp_X = -48
#while (Carp_X < 48)
    #declare Carp_Z = -48
    #while (Carp_Z < 48)
        object {
            height_field { tga "SHAGMAP.TGA" water_level 0.0 }
            scale <12,2,12>
            translate <Carp_X, 2, Carp_Z>
            texture { Shag }
        }
        #declare Carp_Z = Carp_Z + 12
    #end
    #declare Carp_X = Carp_X + 12
#end

//
// Poster
//
box { <6,39,47.875>, <30,63,48> pigment { image_map { gif "gi.gif" } scale 24 translate <6,39,0> } }

//
// Beads
//
#declare Bead_String =
union { cylinder { <0,78,0>, <0,2,0>, 0.0625 pigment { Yellow } }
    #declare Bead_Y = 76
    #while ( Bead_Y >= 2 )
        sphere { <0,Bead_Y,0>, 0.375
            pigment { Red filter 0.5 }
            finish { refraction 1 ior 1.1 }
            scale <1,1.5,1>
        }
        #declare Bead_Y = Bead_Y - 2
    #end
}

#declare Bead_X = -38
#while ( Bead_X < -10 )
    object { Bead_String translate <Bead_X,0,49> }
    #declare Bead_X = Bead_X + 2
#end

//
// Table
//
union {
    box { <0,23,30>, <36,24,48> }
    cylinder { <1,0,31>,  <1,23,31>,  1 }
    cylinder { <1,0,47>,  <1,23,47>,  1 }
    cylinder { <35,0,31>, <35,23,31>, 1 }
    cylinder { <35,0,47>, <35,23,47>, 1 }
    texture { T_Wood1 rotate <0,90,0> scale 12 finish { Shiny } }
}

//
// LavaLite
//
union {
    difference {
        cone { <0,0,0>,       2,      <0,3.25,0>,   1 }
        cone { <0,-0.0001,0>, 1.9999, <0,3.2501,0>, 0.9999 }
        texture { T_Gold_5A }
    }
    difference {
        cone { <0,3.25,0>,    1,      <0,7.25,0>,   2 }
        cone { <0,3.2499,0>,  0.9999, <0,7.2501,0>, 1.9999 }
        texture { T_Gold_5A }
    }
    light_source { <0,5,0> color rgb <0,0,0.25> }
    merge {
        cone { <0,5.25,0>,    1.25,   <0,7.25,0>,   2 }
        cone { <0,7.25,0>,    2,      <0,14,0>,      1 }
        texture { T_Glass2 }
        halo {
            attenuating
            cylindrical_mapping
            constant
            color_map {
                [0 color rgbt <0.1,0.1,1,0.85>]
                [1 color rgbt <0.1,0.1,1,0.85>]
            }
            samples 10
        }
        hollow
    }
    difference {
        cone { <0,14,0>,      1,      <0,16,0>,      0.625 }
        cone { <0,13.9999,0>, 0.9999, <0,15.9999,0>, 0.6249 }
        texture { T_Gold_5A }
    }
    blob {
        threshold 0.6
        sphere {<-0.038005, 0.509506, 0>, 0.430878, 2}
        sphere {<0.098814,  0.250951, 0>, 0.303896, 2}
        sphere {<0.098814,  0.022814, 0>, 0.290087, 2}
        sphere {<0.007601, -0.190114, 0>, 0.302178, 2}
        sphere {<0.068410, -0.448669, 0>, 0.230934, 2}
        sphere {<0.068410, -0.844106, 0>, 0.205067, 2}
        sphere {<0.083612,  0.920152, 0>, 0.302178, 2}
        sphere {<0.068410,  0.737643, 0>, 0.205087, 2}
        sphere {<-0.114016, 0.798479, 0>, 0.226470, 2}
        sphere {<-0.053208, 1.057034, 0>, 0.214877, 2}
        sphere {<-0.114016, 0.965779, 0>, 0.160128, 2}
        sphere {<0.114016,  1.102662, 0>, 0.258185, 2}
        pigment { color rgbf <0.95,0.95,1,0.1> }
        scale 2
        translate <0,10,0>
    }
    translate <30,24,39>
}

//
// Ashtray
//
union {
    cylinder { <0,0,0>, <0,0.25,0>, 5 }
    difference {
        torus { 5, 1 scale <1,1.5,1> }
        cylinder { <0,1.5,-6>, <0,1.5,6>, 0.75 }
        cylinder { <0,1.5,-6>, <0,1.5,6>, 0.75 rotate y*90}
    }
    texture { T_Glass1 }
    translate <16,24,39>
}


