//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 19 textures and 189 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 01/31/1997    (31.01.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <0.499,0.499,0.499>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 3    // Mie (Murky)
  distance     100000.0
  color <1.0,1.0,1.0,0.0,0.0>
  scattering   0.1
  samples      100
  jitter       0.0
  aa_threshold 1.0
  aa_level     3.0
}

camera {  //  Camera StdCam
  location  <-11.600, -2.600, 4.600>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.887, 1.608, 3.500>
}

// *******  L I G H T S *******
light_source {   // Licht_all
  <3.100, 0.000, 13.800>
  color rgb <1.000, 1.000, 1.000>
  atmospheric_attenuation on
}

light_source {   // Spotlight Licht1
  <11.500, 0.000, 10.000>
  color  rgb <1.004, 1.004, 1.004>
  spotlight
    point_at  <10.619, 0.000, 9.527>
    falloff   24.2  // outer radius (in deg)
      radius    21.7  // inner radius
  atmospheric_attenuation on
}


// ********  TEXTURES  *******
//

#include "licht.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare Spirale71 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale72 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL35
  sphere { // Kugel_g35
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale71 }
  object { Spirale72 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.437931, 6.396447, 5.696501>
}


#declare Spirale69 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale70 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL34
  sphere { // Kugel_g34
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale69 }
  object { Spirale70 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.543246, 5.685566, 5.696501>
}


#declare Spirale67 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale68 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL33
  sphere { // Kugel_g33
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale67 }
  object { Spirale68 }
  scale 0.04
  rotate -30.0*z
  translate  <-0.96401, 3.500265, 5.696501>
}


#declare Spirale65 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale66 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL32
  sphere { // Kugel_g32
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale65 }
  object { Spirale66 }
  scale 0.04
  rotate -30.0*z
  translate  <-0.384773, 2.763055, 5.696501>
}


#declare Spirale63 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale64 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL31
  sphere { // Kugel_g31
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale63 }
  object { Spirale64 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.016668, 4.211146, 5.696501>
}


#declare Spirale61 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale62 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL30
  sphere { // Kugel_g30
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale61 }
  object { Spirale62 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.016668, 3.107035, 4.451167>
}


#declare Spirale59 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale60 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL29
  sphere { // Kugel_g29
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale59 }
  object { Spirale60 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.016668, 4.403724, 4.451167>
}


#declare Spirale57 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale58 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL28
  sphere { // Kugel_g28
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale57 }
  object { Spirale58 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.016668, 3.479351, 5.067415>
}


#declare Spirale55 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale56 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL27
  sphere { // Kugel_g27
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale55 }
  object { Spirale56 }
  scale 0.04
  rotate -30.0*z
  translate  <-0.885023, 2.76847, 5.067415>
}


#declare Spirale53 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale54 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL26
  sphere { // Kugel_g26
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale53 }
  object { Spirale54 }
  scale 0.04
  rotate -30.0*z
  translate  <-0.332115, 3.321378, 5.067415>
}


#declare Spirale51 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale52 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL25
  sphere { // Kugel_g25
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale51 }
  object { Spirale52 }
  scale 0.04
  rotate -30.0*z
  translate  <-0.674392, 4.190233, 5.067415>
}


#declare Spirale49 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale50 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL24
  sphere { // Kugel_g24
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale49 }
  object { Spirale50 }
  scale 0.04
  rotate -30.0*z
  translate  <-1.806732, 6.0, 5.059268>
}


#declare HALTER4 = difference {
  torus { // halter6
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter29
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter30
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
  rotate -90.0*y
  translate  <-11.5, 0.0, -8.5>
}
#declare HALTER5 = difference {
  torus { // halter7
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter31
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter32
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
}
#declare G_Halter2 = union {
  object { HALTER4 }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 17.0>
    translate  <-11.5, 0.0, -18.5>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  -20.0*z
  }
  object { HALTER5 }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -5.25*z
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -10.25*z
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -15.25*z
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
  }
  texture {
    Halter_Tex
  }
  scale 0.5
  translate  <10.0, -10.0, 15.0>
}
#declare HALTER6 = difference {
  torus { // halter8
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter33
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter34
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
  rotate -90.0*y
  translate  <-11.5, 0.0, -8.5>
}
#declare HALTER7 = difference {
  torus { // halter9
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter35
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter36
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
}
#declare G_Halter3 = union {
  object { HALTER6 }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 17.0>
    translate  <-11.5, 0.0, -18.5>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  -20.0*z
  }
  object { HALTER7 }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -5.25*z
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -10.25*z
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -15.25*z
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
  }
  texture {
    Halter_Tex
  }
  scale 0.5
  translate  <10.0, 0.0, 15.0>
}
union { // Wand_Regal1
  box { // Glas4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 7.625>
  }
  box { // Glas5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 10.125>
  }
  box { // Glas6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 12.625>
  }
  object { G_Halter2 }
  object { G_Halter3 }
  scale 0.25
  translate  <-2.5, 4.8, 2.4>
}


box { // Halle1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Blue_Agate1
  }
  scale <0.5, 16.25, 9.0>
  rotate -90.0*z
  translate  <-13.0, 7.3, 7.75>
}


#declare Rahmen10 = difference {
  torus { // Rahmen01
    1.2, 0.2  rotate -x*90
    rotate -90.0*y
    translate  6.0*z
  }
  box { // Rahmen03
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.1>
    translate  <0.0, 0.1, 4.9>
  }
}
union { // Rahmen
  box { // Rahmen05
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.4, 0.1>
    translate  3.9*z
  }
  object { Rahmen10 }
  cylinder { // Rahmen3
    <0,0,1>, <0,0,0>, 1 
    scale <-0.2, -0.2, -2.0>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, -1.2, 4.0>
  }
  cylinder { // Rahmen02
    <0,0,1>, <0,0,0>, 1 
    scale <-0.2, -0.2, -2.0>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 1.2, 4.0>
  }
  texture {
    Cherry_Wood1
  }
}


#declare Spirale15 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale16 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL7
  sphere { // Kugel_g7
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale15 }
  object { Spirale16 }
  scale 0.04
  rotate -30.0*z
  translate  <-5.01, -0.14, 3.51>
}


#declare Spirale47 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale48 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL23 = union {
  sphere { // Kugel_g23
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale47 }
  object { Spirale48 }
  scale 0.04
  rotate -18.0*z
  translate  <-4.21, 0.08, 2.87>
}
#declare Spirale45 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale46 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL22 = union {
  sphere { // Kugel_g22
    <0,0,0>,1
    texture {
      Blau_g
    }
    scale 2.5
  }
  object { Spirale45 }
  object { Spirale46 }
  scale 0.04
  rotate -120.0*z
  translate  <-3.93, 0.35, 2.87>
}
#declare Spirale43 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_ge
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale44 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL21 = union {
  sphere { // Kugel_g21
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale43 }
  object { Spirale44 }
  scale 0.04
  rotate -56.0*z
  translate  <-3.62, -0.2, 2.87>
}
#declare Spirale41 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale42 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL20 = union {
  sphere { // Kugel_g20
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale41 }
  object { Spirale42 }
  scale 0.04
  rotate -12.0*z
  translate  <-3.88, 0.04, 2.87>
}
#declare Spirale39 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale40 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL19 = union {
  sphere { // Kugel_g19
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale39 }
  object { Spirale40 }
  scale 0.04
  translate  <-3.93, -0.32, 2.87>
}
#declare Spirale37 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_ge
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale38 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL18 = union {
  sphere { // Kugel_g18
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale37 }
  object { Spirale38 }
  scale 0.04
  rotate -248.0*z
  translate  <-4.0, -1.61, 2.87>
}
#declare Spirale35 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale36 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL17 = union {
  sphere { // Kugel_g17
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale35 }
  object { Spirale36 }
  scale 0.04
  rotate -10.0*z
  translate  <-6.72, -1.43, 2.87>
}
#declare Spirale33 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale34 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL16 = union {
  sphere { // Kugel_g16
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale33 }
  object { Spirale34 }
  scale 0.04
  translate  <-4.84, 0.98, 2.87>
}
#declare Spirale31 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale32 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_ge
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL15 = union {
  sphere { // Kugel_g15
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale31 }
  object { Spirale32 }
  scale 0.04
  rotate -223.0*z
  translate  <-6.21, 0.1, 2.87>
}
#declare Spirale29 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale30 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL14 = union {
  sphere { // Kugel_g14
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale29 }
  object { Spirale30 }
  scale 0.04
  rotate -74.0*z
  translate  <-5.05, -1.25, 2.87>
}
#declare Spirale27 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale28 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL13 = union {
  sphere { // Kugel_g13
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale27 }
  object { Spirale28 }
  scale 0.04
  rotate -23.0*z
  translate  <-5.69, -0.6, 2.87>
}
#declare Spirale25 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale26 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_ge
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL12 = union {
  sphere { // Kugel_g12
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale25 }
  object { Spirale26 }
  scale 0.04
  rotate -87.0*z
  translate  <-5.58, 0.61, 2.87>
}
#declare Spirale23 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale24 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL11 = union {
  sphere { // Kugel_g11
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale23 }
  object { Spirale24 }
  scale 0.04
  rotate -33.0*z
  translate  <-4.31, 0.41, 2.87>
}
#declare Spirale21 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale22 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL10 = union {
  sphere { // Kugel_g10
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale21 }
  object { Spirale22 }
  scale 0.04
  rotate -123.0*z
  translate  <-4.11, -0.69, 2.87>
}
#declare Spirale19 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale20 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL9 = union {
  sphere { // Kugel_g9
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale19 }
  object { Spirale20 }
  scale 0.04
  rotate -45.0*z
  translate  <-4.63, -0.7, 2.87>
}
#declare Spirale17 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_g
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale18 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL8 = union {
  sphere { // Kugel_g8
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale17 }
  object { Spirale18 }
  scale 0.04
  rotate -198.0*z
  translate  <-4.07, -0.14, 2.87>
}
#declare Spirale73 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale74 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL36 = union {
  sphere { // Kugel_g36
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale73 }
  object { Spirale74 }
  scale 0.04
  rotate -123.0*z
  translate  <-5.879341, 1.443039, 2.87>
}
#declare Spirale75 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale76 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL37 = union {
  sphere { // Kugel_g37
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale75 }
  object { Spirale76 }
  scale 0.04
  rotate -123.0*z
  translate  <-3.736472, 1.580655, 2.87>
}
#declare Spirale77 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale78 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL38 = union {
  sphere { // Kugel_g38
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale77 }
  object { Spirale78 }
  scale 0.04
  rotate -123.0*z
  translate  <-2.458615, 0.794281, 2.87>
}
#declare Spirale79 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale80 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_li
  }
  translate  <0.5, 0.5, 0.0>
}
#declare KUGEL39 = union {
  sphere { // Kugel_g39
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale79 }
  object { Spirale80 }
  scale 0.04
  rotate -123.0*z
  translate  <-4.945522, 1.836226, 2.87>
}
union { // kugeln
  object { KUGEL23 }
  object { KUGEL22 }
  object { KUGEL21 }
  object { KUGEL20 }
  object { KUGEL19 }
  object { KUGEL18 }
  object { KUGEL17 }
  object { KUGEL16 }
  object { KUGEL15 }
  object { KUGEL14 }
  object { KUGEL13 }
  object { KUGEL12 }
  object { KUGEL11 }
  object { KUGEL10 }
  object { KUGEL9 }
  object { KUGEL8 }
  object { KUGEL36 }
  object { KUGEL37 }
  object { KUGEL38 }
  object { KUGEL39 }
  translate  -0.02*z
}


#declare Spirale13 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale14 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL6
  sphere { // Kugel_g6
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale13 }
  object { Spirale14 }
  scale 0.04
  rotate -45.0*z
  translate  <-4.81, 0.1, 3.32>
}


#declare Spirale11 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale12 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL5
  sphere { // Kugel_g5
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale11 }
  object { Spirale12 }
  scale 0.04
  rotate -39.0*z
  translate  <-4.89, -0.1, 3.32>
}


#declare Spirale9 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale10 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL4
  sphere { // Kugel_g4
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale9 }
  object { Spirale10 }
  scale 0.04
  rotate -244.0*z
  translate  <-5.08, -0.21, 3.32>
}


#declare Spirale7 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale8 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL3
  sphere { // Kugel_g3
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale7 }
  object { Spirale8 }
  scale 0.04
  rotate -69.0*z
  translate  <-5.08, 0.07, 3.5>
}


#declare Spirale5 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale6 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL2
  sphere { // Kugel_g2
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale5 }
  object { Spirale6 }
  scale 0.04
  rotate -166.0*z
  translate  <-4.99, 0.09, 3.33>
}


#declare Spirale3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale4 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL1
  sphere { // Kugel_g1
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale3 }
  object { Spirale4 }
  scale 0.04
  translate  <-5.17, -0.02, 3.32>
}




box { // Himmel
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Blue_Sky4
  }
  hollow
  scale <2.0, -28.200001, 27.6>
  translate  <14.9, 0.0, 16.2>
}


lathe {
  cubic_spline
  24  // control points
  <0.0, -1.0>,
  <0.0, -1.0>,
  <0.2, -1.0>,
  <0.4, -1.0>,
  <0.6, -1.0>,
  <0.8, -1.0>,
  <0.908453, -0.983877>,
  <0.684462, -0.899464>,
  <0.223031, -0.891115>,
  <0.147821, -0.747322>,
  <0.145888, -0.547626>,
  <0.137216, -0.398548>,
  <0.162664, -0.248196>,
  <0.38909, -0.201165>,
  <0.661233, -0.202099>,
  <0.983761, 0.018394>,
  <0.729399, 1.204059>,
  <0.686387, 1.156495>,
  <0.918687, 0.045668>,
  <0.657455, -0.118578>,
  <0.388071, -0.129989>,
  <0.135031, -0.15427>,
  <0.0, -0.2>,
  <0.0, -0.2>
  rotate <90,0,90>
  texture {
    Glas
  }
  scale 0.5
  translate  <-5.0, 0.0, 3.25>
}


box { // Tisch1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFWood4
  }
  scale <-5.5, 2.75, 0.25>
  translate  <-7.0, 0.0, 2.5>
}




plane { // Boden
  z,0
  texture {
    Boden_tex
  }
  hollow
}


difference { // Wand
  box { // Halle
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <0.5, 16.25, 9.0>
    translate  <0.5, 0.0, 7.75>
  }
  box { // Wand2
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <-1.75, 1.0, 1.0>
    translate  <0.5, 0.0, 5.0>
  }
  cylinder { // Wand3
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <1.0, 1.0, -3.25>
    rotate -90.0*y
    translate  <-1.25, 0.0, 6.0>
  }
  texture {
    Blue_Agate1
  }
  hollow
}


#declare Spirale2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_p
  }
  rotate -90.0*y
  translate  <0.0, 0.5, 0.5>
}
#declare Spirale1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.619757, 1.178328>, <0.000000, 0.646198, 1.456739>, <1.017019, 1.002179, 0.044925>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.844580, 0.546584>, <0.000000, -0.038986, 0.728370>, <1.022429, 0.002440, 0.022733>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, -0.069402, -0.085160>, <0.000000, -0.724171, 0.000000>, <1.027838, -0.997299, 0.000540>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.705775, -0.716903>, <0.000000, -1.409355, -0.728370>, <1.033247, -1.997038, -0.021653>
    }
  }
  texture {
    Blau_r
  }
  translate  <0.5, 0.5, 0.0>
}
union { // KUGEL
  sphere { // Kugel_g
    <0,0,0>,1
    texture {
      Glas_Ku
    }
    scale 2.5
  }
  object { Spirale2 }
  object { Spirale1 }
  scale 0.04
  translate  <-5.17, 0.19, 3.31>
}


#declare HALTER2 = difference {
  torus { // halter4
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter25
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter26
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
  rotate -90.0*y
  translate  <-11.5, 0.0, -8.5>
}
#declare HALTER3 = difference {
  torus { // halter5
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter27
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter28
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
}
#declare G_Halter1 = union {
  object { HALTER2 }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 17.0>
    translate  <-11.5, 0.0, -18.5>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  -20.0*z
  }
  object { HALTER3 }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -5.25*z
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -10.25*z
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -15.25*z
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
  }
  texture {
    Halter_Tex
  }
  scale 0.5
  translate  <10.0, -10.0, 15.0>
}
#declare HALTER1 = difference {
  torus { // halter3
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter23
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter24
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
  rotate -90.0*y
  translate  <-11.5, 0.0, -8.5>
}
#declare HALTER = difference {
  torus { // halter2
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <-10.0, 0.0, -1.5>
  }
  box { // halter22
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 2.5>
    translate  <-10.0, 0.0, -4.0>
  }
  box { // halter21
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 2.5>
    translate  <-8.0, 0.0, -1.5>
  }
}
#declare G_Halter = union {
  object { HALTER1 }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 17.0>
    translate  <-11.5, 0.0, -18.5>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
    translate  -20.0*z
  }
  object { HALTER }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -5.25*z
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -10.25*z
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.25>
    rotate -90.0*y
    translate  -15.25*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*y
  }
  texture {
    Halter_Tex
  }
  scale 0.5
  translate  <10.0, 0.0, 15.0>
}
union { // Wand_Regal
  box { // Glas3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 7.625>
  }
  box { // Glas2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 10.125>
  }
  box { // Glas1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glas_gruen
    }
    scale <2.75, 7.0, 0.125>
    translate  <7.25, -5.0, 12.625>
  }
  object { G_Halter1 }
  object { G_Halter }
  scale 0.25
  rotate -270.0*z
  translate  <-3.7, 4.3, 2.4>
}


