/*
  Screw in a lightbulb

  POVray scene file
  
  Smilodon, 14 Feb 1997
  Last version 19 Feb 1997

  Submitted to IRTC competition Jan/Feb '97
  Contact info: Email at seppo.halonen@hut.fi

  Copyright/license: Use freely as long as credits remain
  For non-commercial projects only.
  */

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
//#include "wplants.pov"

/* Also 'arialbd.ttf' (Windows' Arial Bold) and 
   'courbd.ttf' (Windows' Courier New Bold) or
   other similar TrueType fonts are required.
   Any Helvetica and fixed-pitch font should work.
   */

// Setting this to 'yes' renders the screwy things as plain cones/cylinders.

#declare QUICK_PREVIEW = no

#declare very_fast_glass =
texture { pigment { color Red } finish { phong 0.4 phong_size 500 }}

#declare fast_glass = 
texture { 
  pigment { 
    color rgbt 0.9
    scale 0.06
  }
  finish { phong 1 phong_size 800 brilliance 9 }
}

#declare slow_glass = 
texture {
  pigment { color rgb 0.98 filter 0.9 }
  finish {
    diffuse 0.2
    ambient 0.01
    brilliance 9
    specular 0.9
    roughness 0.0003
    refraction 1
    ior 1.45
    reflection 0.1
    caustics 1
  }
}

#declare slow_glass2 =
texture {
  pigment { color rgb 0.98 filter 0.95 }
  finish {
    diffuse 0.1
    ambient 0.01
    brilliance 9
    specular 0.9
    refraction 0.9
    ior 1.01
    roughness 0.0003
  }
}
     
#declare Air = 
texture { 
  pigment { color Clear }
  finish { refraction 1 ior 1 }
}

#declare quick_glass = texture { slow_glass }
#declare quick_glass2 = texture { slow_glass2 }

#declare bulb_frame = 
blob {
  sphere { 0,2,1.5 scale 1+0.1*y }
  cylinder { 0,-2*y,1,1 }
  threshold 0.55
  // texture { quick_glass2 }
  // translate 2*y
}

#declare internal_framework =
merge {
  torus { 0.25,0.07 }
  cylinder { -0.07*y,0.07*y,0.25 }
  cylinder { 0,-1.2*y,0.15 }
  superellipsoid { < 0.36,0.5 > scale 0.6 translate -1.8*y scale 1-0.55*z }
  cone { -y,0.15,-1.2*y,0.16 }
  sphere { -1.2*y,0.16 }
  sphere { -1.22*y,0.17 }
  sphere { -1.24*y,0.18 }
  sphere { -1.26*y,0.19 }
  sphere { -1.28*y,0.20 }
  sphere { -1.30*y,0.21 }
  //  texture { quick_glass }
}

#declare internal_extend = 
blob {

  // vertical 'bars'
  cylinder { -x,x,1,1 scale 0.6 }
  cylinder { -x,x,1,1 scale 0.6 translate -0.4*y }
  cylinder { -x,x,1,1 scale 0.6 translate -0.2*y }
  cylinder { -x,x,1,1 scale 0.6 translate -0.6*y }
  cylinder { -x,x,1,1 scale 0.6 translate -0.8*y }
  cylinder { -x,x,1,0.9 scale 0.6 translate 0.4*y }

  // 'inhibitors'
  cylinder { -2*x,2*x,1,-0.3 scale 0.6 translate -z }
  cylinder { -2*x,2*x,1,-0.3 scale 0.6 translate z }

  // Hole in Z direction
  cylinder { -2*z,2*z,0.8,-1 scale 0.6 }

  // Big one
  cylinder { -y,-5*y,2.9,1 }
  threshold 0.65
}

#declare MyOrange = < 1,0.45,0.47 >

#declare Scorched_Steel =
texture {
  pigment {
    gradient y
    scale  1+4*y
    color_map {
      [ 0    color MyOrange ]
	[ 0.04 color Gray70 ]
	[ 0.1  color Copper ]
	[ 0.12 color Yellow ]
	[ 0.15 color Cyan ]
	[ 0.17 color Blue ]
	[ 0.23 color blue 0.2 ]
	[ 0.25 color Maroon ]
	[ 0.27 color DarkTan ]
	[ 0.29 color Gray50 ]
	[ 0.3  color Gray80 ]
	[ 0.6  color Gray80 ]
	[ 0.65 color White ]
	[ 1    color White ]
	}
  }
  finish { Metal }
}

#declare Glear = color rgbf 1

#declare Screwire = 
texture {
  pigment {
    spiral1 1
    ramp_wave
      color_map {
        [ 0 color Glear ]
	  [ 0.33 color Glear ]
	  [ 0.33 color White ]
	  [ 0.66 color White ]
	  [ 0.66 color Glear ]
	  [ 1 color Glear ]
	  }
  }
  finish { ambient 1 }
  rotate 90*y
}

#declare Internal = 
union {

  // The glass

  difference {
    merge {
      object { internal_framework translate 1.3*y scale 1.8 }
      object { internal_extend translate -1.4*y  }
      texture { quick_glass scale 0.8 }
    }
    merge {
      cylinder { -1.4*y-z,-1.5*y+z,0.4 }
      cylinder { -1.4*y,-10*y,0.27 }
      sphere { -1.4*y,0.5 }
      blob { threshold 0.65
	       cylinder { -2.6*y,-6.4*y,2.6,1 } 
      }
      texture { quick_glass }
    }
  }
  difference {
    cylinder { -1.7*y,-7*y,0.37 texture { quick_glass }}
    cylinder { -1.6*y,-7.1*y,0.27 texture { quick_glass }}
  }

  // Metal structures inside the glass

  cylinder { 
    < 0.02,-2.5,0>
      0.2*y,
      0.05 
      translate -0.85*x 
       texture { 
      pigment { color MyOrange }
      finish { Metal }
    }
  }
  cylinder { 
    <-0.02,-2.5,0>
       0.2*y,
       0.05 
       translate 0.85*x
       texture { 
      pigment { color MyOrange }
      finish { Metal }
    }
  }
  cylinder { <0.02,-2.5,0>,<-0.1,-5,0>,0.02 
		translate -0.85*x
		pigment { color Gray60 }}
  cylinder { <-0.02,-2.5,0>,<0.1,-5,0>,0.02 
		translate 0.85*x
		pigment { color Gray60 }}

  cylinder { -0.21*y,0,0.06 translate -0.85*x  pigment { color White }}
  cylinder { -0.21*y,0,0.06 translate 0.85*x  pigment { color White }}

  // The long stems

  merge {
    cylinder { 0,4.9*y,0.05 }
    cylinder { 4.6*y,4.9*y,0.05 translate 0.1*x }
    torus { 0.05,0.05 rotate 90*x translate <0.05,4.9,0> }
    texture { Scorched_Steel }
    rotate 60*y 
    rotate -20*z translate <0.85,0.2,0> 
  }
  merge {
    cylinder { 0,4.9*y,0.05 }
    cylinder { 4.6*y,4.9*y,0.05 translate 0.1*x }
    torus { 0.05,0.05 rotate 90*x translate <0.05,4.9,0> }
    texture { Scorched_Steel }
    rotate 120*y 
    rotate 20*z translate <-0.85,0.2,0> 
  }

  sphere { <0.85,0.2,0>,0.05 pigment { color MyOrange }}
  sphere { <-0.85,0.2,0>,0.05 pigment { color MyOrange }}

  // Short stems

  cylinder { <0.31,2.21,0.31>,<1,5,1>,0.02 
		pigment { color Gray90 }
  }
  cylinder { <-0.31,2.21,0.31>,<-1,5,1>,0.02 
		pigment { color Gray90 }
  }
  cylinder { <0.31,2.21,0.31>,<0.27,2.21,0>,0.02
		pigment { color Gray90 }
  }
  cylinder { <-0.31,2.21,0.31>,<-0.27,2.21,0>,0.02
		pigment { color Gray90 }
  }
  intersection {
    torus { 0.27,0.02 }
    box { <-0.3,-0.03,-0.3>,<0.3,0.03,0> }
    pigment { color Gray90 }
    translate 2.21*y
  }
  torus { 
    0.1,0.02 
      rotate 90*z 
      translate <0.98,4.8,0.85> 
      pigment { color Gray90 }
  }
  torus { 
    0.1,0.02 
      rotate 90*z 
      translate <-0.98,4.8,0.85> 
      pigment { color Gray90 }
  }

  // The wire

  cylinder { 
    <0.98,4.8,0.80>,<2.56,4.8,0>,0.05
       texture { Screwire 
		   scale 0.05
		   rotate y*26.854
		   translate <2.56,4.8,0> 
		   }
  }
  cylinder {
    <0.98,4.8,0.80>,<-0.98,4.8,0.80>,0.05
       texture { Screwire
		   scale 0.05
		   translate <0,4.8,0.80>
		   }
  }
  cylinder {
    <-0.98,4.8,0.80>,<-2.56,4.8,0>,0.05
       texture { Screwire
		   scale 0.05
		   rotate -y*26.854
		   translate <-2.56,4.8,0>
		   }
  }
  //  sphere { 0,0.1 translate <2.56,4.8,0> pigment { color Red }}
}

#declare Bedding = 
union {
  #if (QUICK_PREVIEW)
  cylinder { -y,y,1.5 open 
	       texture { pigment { color Gray90 } finish { Metal }}
  }  
  #else
  difference {
    merge {
      cylinder { -y,y,1.5 open }  
      #declare N = 180*5
      #while ( N > 0 )
      sphere { <0,1,1.44>,0.122
		  rotate -x-N*2*y 
		  translate -y*N/(90*5) 
		  }
      #declare N = N - 1
      #end
    }
    merge {
      #declare N = 180*5.5
      #while ( N > 0 )
      sphere { <0,0.8,1.56>,0.122
		  rotate -x-N*2*y 
		  translate -y*N/(90*5)
		  }
      #declare N = N - 1
      #end
    }
    bounded_by { cylinder { -1.1*y,1.1*y,1.65 }}
    texture { pigment { color Gray80 } finish { Metal }}
  }
  #end // if quick 

  // The basing at the 'bulb end'
  cylinder { 0.97*y,1.4*y,1.622 open
	       texture { pigment { color Gray90 } finish { Metal }}
  }
  cone { 0.97*y,1.622,0.7*y,1.3 open
	   texture { pigment { color Gray90 } finish { Metal }}
  }
  cone { 1.4*y,1.622,1.5*y,1.7 open
	   texture { pigment { color Gray90 } finish { Metal }}
  }

  // The inside of the base

  cone { 1.4*y,1.45,0.7*y,1.1 open
	   pigment { DMFWood2 granite }
  }
  torus { 1.536,0.08 translate 1.4*y
	    pigment { DMFWood2 granite }
  }
  cylinder { 0.7*y,-y,1.101 open pigment { color rgbf 0.6 }}

  // The cone at the end of the base
  cone { -y,1.47,-1.4*y,1
	   texture { pigment { color Gray90 } finish { Metal }}
  }
  cone { -1.4*y,0.9,-1.8*y,0.55
	   texture { pigment { color Gray10 } finish { Metal }}
  }
  cylinder { -1.75*y,-1.83*y,0.6
	       texture { pigment { color Brass } finish { Metal }}
  }
  object { Sphere scale 0.35-0.25*y translate -1.83*y 
	     texture { pigment { color Gray50 } finish { Metal }}
  }
}

#declare screw = 
merge {
  difference {
    cone { 0,1,-y,0 }
    box { -0.1,0.1 scale 1+49*x }
  }
  cylinder { -0.1*y,-2*y,0.4 }

  #if (QUICK_PREVIEW)
  cone { -2*y,0.4,-5.5*y,0.2 }
  #else
  difference {
    cone { -2*y,0.4,-5.5*y,0.2 }
    merge {
      #declare N = 45*30
      #while (N > 0)
      sphere { <0.04+(0.45*N/(45*30)),0,0>,0.12
		  rotate N*4*y
		  translate -y*(7 - N*5/(45*30))
		  }
      #declare N = N - 1
      #end
      bounded_by { cylinder { -2*y,-7*y,0.4 }}
    }
  }
  #end // if preview
  texture { Silver1 }
}      

#declare title1 = "60W 230V"
#declare title2 = "By Smilodon"

#declare Markings =
merge {
  #declare N = 1
  #while (N <= strlen(title1))
  text { ttf "arialbd.ttf" substr(title1,N,1) 0.1, 0 
	   translate -0.3*x+1.7*y
	   rotate 13*x-180*(N-0.5)/( strlen(title1) +1 )*z
	   translate -0.15*z
	   }
  #declare N = N+1
  #end
  #declare N = 1
  #while (N <= strlen(title2))
  text { ttf "courbd.ttf" substr(title2,N,1) 0.1, 0 
	   translate -0.2*x-2.5*y
	   rotate -13*x-180*(strlen(title2)-(N-0.5))/( strlen(title2) +1 )*z
	   translate -0.15*z
	   }
  #declare N = N+1
  #end
  text { ttf "arialbd.ttf" "@" 0.03, 0
	   translate -0.3*y-0.4*x
	   scale 2.5
	   rotate -90*z
	   }
  scale 2
  bounded_by { cylinder { -1.5*z,1.5*z,6 }}
  translate -0.05*z
  rotate 180*y-90*z
  pigment { color Gray40 }
}

#declare Lightbulb =
union {
  object { Bedding scale 1.7 translate -y rotate 60*y }
  object { Internal translate 6*y scale 1.22 }
  //  intersection {
  object { bulb_frame scale 5 translate (1.7+10)*y 
	     texture { slow_glass2 }}
  object { bulb_frame scale 4.995 translate (1.7+10)*y 
	     texture { Air }}
  //    }
  object { Markings scale 0.3 rotate -90*x translate 18.57*y }

  rotate -109*y 
  scale 10
  rotate 73*z
}

object { Lightbulb }
object { screw 
	   rotate 129*y 
	   rotate <92,-79,0> 
	   scale 8 
	   translate <-120,-20,0> 
	   }
	   


//  cone { -35*y,188,-25*y,270 open }
//  torus { 275,5 translate -25*y }
//  cylinder { -30*y,-40*y,190 }

#declare Swirlylayer0 =
texture {
  pigment {
    crackle
      color_map {
      [ 0 color Feldspar ]
	[ 0.3 color rgb <1,0.4,0.4> ]
	[ 0.6 color rgb <1,0.7,0.4> ]
	[ 1 color Feldspar ]
	}
    scale 3
      turbulence 1.2
      }
}

#declare SwirlyZigZag = 
texture {
  pigment { 
    //spiral1 6
    crackle
      rotate 90*x
      
      color_map {
      [ 0 color rgb 1 filter 0.2 ]
	[ 0.05 color rgb 0.9 filter 0.5 ]
	[ 0.06 color Clear ]
	[ 1 color Clear ]
	}
      turbulence 0
	scale 10
	} 
  /*  finish {
    reflection 0.3
      phong 0.2
      phong_size 50
      }*/
}

merge {
  cone { -29.9999*y,188,-25*y,220 open } // Coinciding surfaces are icky.
  torus { 225,5 translate -25*y }
  cylinder { -30*y,-40*y,190 }
  texture { Swirlylayer0 }
  texture { SwirlyZigZag }
  texture { 
    pigment { color Clear } 
    finish { phong 0.4 phong_size 900 }
  }
  translate -50*x 
}

/*
object { pumpkin scale 10 translate <200 ,-80,-400  > no_shadow }
object { pumpkin scale 10 rotate 10*z translate <500,-80,-230> no_shadow }
object { pumpkin scale 10 rotate -5*x translate <280,-80,-590> no_shadow }

object { lotus scale 30 translate < 489,-45,-680> }
object { lotus scale 30 translate < -50,-45,-330> }

object { Flowwer rotate -50*y scale 15 translate <280,-45,-280> }
object { Flowwer scale 15 rotate -34*y translate <50,-45,-530> }
object { Flow2 scale 20 rotate 10*y translate < 270,-45, -150 > }
*/

#declare FonkyGraphics = 
texture {
  pigment { 
    leopard
    triangle_wave
    frequency 10
    color_map { 
      [ 0 color MediumForestGreen ]
      [ 0.5 color DarkOliveGreen ] 
      [ 0.8 color DarkTurquoise ] 
      [ 1 color DarkTurquoise ] 
    }
    rotate 90*x
    scale 110
    rotate 90*y 
  } 
  normal { granite 0.3 scale 5 }
  finish { Phong_Dull }
}

#declare FonkyWater =
texture { 
  pigment { color rgbf <0.6,0.7,0.9,0.8> }  
  normal { waves 0.2 scale 5 translate -60*x  }
  finish { 
    reflection 0.2
      refraction 1
      ior 1.1
  }
  scale 30
}

box {  
  <-500,-50,-500>,<500,-45,500>
  // was plane {  y,-45 }
  texture { 
    /*
      hexagon
      texture { DMFDarkOak translate -y scale 0.9 }
      texture { DMFLightOak translate 0.3*y scale 0.7 rotate 60*y }
      texture { Rosewood translate y scale 0.5 rotate 120*y }
      scale 90
      */
    pigment { leopard
		scale 30
		color_map {
      [ 0 color rgb < 0.4,0.4,0.45 > ]
	[ 0.3 color Gray80 ] 
	[ 0.45 color rgb < 0.5,0.4,0.4> ]
	[ 0.7 color Gray90 ]
	[ 0.9 color rgb < 0.5,0.4,0.4> ]
	[ 1 color rgb < 0.51,0.57,0.54 > ]
	}
    turbulence 4
    octaves 3
    omega 0.4
    }
    finish { Phong_Dull }
    normal { granite 0.3 scale 5 }
  }
  rotate -20*y
}

plane { 
  y,-330
  texture { 
    pigment { 
      bozo
	color_map { 
	[ 0 color Gray50]
	  [ 0.3 color Gray50 ]
	  [ 0.6 color Gray60]  
	  [ 1 color Gray60 ] 
	  }
      scale (20+50*z)*2
	turbulence 0.9
	rotate 45*y
	}
    finish { ambient 0.5 }
  }
}
/*
plane { 
  y,-190 
    texture { 
    pigment { color Cyan*0.3 } // Counter shadowlessness
    finish { ambient 1 } // Shadowless
  }
} 
*/
camera { location <-270,160,230> look_at 30*y-89*x angle 38 }
//camera { location <-410,60,50> look_at 50*y-180*x angle 20 }

light_source { < -290,190,90 > color White }
light_source { < 100,230,-200 > color White }
//light_source { < -548,-69,-92 > color White }

sky_sphere { pigment { Bright_Blue_Sky turbulence 2.1 } rotate 60*x scale 0.3 }

global_settings { 
    assumed_gamma 1.8
    max_trace_level 35
    adc_bailout 1/64
}
