// Love Sucks -- by Roy Mitchell Harper

// I was feeling a little cynical one day, and became inspired to create this image. As a
//   fortunate happenstance, the topic at this time for the Internet Raytracing Competition
//   is "Glass." Hence this entry.

// Although the image works just fine as a standalone image, I have set it up to be a simple
//   animation. Just add the options "+KI-1 +KFF[number of frames]" to the render
//   settings. ("+KI-1" sets the initial clock value to -1, "+KFF" sets the ).

// Also, I have been experimenting with the alternate anti-aliasing method recently. On this
//   image, I used "+AM2 +R2 +A0.0". "+AM2" selects the second anti-aliasing method (the .INI
//   file setting is "Sampling_Method=2"). "+R2" sets the anti-aliasing recursion depth to 2
//   (the default is 3, which is a bit too time consuming for me). "+A0.0" tells POV-Ray
//   to work it's absolute hardest to create an antialiased image ("+A0.3" does a perfectly
//   fine job, I just wanted to give my computer something to do for a while).


// By changing the flags here, you can have "Love Sucks", "Celibacy Sucks", or "Love Stinks".
//   (I suppose you could also have "Celibacy Stinks", if you really want to).

#declare bCelibacy   = false
#declare bLove       = true
#declare bSucks      = true
#declare bStinks     = false



//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 3 textures and 19 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/15/1997    (15.02.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-1.750 + (clock * 3.5), -4.250, 3.250 - (clock * 1.0)>
  // location  <-2 + (clock * 4), -4.250, 3.250 - (clock * 1.0)>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******
light_source {   // Light2
  <-14.000, -10.000, 40.000>
  color rgb <0.502, 0.677, 0.885>
}

light_source {   // Light1
  <15.000, -15.000, 30.000>
  color rgb <1.000, 0.745, 0.604>
}


// ********  TEXTURES  *******
//

#include "ls.inc"



// ********  REFERENCED OBJECTS  *******

#declare TempCSG001 = union {
  plane { // Plane3
    z,0
    rotate -180.0*x
  }
  translate  0.95*z
}
#declare CSG001 = union {
  object { TempCSG001 }
  rotate -60.0*x
}
#declare TempCSG2 = union {
  plane { // Plane4
    z,0
    rotate -180.0*x
  }
  translate  0.95*z
}
#declare CSG7 = union {
  object { TempCSG2 }
  rotate <-120.0, 0.0, -30.0>
}




// ********  OBJECTS  *******


// Text Object
#declare fTextHeight = 0.1

union
  {
    object
    {
#if (bCelibacy = true)
      text
        {
          ttf "Shelley-.ttf",
          "Celibacy",
          fTextHeight, 0
        }
      scale <0.61, 0.61, 1>
      translate <-0.8, 0.15, 0>
#end

#if (bLove = true)
      text
        {
          ttf "Shelley-.ttf",
          "Love",
          fTextHeight, 0
        }
      scale <0.75, 0.75, 1>
      translate <-0.65, 0.1, 0>
#end
    }
    object
    {
#if (bSucks = true)
      text
        {
          ttf "Shelley1.ttf",
          "Sucks",
          fTextHeight, 0
        }
      scale <0.75, 0.75, 1>
      translate <-0.7, -0.6, 0>
#end

#if (bStinks = true)
      text
        {
          ttf "Shelley1.ttf",
          "Stinks",
          fTextHeight, 0
        }
      scale <0.75, 0.75, 1>
      translate <-0.8, -0.6, 0>
#end
    }
  texture { TextTexture }
  translate <0, 0, -(fTextHeight/2)>
  no_shadow
}


/*
box { // TextCube
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LoveSucksTexture
  }
  no_shadow
  scale <0.7072, 0.7072, 0.0001>
}
*/


difference { // MainObject
  sphere { // MainSphere
    <0,0,0>,1
  }
  plane { // Plane1
    z,0
    rotate -180.0*x
    translate  0.85*z
  }
  plane { // Plane2
    z,0
    translate  -0.85*z
  }
  object { CSG001 }
  object { // CSG2->CSG001
    CSG001
    rotate -60.0*z
  }
  object { // CSG3->CSG001
    CSG001
    rotate -120.0*z
  }
  object { // CSG4->CSG001
    CSG001
    rotate 180.0*z
  }
  object { // CSG5->CSG001
    CSG001
    rotate 120.0*z
  }
  object { // CSG6->CSG001
    CSG001
    rotate 60.0*z
  }
  object { CSG7 }
  object { // CSG8->CSG7
    CSG7
    rotate <0.0, 0.0, -60.0>
  }
  object { // CSG9->CSG7
    CSG7
    rotate <0.0, 0.0, -120.0>
  }
  object { // CSG10->CSG7
    CSG7
    rotate <0.0, 0.0, 180.0>
  }
  object { // CSG11->CSG7
    CSG7
    rotate <0.0, 0.0, 120.0>
  }
  object { // CSG12->CSG7
    CSG7
    rotate <0.0, 0.0, 60.0>
  }
  texture {
    GlassTexture
  }
  no_shadow
  rotate <0, 0, 60 * -clock>
}


plane { // FloorPlane
  z,0
  texture {
    FloorTexture
  }
  no_shadow
  translate  -1.25*z
}




