
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:magic
// Date:02 08 1997
// Auth:Anto Matkovic
// Email: anto.matkovic@zg.tel.hr

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "boca.INC"
#include "guster.INC"

#declare svijeca = texture{pigment{colour rgbf<1, 0.98, 0.9, 0.2>}
  finish {diffuse 0.6 ambient 0.4 phong 0.6    phong_size 20 }
  normal{ bumps 0.1 scale 0.05 }}

#declare fitilj = texture{pigment{gradient z
colour_map {[0.2 red 1 green 0.95 blue 0.9]
            [0.6 red 0 green 0 blue 0]}}
  finish {diffuse 0.6 ambient 0.4 phong 0.8  phong_size 30 }}

#declare vatra = texture { pigment {colour Clear}
   halo {linear max_value 1 spherical_mapping
    emitting turbulence 0.4
    omega 0.2 colour_map {
         [0 colour rgbt <1, 0.4, 0.2, 1>]
         [1 colour rgbt <1,1,0,-0.8>]}
      samples 5}}

#declare vatra1 = texture { pigment {colour Clear}
   halo {linear max_value 1 spherical_mapping
    emitting turbulence 0.6
    omega 0.2 colour_map {
         [0 colour rgbt <1, 0.4, 0.2, 1>]
         [1 colour rgbt <1,1,0,-0.8>]}
      samples 5}}

#declare plavavatra = texture { pigment {colour Clear}
   halo {linear max_value 0.5 spherical_mapping
    emitting turbulence 0.1
    omega 0.2 colour_map {
         [0 colour rgbt <1,0.5,0.7,1>]
         [1 colour rgbt <0.3, 0.2, 1,0>]}
      samples 5}}

#declare specfade4 = texture{pigment{colour rgbf<0.9,0.9,0.8,0.9>}
  finish {diffuse 0.1 specular 0.8  roughness 0.01 phong 1.0    phong_size 400
    reflection 0.3 refraction 1.0    ior 1.4}}

#declare specunutra6 = texture{pigment{marble turbulence 1
color_map{ [0.2 red 1 green 0.9 blue 0.1 filter 0.9]
           [0.6 red 1.0 green 0.6 blue 0.2 filter 0.9]
           [0.9 red 0.5 green 0.5 blue 0.5 filter 0.9]}
scale 0.1}  finish {diffuse 0.1 ambient 0.7 }}


#declare rastopljeniv = texture {pigment {colour rgbf <0.8, 0.8, 0.8, 0.7>}
finish {ambient 0.1 diffuse 0.1 phong 1 phong_size 240 reflection 0.3
refraction 1 ior 1.4}}

#declare specfadebozo = texture{pigment{bozo turbulence 0.7
color_map{ [0.3 red 1 green 0.9 blue 0.9 filter 0.95]
           [0.9 red 1.0 green 0.6 blue 0.1 filter 0.95]}}
  finish {diffuse 0.1 specular 0.8  roughness 0.01 phong 1.0    phong_size 400
    reflection 0.3 refraction 1.0  ior 1.4 fade_distance 4 fade_power 1} scale 0.2}

#declare specmarble1 = texture{pigment{marble turbulence 1
color_map{ [0.6 red 0.9 green 0.9 blue 0.9 filter 0.9]
           [0.7 red 0.5 green 0.6 blue 0.9 filter 0.5]
           [0.8 red 1.0 green 0.9 blue 0.3 filter 0.5]
           [0.9 red 1.0 green 0.5 blue 0.1 filter 0.5]}
scale 0.6}  finish {diffuse 0.1 specular 0.8  roughness 0.01
phong 1.0  phong_size 400
reflection 0.4 refraction 1.0  ior 1.45 }}



#declare specunutra1 = texture{pigment{gradient y+z
color_map{ [0.4 red 0.5 green 0.5 blue 1 filter 0.3 transmit 0.5]
           [0.6 red 1.0 green 0.9 blue 0.1 filter 0.3 transmit 0.5]
           [0.9 red 1.0 green 0.0 blue 0.0 filter 0.3 transmit 0.5]}
scale 0.1}  finish {diffuse 0.1 ambient 0.7 }}


#declare specunutra2 = texture{pigment{gradient x+y
color_map{ [0.2 red 1 green 0.96 blue 0.8 filter 0.3 transmit 0.5]
           [0.6 red 0.0 green 0.5 blue 0.7 filter 0.3 transmit 0.5]
           [0.9 red 1.0 green 0.5 blue 0.1 filter 0.3 transmit 0.5]}
scale 0.1}  finish {diffuse 0.1 ambient 0.7 }}

#declare specunutra3 = texture{pigment{gradient x+y
color_map{ [0.2 red 1 green 0.96 blue 0.8 filter 0.3 transmit 0.5]
           [0.9 red 1.0 green 0.5 blue 0.9 filter 0.3 transmit 0.5]}
scale 0.1}  finish {diffuse 0.1 ambient 0.7 }}


sky_sphere
{pigment { gradient z
color_map { [0.0 color red 0 green 0 blue 0] [1.0 color red 0.5 green 0.5 blue 0.5 ] }}}


camera
{  location  <35, 0, 22>
   direction <0.0, 2.747477, 0.0>
   sky       <0.0, 0.0, 1.0>
   up        <0.0, 0.0, 1.0>
   right     <1.33, 0.0, 0.0>
   look_at   <0, 0, -1>
   angle 29}

height_field
{
  gif  "zaheightfield.gif"     // the file name to read
 inverse
  texture {pigment {bozo colour_map
  {[0.2 red 0.4 green 0.33 blue 0.28]
   [0.5 red 0.37 green 0.3 blue 0.25]
   [0.9 red 0.32 green 0.28 blue 0.18]}
   scale 0.02}
   finish {ambient 0.1 diffuse 0.3
   }
   normal{granite 0.5 scale 0.01}}
smooth
water_level -2

 rotate <0, 0, 90>
 scale <80, 40, 2>
 translate <8, -20, -5.5>
}
//Svijeca1
union{
light_source
{ 0*x // light's position (translated below)
  color rgb <2.2, 1.8, 1.2> translate <0, 0.4, 6.6>}
//svijeca
blob
{ threshold 0.64
  cylinder {  <0, 0, -2>, <0, 0, 5>, 1.1, 1 }//glavni
  sphere { <-0.5, 0, 0>, 0.6, 0.3 }//dolje debela
  sphere { <0, 0, 6>, -1, -7 }//gore
  sphere { <0, 0.5, 6>, 1, 1 }//mala gore
  sphere { <0.5, 0.5, 3>, 1, 0.4 scale <0.4, 0.4, 1.4> }//mala sa strane
  sphere { <0.35, -0.35, 7>, 0.9, 0.6 scale <0.3, 0.3, 0.6> }//mala sa strane desno
  cylinder {  <-0.3, 0, 4.5>, <-0.5, 0, 5.6>, 0.2, 0.1 }//ovo je mali cylinder
  cylinder {  <-0.3, 0.2, 3>, <-0.3, 0.3, 5.5>, 0.2, 0.1 }//ovo je mali cylinder
  sphere { <0, 0, -1.22>, -1, -6 }//dolje
  texture {svijeca}}

//rastopljeni vosak
sphere { <0, 0, 0> 0.5
scale < 0.4, 0.7, 0.2>
translate <0, 0, 5.1>
texture {rastopljeniv}}

//fitilj
cylinder
{ <0, 0, 2> <0, 0, 5.64> 0.04
texture {fitilj}}

//vatra
object{Sphere hollow texture {vatra}
scale <0.27, 0.27, 1.1>
translate <0, 0,6.7>}

//plava vatra
object{Sphere hollow texture {plavavatra}
scale <0.11, 0.11, 0.4>
translate <0, 0, 5.5>}
translate <-2, -4,-1.6>}

//Svijeca2
union{
light_source
{ 0*x // light's position (translated below)
  color rgb <2.2, 1.8, 1.2> translate <0, 0.4, 6.6>}

//svijeca
blob
{ threshold 0.64
  cylinder {  <0, 0, -2>, <0, 0, 5>, 1.1, 1 }//glavni
  sphere { <0, 0, 6>, -1, -7 }//gore
  sphere { <0, 0.5, 6>, 1, 1 }//mala gore
  sphere { <0.35, -0.35, 7>, 0.9, 0.6 scale <0.3, 0.3, 0.6> }//mala sa strane desno
  cylinder {  <-0.3, 0, 4.5>, <-0.5, 0, 5.6>, -0.2, -0.1 }//ovo je mali cylinder
  sphere { <0, 0, -1.22>, -1, -6 }//dolje
  texture {svijeca}
  rotate <0, 0, 45>}

//rastopljeni vosak
sphere { <0, 0, 0> 0.5
scale < 0.4, 0.6, 0.2>
translate <0, 0, 5.1>
texture {rastopljeniv}}

//fitilj
cylinder
{ <0, 0, 2> <0, 0, 5.64> 0.04
texture {fitilj}}

//vatra
object{Sphere hollow texture {vatra1}
scale <0.27, 0.27, 1.05>
translate <0, 0, 6.7>}

//plava vatra
object{Sphere hollow texture {plavavatra}
scale <0.11, 0.11, 0.4>
translate <0, 0, 5.5>}
translate <-2, 4, -1.63>}

//gornje staklo

object
{    box {<0, 0, 0>, <1, 1, 1> }
texture{
 material_map {
  gif "aakrivulje.GIF" 
  once
  map_type 0// 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

  texture { pigment {colour rgb <0.05, 0.05, 0.05>}
  finish{ambient 0.2 diffuse 0.6 phong 1 phong_size 160}
  normal { bumps 0.5 scale 0.5}}
  texture { pigment {colour rgbf <0.93, 0.93, 0.93, 0.9>}
  finish {ambient 0.1 diffuse 0.1 phong 1 phong_size 270 reflection 0.3}}}
  scale     <1.00, 1.00, 0.01>}

   scale     <14.00, 14.00, 0.01>
 translate <-7, -7, -2>
 rotate <0, 0, 45>}

//donja ploca
 box
{
  <0, 0, 0>
  < 1,  1,  1>
  texture{
 material_map {
  gif "aalinije.GIF"
  once
  map_type 0// 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

  texture { pigment {colour rgb <0.05, 0.05, 0.05>}
  finish{ambient 0.2 diffuse 0.6 phong 1 phong_size 160}
  normal { quilted 0.2 control0 -1 control1 1}}
  texture { pigment {colour rgbt <0.9, 0.2, 0, 0.5>}
  finish {ambient 0.2 diffuse 0.2 phong 1 phong_size 220 reflection 0.3}
  scale 0.05}}
  }
  scale < 18, 28, 5>
  translate <-9, -11, -9>
  rotate <0, 0, 90>

}

//spectorus
union{
sphere
{<0, 0, 0> // center of sphere <X Y Z>
  0.5       // radius of sphere
 texture {specfadebozo}}
object{
union{

 torus {2.000000, 0.500000
	scale     <0.14, 0.14, 0.07>
      texture {specunutra1}
      rotate <0, 0, 0 >}
 torus {2.000000, 0.500000
	scale     <0.07, 0.14, 0.14>
      texture {specunutra2}
      rotate <0, 0, 90 >}
 torus {2.000000, 0.500000
	scale     <0.14, 0.14, 0.07>
      texture {specunutra3}
      rotate <90, 0, 90 >}}}
 scale 3
 translate <9, 0, 0.5>}


//  specmarble
object
{    sphere {<0, 0, 0>, 0.5 }
       scale     <3, 3, 3>
       translate <4, 5.5, 0.5>
       texture {specmarble1}
}

//spec disc
union{
 sphere
 {<0, 0, 0>, 0.5
texture {specfade4}}
disc
{<0, 0, 0>  z, 0.4,
  texture{specunutra6}}
disc
{<0, 0, 0>  y, 0.4,
  texture{specunutra6}}
 scale <3, 3, 3>
 rotate <0, 0, 90>
 translate <4, -5.5, 0.5>}

