//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 12 textures and 302 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/27/1997    (27.02.1997)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//


camera {  //  Camera Camera01
  location  <-29.480, 14.439, 17.538>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-2.341, -0.214, 2.129>
}



// *******  L I G H T S *******
light_source {   // Light001
  <-111.028, -16.781, 29.908>
  color rgb <1.000, 1.000, 0.953>
  
}

light_source {   // Light002
  <-110.028, -16.781, 29.908>
  color rgb <1.000, 1.000, 0.953>
  
}


// ********  TEXTURES  *******
//

#include "beer.inc"



// ********  REFERENCED OBJECTS  *******

#declare bottle_mesh = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.040131, -0.007227, 0.041203>, <-0.040131, -0.028655, 0.041203>, <-0.022578, -0.046187, 0.041203>, <-0.001124, -0.046187, 0.041203>,
      <-0.986727, 0.000000, -0.214342>, <-0.986727, -0.531910, -0.214342>, <-0.542700, -0.967109, -0.214342>, <0.000000, -0.967109, -0.214342>,
      <-0.979354, 0.000000, 0.062758>, <-0.979354, -0.531910, 0.062758>, <-0.535327, -0.967109, 0.062758>, <0.007373, -0.967109, 0.062758>,
      <-0.979332, 0.000000, 0.170782>, <-0.979332, -0.533127, 0.170782>, <-0.536974, -0.969321, 0.170782>, <0.003687, -0.969321, 0.170782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001124, -0.046187, 0.041203>, <0.020331, -0.046187, 0.041203>, <0.037884, -0.028655, 0.041203>, <0.037884, -0.007227, 0.041203>,
      <0.000000, -0.967109, -0.214342>, <0.542700, -0.967109, -0.214342>, <0.986727, -0.531910, -0.214342>, <0.986727, 0.000000, -0.214342>,
      <0.007373, -0.967109, 0.062758>, <0.550073, -0.967109, 0.062758>, <0.994100, -0.531910, 0.062758>, <0.994100, 0.000000, 0.062758>,
      <0.003687, -0.969321, 0.170782>, <0.544347, -0.969321, 0.170782>, <0.986705, -0.533127, 0.170782>, <0.986705, 0.000000, 0.170782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.037884, -0.007227, 0.041203>, <0.037884, 0.014202, 0.041203>, <0.020331, 0.031734, 0.041203>, <-0.001124, 0.031734, 0.041203>,
      <0.986727, 0.000000, -0.214342>, <0.986727, 0.531910, -0.214342>, <0.542700, 0.967109, -0.214342>, <0.000000, 0.967109, -0.214342>,
      <0.994100, 0.000000, 0.062758>, <0.994100, 0.531910, 0.062758>, <0.550073, 0.967109, 0.062758>, <0.007373, 0.967109, 0.062758>,
      <0.986705, 0.000000, 0.170782>, <0.986705, 0.533127, 0.170782>, <0.544347, 0.969321, 0.170782>, <0.003687, 0.969321, 0.170782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001124, 0.031734, 0.041203>, <-0.022578, 0.031734, 0.041203>, <-0.040131, 0.014202, 0.041203>, <-0.040131, -0.007227, 0.041203>,
      <0.000000, 0.967109, -0.214342>, <-0.542700, 0.967109, -0.214342>, <-0.986727, 0.531910, -0.214342>, <-0.986727, 0.000000, -0.214342>,
      <0.007373, 0.967109, 0.062758>, <-0.535327, 0.967109, 0.062758>, <-0.979354, 0.531910, 0.062758>, <-0.979354, 0.000000, 0.062758>,
      <0.003687, 0.969321, 0.170782>, <-0.536974, 0.969321, 0.170782>, <-0.979332, 0.533127, 0.170782>, <-0.979332, 0.000000, 0.170782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.979332, 0.000000, 0.170782>, <-0.979332, -0.533127, 0.170782>, <-0.536974, -0.969321, 0.170782>, <0.003687, -0.969321, 0.170782>,
      <-0.979310, 0.000000, 0.278806>, <-0.979310, -0.534343, 0.278806>, <-0.538621, -0.971533, 0.278806>, <0.000000, -0.971533, 0.278806>,
      <-0.948487, 0.000000, 0.450300>, <-0.948487, -0.531245, 0.450300>, <-0.521668, -0.965900, 0.450300>, <0.000000, -0.965900, 0.450300>,
      <-0.967607, 0.000000, 1.849518>, <-0.967607, -0.531577, 1.849518>, <-0.532184, -0.966504, 1.849518>, <0.000000, -0.966504, 1.849518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.003687, -0.969321, 0.170782>, <0.544347, -0.969321, 0.170782>, <0.986705, -0.533127, 0.170782>, <0.986705, 0.000000, 0.170782>,
      <0.000000, -0.971533, 0.278806>, <0.538621, -0.971533, 0.278806>, <0.979310, -0.534343, 0.278806>, <0.979310, 0.000000, 0.278806>,
      <0.000000, -0.965900, 0.450300>, <0.521668, -0.965900, 0.450300>, <0.948487, -0.531245, 0.450300>, <0.948487, 0.000000, 0.450300>,
      <0.000000, -0.966504, 1.849518>, <0.532184, -0.966504, 1.849518>, <0.967607, -0.531577, 1.849518>, <0.967607, 0.000000, 1.849518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.986705, 0.000000, 0.170782>, <0.986705, 0.533127, 0.170782>, <0.544347, 0.969321, 0.170782>, <0.003687, 0.969321, 0.170782>,
      <0.979310, 0.000000, 0.278806>, <0.979310, 0.534343, 0.278806>, <0.538621, 0.971533, 0.278806>, <0.000000, 0.971533, 0.278806>,
      <0.948487, 0.000000, 0.450300>, <0.948487, 0.531245, 0.450300>, <0.521668, 0.965900, 0.450300>, <0.000000, 0.965900, 0.450300>,
      <0.967607, 0.000000, 1.849518>, <0.967607, 0.531577, 1.849518>, <0.532184, 0.966504, 1.849518>, <0.000000, 0.966504, 1.849518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.003687, 0.969321, 0.170782>, <-0.536974, 0.969321, 0.170782>, <-0.979332, 0.533127, 0.170782>, <-0.979332, 0.000000, 0.170782>,
      <0.000000, 0.971533, 0.278806>, <-0.538621, 0.971533, 0.278806>, <-0.979310, 0.534343, 0.278806>, <-0.979310, 0.000000, 0.278806>,
      <0.000000, 0.965900, 0.450300>, <-0.521668, 0.965900, 0.450300>, <-0.948487, 0.531245, 0.450300>, <-0.948487, 0.000000, 0.450300>,
      <0.000000, 0.966504, 1.849518>, <-0.532184, 0.966504, 1.849518>, <-0.967607, 0.531577, 1.849518>, <-0.967607, 0.000000, 1.849518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.967607, 0.000000, 1.849518>, <-0.967607, -0.531577, 1.849518>, <-0.532184, -0.966504, 1.849518>, <0.000000, -0.966504, 1.849518>,
      <-0.986727, 0.000000, 3.248735>, <-0.986727, -0.531910, 3.248735>, <-0.542700, -0.967109, 3.248735>, <0.000000, -0.967109, 3.248735>,
      <-0.983813, 0.000000, 3.392750>, <-0.983813, -0.506993, 3.392750>, <-0.541097, -0.921805, 3.392750>, <0.000000, -0.921805, 3.392750>,
      <-1.012417, 0.000000, 3.906224>, <-0.995929, -0.531644, 3.906224>, <-0.547761, -0.966626, 3.906224>, <-0.016488, -0.966626, 3.906224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.966504, 1.849518>, <0.532184, -0.966504, 1.849518>, <0.967607, -0.531577, 1.849518>, <0.967607, 0.000000, 1.849518>,
      <0.000000, -0.967109, 3.248735>, <0.542700, -0.967109, 3.248735>, <0.986727, -0.531910, 3.248735>, <0.986727, 0.000000, 3.248735>,
      <0.000000, -0.921805, 3.392750>, <0.541097, -0.921805, 3.392750>, <0.983813, -0.506993, 3.392750>, <0.983813, 0.000000, 3.392750>,
      <-0.016488, -0.966626, 3.906224>, <0.547761, -0.966626, 3.906224>, <0.995929, -0.531644, 3.906224>, <0.979441, 0.000000, 3.906224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.967607, 0.000000, 1.849518>, <0.967607, 0.531577, 1.849518>, <0.532184, 0.966504, 1.849518>, <0.000000, 0.966504, 1.849518>,
      <0.986727, 0.000000, 3.248735>, <0.986727, 0.531910, 3.248735>, <0.542700, 0.967109, 3.248735>, <0.000000, 0.967109, 3.248735>,
      <0.983813, 0.000000, 3.392750>, <0.983813, 0.506993, 3.392750>, <0.541097, 0.921805, 3.392750>, <0.000000, 0.921805, 3.392750>,
      <0.979441, 0.000000, 3.906224>, <0.995929, 0.531644, 3.906224>, <0.547761, 0.966626, 3.906224>, <-0.016488, 0.966626, 3.906224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.966504, 1.849518>, <-0.532184, 0.966504, 1.849518>, <-0.967607, 0.531577, 1.849518>, <-0.967607, 0.000000, 1.849518>,
      <0.000000, 0.967109, 3.248735>, <-0.542700, 0.967109, 3.248735>, <-0.986727, 0.531910, 3.248735>, <-0.986727, 0.000000, 3.248735>,
      <0.000000, 0.921805, 3.392750>, <-0.541097, 0.921805, 3.392750>, <-0.983813, 0.506993, 3.392750>, <-0.983813, 0.000000, 3.392750>,
      <-0.016488, 0.966626, 3.906224>, <-0.547761, 0.966626, 3.906224>, <-0.995929, 0.531644, 3.906224>, <-1.012417, 0.000000, 3.906224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.012417, 0.000000, 3.906224>, <-0.995929, -0.531644, 3.906224>, <-0.547761, -0.966626, 3.906224>, <-0.016488, -0.966626, 3.906224>,
      <-1.008045, 0.000000, 4.419698>, <-1.008045, -0.556295, 4.419698>, <-0.554425, -1.011446, 4.419698>, <0.000000, -1.011446, 4.419698>,
      <-1.000538, -0.015439, 4.674583>, <-0.988237, -0.569107, 4.674583>, <-0.557062, -0.991284, 4.674583>, <-0.004008, -0.990375, 4.674583>,
      <-0.676885, -0.007719, 4.869174>, <-0.654246, -0.383094, 4.869174>, <-0.366601, -0.674808, 4.869174>, <-0.018492, -0.674353, 4.869174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016488, -0.966626, 3.906224>, <0.547761, -0.966626, 3.906224>, <0.995929, -0.531644, 3.906224>, <0.979441, 0.000000, 3.906224>,
      <0.000000, -1.011446, 4.419698>, <0.554425, -1.011446, 4.419698>, <1.008045, -0.556295, 4.419698>, <1.008045, 0.000000, 4.419698>,
      <-0.004008, -0.990375, 4.674583>, <0.549047, -0.989465, 4.674583>, <0.996168, -0.538482, 4.674583>, <1.004504, -0.007339, 4.674583>,
      <-0.018492, -0.674353, 4.869174>, <0.362594, -0.673898, 4.869174>, <0.658212, -0.367782, 4.869174>, <0.645892, -0.003669, 4.869174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.979441, 0.000000, 3.906224>, <0.995929, 0.531644, 3.906224>, <0.547761, 0.966626, 3.906224>, <-0.016488, 0.966626, 3.906224>,
      <1.008045, 0.000000, 4.419698>, <1.008045, 0.556295, 4.419698>, <0.554425, 1.011446, 4.419698>, <0.000000, 1.011446, 4.419698>,
      <1.004504, -0.007339, 4.674583>, <1.012840, 0.523805, 4.674583>, <0.580435, 0.995135, 4.674583>, <0.004003, 1.006068, 4.674583>,
      <0.645892, -0.003669, 4.869174>, <0.666548, 0.360443, 4.869174>, <0.378288, 0.676733, 4.869174>, <-0.014487, 0.682200, 4.869174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016488, 0.966626, 3.906224>, <-0.547761, 0.966626, 3.906224>, <-0.995929, 0.531644, 3.906224>, <-1.012417, 0.000000, 3.906224>,
      <0.000000, 1.011446, 4.419698>, <-0.554425, 1.011446, 4.419698>, <-1.008045, 0.556295, 4.419698>, <-1.008045, 0.000000, 4.419698>,
      <0.004003, 1.006068, 4.674583>, <-0.572429, 1.017000, 4.674583>, <-1.012840, 0.538229, 4.674583>, <-1.000538, -0.015439, 4.674583>,
      <-0.014487, 0.682200, 4.869174>, <-0.374285, 0.687666, 4.869174>, <-0.666548, 0.367656, 4.869174>, <-0.676885, -0.007719, 4.869174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.676885, -0.007719, 4.869174>, <-0.654246, -0.383094, 4.869174>, <-0.366601, -0.674808, 4.869174>, <-0.018492, -0.674353, 4.869174>,
      <-0.320256, 0.000000, 5.063764>, <-0.320256, -0.197082, 5.063764>, <-0.176141, -0.358331, 5.063764>, <0.000000, -0.358331, 5.063764>,
      <-0.466178, 0.000000, 5.517425>, <-0.466178, -0.259626, 5.517425>, <-0.256398, -0.472047, 5.517425>, <0.000000, -0.472047, 5.517425>,
      <-0.491888, 0.000000, 5.931869>, <-0.475400, -0.265437, 5.931869>, <-0.261470, -0.482613, 5.931869>, <-0.016488, -0.482613, 5.931869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.018492, -0.674353, 4.869174>, <0.362594, -0.673898, 4.869174>, <0.658212, -0.367782, 4.869174>, <0.645892, -0.003669, 4.869174>,
      <0.000000, -0.358331, 5.063764>, <0.176141, -0.358331, 5.063764>, <0.320256, -0.197082, 5.063764>, <0.320256, 0.000000, 5.063764>,
      <0.000000, -0.472047, 5.517425>, <0.256398, -0.472047, 5.517425>, <0.466178, -0.259626, 5.517425>, <0.466178, 0.000000, 5.517425>,
      <-0.016488, -0.482613, 5.931869>, <0.261470, -0.482613, 5.931869>, <0.475400, -0.265437, 5.931869>, <0.458912, 0.000000, 5.931869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.645892, -0.003669, 4.869174>, <0.666548, 0.360443, 4.869174>, <0.378288, 0.676733, 4.869174>, <-0.014487, 0.682200, 4.869174>,
      <0.320256, 0.000000, 5.063764>, <0.320256, 0.197082, 5.063764>, <0.176141, 0.358331, 5.063764>, <0.000000, 0.358331, 5.063764>,
      <0.466178, 0.000000, 5.517425>, <0.466178, 0.259626, 5.517425>, <0.256398, 0.472047, 5.517425>, <0.000000, 0.472047, 5.517425>,
      <0.458912, 0.000000, 5.931869>, <0.475400, 0.265437, 5.931869>, <0.261470, 0.482613, 5.931869>, <-0.016488, 0.482613, 5.931869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.014487, 0.682200, 4.869174>, <-0.374285, 0.687666, 4.869174>, <-0.666548, 0.367656, 4.869174>, <-0.676885, -0.007719, 4.869174>,
      <0.000000, 0.358331, 5.063764>, <-0.176141, 0.358331, 5.063764>, <-0.320256, 0.197082, 5.063764>, <-0.320256, 0.000000, 5.063764>,
      <0.000000, 0.472047, 5.517425>, <-0.256398, 0.472047, 5.517425>, <-0.466178, 0.259626, 5.517425>, <-0.466178, 0.000000, 5.517425>,
      <-0.016488, 0.482613, 5.931869>, <-0.261470, 0.482613, 5.931869>, <-0.475400, 0.265437, 5.931869>, <-0.491888, 0.000000, 5.931869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.491888, 0.000000, 5.931869>, <-0.475400, -0.265437, 5.931869>, <-0.261470, -0.482613, 5.931869>, <-0.016488, -0.482613, 5.931869>,
      <-0.484622, 0.000000, 6.346313>, <-0.484622, -0.271248, 6.346313>, <-0.266542, -0.493179, 6.346313>, <0.000000, -0.493179, 6.346313>,
      <-0.326030, 0.000000, 6.766363>, <-0.326030, -0.175042, 6.766363>, <-0.179316, -0.318258, 6.766363>, <0.000000, -0.318258, 6.766363>,
      <-0.326030, 0.000000, 7.186412>, <-0.326030, -0.175042, 7.186412>, <-0.179316, -0.318258, 7.186412>, <0.000000, -0.318258, 7.186412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016488, -0.482613, 5.931869>, <0.261470, -0.482613, 5.931869>, <0.475400, -0.265437, 5.931869>, <0.458912, 0.000000, 5.931869>,
      <0.000000, -0.493179, 6.346313>, <0.266542, -0.493179, 6.346313>, <0.484622, -0.271248, 6.346313>, <0.484622, 0.000000, 6.346313>,
      <0.000000, -0.318258, 6.766363>, <0.179316, -0.318258, 6.766363>, <0.326030, -0.175042, 6.766363>, <0.326030, 0.000000, 6.766363>,
      <0.000000, -0.318258, 7.186412>, <0.179316, -0.318258, 7.186412>, <0.326030, -0.175042, 7.186412>, <0.326030, 0.000000, 7.186412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.458912, 0.000000, 5.931869>, <0.475400, 0.265437, 5.931869>, <0.261470, 0.482613, 5.931869>, <-0.016488, 0.482613, 5.931869>,
      <0.484622, 0.000000, 6.346313>, <0.484622, 0.271248, 6.346313>, <0.266542, 0.493179, 6.346313>, <0.000000, 0.493179, 6.346313>,
      <0.326030, 0.000000, 6.766363>, <0.326030, 0.175042, 6.766363>, <0.179316, 0.318258, 6.766363>, <0.000000, 0.318258, 6.766363>,
      <0.326030, 0.000000, 7.186412>, <0.326030, 0.175042, 7.186412>, <0.179316, 0.318258, 7.186412>, <0.000000, 0.318258, 7.186412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016488, 0.482613, 5.931869>, <-0.261470, 0.482613, 5.931869>, <-0.475400, 0.265437, 5.931869>, <-0.491888, 0.000000, 5.931869>,
      <0.000000, 0.493179, 6.346313>, <-0.266542, 0.493179, 6.346313>, <-0.484622, 0.271248, 6.346313>, <-0.484622, 0.000000, 6.346313>,
      <0.000000, 0.318258, 6.766363>, <-0.179316, 0.318258, 6.766363>, <-0.326030, 0.175042, 6.766363>, <-0.326030, 0.000000, 6.766363>,
      <0.000000, 0.318258, 7.186412>, <-0.179316, 0.318258, 7.186412>, <-0.326030, 0.175042, 7.186412>, <-0.326030, 0.000000, 7.186412>
    }
  }
}
#declare lable = difference {
  cylinder { // lable_cyl
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 4.2>
    translate  1.0*z
  }
  texture {
    lable_text
    scale <1.0, 1.0, 4.1>
    rotate 115.0*z
  translate <0.000000, 0.000000, 1.050000>
  }
  scale <1.0, 1.0, 0.7>
}
#declare beer_bottle = union { // beer_bottle
  torus { // Torus001
    1.25, 0.25  rotate -x*90
    scale <0.25, 0.25, 0.3>
    translate  7.2*z
  }
  object { bottle_mesh }
  object { lable }
  texture {
    brown_bottle_glass
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.488244, 1.638244, 3.756518>
      translate  <0.0, 0.55, 3.606726>
    }
  }
  translate  <4.4, -1.85, 0.0>
}




// ********  OBJECTS  *******

plane { // carpet_plane1
  z,0
  texture {
    stains
  }
  translate  <17.6, -16.4, -10.18>
}


object { // beer_table
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.164066, -1.260520, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <0.560599, -1.228369, 0.000000>,
      <-2.000000, -1.000000, 0.000000>, <-2.045922, -2.101182, 0.177768>, <1.579433, -2.101182, 0.129777>, <1.000000, -1.000000, 0.000000>,
      <-2.000000, 0.000000, 0.000000>, <-2.045922, 1.253901, 0.255078>, <1.579433, 1.253901, 0.209532>, <1.000000, 0.000000, 0.000000>,
      <-0.960441, -0.843341, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <-0.146730, 0.399842, 0.008038>
    }
  }
  texture {
    beer_in_glass
  }
  rotate -70.0*z
  translate  <-0.7, 6.45, 0.05>
}


sphere { // Sphere003
  <0,0,0>,1
  texture {
    beer_in_glass
  }
  scale <2.2, 0.4, 0.1>
  translate  <2.05, 6.8, 0.4>
}


#declare window = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    translate  <-80.0, 15.146128, 42.573323>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    rotate 0.0*z
    translate  <-79.421277, 15.162113, 11.129215>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    rotate 0.0*z
    translate  <-79.421277, -17.745199, 11.161184>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    rotate 0.0*z
    translate  <-79.421277, -17.71323, 42.364294>
  }
  scale <0.4, 0.4, 0.6>
  translate  <-46.940249, -6.510638, 13.119789>
}
difference { // wal_window
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 80.0, 50.0>
    translate  <-80.0, 0.0, 40.0>
  }
  object { window }
  texture {
    DMFLightOak1
  }
}


box { // Cube5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFLightOak1
  }
  scale <1.0, 80.0, 80.0>
  rotate <0.0, -90.0, -90.0>
  translate  <0.0, 0.0, 90.0>
}


box { // Cube4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    ceiling
  }
  scale <1.0, 80.0, 50.0>
  rotate -270.0*z
  translate  <0.0, -80.0, 40.0>
}


box { // Cube3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFLightOak1
    scale 0.3
  }
  scale <1.0, 80.0, 50.0>
  rotate -180.0*z
  translate  <80.0, 0.0, 40.0>
}


box { // Cube2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFLightOak1
  }
  scale <1.0, 80.0, 50.0>
  rotate -90.0*z
  translate  <0.0, 80.0, 40.0>
}


#declare BzPtch2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.986859, 0.000000, 0.466745>, <-0.986859, 0.087570, 0.466745>, <-0.991283, 0.159218, 0.372454>, <-0.996690, 0.159218, 0.257210>,
      <-0.180118, 0.000000, 0.500000>, <-0.180118, 0.099592, 0.500000>, <-0.099065, 0.181077, 0.500000>, <0.000000, 0.181077, 0.500000>,
      <-0.096987, 0.000000, 1.015977>, <-0.096987, 0.099592, 1.015977>, <-0.053343, 0.181077, 1.015977>, <0.000000, 0.181077, 1.015977>,
      <-0.086187, 0.000000, 1.748484>, <-0.086187, 0.099592, 1.748484>, <-0.042259, 0.181077, 1.782450>, <0.011432, 0.181077, 1.823965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.996690, 0.159218, 0.257210>, <-1.002098, 0.159218, 0.141967>, <-1.006522, 0.087570, 0.047676>, <-1.006522, 0.000000, 0.047676>,
      <0.000000, 0.181077, 0.500000>, <0.099065, 0.181077, 0.500000>, <0.180118, 0.099592, 0.500000>, <0.180118, 0.000000, 0.500000>,
      <0.000000, 0.181077, 1.015977>, <0.053343, 0.181077, 1.015977>, <0.096987, 0.099592, 1.015977>, <0.096987, 0.000000, 1.015977>,
      <0.011432, 0.181077, 1.823965>, <0.065122, 0.181077, 1.865479>, <0.109050, 0.099592, 1.899445>, <0.109050, 0.000000, 1.899445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-1.006522, 0.000000, 0.047676>, <-1.006522, -0.087570, 0.047676>, <-1.002098, -0.159218, 0.141967>, <-0.996690, -0.159218, 0.257210>,
      <0.180118, 0.000000, 0.500000>, <0.180118, -0.099592, 0.500000>, <0.099065, -0.181077, 0.500000>, <0.000000, -0.181077, 0.500000>,
      <0.096987, 0.000000, 1.015977>, <0.096987, -0.099592, 1.015977>, <0.053343, -0.181077, 1.015977>, <0.000000, -0.181077, 1.015977>,
      <0.109050, 0.000000, 1.899445>, <0.109050, -0.099592, 1.899445>, <0.065122, -0.181077, 1.865479>, <0.011432, -0.181077, 1.823965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.996690, -0.159218, 0.257210>, <-0.991283, -0.159218, 0.372454>, <-0.986859, -0.087570, 0.466745>, <-0.986859, 0.000000, 0.466745>,
      <0.000000, -0.181077, 0.500000>, <-0.099065, -0.181077, 0.500000>, <-0.180118, -0.099592, 0.500000>, <-0.180118, 0.000000, 0.500000>,
      <0.000000, -0.181077, 1.015977>, <-0.053343, -0.181077, 1.015977>, <-0.096987, -0.099592, 1.015977>, <-0.096987, 0.000000, 1.015977>,
      <0.011432, -0.181077, 1.823965>, <-0.042259, -0.181077, 1.782450>, <-0.086187, -0.099592, 1.748484>, <-0.086187, 0.000000, 1.748484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.086187, 0.000000, 1.748484>, <-0.086187, 0.099592, 1.748484>, <-0.042259, 0.181077, 1.782450>, <0.011432, 0.181077, 1.823965>,
      <-0.075388, 0.000000, 2.480990>, <-0.075388, 0.099592, 2.480990>, <-0.031175, 0.181077, 2.548923>, <0.022863, 0.181077, 2.631952>,
      <-0.180118, 0.000000, 2.500000>, <-0.180118, 0.099592, 2.500000>, <-0.099065, 0.181077, 2.500000>, <0.000000, 0.181077, 2.500000>,
      <-0.991255, 0.000000, 2.353009>, <-0.991255, 0.093979, 2.353009>, <-0.991359, 0.170870, 2.442483>, <-0.991487, 0.170870, 2.551840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.011432, 0.181077, 1.823965>, <0.065122, 0.181077, 1.865479>, <0.109050, 0.099592, 1.899445>, <0.109050, 0.000000, 1.899445>,
      <0.022863, 0.181077, 2.631952>, <0.076901, 0.181077, 2.714980>, <0.121114, 0.099592, 2.782913>, <0.121114, 0.000000, 2.782913>,
      <0.000000, 0.181077, 2.500000>, <0.099065, 0.181077, 2.500000>, <0.180118, 0.099592, 2.500000>, <0.180118, 0.000000, 2.500000>,
      <-0.991487, 0.170870, 2.551840>, <-0.991614, 0.170870, 2.661197>, <-0.991718, 0.093979, 2.750671>, <-0.991718, 0.000000, 2.750671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.109050, 0.000000, 1.899445>, <0.109050, -0.099592, 1.899445>, <0.065122, -0.181077, 1.865479>, <0.011432, -0.181077, 1.823965>,
      <0.121114, 0.000000, 2.782913>, <0.121114, -0.099592, 2.782913>, <0.076901, -0.181077, 2.714980>, <0.022863, -0.181077, 2.631952>,
      <0.180118, 0.000000, 2.500000>, <0.180118, -0.099592, 2.500000>, <0.099065, -0.181077, 2.500000>, <0.000000, -0.181077, 2.500000>,
      <-0.991718, 0.000000, 2.750671>, <-0.991718, -0.093979, 2.750671>, <-0.991614, -0.170870, 2.661197>, <-0.991487, -0.170870, 2.551840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.011432, -0.181077, 1.823965>, <-0.042259, -0.181077, 1.782450>, <-0.086187, -0.099592, 1.748484>, <-0.086187, 0.000000, 1.748484>,
      <0.022863, -0.181077, 2.631952>, <-0.031175, -0.181077, 2.548923>, <-0.075388, -0.099592, 2.480990>, <-0.075388, 0.000000, 2.480990>,
      <0.000000, -0.181077, 2.500000>, <-0.099065, -0.181077, 2.500000>, <-0.180118, -0.099592, 2.500000>, <-0.180118, 0.000000, 2.500000>,
      <-0.991487, -0.170870, 2.551840>, <-0.991359, -0.170870, 2.442483>, <-0.991255, -0.093979, 2.353009>, <-0.991255, 0.000000, 2.353009>
    }
  }
  texture {
    Glass3
  }
  bounded_by { // Bound3
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.72789, 0.484518, 1.555622>
      translate  <-0.314119, 0.0, 1.399582>
    }
  }
  translate  <2.95, 0.0, 1.05>
}
#declare CSG2 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 5.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <1.7, 1.7, 5.1>
    translate  -0.05*z
  }
}
#declare CSG10 = union {
  object { CSG2 }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <1.99, 1.99, 0.5>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass5
    }
    scale <1.7, 1.7, 1.2>
    rotate -360.0*z
    translate  0.5*z
  }
  torus { // Torus4
    1.85, 0.15  rotate -x*90
    translate  <0.0, 0.05, 5.0>
  }
  torus { // Torus5
    1.85, 0.15  rotate -x*90
  }
}
#declare CSG11 = union {
  sphere { // Sphere97
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere98
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere99
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere100
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere101
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere102
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere103
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere104
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere105
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere106
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere107
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere108
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 45.0*z
  translate  -3.5*z
}
#declare CSG12 = union {
  sphere { // Sphere109
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere110
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere111
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere112
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere113
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere114
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere115
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere116
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere117
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere118
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere119
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere120
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 90.0*z
  translate  -3.0*z
}
#declare CSG13 = union {
  sphere { // Sphere121
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere122
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere123
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere124
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere125
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere126
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere127
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere128
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere129
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere130
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere131
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere132
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 135.0*z
  translate  -2.5*z
}
#declare CSG14 = union {
  sphere { // Sphere133
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere134
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere135
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere136
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere137
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere138
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere139
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere140
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere141
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere142
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere143
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere144
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -45.0*z
  translate  -0.5*z
}
#declare CSG15 = union {
  sphere { // Sphere145
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere146
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere147
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere148
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere149
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere150
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere151
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere152
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere153
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere154
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere155
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere156
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -90.0*z
  translate  -1.0*z
}
#declare CSG16 = union {
  sphere { // Sphere157
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere158
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere159
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere160
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere161
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere162
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere163
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere164
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere165
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere166
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere167
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere168
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -135.0*z
  translate  -1.5*z
}
#declare CSG17 = union {
  sphere { // Sphere169
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere170
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere171
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere172
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere173
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere174
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere175
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere176
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere177
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere178
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere179
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere180
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 180.0*z
  translate  -2.0*z
}
#declare CSG18 = union {
  sphere { // Sphere181
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere182
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere183
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere184
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere185
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere186
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere187
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere188
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere189
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere190
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere191
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere192
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
}
#declare CSG19 = union {
  object { CSG11 }
  object { CSG12 }
  object { CSG13 }
  object { CSG14 }
  object { CSG15 }
  object { CSG16 }
  object { CSG17 }
  object { CSG18 }
}
#declare Steininner1 = difference {
  object { CSG10 }
  object { CSG19 }
  texture {
    Glass3
  }
  bounded_by { // Bound4
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.3, 2.4, 2.8>
      translate  2.5*z
    }
  }
}
union { // stein2
  object { BzPtch2 }
  object { Steininner1 }
  rotate 115.58609*z
  translate  <5.5, 1.4, 0.0>
}


#declare BzPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.986859, 0.000000, 0.466745>, <-0.986859, 0.087570, 0.466745>, <-0.991283, 0.159218, 0.372454>, <-0.996690, 0.159218, 0.257210>,
      <-0.180118, 0.000000, 0.500000>, <-0.180118, 0.099592, 0.500000>, <-0.099065, 0.181077, 0.500000>, <0.000000, 0.181077, 0.500000>,
      <-0.096987, 0.000000, 1.015977>, <-0.096987, 0.099592, 1.015977>, <-0.053343, 0.181077, 1.015977>, <0.000000, 0.181077, 1.015977>,
      <-0.086187, 0.000000, 1.748484>, <-0.086187, 0.099592, 1.748484>, <-0.042259, 0.181077, 1.782450>, <0.011432, 0.181077, 1.823965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.996690, 0.159218, 0.257210>, <-1.002098, 0.159218, 0.141967>, <-1.006522, 0.087570, 0.047676>, <-1.006522, 0.000000, 0.047676>,
      <0.000000, 0.181077, 0.500000>, <0.099065, 0.181077, 0.500000>, <0.180118, 0.099592, 0.500000>, <0.180118, 0.000000, 0.500000>,
      <0.000000, 0.181077, 1.015977>, <0.053343, 0.181077, 1.015977>, <0.096987, 0.099592, 1.015977>, <0.096987, 0.000000, 1.015977>,
      <0.011432, 0.181077, 1.823965>, <0.065122, 0.181077, 1.865479>, <0.109050, 0.099592, 1.899445>, <0.109050, 0.000000, 1.899445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-1.006522, 0.000000, 0.047676>, <-1.006522, -0.087570, 0.047676>, <-1.002098, -0.159218, 0.141967>, <-0.996690, -0.159218, 0.257210>,
      <0.180118, 0.000000, 0.500000>, <0.180118, -0.099592, 0.500000>, <0.099065, -0.181077, 0.500000>, <0.000000, -0.181077, 0.500000>,
      <0.096987, 0.000000, 1.015977>, <0.096987, -0.099592, 1.015977>, <0.053343, -0.181077, 1.015977>, <0.000000, -0.181077, 1.015977>,
      <0.109050, 0.000000, 1.899445>, <0.109050, -0.099592, 1.899445>, <0.065122, -0.181077, 1.865479>, <0.011432, -0.181077, 1.823965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.996690, -0.159218, 0.257210>, <-0.991283, -0.159218, 0.372454>, <-0.986859, -0.087570, 0.466745>, <-0.986859, 0.000000, 0.466745>,
      <0.000000, -0.181077, 0.500000>, <-0.099065, -0.181077, 0.500000>, <-0.180118, -0.099592, 0.500000>, <-0.180118, 0.000000, 0.500000>,
      <0.000000, -0.181077, 1.015977>, <-0.053343, -0.181077, 1.015977>, <-0.096987, -0.099592, 1.015977>, <-0.096987, 0.000000, 1.015977>,
      <0.011432, -0.181077, 1.823965>, <-0.042259, -0.181077, 1.782450>, <-0.086187, -0.099592, 1.748484>, <-0.086187, 0.000000, 1.748484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-0.086187, 0.000000, 1.748484>, <-0.086187, 0.099592, 1.748484>, <-0.042259, 0.181077, 1.782450>, <0.011432, 0.181077, 1.823965>,
      <-0.075388, 0.000000, 2.480990>, <-0.075388, 0.099592, 2.480990>, <-0.031175, 0.181077, 2.548923>, <0.022863, 0.181077, 2.631952>,
      <-0.180118, 0.000000, 2.500000>, <-0.180118, 0.099592, 2.500000>, <-0.099065, 0.181077, 2.500000>, <0.000000, 0.181077, 2.500000>,
      <-0.991255, 0.000000, 2.353009>, <-0.991255, 0.093979, 2.353009>, <-0.991359, 0.170870, 2.442483>, <-0.991487, 0.170870, 2.551840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.011432, 0.181077, 1.823965>, <0.065122, 0.181077, 1.865479>, <0.109050, 0.099592, 1.899445>, <0.109050, 0.000000, 1.899445>,
      <0.022863, 0.181077, 2.631952>, <0.076901, 0.181077, 2.714980>, <0.121114, 0.099592, 2.782913>, <0.121114, 0.000000, 2.782913>,
      <0.000000, 0.181077, 2.500000>, <0.099065, 0.181077, 2.500000>, <0.180118, 0.099592, 2.500000>, <0.180118, 0.000000, 2.500000>,
      <-0.991487, 0.170870, 2.551840>, <-0.991614, 0.170870, 2.661197>, <-0.991718, 0.093979, 2.750671>, <-0.991718, 0.000000, 2.750671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.109050, 0.000000, 1.899445>, <0.109050, -0.099592, 1.899445>, <0.065122, -0.181077, 1.865479>, <0.011432, -0.181077, 1.823965>,
      <0.121114, 0.000000, 2.782913>, <0.121114, -0.099592, 2.782913>, <0.076901, -0.181077, 2.714980>, <0.022863, -0.181077, 2.631952>,
      <0.180118, 0.000000, 2.500000>, <0.180118, -0.099592, 2.500000>, <0.099065, -0.181077, 2.500000>, <0.000000, -0.181077, 2.500000>,
      <-0.991718, 0.000000, 2.750671>, <-0.991718, -0.093979, 2.750671>, <-0.991614, -0.170870, 2.661197>, <-0.991487, -0.170870, 2.551840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.011432, -0.181077, 1.823965>, <-0.042259, -0.181077, 1.782450>, <-0.086187, -0.099592, 1.748484>, <-0.086187, 0.000000, 1.748484>,
      <0.022863, -0.181077, 2.631952>, <-0.031175, -0.181077, 2.548923>, <-0.075388, -0.099592, 2.480990>, <-0.075388, 0.000000, 2.480990>,
      <0.000000, -0.181077, 2.500000>, <-0.099065, -0.181077, 2.500000>, <-0.180118, -0.099592, 2.500000>, <-0.180118, 0.000000, 2.500000>,
      <-0.991487, -0.170870, 2.551840>, <-0.991359, -0.170870, 2.442483>, <-0.991255, -0.093979, 2.353009>, <-0.991255, 0.000000, 2.353009>
    }
  }
  texture {
    Glass3
  }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.72789, 0.484518, 1.555622>
      translate  <-0.314119, 0.0, 1.399582>
    }
  }
  translate  <2.95, 0.0, 1.05>
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 5.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.7, 1.7, 5.1>
    translate  -0.05*z
  }
}
#declare CSG004 = union {
  object { CSG001 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <1.99, 1.99, 0.5>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass5
    }
    scale <1.7, 1.7, 1.2>
    rotate -360.0*z
    translate  0.5*z
  }
  torus { // Torus2
    1.85, 0.15  rotate -x*90
    translate  <0.0, 0.05, 5.0>
  }
  torus { // Torus3
    1.85, 0.15  rotate -x*90
  }
}
#declare CSG9 = union {
  sphere { // Sphere85
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere86
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere87
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere88
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere89
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere90
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere91
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere92
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere93
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere94
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere95
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere96
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 45.0*z
  translate  -3.5*z
}
#declare CSG8 = union {
  sphere { // Sphere73
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere74
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere75
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere76
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere77
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere78
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere79
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere80
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere81
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere82
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere83
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere84
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 90.0*z
  translate  -3.0*z
}
#declare CSG7 = union {
  sphere { // Sphere61
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere62
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere63
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere64
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere65
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere66
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere67
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere68
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere69
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere70
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere71
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere72
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 135.0*z
  translate  -2.5*z
}
#declare CSG3 = union {
  sphere { // Sphere13
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere18
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere21
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere23
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -45.0*z
  translate  -0.5*z
}
#declare CSG4 = union {
  sphere { // Sphere25
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere26
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere27
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere28
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere29
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere30
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere31
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere32
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere33
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere34
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere35
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere36
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -90.0*z
  translate  -1.0*z
}
#declare CSG5 = union {
  sphere { // Sphere37
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere38
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere39
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere40
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere41
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere42
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere43
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere44
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere45
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere46
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere47
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere48
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate -135.0*z
  translate  -1.5*z
}
#declare CSG6 = union {
  sphere { // Sphere49
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere50
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere51
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere52
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere53
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere54
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere55
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere56
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere57
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere58
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere59
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere60
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
  rotate 180.0*z
  translate  -2.0*z
}
#declare CSG002 = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    translate  <-2.85, 0.0, 4.5>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -30.0*z
    translate  <-2.468172, 1.425, 4.5>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -60.0*z
    translate  <-1.425, 2.468172, 4.5>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -90.0*z
    translate  <0.0, 2.85, 4.5>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -120.0*z
    translate  <1.425, 2.468172, 4.5>
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -150.0*z
    translate  <2.468172, 1.425, 4.5>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -180.0*z
    translate  <2.85, 0.0, 4.5>
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -210.0*z
    translate  <2.468172, -1.425, 4.5>
  }
  sphere { // Sphere9
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -240.0*z
    translate  <1.425, -2.468172, 4.5>
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -270.0*z
    translate  <0.0, -2.85, 4.5>
  }
  sphere { // Sphere11
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -300.0*z
    translate  <-1.425, -2.468172, 4.5>
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale <1.1, 0.5, 0.5>
    rotate -330.0*z
    translate  <-2.468172, -1.425, 4.5>
  }
}
#declare CSG003 = union {
  object { CSG9 }
  object { CSG8 }
  object { CSG7 }
  object { CSG3 }
  object { CSG4 }
  object { CSG5 }
  object { CSG6 }
  object { CSG002 }
}
#declare Steininner = difference {
  object { CSG004 }
  object { CSG003 }
  texture {
    Glass3
  }
  bounded_by { // Bound2
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.3, 2.4, 2.8>
      translate  2.5*z
    }
  }
}
union { // stein1
  object { BzPtch001 }
  object { Steininner }
  rotate <-90.0, 35.0, 90.0>
  translate  <4.95, 6.7, 1.95>
}


plane { // carpet_plane
  z,0
  texture {
    carpet
  }
  translate  <17.6, -16.4, -10.2>
}


#declare table_cutP = union {
  box { // table_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 1.0>
    rotate 45.0*z
  }
  box { // table_glass1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.2, 5.2, 0.1>
    rotate 45.0*z
    translate  0.09*z
  }
}
#declare table_top = difference {
  box { // table_wood
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 0.2>
    translate  -0.2*z
  }
  object { table_cutP }
}
#declare glas_bev_cut = union {
  box { // table_glass5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate 10.0*y
    translate  <5.0, 0.0, 0.9>
  }
  box { // table_glass4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate <0.0, 10.0, -90.0>
    translate  <0.0, -5.0, 0.9>
  }
  box { // table_glass3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate <0.0, -10.0, -90.0>
    translate  <0.0, 5.0, 0.9>
  }
  box { // table_glass2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate -10.0*y
    translate  <-5.0, 0.0, 0.9>
  }
}
#declare glass_top = difference {
  box { // table_glass
    <-1, -1, -1>, <1, 1, 1>
    scale <5.2, 5.2, 0.1>
    translate  -0.09*z
  }
  object { glas_bev_cut }
  texture {
    Glass4
  }
  rotate 45.0*z
}
union { // table
  object { table_top }
  box { // Table_leg
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood8
      rotate <0.0, -10.0, -135.0>
    }
    scale <1.0, 1.0, 5.0>
    translate  <-8.5, 8.5, -5.1>
  }
  box { // Table_leg1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood8
      rotate <0.0, 10.0, -60.0>
    }
    scale <1.0, 1.0, 5.0>
    translate  <8.5, 8.5, -5.1>
  }
  box { // Table_leg2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood8
      rotate <0.0, -10.0, -135.0>
    }
    scale <1.0, 1.0, 5.0>
    translate  <8.5, -8.5, -5.1>
  }
  box { // Table_leg3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood8
      rotate <0.0, 10.0, -60.0>
    }
    scale <1.0, 1.0, 5.0>
    translate  <-8.5, -8.5, -5.1>
  }
  object { glass_top }
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 20.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-10.0, -10.0, -0.2>
  }
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 20.0>
    rotate <-180.0, -90.0, 0.0>
    translate  <-10.0, -10.0, -0.2>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 20.0>
    rotate <90.0, -90.0, 0.0>
    translate  <9.9, 10.0, -0.2>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 20.0>
    rotate -90.0*y
    translate  <10.0, 10.0, -0.2>
  }
  sphere { // Sphere195
    <0,0,0>,1
    scale 0.2
    rotate 90.0*z
    translate  <-10.0, -10.0, -0.2>
  }
  sphere { // Sphere194
    <0,0,0>,1
    scale 0.2
    rotate 180.0*z
    translate  <10.0, -10.0, -0.2>
  }
  sphere { // Sphere193
    <0,0,0>,1
    scale 0.2
    rotate -90.0*z
    translate  <10.0, 10.0, -0.2>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.2
    translate  <-10.0, 10.0, -0.2>
  }
  texture {
    DMFWood8
    scale 11.7
    rotate <-94.697273, -1.875575, -91.843582>
  translate <0.250000, 3.400000, 0.000000>
  }
}


object { // beer_bottle5->beer_bottle
  beer_bottle
  rotate <-45.0, -90.0, -5.0>
  translate  <-2.6, -8.75, -13.2>
}


object { // beer_bottle4->beer_bottle
  beer_bottle
  rotate 135.0*z
  translate  <-2.75, 0.8, 0.0>
}


object { // beer_bottle3->beer_bottle
  beer_bottle
  rotate <90.0, -15.0, -65.0>
  translate  <-0.95, 4.6, 1.6>
}


object { // beer_bottle2->beer_bottle
  beer_bottle
  rotate -30.0*z
  translate  <-8.25, -2.65, 0.0>
}


object { // beer_bottle1->beer_bottle
  beer_bottle
  rotate <-125.0, -90.0, 0.0>
  translate  <-6.35, -4.5, -3.3>
}


object { beer_bottle }




#declare CSG20 = union {
  torus { // Torus6
    2.5, 0.5  rotate -x*90
    rotate <-90.0, 0.0, 0.0>
    translate  <5.05, 0.0, 7.15>
  }
  torus { // Torus002
    2.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  <3.85, 0.0, 2.75>
  }
}
#declare CSG21 = difference {
  object { CSG20 }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1
    scale <10.0, 10.0, 6.0>
    rotate <0.0, 15.0, 0.0>
    translate  <6.0, 0.0, 1.5>
  }
}
#declare CSG22 = union {
  object { CSG21 }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 6.0>
    rotate <0.0, 15.0, 0.0>
    translate  <6.0, 0.0, 1.5>
  }
  scale <1.0, 1.0, 0.8>
  translate  <0.45, 0.0, 0.85>
}
#declare CSG005 = difference {
  object { CSG22 }
  cone { // Cone002
    <0,0,0>, 3.5, <0,0,1>, 6.0
    scale <1.0, 1.0, 9.5>
  }
}
#declare side_of_pitcher = union {
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate 15.0*y
    translate  3.0*x
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -8.0>
    translate  <2.970804, -0.417519, 0.0>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -16.0>
    translate  <2.883785, -0.826912, 0.0>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -24.0>
    translate  <2.740636, -1.22021, 0.0>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -32.0>
    translate  <2.544144, -1.589758, 0.0>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -40.0>
    translate  <2.298133, -1.928363, 0.0>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -48.0>
    translate  <2.007392, -2.229434, 0.0>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -56.0>
    translate  <1.677579, -2.487113, 0.0>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -64.0>
    translate  <1.315113, -2.696382, 0.0>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -72.0>
    translate  <0.927051, -2.85317, 0.0>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -80.0>
    translate  <0.520945, -2.954423, 0.0>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -88.0>
    translate  <0.104698, -2.998172, 0.0>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -96.0>
    translate  <-0.313585, -2.983566, 0.0>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -104.0>
    translate  <-0.725766, -2.910887, 0.0>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -112.0>
    translate  <-1.12382, -2.781552, 0.0>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -120.0>
    translate  <-1.5, -2.598076, 0.0>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -128.0>
    translate  <-1.846984, -2.364032, 0.0>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -136.0>
    translate  <-2.158019, -2.083975, 0.0>
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -144.0>
    translate  <-2.427051, -1.763356, 0.0>
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -152.0>
    translate  <-2.648843, -1.408415, 0.0>
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -160.0>
    translate  <-2.819078, -1.02606, 0.0>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -168.0>
    translate  <-2.934443, -0.623735, 0.0>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -176.0>
    translate  <-2.992692, -0.209269, 0.0>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -184.0>
    translate  <-2.992692, 0.209269, 0.0>
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -192.0>
    translate  <-2.934443, 0.623735, 0.0>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -200.0>
    translate  <-2.819078, 1.02606, 0.0>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -208.0>
    translate  <-2.648843, 1.408415, 0.0>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -216.0>
    translate  <-2.427051, 1.763356, 0.0>
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -224.0>
    translate  <-2.158019, 2.083975, 0.0>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -232.0>
    translate  <-1.846984, 2.364032, 0.0>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -240.0>
    translate  <-1.5, 2.598076, 0.0>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -248.0>
    translate  <-1.12382, 2.781552, 0.0>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -256.0>
    translate  <-0.725766, 2.910887, 0.0>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -264.0>
    translate  <-0.313585, 2.983566, 0.0>
  }
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -272.0>
    translate  <0.104698, 2.998172, 0.0>
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -280.0>
    translate  <0.520945, 2.954423, 0.0>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -288.0>
    translate  <0.927051, 2.85317, 0.0>
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -296.0>
    translate  <1.315113, 2.696382, 0.0>
  }
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -304.0>
    translate  <1.677579, 2.487113, 0.0>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -312.0>
    translate  <2.007392, 2.229434, 0.0>
  }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -320.0>
    translate  <2.298133, 1.928363, 0.0>
  }
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -328.0>
    translate  <2.544144, 1.589758, 0.0>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -336.0>
    translate  <2.740636, 1.22021, 0.0>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -344.0>
    translate  <2.883785, 0.826912, 0.0>
  }
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 10.0>
    rotate <0.0, 15.0, -352.0>
    translate  <2.970804, 0.417519, 0.0>
  }
  torus { // Torus7
    3.0, 0.5  rotate -x*90
  }
  torus { // Torus003
    5.8, 0.3  rotate -x*90
    translate  9.6*z
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 1.0>
    translate  -0.5*z
  }
}
#declare CSG23 = difference {
  object { side_of_pitcher }
  cone { // Cone001
    <0,0,0>, 3.0, <0,0,1>, 5.5
    scale <1.0, 1.0, 10.0>
  }
}
union { // pitcher
  object { CSG005 }
  object { CSG23 }
  texture {
    Glass1
  }
  scale 0.6
  rotate -120.225479*z
  translate  <-1.011749, -4.401793, 0.29831>
}


