#include "shapes.inc"
#include "mypaper.inc"

global_settings { max_trace_level 30 }

camera {
	location <3, 12, -12>
	direction <0, 0, 1.5>
	look_at <0, 2, 0>
}
light_source { <1.4, 0.6, 2.8> colour rgb <1, 1, 0>
	fade_distance 1.5
	fade_power 2
	shadowless }

light_source { <7, 10, 6>
	colour rgb <1.5, 1.5, 1.3>
	spotlight
	point_at <-7, 0, 0>
	radius 15
	falloff 20
	tightness 5
	area_light <0, 0, 1>, <0.2, 0.8, 0>, 4, 4
	jitter
	adaptive 1 
}

/* light_source { <50, 50, 30> colour rgb <0.15, 0.15, 0.15> shadowless } */

plane { <0, 1, 0> 0
	pigment {
		bozo
		turbulence 0.7
		colour_map {
			[ 0	colour rgbf <0, 0.6, 0, 0.1> ]
			[ 0.25 colour rgbf <0.1, 0.7, 0.05, 0> ]
			[ 0.5 colour rgbf <0, 0.4, 0, 0.15> ]
			[ 0.75 colour rgbf <0, 0.5, 0.1, 0.05> ]
			[ 1 colour rgbf <0, 0.6, 0, 0.1> ]
		}
	}
	finish {
		ambient 0.1
		diffuse 0.9
		reflection 0.1
	}
	normal {
		crackle
		slope_map {
			[ 0		<0, 0> ]
			[ 0.01	<0, 0> ]
			[ 0.01	<0, 1> ]
			[ 0.1	<1, 0> ]
			[ 1		<1, 0> ]
		}
		scale 3 translate <1, 0, -1>
		bump_size 3
	} 
	scale 2
}

box { <-1000, -10, -1000>, <1000, 1000, 1000>
	pigment { colour rgb 0.7 }
	finish { ambient 0.1 diffuse 0.7 }
	hollow
}

intersection {
	object { Hyperboloid_Y }
	plane { <0, 1, 0> 2 }
	plane { <0, -1, 0> 2 }
	cone { <0, 2.1, 0>, 1.9 <0, -2.1, 0>, 6.0 }
	cone { <0, -2.1, 0>, 1.9 <0, 2.1, 0>, 6.0 }
	pigment { colour rgbf <1, 0.9, 0.6, 1> }
	finish {
		diffuse 0.7
		ambient 0.05
		specular 1
		roughness 0.001
		refraction on
		ior 1.5
		reflection 0.2
		caustics 1
		fade_distance 4
		fade_power 1 
	}
	scale <0.7, 1, 0.7>
	translate <-3.5, 2, -2>
}


object { paper translate <-1, 0, 1> }

sphere { <0, 0, 0>, 3
	pigment { colour rgbf <1, 1, 1, 1> }
	finish { ambient 1 diffuse 0 }

	halo {
		emitting
		spherical_mapping
		linear
		turbulence 0.2
		colour_map {
			[ 0 colour rgbt <1, 0, 0, 1> ]
			[ 1 colour rgbt <1, 1, 0, -1> ]
		}
		scale <2, 1.6, 0.6>
		rotate <0, 60, 0>
	}
	scale 1.1
	translate <1.4, 0.6, 2.8>
	hollow
}

