//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 2 lights, 5 textures and 15 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 01/12/1997    (12.01.1997)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <0.300, -12.900, 6.200>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.011, 0.470, 1.093>
}

// *******  L I G H T S *******
light_source {   // Light001
  <-10.300, 5.800, 6.400>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <3.900, 2.800, 10.300>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "jug2.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



object {   // mntain
  height_field {
    tga "I:\FRACTAL\POV3\COMP\MOUNTAIN.TGA"
    water_level 0.114
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    mounttex
  }
  no_shadow
  scale <9.5, 1.3, 4.4>
  translate  <0.0, 10.0, 0.4>
}


#declare hollowcup1 = difference {
  sphere { // Cup1
    <0,0,0>,1
    translate  <3.4, 1.4, 1.3>
  }
  sphere { // inscup1
    <0,0,0>,1
    scale 0.7
    translate  <3.4, 1.4, 1.5>
  }
  translate  <0.1, 0.2, 0.0>
}
difference { // cup2
  object { hollowcup1 }
  cylinder { // topcup1
    <0,0,1>, <0,0,0>, 1 
    translate  <3.5, 1.6, 1.3>
  }
  texture {
    Glass1
  }
  rotate 20.0*y
  translate  <-7.4, -0.2, -0.2>
}


#declare hollowcup = difference {
  sphere { // Cup
    <0,0,0>,1
    translate  <3.4, 1.4, 1.3>
  }
  sphere { // inscup
    <0,0,0>,1
    scale 0.7
    translate  <3.4, 1.4, 1.5>
  }
  translate  <0.1, 0.2, 0.0>
}
difference { // cup1
  object { hollowcup }
  cylinder { // topcup
    <0,0,1>, <0,0,0>, 1 
    translate  <3.5, 1.6, 1.3>
  }
  texture {
    Glass1
  }
  rotate -10.0*y
  translate  <-0.1, -0.2, 0.0>
}


#declare jar = difference {
  cone { // Jug
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Glass1
    }
    scale <1.4, 1.6, 3.2>
    rotate -180.0*x
    translate  <-0.1, 0.0, 3.2>
  }
  cylinder { // top
    <0,0,1>, <0,0,0>, 1 
    texture {
      Glass1
    }
    scale <1.0, 1.0, 1.3>
    translate  <-0.1, 0.0, 2.0>
  }
}
union { // juggrp
  torus { // handle1
    1.5, 0.5  rotate -x*90
    texture {
      Glass1
    }
    scale 0.5
    rotate <-90.0, 0.0, 25.0>
    translate  <0.8, 0.1, 0.7>
  }
  cylinder { // spout1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Glass1
    }
    scale <0.3, 0.5, 0.4>
    rotate <0.0, 0.0, -55.0>
    translate  <-0.7, -0.6, 1.4>
  }
  object { jar }
  rotate -20.0*y
}


plane { // wall
  z,0
  texture {
    Blue_Sky3
  }
  rotate 90.0*x
  translate  15.1*y
}


plane { // desk
  z,0
  texture {
    ripplewater
  }
  translate  -2.5*z
}




