//Stilleben.pov: Glasschale mit Klickern, Vase mit einer Bluete
//(c) ASTI, Januar 1997


#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "golds.inc"

#declare Kubbi_1 =
 cubic 
  {< 1,14,-6,    3,0,0,  3,0,0,   0,0,0, -40,0,0, 0,0,0,   0,0>}

#declare Kubbi_2 =
 cubic 
  {< 0,0,2,  1,1,1, 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0, 0>}



camera {
  location <4, 13, -18>
  right <4/3, 0, 0>
  up <0, 1, 0>
  direction <0, 0, 1>
  look_at <2, 6, 0>
}

light_source { <40, 40, -80> colour Gray40 }
light_source { <0, 50, 20> colour Gray40 }
light_source { <50, 50, -50> colour Gray40 }
light_source { <-50, 50, -50> colour Gray40 }


plane { y, -0
   pigment { colour MediumTurquoise }
   finish {
      ambient 0.1
      diffuse 0.4
      reflection .25
   }
   normal {waves 0.3}
}

plane { z, 48
   pigment { checker colour Turquoise color MediumTurquoise scale 2}
   finish {
      ambient 0.2
      diffuse 0.6
   }
   normal {wrinkles 0.45}
}


//Punkte z/y --- Radius/Hhe, Minimum sind 4 Punkte


//Blumenvase
#declare Vase =
sor {
  8,
  <0.0  ,-0.1 > //Beginn des Krpers mit Radius 0
  <2.5  ,0.1 >
  <2.5 ,1.5>
  <1.8 ,1.65 >
  <0.5 ,2.65 >
  <0.6 ,6.65 >
  <1.5 ,7.65 >
  <4.8 ,9 >
  open
}

union{

   object {
     Vase
     texture { Silver1 }
     finish {reflection 0.25 ambient 0.35 diffuse 0.55}
     scale <1,1,1>
     translate <6, 0, 6>
   }//Ende der Vase


   cylinder {
     < 6 ,5.5  , 6 >, <7 ,13  ,6  >, 0.2
      pigment {color Green}
   }//Ende des Stengels

   //Beginn der Bluete
   object{
     Kubbi_2
     texture {
         pigment{color Maroon}
         finish {
            ambient 0.5
            diffuse 0.6
            brilliance 4
            metallic
         } 
     }//end texture
   rotate y*-10
   scale <0.2,0.8,0.4>
   translate <7.2,12.2,6.1>
   clipped_by {sphere { <7,13,6>,2.5 }}
   }//end object  

   object{
     Kubbi_1
     texture {
         pigment{color VioletRed}
         finish {
            ambient 0.25
            diffuse 0.3
            reflection 0.55
            brilliance 8
            metallic
            phong 0.5
            phong_size 3         
         } 
     }//end texture
     scale <0.2,0.8,0.4>
     translate <7,13,6>
     clipped_by {sphere { <7,13,6>,3.0 }}
     }//end object  //Ende der Bluete  //Ende der Blume

  translate <1,0,-3.5>
  scale 0.9
} //Ende Vase mit Blume (union)


union{
//Kugel mit mehreren Texturen (layered textures)
sphere { <0  ,3.37 ,0.18  >,0.6
   texture {Jade
     finish {ambient 0.7 reflection 0.25 brilliance 10} 
     scale 6
     }//
}//end klicker1

sphere { <0.7  ,3.15 ,-0.3  >,0.6
   texture {Blue_Agate
     finish {ambient 0.6 reflection 0.25 brilliance 10} 
     scale 6
     }//
}//end klicker2

sphere { <-0.3  ,3.25 ,-0.8  >,0.52
   texture {White_Marble
     finish {ambient 0.7 diffuse 0.4 reflection 0.25 brilliance 10} 
     scale 6
     }//
}//end klicker3

sphere { <-0.7  ,3.3 ,-0.3  >,0.6
   texture {
     pigment {color red 0.6}
     finish {ambient 0.6 reflection 0.25 brilliance 10} 
     scale 6
     }//
}//end klicker4

sphere { <0, 3, 0>, 3
   texture {Glass3
     finish {
        ambient 0.3
        reflection 0.35
     } 
     }//ende t1

   texture{Glass2
      finish {
         ambient 0.4
         diffuse 0.5
         phong 0.2
         phong_size 2
         brilliance 0.2
         reflection 0.25
       }
   }//ende t2
}

bounded_by { sphere { <0, 3,0>, 4 } }
clipped_by {plane {y,3.95}}
translate <-2,0,2>
scale 2
}// Ende Union
