
#declare BlotterCorner = 
union {
	union {
		cylinder {
			<0.0,  0.0,  0.0>, < 1.0,  0.0,  0.0>, .1
		}
		cylinder {
			< 0.0,  0.0, 0.0>, < 0.0,  0.0, -1.0>, .1
		}
		sphere { <0, 0, 0>, 0.1 }
		triangle {
			< 0,  0, 0 >  // <Vertex1>
			< 1,  0, 0>  // <Vertex2>
			< 0,  0, -1>  // <Vertex3>
  			translate .1*y
		}
		triangle {
			< 0,  0, 0 >  // <Vertex1>
			< 1,  0, 0>  // <Vertex2>
			< 0,  0, -1>  // <Vertex3>
  			translate -.1*y
		}
		clipped_by {plane {  <1, 0, -1>, .65 }}
	}		
	union {
		disc { <-.5, 0, 0>, z, 0.1 }
		disc { <.5, 0, 0>, z, 0.1}
		polygon { 5, 
			<-.5, -0.1 >, <-.5, 0.1 >, <.5, 0.1>, <.5, -0.1>, <-.5, -0.1>
		}
		scale <1.3, 1, 1>
		rotate -45*y
		translate <.4595, 0, -.4595>
	}			
	texture { pigment { BakersChoc } finish { phong .6 phong_size 100 }}
}	


#declare WritingMatt = union {
	box { <-1, -1, -1>, < 1,  1,  1>
		pigment { BakersChoc }
		scale <4, 0.025, 2>
	}
	box { <-1, -1, -1>, < 1,  1,  1>
		pigment { DarkGreen }
		scale <3.9, 0.0125, 1.9>
		translate 0.040*y
	}
}

#declare DeskBlotter = 
union {
	object { WritingMatt scale 1.0 rotate -0*x }
	object { BlotterCorner
		scale 0.7
		rotate 90*y
		translate <4, 0, 2>
	}
		object { BlotterCorner
		scale 0.7
		rotate 180*y
		translate <4, 0, -2>
	}
	object { BlotterCorner	
		scale 0.7
		rotate 0*y
		translate <-4, 0, 2>
	}
	object { BlotterCorner
		scale 0.7
		rotate -90*y
		translate <-4, 0, -2>
	}	
}
