// Persistence of Vision Ray Tracer Scene Description File
// File: study2.pov
// Vers: 3
// Desc: Second rendering of a study
// Date: Feb. 1997
// Auth: Stephen Baker
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "sgwin.inc"	// stain glass window
#include "jar.inc"		// jar with beeds in it
#include "sglobe.inc"	// snow globe with snowman
#include "wmat.inc"		// writing mat on desk
#include "wallpic.inc"	// picture on wall
#include "hrglass.inc"	// the hourglass

// ----------------------------------------

global_settings { assumed_gamma 1.7
			   max_trace_level 10
			   adc_bailout 0.0025
			   max_intersections 65
}

camera {
	location  <2.0, -1.98, -5.0>
	direction 1.8*z
	right     4/3*x
	angle 55
	look_at   <4.0, -2.0,  2.0>
}

atmosphere {
	type 4
	samples 30
	distance 30
	scattering 0.1
	jitter 0.4
	aa_threshold 0.1
	aa_level 4
}

// Ceiling Light
light_source { <0, 3, -4> color rgb 0.7
	area_light
	<1, 0, 0> <0, 0, 3> // light tube along the z axis
	4, 4
	adaptive 1
	jitter
	fade_distance 5
	fade_power 2
}


// outside spotlight on stained glass window

light_source
{
	0*x                     // light's position (translated below)
  	color rgb <1,1,1>       // light's color
	spotlight               // this kind of light source
	translate <-40, 100, 100> // <x y z> position of light
  	point_at <2, -1, 0>      // direction of spotlight
  	radius 1                // hotspot (inner, in degrees)
	tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  	falloff 1.5              // intensity falloff radius (outer, in degrees)
	atmospheric_attenuation on
}

// Set a color of the background (sky)
background { White }

#declare Wall = object {
	box {
		<-1, -1, -1>  // one corner position <X1 Y1 Z1>
		< 1,  1,  1>  // other corner position <X2 Y2 Z2>
		scale <7, 5, .05>
	}
	texture {pigment { White } finish { ambient 0.3}}
}

#declare WallAndHole =
union {
	difference {
		object { Wall }
		union {
			box
			{
				<-1, -1, -1>  // one corner position <X1 Y1 Z1>
				< 1,  1,  1>  // other corner position <X2 Y2 Z2>
				translate 1*y
				scale <1.95, 2, .2>
			}
			cylinder { <0, 0, .2>, <0, 0, -.2> 1.95  translate 4*y}
			scale <.59, .5, 1>
			translate <2,-2,0>
		}
	}
	object { StainedGlassWindow scale <.6, .5, 1> translate <2,-2,-.04>}
	texture {pigment { White } finish { ambient 0.3} } /*normal { bumps 9 scale 0.01 }}*/
}


#declare FloorCeiling = object {
	box {
		<-1, -1, -1>  // one corner position <X1 Y1 Z1>
		< 1,  1,  1>  // other corner position <X2 Y2 Z2>
		scale <7, 7, .05>
	}
}

#declare DeskTop = object {
	box {
		<-1, -1, -1>  // one corner position <X1 Y1 Z1>
		< 1,  1,  1>  // other corner position <X2 Y2 Z2>
		scale <4.5, 2.2, .05>
	}
}

#declare Study2 = union {
	object { WallAndHole }
	object { Wall rotate 180*y translate -14*z}
	object { Wall rotate -90*y translate <-7, 0, -7>}
	object { Wall rotate 90*y translate <7, 0, -7>}
	object {FloorCeiling pigment { Yellow } rotate 90*x translate <0, -5, -7>}
	object {FloorCeiling pigment { White } rotate 90*x translate <0, 5, -7>}
	object { DeskTop /* pigment { Brown } */ texture { T_Wood6 finish { reflection 0.2}}  rotate 90*x translate <0, -2.25, -2.3>}
	object { WallPic scale .6 rotate 0*y translate <4.8,-0.5,-.1>}
}

object { Study2 }
object { SnowGlobe scale 0.2 rotate 45*y translate <1.6, -2.15, -2.0> }
object {TheHourGlass scale .3 rotate 0*y translate <3.5, -1.88, -3.2>}
object { BeededJar scale 0.095 translate <3.0, -2.17, -0.7> }

object { DeskBlotter
	scale .7
	translate <0, -2.2, -2.49>
}
