
//------------------------------------------------------------------->
//
// p4def_05.inc
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds one of the "dummies".
//
//------------------------------------------------------------------->
//
// Declare the *textures* for everything.

        #declare P4_Eye_Texture = texture { pigment { Gray50 } }
        #declare P4_Glasses_Texture = texture { pigment{Gray50} }
        
        #declare P4_Hair_Texture = texture {
        pigment { Gray60 } normal { crackle 4 scale < 1, 10, 1 > } }
        
        #declare P4_Hat_Texture = texture { pigment { Gray40 } }
        #declare P4_Lip_Texture = texture { pigment { Gray60 } }
        
        #declare P4_Shirt_Texture = texture {
                pigment { image_map { gif "shirt.gif" interpolate 2 }
                scale <8,8,0.1> } normal { crackle 0.3 scale 0.5 } }

        #declare P4_Shoe_Texture = texture { pigment{ Gray50 } }
        
        #declare P4_Shorts_Texture = texture {
                pigment { Gray40 } normal { crackle 2 scale 0.5 } }

        #declare P4_Skin_Texture = texture { pigment { Gray80 } }

//------------------------------------------------------------------->
//
// Now choose *types* of things. You will have to read the directions
// to see what numbers are legal here!

        #declare P4_Eye_Type = 1
        #declare P4_Glasses_Type = 0
        #declare P4_Hair_Type = 1
        #declare P4_Hand_Type = 1
        #declare P4_Hat_Type = 0
        #declare P4_Mouth_Type = 1
        #declare P4_Nose_Type = 1
        #declare P4_Shirt_Type = 2
        #declare P4_Shoe_Type = 1
        #declare P4_Shorts_Type = 2

//------------------------------------------------------------------->
//
// Set the sizes of various things.

        #declare P4_Leg_Length = 34
        #declare P4_Neck_Height = 3
        #declare P4_Shirt_Height = 22
        #declare P4_Shorts_Height = 15

//------------------------------------------------------------------->
//
// Choose the rotation values. Please read the directions!

        #declare P4_Hat_Rotate = < 20, 0, 0 >
        #declare P4_Neck_Rotate = < 30, -30, 0 >
        #declare P4_Waist_Rotate = < -20, 20, 0 >

        #declare P4_Left_Hand_Rotate = < 0, 0, 30 >
        #declare P4_Right_Hand_Rotate = < 90, 0, 0 >

        #declare P4_Left_Elbow_Rotate = < 00, -80, 0 >
        #declare P4_Right_Elbow_Rotate = < 00, 70, 0 >

        #declare P4_Left_Eyelid_Rotate = -40
        #declare P4_Right_Eyelid_Rotate = -40

        #declare P4_Left_Knee_Rotate = < -120, 0, 0 >
        #declare P4_Right_Knee_Rotate = < -120, 0, 0 >

        #declare P4_Left_Leg_Rotate = < 80, 0, -10 >
        #declare P4_Right_Leg_Rotate = < 80, 0, 10 >

        #declare P4_Left_Shoulder_Rotate = < 30, -60, 20 >
        #declare P4_Right_Shoulder_Rotate = < 0, 60, -50 >

//------------------------------------------------------------------->
//
// Create the optional "holding" object. This will go into the left
// hand, and move with the hand. This is optional - just comment it
// out if not needed, and set the flag to "false".
//
// The flag is necessary to prevent person #2 from carrying the object
// that you gave to person #1. Set it to true or false.

        #declare P4_Holding_Flag = true

        #declare P4_Holding_Object = union {
                cylinder{<0,-6,0><0,4,0>,1.5 pigment{Gray40}}
                cone{<0,4,0>,1.5 <0,6,0>,0.1 pigment{Gray40} }
                cone { < 0, 6, 0 >, 0.1 < -30, 6, 0 >, 1 pigment {
                        color rgbf < 0.7, 0.7, 0.7, 0.8 > } }
                } // End of union.

//------------------------------------------------------------------->
//
// Make another optional object - a "bracelet". This also has a flag
// to set on/off. This prevents duplicate bracelets! The bracelet
// should be at <0,0,0>, just like a standard torus.

        #declare P4_Bracelet_Flag = false

//------------------------------------------------------------------->
//
// Despite my attempts at using "realistic inches" as units, the
// people always seem to end up 8 or 9 feet tall. This variable lets
// you scale the person down to a normal size. Use the P4_TEST.POV
// scene to see how tall your person actually is!

        #declare P4_Total_Scale = 70/100

//------------------------------------------------------------------->
//
// This is the height to move the person up, so his/her feet are on
// the floor. Sorry, but because of bendable legs, this has to be
// adjusted manually (by YOU). 8-)

        #declare P4_Y_Adjust = 28

//------------------------------------------------------------------->
//
// Now call "p4_main.inc" to create the object.

        #include "p4_main.inc"

//------------------------------------------------------------------->
//
// End of this file.

