
//-------------------------------------------->
//-------------------------------------------->
//
// "We Break The Glass"
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//
// February 28, 1997
//
// Released to the public domain - have fun with it!
//
//-------------------------------------------->
//-------------------------------------------->
// Global settings.

        #version 3.0
        global_settings{ max_trace_level 20 }

//-------------------------------------------->
//-------------------------------------------->
// Scene switches - turn everything ON for final render!

        #declare Show_Awnings      = on
        #declare Show_Club_Sign    = on
        #declare Show_Door         = on
        #declare Show_Dummies      = on
        #declare Show_Fog          = on
        #declare Show_Glass        = on
        #declare Show_Misc         = on
        #declare Show_Road         = on
        #declare Show_Sidewalks    = on
        #declare Show_Streetlights = on
        #declare Show_Wall         = on
        #declare Show_Windows      = on

        // If this is off, then one BRIGHT light is on!
        #declare Final_Lights = on

//-------------------------------------------->
//-------------------------------------------->
// Include files and miscellaneous stuff.
        
        #include "colors.inc"
        #include "textures.inc"
        #include "metals.inc"
        #include "stones.inc"
        #include "woods.inc"
        #include "glass.inc"

        #declare R = seed(0)
        #declare P4_RAND = seed(0)

        #default { finish {
                diffuse 0.7 brilliance 0.4 crand 0.1 roughness 0.1 } }
        
        background { White }

//-------------------------------------------->
//-------------------------------------------->
// Camera.
        
        #declare CAMERA_LOC = < 15, 10, -40 >
        
        camera { location CAMERA_LOC look_at <32,5 ,0> }

//-------------------------------------------->
//-------------------------------------------->
// Lights.

// For testing, use one bright light at camera location.
        
        #if ( Final_Lights = off )

                light_source { CAMERA_LOC color rgb 2 }

        #end // End of if block.

// Here are all the final lights.

        #if ( Final_Lights = on )

        // At camera location.
        light_source { CAMERA_LOC color rgb 0.2 shadowless }
        
        // In middle of road, to create pothole shadows.
        light_source { < -20, 1, -16 > color rgb 0.4 }
        
        // Under small awning.
        light_source{<14,15,-1> color rgb 0.4 }
        
        // Behind second story windows.
        light_source{<18,27,8> color rgb 0.3 }
        light_source{<30,27,8> color rgb 0.3 }
        light_source{<45,29,8> color rgb 0.3 }
        light_source{<61,28,8> color rgb 1.0 }
        
        // Behind tall thin window.
        light_source{<53,15,8> color rgb 0.5 }

        // Behind left side door.
        light_source{<13,12,8> color rgb 1.0 }

        // Up behind big window.
        light_source{<33,17,3> color rgb 0.8 }
        
        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Two awnings.

        #if ( Show_Awnings = on )

        #declare Small_Awning = mesh {

                #declare A = 0 #while ( A <= 160 )
                
                #declare VEC1 = < 0, 3, 0 >
                #declare VEC2 = vrotate ( <-5, 0, 0 >, < 0, -A, 0 > )
                #declare VEC3 = vrotate ( <-5, 0, 0 >, < 0, (-20-A), 0 > )
                #declare VEC4 = vrotate ( <-5, -1.5, 0 >, < 0, -A, 0 > )
                #declare VEC5 = vrotate ( <-5, -1.5, 0 >, < 0, (-20-A), 0 > )

                triangle { VEC1, VEC2, VEC3 }
                triangle { VEC2, VEC3, VEC4 }
                triangle { VEC3, VEC4, VEC5 }
                
                #declare A = A + 20 #end

                pigment { Gray20 }
                normal { crackle 2 scale < 0.1, 100, 0.1 > }
                
                } // End of mesh.

        object { Small_Awning translate < 14, 16, 0 > }

        #declare Start_Awning = box {
                < 0.001, 0.001, 0 > < 0.999, 0.999, 15 >
                        pigment { image_map { gif "awning.gif"
                                interpolate 2 once } }
                scale < 26, 1, 1 > }

        #declare Sliced_Awning = difference {
                object { Start_Awning }
                #declare XX = 1 #while ( XX <= 25 )
                        
                        cylinder { < 0, 0, -0.1   > < 0, 0, 10.1 >, 1 
                                scale < 1.01, 0.3, 1 >
                                translate < XX, 1, 0 >
                                pigment { Gray30 } }

                #declare XX = XX + 2 #end

                rotate x * -20

                normal { bumps 0.5 scale 2 }

                } // End of difference.

        #declare Final_Awning = union {

        object{Sliced_Awning translate <21,16,-7>}

        // Poles.
        cylinder {<21.75,8.5,0><21.75,16.5,-6>,0.15 pigment{Gray10}}
        cylinder {<45.25,8.5,0><45.25,16.5,-6>,0.15 pigment{Gray10}}

        // Swivel things at bottom of poles.
        cylinder { < 21.5, 8.5, 0 > < 22, 8.5, 0 >, 1 pigment{Black}}
        cylinder { < 45.0, 8.5, 0 > < 45.5, 8.5, 0 >, 1 pigment{Black}}
       
        } // End of union.

        object { Final_Awning translate y*-1 }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Club sign.

        #if ( Show_Club_Sign = on )
        
        #declare Club_Sign = union {

        box { < 0, 0, 0 > < 1, 1, 0.01 > 
                pigment{image_map { gif "a-club.gif" interpolate 2 once }}
                scale < 4, 1, 1 >
                finish{Shiny}
                normal { bumps 0.2 scale 0.3 }
                }
        
        cylinder{<0,1,0><4,1,0>, 0.05 texture{T_Silver_5E} }
        cylinder{<0,0,0><4,0,0>, 0.05 texture{T_Silver_5E} }
        cylinder{<0,0,0><0,1,0>, 0.05 texture{T_Silver_5E} }
        cylinder{<4,0,0><4,1,0>, 0.05 texture{T_Silver_5E} }

        sphere{<0,0,0>,0.1  texture{T_Silver_5E} }
        sphere{<0,1,0>,0.1  texture{T_Silver_5E} }
        sphere{<4,1,0>,0.1  texture{T_Silver_5E} }
        sphere{<4,0,0>,0.1  texture{T_Silver_5E} }

        } // End of union.

        object { Club_Sign scale<2.5,2,1> translate < 62, 15, -0.4 > }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Left side door.

        #if ( Show_Door = on )

        #declare The_Door = union {

                // Thirtysix panes of glass.
                #declare XX = 1 #while ( XX <= 6 )
                #declare YY = 7 #while ( YY <= 12 )
                        box { < 0, 0, 0 > < 1, 1, 0.01 >
                                texture { T_Glass1 }
                                normal { bumps 1 scale 0.5
                                        translate x * (rand(R)*1000) }
                                translate < XX, YY, 0.2 > }
                #declare YY = YY + 1 #end                
                #declare XX = XX + 1 #end
                
                // Wood pieces.
                // Left.
                        box { < -0.1, -0.5, 0 > < 1, 14.1, 0.4 > }
                // Top.
                        box { < 1, 13, 0 > < 7, 14.1, 0.4 > }
                // Right.
                        box { < 7, 14.1, 0 > < 8.1, -0.5, 0.4 > }
                // Bottom.
                        box { < 1, -0.5, 0 > < 7, 1, 0.4 > }
                // Center (directly under glass).
                        box { < 1, 6, 0 > < 7, 7, 0.4 > }

                // Threshold (of the door, not the antialiasing 8-)).
                        box { < -0.1, -0.5, -0.7 > < 8.1, 0.1, 0.4 >
                                pigment { Gray20 }
                                normal { bumps 1 scale 0.5 } }

                // Hand carved panel in lower part of door.
                        height_field { gif "door.gif"
                                scale < 6, 0.3, 5 >
                                rotate x * -90
                                translate < 1, 1, 0.3 >
                                pigment { Gray70 }
                        } // End of height_field.

                // Door handle.
                torus { 1, 0.2
                        rotate z * 90
                        scale < 1, 1, 0.3 >
                        translate < 7.5, 7, 0 >
                        pigment { Black }
                        finish { Shiny } }

                // Vertical dividers.
                // (Too lazy to use a loop!).
                cylinder { < 1, 7, 0.2 > < 1, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 2, 7, 0.2 > < 2, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 3, 7, 0.2 > < 3, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 4, 7, 0.2 > < 4, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 5, 7, 0.2 > < 5, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 6, 7, 0.2 > < 6, 13, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 7, 7, 0.2 > < 7, 13, 0.2 >, 0.1 pigment { Gray10 } }

                // Horizontal dividers.
                // (Too lazy to use a loop!).
                cylinder { < 1,  7, 0.2 > < 7,  7, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1,  8, 0.2 > < 7,  8, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1,  9, 0.2 > < 7,  9, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1, 10, 0.2 > < 7, 10, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1, 11, 0.2 > < 7, 11, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1, 12, 0.2 > < 7, 12, 0.2 >, 0.1 pigment { Gray10 } }
                cylinder { < 1, 13, 0.2 > < 7, 13, 0.2 >, 0.1 pigment { Gray10 } }

                pigment { Gray30 }

                normal { crackle 4 scale <0.5,100,0.5> turbulence 0.2 }
                
                } // End of union.

        object { The_Door translate < 10, 1, 0.9 > }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The dummies.

        #if ( Show_Dummies = on )

        // Woman in window.
        #include "p4def_01.inc"
                object { One_Person scale 0.18
                        rotate y*-10 translate < 28, 4, 2 > }

        // Man climbing out of window.
        #include "p4def_02.inc"
                object { One_Person scale 0.18
                        rotate y*80 translate < 40, 1, -0.75 > }

        // Man going into a club.
        #include "p4def_03.inc"
                object { One_Person scale 0.18
                        rotate y*100 translate < 65, 1, -4 > }

        // Woman going into a club.
        #include "p4def_04.inc"
                object { One_Person scale 0.18
                        rotate y*-100 translate < 59, 1, -3 > }

        // Spray paint person.
        #include "p4def_05.inc"
                object { One_Person scale 0.18
                        rotate <-60,70,0> translate < 38.5, 0.1, -20 > }
        
        // Woman in center rear of window.
        #include "p4def_06.inc"
                object { One_Person scale 0.18
                        rotate <0,40,0> translate < 35, 4, 3.5 > }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The fog.

        #if ( Show_Fog = on )

                fog {   distance 1
                        color rgbt < 0.25, 0.25, 0.30, 0.6 >
                        fog_type 2
                        fog_offset 0.1
                        fog_alt 20
                        turbulence 0.5

                } // End of fog.

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The main section of broken glass.

        #if ( Show_Glass = on )

        #declare Glass_Section = polygon {

                104,

                < 0, 0 >
                < 0, 1 >

                #declare A = 1 #while ( A <=99 )

                        < A, rand(R)+0.5 >

                #declare A = A + 1 #end

                < 100, 1 >
                < 100, 0 >
                <   0, 0 >
                
                } // End of polygon.

        union {

        // Top.
        object { Glass_Section scale < 21/100, 1, 1 >
                rotate x*180 translate y * 12 }
        
        // Bottom.
        object { Glass_Section scale < 21/100, 1, 1 > }
        
        // Left (pokes down through floor).
        object { Glass_Section scale < 21/100, 1, 1 >
                rotate x*180 rotate z*90 translate y*-8 }
        
        // Right (pokes down through floor).
        object { Glass_Section scale < 21/100, 1, 1 >
                rotate z*90 translate x*21 translate y*-8 }

        texture { T_Glass1 }
        finish { ambient 0.7 }
        translate < 23, 4, 0.1 >

        } // End of union.

        // Broken glass on sidewalk.

                #declare A = 1 #while ( A <= 100 )

                        #declare X1 = (rand(R)*20) + 23
                        #declare Y1 = 1.01
                        #declare Z1 = (rand(R)*6) - 5

                        #declare X2 = X1 + (rand(R)*2) - 1
                        #declare Y2 = 1.05
                        #declare Z2 = Z1 + (rand(R)*2) - 1

                        #declare X3 = X2 + (rand(R)*2) - 1
                        #declare Y3 = 1.10
                        #declare Z3 = Z2 + (rand(R)*2) - 1

                        triangle { <X1,Y1,Z1><X2,Y2,Z2><X3,Y3,Z3>
                                texture { T_Chrome_5E }
                                finish { ambient 0.5 }
                                } // End of triangle.

                #declare A = A + 1 #end
        
        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Miscellaneous objects.

        #if ( Show_Misc = on )

        // Backdrop panel in big window.
                box { < 20, 0, 5 > < 50, 18, 5.1 > pigment{Gray60}}

        // Left side panel in big window.
                box { < 22.5, 0, 0.5 > < 22.6, 18, 6 > pigment{Gray60}}

        // Right side panel in big window.
                box { < 44.5, 0, 0.5 > < 44.6, 18, 6 > pigment{Gray60}}

        // Right side panel in club doorway.
                box { < 70.5, 0, 0.5 > < 70.6, 18, 6 > pigment{Gray30}}

        // Set up the back wall.
                box { < -200, -200, 15 > < 200, 200, 16 > pigment{White}}

        // This is the second-floor-floor and the first-floor-ceiling!
                box{<-20,19,0.1><100,19.1,20> pigment{White}}

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The road.

        #if ( Show_Road = on )

                height_field { png "road.png"

                        pigment{image_map {
                                gif "paint.gif"
                                interpolate 2 } rotate x*90}

                        scale < 70, 0.3, 20 >
                        translate < 0, -0.1, -26 >

                        normal { crackle 0.1 scale 0.1 turbulence 0.1 }

                        } // End of height_field.

                // Here are the puddles in the road.
                        box { < -10, -1, -5 > < 100, 0, -27 >
                                pigment{White}finish{Mirror}
                                normal { bumps 0.2 scale 0.4 }
                                } // End of box.

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The sidewalks.

        #if ( Show_Sidewalks = on )

        // This flips from 0 to 1 to 0, to offset the blocks.
                #declare OFFSET = 1

        #declare One_Block = superellipsoid { < 0.1, 0.1 >
                scale < 0.95, 0.5, 0.95 > }

        #declare XX = -10 #while ( XX <= 100 )

        #declare ZZ = -6 #while ( ZZ <= 6 )

                #declare OFFSET = 1 - OFFSET
                
                object { One_Block
                        
                        // Add random wiggle.
                        #declare WIGGLE = (rand(R)*6)-3
                        rotate y * WIGGLE
                        translate < XX+OFFSET+1, 0.5, ZZ+1 >
                        
                        #declare RGB = (rand(R)/10) + 0.35
                        pigment { color rgb RGB }
                        normal { crackle 0.3 scale 0.1 } }

        #declare ZZ = ZZ + 2 #end

        #declare ZZ = -36 #while ( ZZ <= -28 )
                
                #declare OFFSET = 1 - OFFSET

                object { One_Block
                
                        // Add random wiggle.
                        #declare WIGGLE = (rand(R)*6)-3
                        rotate y * WIGGLE
                        translate < XX+OFFSET+1, 0.5, ZZ+1 >
                
                        #declare RGB = (rand(R)/10) + 0.35
                        pigment { color rgb RGB }
                        normal { crackle 0.3 scale 0.1 } }

        #declare ZZ = ZZ + 2 #end

        #declare XX = XX + 2 #end

        // Put in the grout all at once.
                box { < -10, 0, -5.9 > < 100, 0.9, 8 >
                        pigment { Gray20 }
                        normal { crackle 4 scale 1 } }
                
                box { < -10, 0, -26.1 > < 100, 0.9, -36 >
                        pigment { Gray20 }
                        normal { crackle 4 scale 1 } }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// The streetlights.

        #if ( Show_Streetlights = on )

        #declare Street_Light = union {

                // Base.
                cone { < 0,0,0>,1 <0,0.3,0>,0.8
                        normal{crackle 1 scale 0.5 }
                        pigment { Gray20 } }
                // Tall column.
                cone { < 0,0.3,0>,0.6 <0,12.5,0>,0.4
                        normal{crackle 1 scale 0.5 }
                        pigment { Gray40 } }
                // Under light.
                cone { < 0,12.5,0>,0.4 <0,13.2,0>,0.8
                        normal{crackle 1 scale 0.5 }
                        pigment { Gray20 } }
                // Over light.
                cone { < 0,15,0>,1.2 <0,15.2,0>,1.0
                        normal{crackle 1 scale 0.5 }
                        pigment { Gray20 } }
                // Very top.
                cone { < 0,15.2,0>,1.0 <0,15.5,0>,0.001
                        normal{crackle 1 scale 0.5 }
                        pigment { Gray20 } }

                // Around glass part.
                #declare A = 0 #while ( A < 360 )
                        cylinder { <0.7,13.2,0><0.9,15,0>,0.03
                                rotate y*A
                                normal { crackle 1 scale 0.5 }
                                pigment { Gray40 } }
                #declare A=A+30 #end

                // Glass part.
                difference {
                        cone { < 0, 13.200, 0>,0.700 <0,15.000,0>,0.900 }
                        cone { < 0, 13.199, 0>,0.699 <0,15.001,0>,0.899 }
                        texture { T_Glass1 }
                } // End of difference.

                // Actual light inside it.
                light_source { < 0, 0, 0 > color rgb 1
                        looks_like {
                                
                                // Two stretched spheres.
                                union {
                                        sphere { 0, 0.2
                                        scale < 1, 2, 1 >
                                        translate <-0.2,0.3,0> }
                                        sphere { 0, 0.2
                                        scale < 1, 2, 1 >
                                        translate <0.2,0.3,0> }
                                pigment { White * 8 }
                                finish { Shiny }
                                } // End of union.
                                } // End of looks_like.

                        translate y*14 } // End of light_source.
                
                } // End of union.

        object { Street_Light translate < 20, 1, -5 > }
        object { Street_Light translate < 54, 1, -5 > }
        
        object { Street_Light translate < 35, 1, -30 > }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Build some blocks for the wall.

        #if ( Show_Wall = on )

        // "^" is the top of a window/door.
        #declare Tile_2 = box{<0,0,-0.3><1,1,2>
                pigment{Gray70}
                normal { crackle 0.5 scale 0.1 } } 
        

        // "X" is the bottom of a window/door.
        #declare Tile_3 = box{<0,0,-0.4><1,1,5>
                pigment{Gray40}
                normal { crackle 0.5 scale 0.1 } } 

        // "I" is the side of a window/door.
        #declare Tile_4 = box { < 0, 0, -0.3 > < 1, 1, 1 >
                pigment{Gray50}
                normal { crackle 0.5 scale 0.1 } } 
        
//-------------------------------------------->
//-------------------------------------------->
// "@" is a solid double wide block.

        #declare V01 = < 0, 1, 0 >
        #declare V02 = < 1, 1, 0 >
        #declare V03 = < 2, 1, 0 >
        #declare V04 = < 0.1, 0.9, -0.2 >
        #declare V05 = < 1.9, 0.9, -0.2 >
        #declare V06 = < 0, 0.5, 0 >
        #declare V07 = < 1, 0.5, -0.25 >
        #declare V08 = < 2, 0.5, 0 >
        #declare V09 = < 0.1, 0.1, -0.2 >
        #declare V10 = < 1.9, 0.1, -0.2 >
        #declare V11 = < 0, 0, 0 >
        #declare V12 = < 1, 0, 0 >
        #declare V13 = < 2, 0, 0 >

        #declare Tile_1 = mesh {

        // Top.
        triangle { V01, V02, V04 }
        triangle { V02, V03, V05 }
        triangle { V04, V02, V05 }
        
        // Right.
        triangle { V03, V05, V08 }
        triangle { V05, V08, V10 }
        triangle { V08, V10, V13 }
        
        // Bottom.
        triangle { V09, V12, V10 }
        triangle { V09, V11, V12 }
        triangle { V12, V10, V13 }
        
        // Left.
        triangle { V01, V04, V06 }
        triangle { V04, V06, V09 }
        triangle { V06, V09, V11 }
        
        // Center.
        triangle { V04, V05, V07 }
        triangle { V04, V07, V09 }
        triangle { V09, V07, V10 }
        triangle { V05, V07, V10 }

        } // End of mesh.

//-------------------------------------------->
//-------------------------------------------->
// "H" is a half block..

        #declare V01 = < 0, 1, 0 >
        #declare V02 = < 0.5, 1, 0 >
        #declare V03 = < 1 1, 0 >
        #declare V04 = < 0.1, 0.9, -0.2 >
        #declare V05 = < 0.9, 0.9, -0.2 >
        #declare V06 = < 0, 0.5, 0 >
        #declare V07 = < 0.5, 0.5, -0.25 >
        #declare V08 = < 1, 0.5, 0 >
        #declare V09 = < 0.1, 0.1, -0.2 >
        #declare V10 = < 0.9, 0.1, -0.2 >
        #declare V11 = < 0, 0, 0 >
        #declare V12 = < 0.5, 0, 0 >
        #declare V13 = < 1, 0, 0 >

        #declare Tile_5 = mesh {

        // Top.
        triangle { V01, V02, V04 }
        triangle { V02, V03, V05 }
        triangle { V04, V02, V05 }
        
        // Right.
        triangle { V03, V05, V08 }
        triangle { V05, V08, V10 }
        triangle { V08, V10, V13 }
        
        // Bottom.
        triangle { V09, V12, V10 }
        triangle { V09, V11, V12 }
        triangle { V12, V10, V13 }
        
        // Left.
        triangle { V01, V04, V06 }
        triangle { V04, V06, V09 }
        triangle { V06, V09, V11 }
        
        // Center.
        triangle { V04, V05, V07 }
        triangle { V04, V07, V09 }
        triangle { V09, V07, V10 }
        triangle { V05, V07, V10 }
        
        } // End of mesh.

//-------------------------------------------->
//-------------------------------------------->
// Now put all the blocks together.

        union {

                #declare YYY = 1 #while (YYY<=32)

                #if(YYY=32)#declare STRING = ".@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@." #end
                #if(YYY=31)#declare STRING = "@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.^^^^^^^^^^^^@.@.@.@.@.@.@.@.@.@.@.@.@" #end
                #if(YYY=30)#declare STRING = ".@.@.@.@.@.@.H^^^^^^^^H@.^^^^^^^^@.@.H^^^^^^^^^^^^H@.@.@.@.@.@.@.@.@.@.@.@." #end
                #if(YYY=29)#declare STRING = "@.@.@.@.@.@.@.I......I@.HI......IH@.@.I..........I@.@.@.^^^^^^^^^H@.@.@.@.@" #end
                #if(YYY=28)#declare STRING = ".@.@.@.@.@.@.HI......IH@.I......I@.@.HI..........IH@.@.HI.......I@.@.@.@.@." #end
                #if(YYY=27)#declare STRING = "@.@.@.@.@.@.@.I......I@.HI......IH@.@.I..........I@.@.@.I.......IH@.@.@.@.@" #end
                #if(YYY=26)#declare STRING = ".@.@.@.@.@.@.HI......IH@.I......I@.@.HXXXXXXXXXXXXH@.@.HI.......I@.@.@.@.@." #end
                #if(YYY=25)#declare STRING = "@.@.@.@.@.@.@.I......I@.HI......IH@.@.@.@.@.@.@.@.@.@.@.I.......IH@.@.@.@.@" #end
                #if(YYY=24)#declare STRING = ".@.@.@.@.@.@.HI......IH@.I......I@.@.@.@.@.@.@.@.@.@.@.HI.......I@.@.@.@.@." #end
                #if(YYY=23)#declare STRING = "@.@.@.@.@.@.@.I......I@.HI......IH@.@.@.@.@.@.@.@.@.@.@.I.......IH@.@.@.@.@" #end
                #if(YYY=22)#declare STRING = ".@.@.@.@.@.@.HI......IH@.I......I@.@.@.@.@.@.@.@.@.@.@.HXXXXXXXXX@.@.@.@.@." #end
                #if(YYY=21)#declare STRING = "@.@.@.@.@.@.@.XXXXXXXX@.HXXXXXXXXH@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@" #end
                #if(YYY=20)#declare STRING = ".@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@." #end
                #if(YYY=19)#declare STRING = "@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@" #end
                #if(YYY=18)#declare STRING = ".@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.H^^^^^@.@.@.@.@.@.@.@.@.@." #end
                #if(YYY=17)#declare STRING = "@.@.@.@.@.@.@.@.@.@.H^^^^^^^^^^^^^^^^^^^^^^^@.@.@.I...IH@.@.@.@.@.@.@.@.@.@" #end
                #if(YYY=16)#declare STRING = ".@.@.@.@.@.@.@.@.@.@.^^^^^^^^^^^^^^^^^^^^^^^H@.@.HI...I@.@.@.@.@.@.@.@.@.@." #end
                #if(YYY=15)#declare STRING = "@.@.@.@.^^^^^^^^^^@.HI.....................I@.@.@.I...IH@.@.@.^^^^^^^^@.@.@" #end
                #if(YYY=14)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.HI...I@.@.@.H^^^^^^^^H@.@." #end
                #if(YYY=13)#declare STRING = "@.@.@.@.I........I@.HI.....................I@.@.@.I...IH@.@.@.I......I@.@.@" #end
                #if(YYY=12)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.HI...I@.@.@.HI......IH@.@." #end
                #if(YYY=11)#declare STRING = "@.@.@.@.I........I@.HI.....................I@.@.@.I...IH@.@.@.I......I@.@.@" #end
                #if(YYY=10)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.HI...I@.@.@.HI......IH@.@." #end
                #if(YYY= 9)#declare STRING = "@.@.@.@.I........I@.HI.....................I@.@.@.XXXXXH@.@.@.I......I@.@.@" #end
                #if(YYY= 8)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.@.@.@.@.@.@.HI......IH@.@." #end
                #if(YYY= 7)#declare STRING = "@.@.@.@.I........I@.HI.....................I@.@.@.@.@.@.@.@.@.I......I@.@.@" #end
                #if(YYY= 6)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.@.@.@.@.@.@.HI......IH@.@." #end
                #if(YYY= 5)#declare STRING = "@.@.@.@.I........I@.HI.....................I@.@.@.@.@.@.@.@.@.I......I@.@.@" #end
                #if(YYY= 4)#declare STRING = ".@.@.@.HI........IH@.I.....................IH@.@.@.@.@.@.@.@.HI......IH@.@." #end
                #if(YYY= 3)#declare STRING = "@.@.@.@.I........I@.HXXXXXXXXXXXXXXXXXXXXXXX@.@.@.@.@.@.@.@.@.I......I@.@.@" #end
                #if(YYY= 2)#declare STRING = ".@.@.@.HI........IH@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.HI......IH@.@." #end
                #if(YYY= 1)#declare STRING = "@.@.@.@.I........I@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.I......I@.@.@" #end

                #declare XXX = 1 #while (XXX<=75)

                #declare TEMPSTRING= substr( STRING, XXX, 1)
        
                #declare Match_1 = strcmp ( TEMPSTRING,"@" )
                #declare Match_2 = strcmp ( TEMPSTRING,"^" )
                #declare Match_3 = strcmp ( TEMPSTRING,"X" )
                #declare Match_4 = strcmp ( TEMPSTRING,"I" )
                #declare Match_5 = strcmp ( TEMPSTRING,"H" )

                #declare TEMP_TEX = texture { T_Stone16
                translate <rand(R)*100,rand(R)*100,rand(R)*100> }

                #if ( Match_1 = 0 ) object{Tile_1 translate <XXX,YYY,0> texture { TEMP_TEX }} #end
                #if ( Match_2 = 0 ) object{Tile_2 translate <XXX,YYY,0> } #end
                #if ( Match_3 = 0 ) object{Tile_3 translate <XXX,YYY,0> } #end
                #if ( Match_4 = 0 ) object{Tile_4 translate <XXX,YYY,0> } #end
                #if ( Match_5 = 0 ) object{Tile_5 translate <XXX,YYY,0> texture { TEMP_TEX }} #end

                #declare XXX=XXX+1 #end

                #declare YYY=YYY+1 #end

                normal { crackle 0.05 scale 0.05 }

        } // End of union.

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Windows (incredibly sloppy!).

        #if ( Show_Windows = on )

        // Vertical dividers.
        #declare X = 15 #while ( X <= 66 )
                cylinder { < X, 20, 0.5 > < X, 31, 0.5 >, 0.1
                        pigment { Gray10 } }
        #declare X = X + 1 #end

        // Horizontal dividers.
        #declare Y = 20 #while ( Y <= 31 )
                cylinder { < 15, Y, 0.5 > < 66, Y, 0.5 >, 0.1
                        pigment { Gray10 } }
        #declare Y = Y + 1 #end

        // Lots of individual panes of glass.

                #declare XX = 15 #while ( XX <= 65 )
                #declare YY = 20 #while ( YY <= 30 )
                        
                        box { < 0, 0, 0 > < 1, 1, 0.001 >
                                texture { T_Glass1 }
                                normal { bumps 1 scale 0.5
                                        translate x * (rand(R)*1000) }
                                translate < XX, YY, 0.5 > }
                #declare YY = YY + 1 #end                
                #declare XX = XX + 1 #end

        // Now do the tiny window, with diagonal dividers.
                #declare A = 3 #while ( A <= 17 )
                        
                        cylinder { <49,A,0.3><57,A+5,0.3>,0.1
                                pigment { Gray50 } }
                        cylinder { <49,A+5,0.3><57,A,0.3>,0.1
                                pigment { Gray50 } }

                #declare A = A + 1 #end
                
                box { < 50, 8, 0.3 > < 56, 19, 0.301 >
                        texture { T_Glass1 }
                                normal { bumps 1 scale 0.5 } }

        #end // End of if block.

//-------------------------------------------->
//-------------------------------------------->
// Bye!

