#include "GLights.inc"
#include "GTextures.inc"
#include "book.inc"
#include "Clock.inc"
#include "SpiralBooks.inc"
#include "pencil.inc"
#include "PaperClips.inc"
#include "Highlighter.inc"
#include "IndyCar.inc"


// Glenn's "Do Your Homework!" POV-Ray Scene File
// created 4-Mar-97
// for the Internet Ray Tracing Competition
// at http://www.povray.org/irtc
// last update 24-Apr-97
// copyright 1997 Glenn McCarter

// It's late afternoon at a teenager's desk.
// Today's homework assignment is to apply physics knowledge to a
// real-world topic.  The student had been thinking about designing
// a faster race car, and uses a model car for inspiration.
// While the student researches slip angles and ground effects,
// the model suddenly becomes real, wreaking havoc across the desk!

// Origin is at center of desk, +X to the right of the scene
// Unit scale is inches.

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare Special_Cam = //for debugging
  camera {
    angle 50
//    location <-8,3.6,-9> //whole clock
//		look_at <-10.5,2.1,-4>
//    location <-7,5,-8> //whole clock angle
//		look_at <-10,2.1,-3>
//    location <-9,2.8,-6> // clock edge
//		look_at <-10.5,1.3,-3>
//    location <9,8,-16> // book
//		look_at <10.5,1.3,3>
//    location <1.7,8,-18> // paper
//		look_at <1.0,3,-5.5>
//    location <-5,9.9,-2> //lamp bulb
//		look_at <-5.5,8.6,1>
//    location <15,13,-21> //scene
//		look_at <0,2,0>
//    location <-19,20,-7> //person
//		look_at <-19,20,-16>
//    location <2,3,-8> //front wheel and glue strip
//		look_at <2,-.5,-1>
//    location <0,4,-8> //bodyside
//		look_at <0,.5,-1>
//    location <1.1,3.1,-1.8> //driver angle
//		look_at <-.5,1.8,1>
//    location <-1.3,2.8,-1.3> //driver side
//		look_at <-.7,1.8,1>
//    location <9,3,-14> //spiral book1 end
//    location <8,3,-11> //spiral book1 side
//		look_at <10,0,-11>
//    location <4,3,-14> //spiral book2 end
    location <4,3,-11> //spiral book2 side
		look_at <8,0,-10>
  }
//sphere { <-19,20,-16>, .7 texture {pigment{color rgb<1,1,0>} finish{ambient .8}}}

#declare Room_Cam = //for viewing the rest of the room
  camera {
		location <-22,20,-3>
		angle 60
		look_at <45,20,-15>
  }
#declare Render_Cam = //for final render
  camera {
		location <-2,16,-28>
		angle 50
		look_at <0,0,0>
  }

camera {
//    Special_Cam
//    Room_Cam
		Render_Cam
/*   // Focal Blur section: uncomment to enable focal blur
  blur_samples 4
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
*/   // end focal blur
  }

cylinder {//overhead light fixture
	<0,0,0>,<0,3,0>,8
	texture{ pigment {color rgb<1,1,1>} finish {ambient .7}}
	translate <0*Feet,4.9*Feet,-3*Feet>
}
#declare OverheadLight =
  light_source {
    <0,0,0>
    colour rgb <.5, .5, .5>
		fade_distance 24
		fade_power 1
//		area_light <.5*Feet,0,0>,<0,0,.5*Feet> 3, 3
  }
object {OverheadLight translate <0*Feet,4.6*Feet,-3*Feet> }

#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
//   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}
object { Sun rotate <0,0,40> translate <0*Miles,17.2*Miles,24*Miles> }
//(the rotation helps further distribute area_light rays)

#declare SkyLight = //casts bluish highlights
  light_source {
	  <-3,13,5>
   	colour rgb <0.6 0.5, 1.3>
		fade_distance 5
		fade_power 1
		spotlight
		point_at <-7, 9, 2>
		radius 18    // degrees fully lit (*2)
		falloff 28   // degrees no lighting (*2)
		tightness 1
	}
object { SkyLight translate <0,0,0> }

background { color rgb <0.4, 0.6, 0.8> }//daylight sky
//background { color rgb <0.02, 0.04, 0.2> }//nighttime

#declare FakeLandscape =
	union {
		cylinder {//local rolling hill?
			<0,0,0>,<25*Feet,0,0>,15*Feet
			texture {
				pigment { color rgb<.12,.45,.12> }
				finish { ambient .1 diffuse .6 specular .2 roughness .004 }
				normal { crackle 18 scale 13 }
			}
			rotate z*4
			translate <0,-20*Feet,25*Feet>
		}
		cylinder {//rolling hill in distance?
			<0,0,0>,<25*Feet,0,0>,15*Feet
			texture {
				pigment { color rgb<.12,.45,.12> }
				finish { ambient .1 diffuse .6 specular .2 roughness .004 }
				normal { crackle 18 scale 13 }
			}
			rotate z*-12
			translate <-6*Feet,-20*Feet,40*Feet>
		}
		box {//distant horizon?
			<-300*Feet,-50*Feet,0>,<300*Feet,200*Feet,10>
			texture {
				pigment {
					gradient y
						color_map {
							[0.0 color rgb<.12,.65,.12>] //ground
							[0.5 color rgb<.4,.7,.6>] //sky
							[1.0 color rgb<.12,.65,.12>] //ground
						}
					scale 50*Feet
				}
				finish { ambient .8 diffuse .6 specular .2 roughness .004 }
			}
			rotate z*2
			translate <160*Feet,-160*Feet,800*Feet>
		}
		cylinder { //hanging leaves?
			<0,0,0>,<0,12*Feet,0>,20
		  texture {
				pigment {
					marble
					color_map {
						[0.0 color rgbf<.2,.6,.1,.3> ]
						[0.8 color rgbf<1,1,1,1> ]
					}
					turbulence 1.3
					scale 10
					translate <1,12,0>
				}
				normal { crackle .08 scale 300 }
			}
			translate <4.8*Feet,-3*Feet,12*Feet>
		}
		sphere { //small bushes?
			<0,0,0>,10
		  texture {
				pigment {
					marble
					color_map {
						[0.0 color rgbf<.2,.6,.1,.3> ]
						[0.8 color rgbf<1,1,1,1> ]
					}
					turbulence 1.3
					scale 6
					translate <1,12,0>
				}
				normal { bumps 3 scale 20 }
			}
			translate <2*Feet,-2.4*Feet,11*Feet>
		}

		cylinder {//big tree trunk?
			<0,0,0>,<0,25*Feet,0>,6
			texture {
				pigment { color rgb<.42,.35,.12> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*-1
			translate <5*Feet,-3*Feet,11*Feet>
		}

		cylinder {//big tree branch?
			<0,0,0>,<0,25*Feet,0>,.7
			texture {
				pigment { color rgb<.32,.27,.13> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*14
			translate <3.7*Feet,-1.5*Feet,8*Feet>
		}

		cylinder {//med tree trunk?
			<0,0,0>,<0,25*Feet,0>,.6
			texture {
				pigment { color rgb<.32,.47,.12> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*6
			translate <2.5*Feet,-3*Feet,8*Feet>
		}

		cylinder {//med tree branch?
			<0,0,0>,<0,25*Feet,0>,.3
			texture {
				pigment { color rgb<.32,.47,.12> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*11
			translate <2.45*Feet,-2.3*Feet,8*Feet>
		}

		cylinder {//small tree trunk?
			<0,0,0>,<0,25*Feet,0>,1.3
			texture {
				pigment { color rgb<.32,.25,.09> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*3
			translate <6.5*Feet,-3*Feet,12*Feet>
		}
		cylinder {//small tree branch?
			<0,0,0>,<0,25*Feet,0>,1.0
			texture {
				pigment { color rgb<.32,.28,.12> }
				finish { ambient .4 diffuse .6 specular .2 roughness .004 }
				normal { bumps 2. scale 3 }
			}
			rotate z*-8
			translate <6.5*Feet,-3*Feet,12*Feet>
		}
	}

//===============================================
//             Objects In Room
//===============================================

#declare RoomPaint =
	texture {
		pigment { color <.95,1.0,.77> }
	  finish { ambient .25 phong .1}
	}
#declare WinFrameTex =
	texture {
		pigment { color rgb<.92,.91,.98> }
		finish { ambient .2 }
	}
#declare WinLH=-2 //window LH edge X-axis
#declare BasicRoom16x12 =
	union {
	  difference {
			box { //WestWall
    		<-8.2*Feet,0,36+17>,<8.2*Feet,8.2*Feet,57>
			  texture { RoomPaint }
			}
			box {
				<WinLH,38,52>,<WinLH+33,76,58> //window cutout in wall
			  texture { RoomPaint }
			}
		}
		difference {
			box {//windowframe
				<WinLH-1,37,54.8>,<WinLH+34,77,56.2>
				texture { WinFrameTex	}
			}
			box {//window cutout in frame
				<WinLH+1.3,40.2,54>,<WinLH+31.7,74.4,57>
				texture { WinFrameTex	}
			}
			box {//window glass channel
				<WinLH+.3,37.5,55.35>,<WinLH+33.7,76.5,55.65>
				texture { WinFrameTex	}
			}
		}
		superellipsoid {//window sill
			<.07,.07>
			texture { pigment { color rgb<.81,.72,.61> } finish {ambient .2} }
			scale <18,.5,5>
			translate <WinLH+18,38,56>
		}
		box {
			<WinLH-1,36,57>,<WinLH+34,77,57.01> //shadow on window
		  texture {
				pigment {
					crackle
					color_map {
						[0.0 color rgbf<1,1,1,.4> ]
						[0.2 color rgbf<1,1,1,1> ]
					}
					turbulence 1.3
					scale 18
					translate <-1,12,0>
				}
			}
		}
		box { //blurs landscape outside of window
			<-44,-10,60>,<44,60,60.01>
		  texture {
				pigment { color rgbf<1,1,1,1> }
				normal {
					bozo .0005
					turbulence 1.3
					scale .4
				}
				finish { refraction 1 ior 1.33 }
			}
		}
		box { //EastWall
			<-8.2*Feet,0,-6*Feet>,<8.2*Feet,8.2*Feet,-6.4*Feet>
			  texture { RoomPaint }
		}
		box { //NorthWall
			<8*Feet,0,-6.2*Feet>,<8.4*Feet,8.2*Feet,6.2*Feet>
			  texture { RoomPaint }
		}
		box { //SouthWall
			<-8*Feet,0,-6.2*Feet>,<-8.4*Feet,8.2*Feet,6.2*Feet>
			  texture { RoomPaint }
		}
		box { //Floor
			<-8.2*Feet,-2,-6.2*Feet>,<8.2*Feet,0,6.2*Feet>
			  texture { RoomPaint }
		}
		box { //Ceiling
			<-8.2*Feet,8*Feet,-6.2*Feet>,<8.2*Feet,8.2*Feet,6.2*Feet>
			  texture { RoomPaint }
		}
	}

#declare Door =
	box {
		<0,-36,-18>,<1,44,18> texture {Formica}
	}

#declare Calendar =
	union {
		difference {
			box {//sits on xz plane, bottom at z=0
				<0,.07,0>,<27,.27,14>
				texture { PaperWhite }
				texture {
				  pigment {
							image_map {
							png "IndyCal.png" //lo-res calendar with image of IndyCar
							once
							}
					}
					scale <14,27,1> rotate <90,90,0> translate <0,1,14>
					finish { ambient .4 }
				}
				texture {
				  pigment {
							image_map {
							png "IndyCalDetail4.png" //hi-res detail in visible area
							once
							}
					}
					scale <11.5,6,1> rotate <90,90,0> translate <0,1,11.5>
					finish { ambient .3 }
				}
			}
			cylinder {//hangin'-up hole
				<0,-.5,0>,<0,.5,0>,.1
				texture { pigment { color rgb<1,1,1> } }
				translate <.3,0,7>
			}
		}
		box { //back page
			<-.6,0,0>,<1,.05,14>
			texture { PaperWhite }
		}
	}
#declare Person =
   box {//sits on xy plane
     <0,0,0>,<24,28,.3>
     texture { pigment {color rgbf<1,1,1,1> } }
     texture {
        pigment {
          image_map {
            png "Neal.png" //person image
						filter 0, 1.0  //make color index 0 transparent
            once
          }
        }
        scale <36,24,1> translate <-6,1,37>
        finish { ambient .8 }
     }
   }

#declare Bed = //x-axis,0 at head
	union {
		box { <0,0,-22>,<2,33,22> texture{Formica}}
		box { <71.5,0,-22>,<73.5,27,22> texture{Formica}}
		box { <1.8,6,-20>,<72,24,20> texture{PaperWhite}}
	}

#declare PieceOChair =
	union {
		box {<0,0,0>,<14,5,.7> texture { Formica } }
		box {<13,0,0>,<14,-30,.7> texture { Formica } }
		box {<0,0,0>,<1,-30,.7> texture { Formica } }
		translate <-10,3,-22>
	}

#declare TableZ = 14 //sets front-to-back distance
// Table is defined with center of tabletop at <0,0,0>
// Legs extend 36 down
#declare TableTop =
   box {
     <-24,-1,-TableZ>,<24,0,TableZ>
        texture { Formica rotate y*90}
   }
#declare TableLeg =
   box {
     <-1,-36,-1>,<1,-1,1>
        texture { Formica rotate x*90}
   }
#declare Table =
   union {
     object { TableTop }
     object { TableLeg translate <-22.5,0,-TableZ+1.5> }
     object { TableLeg translate <-22.5,0,TableZ-1.5> }
     object { TableLeg translate <22.5,0,-TableZ+1.5> }
     object { TableLeg translate <22.5,0,TableZ-1.5> }

   }

#declare BlindTexture =
	texture {
		pigment { color rgb <.78,.83,.46> }
		finish { ambient .1 diffuse .2 specular .4 roughness .02 }
	}
#declare BlindSlat =
	difference {
		intersection {
			superellipsoid { //this creates the rounded ends
				<.45, .45>
				texture { BlindTexture }
				scale <17,1,1> translate x*17
			}
			box { // front and rear edges
				<0,-1,-.55>,<40,1,.55>
				texture { BlindTexture }
			}
			cylinder { // the upper surface
				<0,-1.5,0>,<40,-1.5,0>,1.5
				texture { BlindTexture }
			}
			cylinder { // the lower surface
				<0,-1.5,0>,<40,-1.5,0>,1.4
				inverse
				texture { BlindTexture }
			}
		}
		cylinder { //cut out the holes
			<5,-.2,-.35>,<5,.2,-.35>,.08
			texture { BlindTexture }
		}
		cylinder { //cut out the holes
			<5,-.2,.35>,<5,.2,.35>,.08
			scale <1,1,3>
			texture { BlindTexture }
		}
		box { //cut out the holes
			<4.92,-.2,-.35>,<5.08,.2,.35>
			texture { BlindTexture }
		}
	}
#declare BaseBar =
	union {
		box {
			<0,0,-.5>,<40,.3,.5>
			texture {BlindTexture }
		}
		cylinder {
			<5,-.2,0>,<5,.2,0>,.25
			texture { BlindTexture }
		}
	}
#declare VertString =
	cylinder {
		<0,0,0>,<0,40,0>,.02
		texture {
			pigment {color rgb <.87,.94,.65> }
			normal {bumps .4 scale .05}
		}
	}
#declare SlatOpenAngle = -4 //"0" is flat, negative is inside down
#declare SlatVertOffset = 1.2
#declare Venetians =
	union {
		object { BaseBar }
		object { VertString translate <5,0,0> }
		object { VertString translate <5,0,-.4> }
		object { VertString translate <5,0,.4> }
		#declare Count=1
  	#while (Count < 36)
    	object{BlindSlat rotate x*SlatOpenAngle translate <0,SlatVertOffset*Count,0> }
	    #declare Count=Count+1
  	#end
	}

//===============================================
//             Objects on Table
//===============================================

// An 8.5 x 11 pad of paper
#declare ScribPad =
	union {
		box {
			<0,.03,0>,<11,.3,8.5>
			texture { pigment {color rgb<1,1,1>} finish {ambient .7} }
			texture {
				pigment { image_map {png "scribblesoft.png" once } }
				scale 11.5 rotate <90,90,0> translate <-.5,1,8.6>
				finish { ambient .4 }
			}
		}
		cylinder {//clever flipped-up corner
			<2,3.3,0>,<0,3.3,2>, 3 open
			texture { PaperWhite }
			texture {
				pigment { image_map {png "scribblesoft.png" once } }
				scale 11 rotate <90,90,0> translate <-.5,1,8.6>
				finish { ambient .4 }
			}
			clipped_by {box{<0,0,0>,<2,.7,2>}}
			clipped_by {box{<-1.4,0,-1.4>,<1.4,1,1.4>rotate y*45}}
		}
		box {//grey base
			<0,0,0>,<11.05,.04,8.55>
			texture { pigment { color rgb<.3,.3,.3> } }
		}
		cylinder {//glue strip
			<11.2,.3,0>,<11.2,.3,8.5>,.2
			texture {
				pigment {
					bozo
					color_map {
						[0.0 color rgb<1,.80,.87> ]//white
						[1.0 color rgb<1,.2,.3> ]//red
					}
					scale <.6,.02,.3>
				}
				finish { ambient .3 specular .3 roughness .2 }
			}
			clipped_by {box{<10.9,.2,0>,<11.13,.43,8.5>}}
		}
	}
#declare JarGlass =
	texture {
    pigment { color rgbf <0.88, 0.98, 0.92, 0.8> }
    finish  { ambient 0 diffuse 0 reflection 0.1 refraction 0.9
			ior 1.45 specular 0.8 roughness 0.0003
		}
	}
#declare Jar =
  difference {
    merge {
      cylinder { // outside wall
        <0,.5,0>, <0,7.825,0>, 2
        texture { JarGlass }
      }
      sphere { // bottom
        <0,0,0>, 2
        scale <1,.16,1>
        translate <0,.5,0>
        texture { JarGlass }
      }
      torus { // top edge
        1.875, .125
        scale <1,1,1>
        translate <0,7.825,0>
        texture { JarGlass }
      }
    }
    cylinder { // inner space
      <0,.5,0>, <0,9,0>, 1.75
      texture { JarGlass }
    }
  }

#declare StuffInJar =
	union {
		object { Jar scale <1,.5,1> }
		object { Pencil rotate <-40,-25,82> scale 1 translate <-1,.5,-1> }
		object { Pencil rotate <160,5,125> scale 1 translate <.8,.5,.2> }
		object { Highlighter rotate <-84,0,-88> translate <.7,5.5,-.5> }
	}

#declare SmokeTrail =
  sphere {
		<0,0,0>,1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      spherical_mapping
      linear
      turbulence <2.1,.9,.8>
			frequency 1.2
      color_map {
        [ 0 color rgbt <0, 0, 0,  1> ]
        [ .5 color rgbt <.6, .5, .4, .3> ] //more grey
        [ 1 color rgbt <0, 0, 0,  1> ]
      }
      samples 10
      scale 0.5
    }
    hollow
  }

//===============================================
//             Motion Blur
//===============================================

// This secion adds simulated motion blur to the race car

#declare IndyCarBlur =
	union {

#declare BFX=3 #declare BFY=1.4 #declare BStrength=1.3
#include "MoBlurFilt.inc"
object { BlurFilterX rotate <20,0,0> translate <-7.5,3.37,-1> }//rear wing surface

#declare BFX=1.5 #declare BFY=.8 #declare BStrength=1.3
#include "MoBlurFilt.inc"
object { BlurFilterX translate <-7.5,2.6,-1> }//rear wing side

#declare BFX=1.5 #declare BFY=1 #declare BStrength=.8
#include "MoBlurFilt.inc"
object { BlurFilterX translate <-3.3,2.7,-1> }//roll cage

#declare BFX=.9 #declare BFY=1.7 #declare BStrength=.7
#include "MoBlurFilt.inc"
object { BlurFilterX translate <-4.0,.6,-1> }//side pod

#declare BFX=2 #declare BFY=2.0 #declare BStrength=.8
#include "MoBlurFilt.inc"
object { BlurFilterX translate <-6.3,.8,-1.2> }//nearside rear wheel

#declare BFX=.50 #declare BStrength=0.05
#include "MoBlurFilt.inc"
object { BlurFilterO translate <-4.7,1.3,-1.49> } //rear wheel circular blur

#declare BFX=1.0 #declare BFY=1.3 #declare BStrength=.3
#include "MoBlurFilt.inc"
object { BlurFilterX translate <-4.7,2.7,-0> }//farside rear wheel

#declare BFX=2.5 #declare BFY=1.9 #declare BStrength=1
#include "MoBlurFilt.inc"
object { BlurFilterX translate <0.1,.5,-1.3> } //nearside front wheel

#declare BFX=.60 #declare BStrength=0.005
#include "MoBlurFilt.inc"
object { BlurFilterO translate <2.15,1.4,-1.49> } //front wheel circular blur

#declare BFX=2.0 #declare BFY=1.5 #declare BStrength=.5
#include "MoBlurFilt.inc"
object { BlurFilterX translate <.9,1.3,1.7> } //farside front wheel

#declare BFX=1.2 #declare BFY=1 #declare BStrength=.8
#include "MoBlurFilt.inc"
object { BlurFilterX translate <2.95,.70,-1.5> } //nearside front wing

#declare BFX=1.1 #declare BFY=.8 #declare BStrength=.7
#include "MoBlurFilt.inc"
object { BlurFilterX translate <3.2,0.6,1.2> } //farside front wing

	} //end of union

//===============================================
//             Object Placement
//===============================================

//TensorLamp variables:
#declare BaseAngle = 55 //40
#declare HeadAngleX = -7
#declare HeadAngleZ = -12
#declare ElbowAngle = 55
#declare CordLength = 3.5
#declare CordAngleY = 0
#declare CordAngleZ = 0
#include "TensorLamp.inc"

object { FakeLandscape }
object { BasicRoom16x12 translate <0,-3*Feet,-36> }
object { Door translate x*-88 }
object { Calendar rotate <-90,0,90> translate <-9.5,4.8,16.8> }
object { Bed rotate <0,0,0> translate <-84,-36,-74> }
object { Venetians translate <WinLH+.4,3,18> }
object { Table }
object { PieceOChair }
object { TensorLamp scale 1.3 rotate <0,-131,0> rotate <8,0,-3> translate <-10.5,.4,6> }
object { StuffInJar rotate <0,0,12> translate <6,.8,5> }
object { Clock rotate <0,-18,0> translate <-10.5,1.8,-4> }
object { SphereHolder rotate <0,-18,0> translate <-10.5,0,-4> }
object { SpiralBook2 rotate <0,-108,0> translate <-13,0,-6> }//reflected in the mirror
object { ScribPad rotate <0,-93,0> translate <3.2,0,-13.0> }
object { Pencil rotate <-60,-73,0> scale 1 translate <-3.0,0.3,-11.3> }
object { Book rotate <0,-29,0> translate <12,0,0> }
object { SpiralBook1 rotate y*-88 translate <14.5,.5,-11.5> }
object { SpiralBook2 rotate y*-102 translate <17.2,0,-12.2> }
object { PaperClipHolderSpilling rotate <-15,20,10> translate <-6,1,-3.5> }
object { YellowClip rotate <-30,8,-12> translate <-5.5,1.7,-6> }
object { PaperClip rotate <40,-78,-8> rotate <-20,0,0> translate <-2.2,.7,-2.5> }
object { IndyCar scale .07 rotate <0,186,0> translate <3,.4,1.5> }
object { IndyCarBlur translate <0,.4,0> }
object { SmokeTrail scale <19,.6,6> rotate <-0,0,-8> translate <-18,2.5,1.2> }
object { Person rotate <0,30,0> translate <-30,-1,-10> }



