
// Glenn's Book POV-Ray Scene File
// This file does not render.  #include "Book.inc" in another .pov file
// created 20-June-96 updated 15-Apr-97
// copyright 1997 Glenn McCarter

// A Physics textbook
// Intended scale is English system (inches)
// Book lies in +X+Z plane, origin at lower rear cover

// Declarations
#declare NumPages = 360
#declare BookHeight = 11
#declare BookWidth = 8.5
#declare BookCoverTexture =
  texture {
    pigment { color rgb<.36,.30,.22> }
		finish { ambient .1 }
  }

#declare BookFrontCover =
  union {
		difference {
			box { // this is the front cover
				<0,0,0>,<BookHeight,.125,BookWidth>
				translate <0,.125+NumPages*.005,0>
				texture { BookCoverTexture }
				texture {
					pigment {
						image_map {
							tga "Illust.tga"
							once
						}
					}
					finish { ambient .45 }
					scale BookWidth/2 rotate <90,90,0> translate <1.4,4,BookWidth/2+BookWidth/4-.2>
				}
			}
			cylinder { // this is the crease near the spine
				<-1,0,0>,<BookHeight+1,0,0>,.1
				texture { BookCoverTexture }
				translate <0,.125+NumPages*.005+.125+.03,BookWidth-.15>
			}
		}
    text {
      ttf "c:\Windows\Fonts\Bookosb.TTF",
      "Physics",
      .2,  0
      texture {
				pigment { color rgb<1,1,.3> }
				finish { ambient .2 }
			}
      scale <1.4,2.2,1>
      rotate <90,90,0>
      translate <BookHeight-2.5,NumPages*.005+.26,BookWidth/2+BookWidth/4+.8>
    }
    text {
      ttf "c:\Windows\Fonts\Bookosb.TTF",
      "Science of Physicists", // !
      .2,  0
      texture {
				pigment { color rgb<1,1,.3> }
				finish { ambient .2 }
			}
      scale <.4,.5,1>
      rotate <90,90,0>
      translate <BookHeight-3.7,NumPages*.005+.26,BookWidth/2+BookWidth/4>
    }
    text {
      ttf "c:\Windows\Fonts\Bookosb.TTF",
      "R.J.M. Parker",
      .2,  0
      texture {
				pigment { color rgb<1,1,.3> }
				finish { ambient .2 }
			}
      scale <.2,.2,1>
      rotate <90,90,0>
      translate <.4,NumPages*.005+.26,BookWidth/2+BookWidth/4-1.8>
    }
  }
#declare BookRearCover =
  box {
    <0,0,0>,<BookHeight,.125,BookWidth>
    translate <0,0,0>
    texture { BookCoverTexture }
  }

#declare BookSpine =
  difference {
    cylinder {
      <0,NumPages*.005/2+.125,0>,<BookHeight,NumPages*.005/2+.125,0>,NumPages*.005/2+.125
      texture { BookCoverTexture }
    }
    cylinder {
      <-.1,NumPages*.005/2+.125,0>,<BookHeight+.1,NumPages*.005/2+.125,0>,NumPages*.005/2
      texture { BookCoverTexture }
    }
  scale <1,1,.2>
  translate <0,0,BookWidth>
  clipped_by { plane {-z,BookWidth} }
  }

#declare BookPages =
  box {
    <.25,.125,.25>, <BookHeight-.25,.125+NumPages*.005,BookWidth>
    texture {
        pigment { gradient y
          color_map {
          [0.0  color rgb<.81,.74,.53>]
          [1.0  color rgb<.40,.32,.31>]
          }
        scale .08
        }
        finish { ambient .4 specular .7 roughness .6 }
    }
  }

#declare Book =
  union {
    object { BookFrontCover }
    object { BookRearCover }
    object { BookPages }
    object { BookSpine }
  }
