
// Glenn's Clock POV-Ray Object File
// This file does not render.  #include "Clock.inc" in another .pov file
// created 13-Apr-97  updated 16-Apr-97
// copyright 1997 Glenn McCarter

// A spherical clock
// Intended scale is English system (inches)
// Clock sits on +X+Z plane, origin at ground level
// Clock face is modelled at +Y, with "12" at +Z for ease of modelling,
// but entire clock is then reoriented such that clock face is at -Z,
// +Z is towards the rear of the clock


#declare FaceY = 1.3
#declare SphereTex =
	texture {
//		pigment {color rgb<.61,.55,.48> }
		pigment {color rgb<.41,.35,.28> }
		finish {ambient .03 diffuse 0 metallic specular 0.98 roughness .008 reflection 0.4 }
//		finish {ambient .1 diffuse .7 metallic
//			specular 0.98 roughness .08 reflection 0 } //test render
	}
#declare ClockFaceTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .3 }
	}
#declare ClockHandTex =
	texture { pigment { color rgb<.02,.03,.06> } }
#declare Clock =
	union {
		difference {//cutouts in the sphere
			sphere {
				<0,0,0>, 2
				texture { SphereTex }
			}
			sphere { //bevel outermost edge
				<0,0,0>,1.8
				texture { SphereTex }
				scale <1,1,1>
				translate <0,FaceY+1.65,0>
			}
			cylinder { //outer edge
				<0,FaceY+.1,0>,<0,FaceY+1,0>,1.10
				texture { SphereTex }
			}
			cylinder { //face diameter
				<0,FaceY-.2,0>,<0,FaceY+.3,0>,.950
				texture { SphereTex }
			}
		}
		torus { //yellow ring
			1.06,.05
			texture { pigment {color rgb<1,1,0>} finish {ambient .34 phong 1 phong_size 100 } }
			translate <0,FaceY+.15,0>
		}
		torus { //black inner ring
			1.0,.05
			texture { SphereTex }
			translate <0,FaceY+.1,0>
		}
		cylinder { //the clockface
		 <0,FaceY-.2,0>,<0,FaceY,0>,.990
		 texture { ClockFaceTex }
		}
		union { //hour hand
			cylinder {
				<.05,0,0>,<.5,0,0>,.08
				texture { ClockHandTex }
				scale <1,.2,1>
				rotate <0,62,0>
				translate <0,FaceY+.03,0>
			}
			sphere { //tip
				<0,0,0>,.08
				texture { ClockHandTex }
				scale <1,.2,1>
				translate <.5,0,0>
				rotate <0,62,0>
				translate <0,FaceY+.03,0>
			}
		}
		union { //minute hand
			cylinder {
				<.05,0,0>,<.7,0,0>,.08
				texture { ClockHandTex }
				scale <1,.2,.7>
				rotate <0,-50,0>
				translate <0,FaceY+.06,0>
			}
			sphere { //tip
				<0,0,0>,.04
				texture { ClockHandTex }
				scale <1,.2,1>
				translate <.7,0,0>
				rotate <0,-50,0>
				translate <0,FaceY+.06,0>
			}
		}
		cylinder { //second hand
			<.05,0,0>,<.8,0,0>,.04
			texture { pigment {color rgb<1,.85,0>} finish {ambient .1} } //bright red
//			texture { ClockHandTex }
			scale <1,.2,.7>
			rotate <0,205,0>
			translate <0,FaceY+.09,0>
		}
		cylinder { //hour hand pivot
			<0,FaceY+.01,0>,<0,FaceY+.06,0>,.12
			texture { ClockHandTex }
		}
		cylinder { //second hand pivot
			<0,FaceY+.08,0>,<0,FaceY+.09,0>,.08
			texture { pigment {color rgb<1,.85,0>} finish {ambient .1} } //bright red
//			texture { ClockHandTex }
		}
		cylinder { //center pivot
			<0,FaceY+.01,0>,<0,FaceY+.1,0>,.025
			texture { ClockHandTex }
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"3",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.45,.45,.45>
			rotate <90,0,0>
			translate <.7-.1,FaceY+.01,-.2>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"6",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.45,.45,.45>
			rotate <90,0,0>
			translate <-.1,FaceY+.01,-.7-.2>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"9",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.45,.45,.45>
			rotate <90,0,0>
			translate <-.7-.1,FaceY+.01,-.2>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"12",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.38,.38,.38>
			rotate <90,0,0>
			translate <-.24,FaceY+.01,.6>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"Arius",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.26,.2,.2>
			rotate <90,0,0>
			translate <-.24,FaceY+.01,.3>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"QUARTZ",
			1,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ClockHandTex }
			scale <.1,.1,.1>
			rotate <90,0,0>
			translate <-.20,FaceY+.01,-.4>
		}
		#declare GroupRot = 0
			while ( GroupRot < 4 )
				superellipsoid { // hour tick marks (first of pair)
					<.4, .4>
					texture { ClockHandTex }
					scale <.1,.02,.03>
					translate <.75,FaceY,0>
					rotate <0,GroupRot*90+360/12,0>
				}
				superellipsoid { // hour tick marks (second of pair)
					<.4, .4>
					texture { ClockHandTex }
					scale <.1,.02,.03>
					translate <.75,FaceY,0>
					rotate <0,GroupRot*90+360/12*2,0>
				}
				#declare GroupRot = GroupRot+1
		#end
/*
		cylinder { //bezel flat glass
			<0,0,0>,<0,.08,0>,1.09
			texture {
				pigment { color rgbf<1,1,1,.97> }
				finish { specular .95 roughness .003 refraction 1 ior 1.5 caustics 1 reflection 0.3}
//				finish { specular .95 roughness .003 refraction 1 ior 1.5 caustics 1 reflection 0}
			}
			translate <0,FaceY+.151,0>
		}
*/
		difference {
			sphere { //bezel outer glass
				<0,0,0>,1.0
				texture {
					pigment { color rgbf<1,1,1,.92> }
					finish { specular .95 roughness .003 refraction 1 ior 1.5 caustics 1 reflection 0.3}
				}
				scale <1,.25,1>
				clipped_by {box{<-2,0,-2>,<2,-.5,2>}}
				translate <0,FaceY+.1,0>
			}
			sphere { //bezel inner glass
				<0,0,0>,1.0
				hollow
				texture {
					pigment { color rgbf<1,1,1,.92> }
					finish { specular .95 roughness .003 refraction 1 ior 1.5 caustics 1 reflection 0.2}
				}
				scale <.96,.2,.96>
				clipped_by {box{<-2,0,-2>,<2,-.5,2>}}
				translate <0,FaceY+.1,0>
			}
		}


		rotate <-90,0,-6> translate <0,1,0> //orient the entire clock
	}

#declare SpHTex =
	texture {
//		pigment { color rgb <0.56, 0.41, 0.18> }
//		pigment { color rgb <0.66, 0.51, 0.34> }
		pigment {color rgb<.1,.1,.1> }
		finish {
			ambient 0.1 brilliance 4 diffuse 0.1
			metallic specular 0.95 roughness .012
//			reflection 0.4
			reflection 0.3
		}
	}
#declare SphereHolder =
	union {
		cylinder {<-1,0,-1>,<-1,1,-1>,.2 texture {SpHTex}}
		cylinder {<-1,0,1>,<-1,1,1>,.2 texture {SpHTex}}
		cylinder {<1,0,-1>,<1,1,-1>,.2 texture {SpHTex}}
		cylinder {<1,0,1>,<1,1,1>,.3 texture {SpHTex}}
		sphere {<-1,1,-1>,.3 texture {SpHTex}}
		sphere {<-1,1,1>,.3 texture {SpHTex}}
		sphere {<1,1,-1>,.3 texture {SpHTex}}
		sphere {<1,1,1>,.3 texture {SpHTex}}
		torus {.2,.06 texture {SpHTex} scale <1,1,1> translate <-1,.06,-1>}
		torus {.2,.06 texture {SpHTex} scale <1,1,1> translate <-1,.06,1>}
		torus {.2,.06 texture {SpHTex} scale <1,1,1> translate <1,.06,-1>}
		torus {.2,.06 texture {SpHTex} scale <1,1,1> translate <1,.06,1>}
		torus {1.2,.3 texture {SpHTex} scale <1,.4,1> translate y*.8}
		torus {1.2,.3 texture {SpHTex} scale <1,.4,1> translate y*.4}
  }

