// Glenn's POV-Ray Highlighter Object File
// created 31-Mar-97
// copyright 1997 Glenn McCarter

// A Pilot Spotlighter highlighter marker
// with the cap on
// origin is at the tip of the point

#declare HR = .18 //barrel radius
#declare FluorescentColor =
	texture {
		pigment { color rgb<.8,1,0> }
		finish { ambient .65 roughness .011 specular .3 }
	}

#declare HBarrel =
	union {
		cylinder {
			<0,0,0>,<5,0,0>,HR
			texture {
				pigment {
					radial
					frequency 12
//					gradient x
						color_map {
							[ 0.0 color rgb<.8,.8,.4> ]
							[ 0.5 color rgb<.8,.8,.4> ]
							[ 0.5 color rgb<.95,.95,.95> ]
							[ 1.0 color rgb<.95,.95,.95> ]
						}
					rotate z*90
				}
				finish { ambient .5 }
			}
		}
		cone {
			<4.9,0,0>,HR-.015,<5.3,0,0>,HR-.03
			texture { FluorescentColor }
		}
	}

#declare HBarrelLettering =
  text {
    ttf "c:\Windows\Fonts\ARIAL.TTF",
    "PILOT    Spotliter",
    .2, 0
    scale <.3,.16,1> rotate x*90 translate <1.3,HR+.003,-.05>
    texture { pigment { color <.1,.2,.9> } }
  }

#declare HCap =
	union {
		cylinder {
			<-.2,0,0>,<1.2,0,0>,HR+.05
			texture { FluorescentColor }
		}
		box { //main shaft of clip
			<0,-.1,.35>,<1,.1,.45>
			texture { FluorescentColor }
		}
		box {
			<-.1,-.1,.15>,<.1,.1,.4>
			texture { FluorescentColor }
		}
		cylinder {
			<.8,-.1,.35>,<.8,.1,.35>,.12
			texture { FluorescentColor }
		}

	}

#declare Highlighter =
 union {
	object { HBarrel }
	object { HBarrelLettering translate <0,0,0> }
	object { HCap }
 }
