
// Glenn's IndyCar POV-Ray Object File
// This file does not render.  #include "IndyCar.inc" in another .pov file
// first concept 14-June-96  last update 30-Mar-97
// copyright 1997 Glenn McCarter

// An IndyCar
// Intended scale is English system (inches)
// Car lies in +X+Z plane, origin at ground level, between front wheels
// +X is towards the rear of the car


//===============================================
//             Wheels
//===============================================

#declare TireLetteringTexture =
    texture {
      pigment { rgb<1,1,0> }
      finish { ambient .2 diffuse .6}
    }

#declare TireLetterE =
difference {
  text {
    ttf "c:\Windows\Fonts\ARIALBD.TTF",
    "E",
    1,     // THICKNESS_FLOAT
    0       //OFFSET_VECTOR
    texture { TireLetteringTexture }
  }
  cylinder {
    <-.5,.3,1.5>, <4,.3,1.5>, 1.5
     texture { TireLetteringTexture }
     inverse
  }
}
#declare TireLetterA =
difference {
  text {
    ttf "c:\Windows\Fonts\ARIALBD.TTF",
    "A",
    1,     // THICKNESS_FLOAT
    0       //OFFSET_VECTOR
    texture { TireLetteringTexture }
  }
  cylinder {
    <-.5,.3,1.5>, <4,.3,1.5>, 1.5
     texture { TireLetteringTexture }
     inverse
  }
}

#declare TireLetterG =
difference {
  text {
    ttf "c:\Windows\Fonts\ARIALBD.TTF",
    "G",
    1,     // THICKNESS_FLOAT
    0       //OFFSET_VECTOR
    texture { TireLetteringTexture }
  }
  cylinder {
    <-.5,.3,1.5>, <4,.3,1.5>, 1.5
     texture { TireLetteringTexture }
     inverse
  }
}

#declare TireLetterL =
difference {
  text {
    ttf "c:\Windows\Fonts\ARIALBD.TTF",
    "L",
    1,     // THICKNESS_FLOAT
    0       //OFFSET_VECTOR
    texture { TireLetteringTexture }
  }
  cylinder {
    <-.5,.3,1.5>, <4,.3,1.5>, 1.5
     texture { TireLetteringTexture }
     inverse
  }
}

  #declare TireLetterE2 =
  difference {
    text {
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "E",
      1,     // THICKNESS_FLOAT
      0       //OFFSET_VECTOR
      texture { TireLetteringTexture }
    }
    cylinder {
      <-.5,.3,1.5>, <4,.3,1.5>, 1.5
       texture { TireLetteringTexture }
       inverse
    }
  }

#declare Tire =
  union {
      lathe {
        cubic_spline // n-3 segments
        19,
        <8.5, 10>
        <9, 2>, <9.2,1>, <10,0.2>,
        <11,0>,
        <12,0.2>, <12.8,1>, <13, 2>,
        <13.5,10>,
        <13, 18>, <12.8, 19>, <12, 19.8>,
        <11, 20>,
        <10, 19.8>, <9.2, 19>, <9, 18>,
        <8.5, 10>, <9, 2>, <9.2,1>
        texture {
          pigment { color rgb<.34,.34,.34> }
          normal { bumps .1 scale .03}
          finish { ambient .05 phong .3 phong_size 12 }
        }
      }
  object { TireLetterE scale 2 rotate x*90 translate <0,20.5,10> rotate y*-25 }
  object { TireLetterA scale 2 rotate x*90 translate <0,20.5,10> rotate y*-15 }
  object { TireLetterG scale 2 rotate x*90 translate <0,20.5,10> rotate y*1 }
  object { TireLetterL scale 2 rotate x*90 translate <0,20.5,10> rotate y*15 }
  object { TireLetterE2 scale 2 rotate x*90 translate <0,20.5,10> rotate y*25 }
}

#declare WheelTexture =
	texture {
		pigment { color rgb <.38, .40, .42> }
		finish { ambient .1 brilliance 4 diffuse .5 metallic
			specular 0.80 roughness .012 reflection .5 }
	}
//#declare WheelTexture = texture { pigment {White}} //for testing

#declare BrakeDisc =
    cylinder {
    <0,2,0>, <0,3,0>, 7
    pigment { color rgb<.4,.3,.3> }
    }
#declare WheelHub =
      box {
        <0,0,0>, <6,2,8>
        pigment { color rgb<.4,.3,.3> }
      }
#declare A_ArmStrut =
      cylinder {
        <0,0,0>, <0,-25.5,0>, .25
        pigment { color rgb<.2,.2,.2> }
				scale <3,1,1>
      }
#declare WheelHubAssyRH =
   union {
     object { WheelHub translate <-3,1,-4> }
     object { A_ArmStrut rotate <3,0,10> translate <0,0,3>}  //upper
     object { A_ArmStrut rotate <-3,0,-10> translate <0,0,3>} //upper
     object { A_ArmStrut rotate <0,0,10> translate <0,0,-3>}  //lower
     object { A_ArmStrut rotate <0,0,-10> translate <0,0,-3>} //lower
   }
#declare WheelHubAssyLH =
   union {
     object { WheelHub translate <-3,1,-4> }
     object { A_ArmStrut rotate <-3,0,10> translate <0,0,3>}  //upper
     object { A_ArmStrut rotate <3,0,-10> translate <0,0,3>} //upper
     object { A_ArmStrut rotate <0,0,10> translate <0,0,-3>}  //lower
     object { A_ArmStrut rotate <0,0,-10> translate <0,0,-3>} //lower
   }

#declare WRim =
    lathe {
//    linear_spline
//    quadratic_spline
    cubic_spline
    12,
    <9,17>, <9, 19>, <8.8, 19>, <8.8, 17>, <8,16>, <7.5, 16.8>,
    <5,17>, <5,15>, <9,15>,
    <9,17>, <9, 19>, <8.8, 19>
    texture { WheelTexture }
    }

#declare WSpoke =
    superellipsoid {
    <.2, .2>
    scale <2,1,6>
    texture { WheelTexture }
    }

#declare WHubNut =
    cylinder {
    <0,0,0>, <0,1,0>, 1.5
    texture {WheelTexture }
    }

#declare FrontWheelAssyRH =
    union {
      object { Tire scale <1,.7,1>  rotate y*28// make it narrower
      }
      object { BrakeDisc }
      object { WheelHubAssyRH }
      object { WRim  translate <0,-6,0> }
      object { WSpoke translate <0,11,3> rotate <0,-20,0> }
      object { WSpoke translate <0,11,3> rotate <0,-140,0> }
      object { WSpoke translate <0,11,3> rotate <0,-260,0> }
      object { WHubNut translate <0,12,0> }
    }
#declare FrontWheelAssyLH =
    union {
      object { Tire scale <1,.7,1>  rotate y*28// make it narrower
      }
      object { BrakeDisc }
      object { WheelHubAssyLH }
      object { WRim  translate <0,-6,0> }
      object { WSpoke translate <0,11,3> rotate <0,-20,0> }
      object { WSpoke translate <0,11,3> rotate <0,-140,0> }
      object { WSpoke translate <0,11,3> rotate <0,-260,0> }
      object { WHubNut translate <0,12,0> }
    }
#declare RearWheelAssyRH =
    union {
      object { Tire rotate y*-12}
      object { BrakeDisc }
      object { WheelHubAssyRH }
      object { WRim }
      object { WSpoke translate <0,17,3> rotate <0,0,0> }
      object { WSpoke translate <0,17,3> rotate <0,120,0> }
      object { WSpoke translate <0,17,3> rotate <0,240,0> }
      object { WHubNut translate <0,18,0> }
    }
#declare RearWheelAssyLH =
    union {
      object { Tire rotate y*-12}
      object { BrakeDisc }
      object { WheelHubAssyLH }
      object { WRim }
      object { WSpoke translate <0,17,3> rotate <0,0,0> }
      object { WSpoke translate <0,17,3> rotate <0,120,0> }
      object { WSpoke translate <0,17,3> rotate <0,240,0> }
      object { WHubNut translate <0,18,0> }
    }
#declare LeftFrontWheelAssy =
object { FrontWheelAssyLH
    rotate <-90,0,0>   // make it upright
    translate <0,13,0> // raise it above ground
    translate <7,0,-2*12> // move it to corner of vehicle
}
#declare RightFrontWheelAssy =
object { FrontWheelAssyRH
    rotate <-90,180,0>
    translate <0,13,0>
    translate <7,0,2*12>
}
#declare LeftRearWheelAssy =
object { RearWheelAssyLH
    rotate <-90,0,0>
    translate <0,13,0>
    translate <9*12,0,-2*12>
}
#declare RightRearWheelAssy =
object { RearWheelAssyRH
    rotate <-90,180,0>
    translate <0,13,0>
    translate <9*12,0,2*12>
}
//===============================================
//             Body
//===============================================


#declare BodyTexture =//for most body parts
			texture {
				pigment {
					gradient x
						color_map {
							[0.0 color rgb<.98,.73,.02> ]//yellow
							[0.5 color rgb<.98,.73,.02> ]
//							[0.0 color rgb<.7,.1,.1> ]//red
//							[0.5 color rgb<.7,.1,.1> ]
//							[0.5 color rgb<1,1,1> ]//white stripes
//							[1.0 color rgb<1,1,1> ]
						}
					scale <106,106,106>
					rotate <0,0,30>
					translate <-32,0,0>
				}
		    finish { ambient .25 specular .8 roughness .012 }
			}
#declare BodyTexture2 =//for main body
			texture {
				pigment {
					gradient x
						color_map {
							[0.0 color rgb<.98,.73,.02> ]//yellow
							[0.5 color rgb<.98,.73,.02> ]
//							[0.0 color rgb<.7,.1,.1> ]//red
//							[0.5 color rgb<.7,.1,.1> ]
//							[0.5 color rgb<1,1,1> ]//white stripes
//							[1.0 color rgb<1,1,1> ]
						}
					scale <106,106,106>
					rotate <0,0,30>
					translate <-32,0,0>
				}
		    finish { ambient .25 specular .95 roughness .0002 }
			}

#declare MainBody =
  object {
  difference {
    intersection {
      sphere { <2*12, -3.2*12, 3*12 >, 6*12
        scale <2,1,1>
      }
      sphere { <2*12, -3.2*12, -3*12 >, 6*12
        scale <2,1,1>
      }
      translate <20,0,0>
        texture { BodyTexture2 }
    }
    cylinder {               //cockpit1
      <0,0,0>, <30,0,0>, 12
      rotate <0,0,-10>
      translate <36,28,0>
      texture {
				pigment {color rgb<.35,.35,.35>} }
    }
    cylinder {               //cockpit2
      <0,0,0>, <30,0,0>, 10
      rotate <0,0,-10>
      translate <36,20,0>
      texture { pigment {color rgb<.35,.35,.35>} }
    }
  }
  clipped_by{plane{-y,-2}}
  clipped_by{plane{x,10.4*12}}
  translate <0,2,0> //raise it above the ground
  }

#declare SteeringWheel =
  object {
    union {
      torus {
	    3.6,.6
	    texture { pigment {color rgb<0,0,0>} }
	  }
      box { //center section
	    <-1,-.5,-3.1>,<1,.5,3.1>
        texture { pigment {color rgb<.7,.7,.7>} }
	  }
      cylinder { //shaft
	    <0,0,0>,<0,-12,0>,.4
		texture { pigment {color rgb<.7,.7,.7>} }
      }
	}
    rotate <0,8,-70>
    translate <38,18,0>
  }
#declare RollBar =
  union {
    object {
      torus { 5, .5
        scale <1,6,1>
        rotate z*90
        translate <0,14,0>
      }
      clipped_by {plane{-y,-14}}
    }
    cylinder { <0,6,0>, <0,14,0>, .5
      scale <6,1,1>
      translate <0,0,5>
    }
    cylinder { <0,6,0>, <0,14,0>, .5
      scale <6,1,1>
      translate <0,0,-5>
    }
    translate <6*12,1.2*12,0>
    texture { WheelTexture }
  }

#declare SidePod =
  object {
  difference {
    superellipsoid {
      <.2, .4>
      scale <3.3*12,8,3*12>
      translate <74,6,0>
      texture { BodyTexture }
    }
    box {         // air inlets
      <0,0,0>, <1,1,1>
      scale <3*12,8,5*12>
      texture { pigment { color rgb<0,0,0> } }
      translate <2*12,3,-2.5*12>
    }
    box {         // part of the cockpit
      <0,7,-12>, <40,20,12>
      texture { pigment { color rgb<.6,.6,.6> } }
      translate <30,0,0>
    }
  }
  translate <0,2,0>
}
#declare BodyAssy =
	difference {
		union {
			object { MainBody }
			object { SidePod }
		}
		superellipsoid {
			<1,.4>
			texture { BodyTexture }
			scale <14,14,14>
			translate <106,10,33>
		}
		superellipsoid {
			<1,.4>
			texture { BodyTexture }
			scale <14,14,14>
			translate <106,10,-33>
		}
	}

#declare FWing =
   box {
     <0,0,-30>, <9,.2,30>
     texture { BodyTexture }
     rotate <0,0,12> // wing angle
     translate <-22,4,0> // move it to the front of the car
   }

#declare RWingSidePanel =
	superellipsoid {
		<.4, .4>
		texture { BodyTexture }
		scale <11.5,7,.6>
		translate <8,20,0>
	}
#declare RWingSupport =
    box {
      <0,0,0>, <8,21,.4>
      texture { BodyTexture }
  }
#declare RWingWidth = 60
#declare RWingMainPanel =
	union {
    box {
      <0,1,-RWingWidth/2>, <18,1.6,RWingWidth/2>
      rotate <0,0,18> // wing angle
      texture { BodyTexture }
    }
		cylinder {//front edge
			<0,0,-RWingWidth/2>,<0,0,RWingWidth/2>,2
			texture { BodyTexture }
		}
	}
#declare RWingAssy =
  union{
    object {RWingMainPanel translate <10*12,30,0> }
    object {RWingSidePanel translate <10*12,12,RWingWidth/2> }
    object {RWingSidePanel translate <10*12,12,-RWingWidth/2> }
		object {RWingSupport translate <10*12+3,10,6> }
		object {RWingSupport translate <10*12,10,-6> }
  }

//===============================================
//             Driver
//===============================================

#declare HelmetTex =
	texture {
		pigment { color rgb<.85,.85,.85> }
		finish { specular .9 roughness .002 }
	}
#declare Visor =
	intersection {
		cylinder { // visor
			<0,0,-8>,<0,0,8>,2.1
			texture { pigment { color rgb<.1,.1,.1> } }
			rotate <0,0,0>
			scale <2.4,1.0,1.0>
			translate <6.0,0,0>
		}
		sphere { // main lid shape
			<0,0,0>,6
			texture { pigment { color rgb<.1,.1,.1> } }
		}
	}
#declare Helmet = // center at center!
	difference {
		union {
			sphere { // the main lid
				<0,0,0>,6
				texture { HelmetTex }
			}
			object { Visor scale 1.05 translate <0,0,0>}
			cylinder { //lower jaw
				<0,-5.0,0>,<0,0,0>,6
				texture { HelmetTex }
			}
		}
		box { //cuts off bottom edge
			<-8,-4,-8>,<8,2,8>
			texture { HelmetTex }
			rotate <0,0,-18>
			translate <-1,-5,0>
			}
	}

#declare SuitTex =
	texture {
		pigment {color rgb<.22,.12,.04> }
		normal {
			crackle .3
			scale <1,2,2>
		}
		finish { specular .6 roughness .03 }
	}
#declare Torso = //center where neck/shoulder join each other
	union {
		cylinder { //neck
			<0,-2,0>,<0,3,0>,3
			texture { SuitTex }
		}
		cylinder { //torso
			<0,-16,0>,<0,0,0>,8
			texture { SuitTex }
			scale <.3,1,1>
		}
		cylinder { //shoulder
			<0,-1,-8>,<0,-1,8>,2
			texture { SuitTex }
		}
	}

#declare LeftArm = //center at shoulder
	union {
		sphere { //shoulder end
			<0,0,0>,2
			texture { SuitTex }
		}
		cylinder { //upper arm
			<0,0,0>,<11,0,0>,2.2
			texture { SuitTex }
			rotate <0,0,-24>
		}
		cylinder { //lower arm
			<0,0,0>,<12,0,0>,1.7
			texture { SuitTex }
			rotate <0,0,20>
			translate <10,-4,0>
		}
		sphere { //hand
			<0,0,0>,1.8
			texture { pigment { color rgb <.7,.5,.3> } }
			scale <1.3,1,.5>
			rotate <0,20,0>
			translate <22,1,0>
		}
	}
#declare RightArm = //center at shoulder
	union {
		sphere { //shoulder end
			<0,0,0>,2
			texture { SuitTex }
		}
		cylinder { //upper arm
			<0,0,0>,<11,0,0>,2.2
			texture { SuitTex }
			rotate <0,0,-24>
		}
		cylinder { //lower arm
			<0,0,0>,<12,0,0>,1.7
			texture { SuitTex }
			rotate <0,0,20>
			translate <10,-4,0>
		}
		sphere { //hand
			<0,0,0>,1.8
			texture { pigment { color rgb <.7,.5,.3> } }
			scale <1.3,1,.5>
			rotate <0,-20,0>
			translate <22,1,0>
		}
	}

#declare Driver = //center at helmet
	union {
		object { Helmet rotate <0,12,0> }
		object { Torso rotate <0,0,40> translate <0,-6,0> }
		object { LeftArm rotate <0,10,0> translate <1,-5,8> }
		object { RightArm rotate <0,-10,0> translate <0,-8,-8> }
	}

#declare IndyCar =
  union {
    object { LeftFrontWheelAssy }
    object { RightFrontWheelAssy }
    object { LeftRearWheelAssy }
    object { RightRearWheelAssy }
    object { BodyAssy }
		object { SteeringWheel }
    object { RollBar }
    object { FWing }
    object { RWingAssy }
		object { Driver rotate <0,180,0> scale 1 translate <60,23,0>}
  }
