// Glenn's POV-Ray PaperClips Include File
// created 3-Apr-97
// copyright 1997 Glenn McCarter

// This file creates various paper clips and related objects.

// a basic Paper Clip
#declare PaperClipWireDia = .05
#declare PCWR = PaperClipWireDia/2
#declare PaperClip =
  union {
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.3,0,.14> } //outer end
    cylinder { <0,0,0>, <1,0,0>, PCWR translate <-.5,0,-.14> }  //longest
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.5,0,.14-PCWR*2> }  //shorter
    cylinder { <0,0,0>, <.6,0,0>, PCWR translate <-.3,0,-.1> }  //inside end
    object {torus { .14, PCWR }
      clipped_by{plane{-x,0}}
      translate <.5,0,0>
    }
    object {torus { (.14+.14-PCWR*2)/2, PCWR }
      clipped_by{plane{x,0}}
      translate <-.5,0,-PCWR>
    }
    object {torus { (.14-PCWR*2+.1)/2, PCWR }
      clipped_by{plane{-x,0}}
      translate <.3,0,(.14-PCWR*2-.1)>
    }
    texture { pigment {color rgb<.66,.66,.66> } }
    finish {ambient 0 diffuse 0 metallic specular 0.80 roughness 1/120 reflection .99 }
    translate <0,PCWR,0>
  }

// Colored Paper Clips

#declare PaperClipWireDia = .07
#declare PCWR = PaperClipWireDia/2
#declare RawColorClip =
  union {
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.3,0,.14> } //outer end
    cylinder { <0,0,0>, <1,0,0>, PCWR translate <-.5,0,-.14> }  //longest
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.5,0,.14-PCWR*2> }  //shorter
    cylinder { <0,0,0>, <.6,0,0>, PCWR translate <-.3,0,-.1> }  //inside end
    object {torus { .14, PCWR }
      clipped_by{plane{-x,0}}
      translate <.5,0,0>
    }
    object {torus { (.14+.14-PCWR*2)/2, PCWR }
      clipped_by{plane{x,0}}
      translate <-.5,0,-PCWR>
    }
    object {torus { (.14-PCWR*2+.1)/2, PCWR }
      clipped_by{plane{-x,0}}
      translate <.3,0,(.14-PCWR*2-.1)>
    }
    translate <0,PCWR,0>
  }

#declare BlueClip =
	object { RawColorClip
	  texture { pigment {color rgb<0,0,1> } }
    finish {ambient .25 diffuse .6 specular 0.80 roughness .001 }
	}
#declare GreenClip =
	object { RawColorClip
	  texture { pigment {color rgb<0,1,0> } }
    finish {ambient .25 diffuse .6 specular 0.80 roughness .001 }
	}
#declare YellowClip =
	object { RawColorClip
	  texture { pigment {color rgb<1,1,0> } }
    finish {ambient .3 diffuse .6 specular 0.80 roughness .001 }
	}
#declare RedClip =
	object { RawColorClip
	  texture { pigment {color rgb<1,0,0> } }
    finish {ambient .25 diffuse .6 specular 0.80 roughness .001 }
	}
#declare WhiteClip =
	object { RawColorClip
	  texture { pigment {color rgb<1,1,1> } }
    finish {ambient .3 diffuse .6 specular 0.80 roughness .001 }
	}
#declare BlackClip =
	object { RawColorClip
	  texture { pigment {color rgb<0,0,0> } }
    finish {ambient .25 diffuse .6 specular 0.80 roughness .001 }
	}

#declare DarkPlasticTexture =
	texture {
		pigment {rgb <.28,.15,.05> }
		finish { specular .9 roughness .005 }
	}
#declare PaperClipHolder =
	union {
		difference {//outer cyl
			cylinder {
				<-1.5,0,0>,<1.5,0,0>,1
				texture { DarkPlasticTexture }
			}
			cylinder {//subtract inner cyl
				<-1.51,0,0>,<1.51,0,0>,.8
				texture { DarkPlasticTexture }
			}
			box {//cut off top
				<-1.6,0,-4>,<1.6,4,4>
				texture { DarkPlasticTexture }
				rotate x*30
			}
			box {//cut off top
				<-1.6,0,-4>,<1.6,4,4>
				texture { DarkPlasticTexture }
				rotate x*-30
			}
		}
		cylinder {//edge
			<-1.5,0,0>,<1.5,0,0>,.1
			texture { DarkPlasticTexture }
			translate <0,0,-.9>
			rotate x*-30
		}
		cylinder {//edge
			<-1.5,0,0>,<1.5,0,0>,.1
			texture { DarkPlasticTexture }
			translate <0,0,.9>
			rotate x*30
		}
		superellipsoid {//endcap
			<.7,.3>
			texture { DarkPlasticTexture }
			scale <.1,.4,1.1>
			translate <-1.5,-.66,0>
		}
		superellipsoid {//endcap
			<.7,.3>
			texture { DarkPlasticTexture }
			scale <.1,.4,1.1>
			translate <1.5,-.66,0>
		}
		translate <0,1.1,0>
	}

#declare MarbleBall =
		sphere {//a marble
			<0,0,0>,.45
			texture{
				pigment{
					marble
					color_map {
						[0.0 color rgb<.98,.98,.01> ]
						[0.5 color rgb<.01,.02,.08> ]
						[1.0 color rgb<1,1,1> ]
					}
					turbulence 1.3
					scale .5
				}
				finish{ ambient .1 phong .3 phong_size 200 specular .95 roughness .02 }
			}
		}

#declare FullOfStuff =
	union {
		object { MarbleBall translate <-.9,.65,0> }
		object { YellowClip rotate<-0,0,0> translate <0,.3,0>}
		object { PaperClip rotate<-13,20,3> translate <0,.5,0>}
		object { PaperClip rotate<-8,-12,-3> translate <0,.6,-.2>}
		object { PaperClip rotate<-20,-6,-15> translate <-.76,.5,.4>}
		object { PaperClip rotate<-20,-46,0> translate <.86,.5,0>}
		object { WhiteClip rotate<-40,-6,20> translate <.8,.7,.35>}
		object { PaperClip rotate<6,14,-5> translate <.4,.6,-.3>}
		object { BlueClip rotate<38,0,-3> translate <-.76,.5,-.4>}
	}

#declare StuffSpilling =
	union {
		object { MarbleBall translate <-.9,.74,0> }
		object { YellowClip rotate<-0,0,0> translate <0,.3,0>}
		object { PaperClip rotate<-13,20,3> translate <0,.5,0>}
		object { PaperClip rotate<-8,-12,-3> translate <0,1.0,-.2>}
		object { PaperClip rotate<-20,-6,-15> translate <-.76,.5,.4>}
		object { PaperClip rotate<-20,-46,0> translate <.86,.5,0>}
		object { WhiteClip rotate<-40,-6,20> translate <.8,1.3,.35>} //top
		object { PaperClip rotate<6,14,-25> translate <.4,1.5,-.3>} //floating
		object { WhiteClip rotate<38,0,-3> translate <-.76,.5,-.5>}//near sphere
	}

#declare PaperClipHolderFull =
	union {
		object { PaperClipHolder }
		object { FullOfStuff }
	}

#declare PaperClipHolderSpilling =
	union {
		object { PaperClipHolder }
		object { StuffSpilling }
	}
