
// Glenn's SpiralBooks POV-Ray Include File
// created 31-Mar-97 updated 25-Apr-97
// copyright 1997 Glenn McCarter

// Two spiral-ring notebooks
// Intended scale is English system (inches)
// Book lies in +X+Z plane, origin at lower front corner of rear cover

//===============================================
//     SpiralBook1  8x5 Spiral Bound
//===============================================

// Declarations
#declare NumPages = 80
#declare BookHeight = 8
#declare BookWidth = 5
#declare CoverThick = .03
#declare BookCoverTexture =
	texture {
		pigment { color <.66,.72,.14> }
		finish { ambient .6 roughness .06 diffuse .5 }
		normal { bumps .03 scale .06 }
	}

#declare BookFrontCover =
  union {
    box { // this is the front cover
      <0,0,0>,<BookHeight,CoverThick,BookWidth>
      translate <0,CoverThick+NumPages*.005,0>
      texture { BookCoverTexture }
    }
    text {
      ttf "c:\Windows\Fonts\Arial.TTF",
      "CLAYTON",
      .2,  0
      texture { pigment { color rgb<.18,.22,.25> } }
      scale <.7,1.2,1>
      rotate <90,90,0>
      translate <BookHeight-2.2,NumPages*.005+CoverThick*2+.01,BookWidth/2+BookWidth/4>
    }
    text {
      ttf "c:\Windows\Fonts\Arial.TTF",
      "School Supplies",
      .2,  0
      texture { pigment { color rgb<.18,.22,.25> } }
      scale <.5,.4,1>
      rotate <90,90,0>
      translate <BookHeight-2.8,NumPages*.005+CoverThick*2+.01,BookWidth/2+BookWidth/4>
    }
  }
#declare BookRearCover =
  box {
    <0,0,0>,<BookHeight,CoverThick,BookWidth>
    translate <0,0,0>
    texture { BookCoverTexture }
  }

#declare BookPages =
  box {
    <.07,CoverThick-.01,.2>,<BookHeight-.07,CoverThick+NumPages*.005,BookWidth-.07>
    texture {
      pigment { gradient y
        color_map {
        [0.0  color rgb<.91,.87,.83>]
        [0.8  color rgb<.91,.87,.83>]
        [1.0  color rgb<.50,.42,.31>]
        }
        scale .03
      }
      finish { ambient .5 specular .7 roughness .3 }
    }
  }
#declare WhiteLabel =
	object {
		union {
			box {
				<0,-.1,0>,<2,.01,3>
				texture {
					pigment { color rgb <1,1,1> }
					finish { ambient .5 }
				}
			}
			box { //guide line
				<.6,-.05,.3>,<.65,.011,2.7>
				texture {
					pigment { color rgb <.1,.1,.9> }
					finish { ambient .1 }
				}
			}
			box { //guide line
				<1.2,-.05,.3>,<1.25,.011,2.7>
				texture {
					pigment { color rgb <.1,.1,.9> }
					finish { ambient .1 }
				}
			}
		}
		translate <BookHeight/3,NumPages*.005+CoverThick*2,1.0>
	}
#declare RawBook =
  union {
    object { BookFrontCover }
    object { BookRearCover }
    object { BookPages }
		object { WhiteLabel }
  }
#declare BookWithHoles =
	difference {
		object { RawBook }
		#declare Hcount=1
		#while (Hcount<23)
			cylinder {
				<-.05+Hcount/3,-.2,BookWidth-.15>,
				<-.05+Hcount/3,CoverThick*2+NumPages*.005+.2,BookWidth-.15>,.08
				texture { pigment { color rgb<.9,.9,.7> } }
			}
			#declare Hcount=Hcount+1
		#end
	}
#declare SpiralTex =
	texture {
		pigment { color rgb<.96,.96,.96> }
		finish { ambient .5 roughness .01 specular .9 }
	}
#declare EndSpiral =
	union {
		torus {
			.30,.03
			texture { SpiralTex }
			clipped_by { box {<0,-1,0>,<1,1,-1> }}
		}
		torus {
			.10,.03
			texture { SpiralTex }
			clipped_by { box {<0,-1,0>,<1,1,1> }}
			translate <.2,0,0>
		}
		cylinder {
			<0,0,0>,<-.2,0,0>,.03
			texture { SpiralTex }
			translate <.2,0,.10>
		}
		rotate <0,0,70>
		rotate <0,15,0>
		translate <0,.33,0> //set it on edge
	}
#declare Spiral =
	torus {
		.3,.03
		texture { SpiralTex }
		rotate <0,0,70>
		rotate <0,15,0>
		translate <0,.33,0> //set it on edge
	}
#declare SpiralGroup =
	union {
		#declare Scount=0
		#while (Scount<22)
			object {Spiral translate <.6+Scount/3,0,BookWidth+.06> }
			#declare Scount=Scount+1
		#end
		object { EndSpiral translate <.3,0,BookWidth+.06> }
	}

#declare SpiralBook1 =
	union {
		object { BookWithHoles  rotate x*-1 translate <0,0,0>}//spiral props it up slightly
		object { SpiralGroup }
	}

//===============================================
//     SpiralBook2   8.5x11 Double Ring Bound
//===============================================

// Declarations
#declare NumPages = 50
#declare BookHeight = 11
#declare BookWidth = 8.5
#declare CoverThick = .03
#declare BookCoverTexture =
	texture {
		pigment { color <.78,.82,.82> }
		finish { ambient .6 roughness .06 diffuse .3 }
		normal { bumps .03 scale .06 }
	}

#declare BookFrontCover =
  union {
    box { // this is the front cover
      <0,0,0>,<BookHeight,CoverThick,BookWidth>
      translate <0,CoverThick+NumPages*.005,0>
      texture { BookCoverTexture }
    }
// Here it is...
    text {
      ttf "c:\Windows\Fonts\ArialBD.TTF",
      "Newark",
      .2,  0
      texture { pigment { color rgb<.2,.2,.3> } }
      scale <1.5,1.5,1>
      rotate <90,90,0>
      translate <BookHeight-3.0,NumPages*.005+CoverThick*2+.01,BookWidth/2+BookWidth/4-.1>
    }
    text {
      ttf "c:\Windows\Fonts\ArialBD.TTF",
      "High School",
      .2,  0
      texture { pigment { color rgb<.2,.2,.3> } }
      scale <.5,1.2,1>
      rotate <90,90,0>
      translate <BookHeight-4.4,NumPages*.005+CoverThick*2+.01,BookWidth/2+BookWidth/4>
    }
// Yep, you found it!
    text {
      ttf "c:\Windows\Fonts\Arial.TTF",
      "Composition Book",
      .2,  0
      texture { pigment { color rgb<.2,.2,.3> } }
      scale <.5,.55,1>
      rotate <90,90,0>
      translate <BookHeight-5.2,NumPages*.005+CoverThick*2+.01,BookWidth/2+BookWidth/4-.1>
    }
  }
#declare BookRearCover =
  box {
    <0,0,0>,<BookHeight,CoverThick,BookWidth>
    translate <0,0,0>
    texture { BookCoverTexture }
  }

#declare BookPages =
  box {
    <.07,CoverThick-.01,.2>,<BookHeight-.07,CoverThick+NumPages*.005,BookWidth-.07>
    texture {
      pigment { gradient y
        color_map {
        [0.0  color rgb<.91,.87,.83>]
        [0.8  color rgb<.91,.87,.83>]
        [1.0  color rgb<.50,.42,.31>]
        }
        scale .03
      }
      finish { ambient .5 specular .7 roughness .3 }
    }
  }
#declare RawBook =
  union {
    object { BookFrontCover }
    object { BookRearCover }
    object { BookPages }
  }
#declare RTwin = .12 //space between adjacent rings
#declare RPitch = .36 //space between pairs of rings
#declare Offset = .45 //start from end of book
#declare BookWithHoles =
	difference {
		object { RawBook }
		#declare Hcount=0
		#while (Hcount<29)
			box {
				<Offset+Hcount*RPitch,-.2,BookWidth-.10>,
				<.1+Offset+Hcount*RPitch,CoverThick*2+NumPages*.005+.2,BookWidth-.20>
				texture { pigment { color rgb<.7,.7,.7> } }
			}
			box {//pair of holes
				<Offset+RTwin+Hcount*RPitch,-.2,BookWidth-.10>,
				<.1+Offset+RTwin+Hcount*RPitch,CoverThick*2+NumPages*.005+.2,BookWidth-.20>
				texture { pigment { color rgb<.7,.7,.7> } }
			}
			#declare Hcount=Hcount+1
		#end
	}
#declare Ring =
	torus {
		.20,.015
		texture {
			pigment { color rgb<.2,.08,.08> }
			finish { ambient .2 roughness .01 specular .9 }
		}
		rotate <0,0,90>
		translate <0,CoverThick+NumPages*.005/2,0>
	}
#declare RingGroup =
	union {
		#declare Rcount=0
		#while (Rcount<29)
			object {Ring translate <.05+Offset+Rcount*RPitch,0,BookWidth> }
			object {Ring translate <.05+Offset+RTwin+Rcount*RPitch,0,BookWidth> }
			#declare Rcount=Rcount+1
		#end
	}

#declare SpiralBook2 =
	union {
		object { BookWithHoles }
		object { RingGroup }
		rotate x*-1 //spiral props it up slightly
	}
