
// Glenn's TensorLamp POV-Ray Scene File
// This file does not render.  #include "TensorLamp.inc" in another .pov file
// first concept 31-Mar-97 last update 23-Apr-97
// copyright 1997 Glenn McCarter

// A "Tensor" high-intensity lamp
// Intended scale is English system (inches)
// Lamp origin is at center of base
// +X towards the rear of the lamp
//
// TensorLampA is the area_light version (takes longer to render)

// Declarations ---------------------------------------
// #declare these in your file to set the angles:
// #declare BaseAngle  = 40  // 0 is fully collapsed
// #declare ElbowAngle = 80  // 0 is fully collapsed
// #declare HeadAngleX  = 0  // side-to-side rotation
// #declare HeadAngleZ  = -8  // positive is away from base
// #declare CordLength =  6  // length of power cord
// #declare CordAngleY  =  0  // Y angle of cord out the back
// #declare CordAngleZ  =  0  // Z angle of cord out the back

#declare ShadeTexture =
  texture {
    pigment { color <.34,.25,.11> }
		normal { granite .3 scale .15 }
		finish { ambient .15 diffuse .3 specular .15 roughness .02 }
  }
#declare BrassColor = color rgb <0.66, 0.48, 0.16>
#declare ArmTexture =
	texture {
		pigment { color BrassColor }
		normal { bumps 0.02 scale <.9,.2,.2> }
		finish {
			ambient 0.1
			brilliance 4
			diffuse 0.5
			metallic
			specular 0.95
			roughness .005
			reflection 0.4
		}
	}

#declare FacePlate =
	union {
		difference {
			box { //main faceplate
				<-1.6,.16,-1.1>,<1.6,1.7,1.1>
				texture { ArmTexture }
			}
			box { //switch recess
				<-1.7,.88,-.45>,<-1.45,1.12,.45>
				texture { pigment { color rgb <.7,.7,.7>} }
			}
		}
		box { //switch
			<-1.75,.9,-.2>,<-1.4,1.1,-.35>
			texture { pigment {color rgb<.1,.1,.1>}}
		}
		box { //lettering background
			<-1.5,.25,-.7>,<-1.65,.5,.7>
			texture { ArmTexture
			pigment { color BrassColor*1.2 }	}
		}
		sphere { //rivet
			<-1.65,.37,-.57>,.07
			texture { ArmTexture
			pigment { color BrassColor*.4 }	}
		}
		sphere { //rivet
			<-1.65,.37,.57>,.07
			texture { ArmTexture
			pigment { color BrassColor*.4 }	}
		}
		object {
	  	text {
  	  	ttf "c:\Windows\Fonts\ARIALBD.TTF",
    		"TENSOR",
    		.1,     // THICKNESS_FLOAT
	    	0       //OFFSET_VECTOR
  	  	texture { pigment {color rgb <0,0,0> } }
	  	}
			scale .2 rotate y*90 translate <-1.655,.29,.4>
		}
		object {
	  	text {
  	  	ttf "c:\Windows\Fonts\ARIALBD.TTF",
    		"OFF    ON",
    		.2,     // THICKNESS_FLOAT
	    	0       //OFFSET_VECTOR
  	  	texture { pigment {color rgb <0,0,0> } }
	  	}
			scale .15 rotate y*90 translate <-1.61,1.2,.4>
		}
	}
#declare Cover =
	union {
		box { <-1.75,.1,-1.12>,<1.75,1.75,-1.08> texture {ShadeTexture} }
		box { <-1.75,.1,1.08>,<1.75,1.75,1.12> texture {ShadeTexture} }
		box { <-1.75,1.68,-1.12>,<1.75,1.78,1.12> texture {ShadeTexture} }//top
	}
#declare TopPivot =
	difference {
		box { <-.25,1.70,-.115>,<.25,2.1,.115> texture {ArmTexture } }
		box { <-.24,1.80,-.105>,<.24,2.2,.105> texture {ArmTexture } }//hollowed out
	}
#declare BaseAssy =
	union {
		object { FacePlate }
		object { Cover }
		object { TopPivot }
	}
#declare LowerArm = //origin at base pivot
	union {
		difference {
			box {<.3,-.2,-.2>,<6,.2,.2> texture {ArmTexture }} //the arm
			box {<.2,-.18,-.18>,<.8,.18,.18> texture {ArmTexture }} //hollowed out
		}
		cylinder {<0,0,-.3><0,0,.3>,.06 texture {ArmTexture }} //pivot
		cylinder {<0,0,-.04><.4,0,-.04>,.05 texture { pigment {color rgb<.6,.72,.44>} }} //wire
		cylinder {<0,0,.04><.4,0,.04>,.05 texture { pigment {color rgb<.6,.72,.44>} }} //wire
		box {<-.27,-.2,-.2>,<.4,.2,-.16> texture {ArmTexture }} //end tab RH
		box {<-.27,-.2,.16>,<.4,.2,.2> texture {ArmTexture }} //end tab LH
	}
#declare UpperArm = //origin at elbow pivot
	union {
		cylinder {<0,0,-.26><0,0,.26>,.06 texture {ArmTexture }}
		box {<0,-.17,-.17>,<-8,.17,.17> texture {ArmTexture }}
	}

#declare CordTex =
	texture { pigment {color rgb<.72,.76,.56>} }
#declare HalfCord =
	union {
		cylinder {<0,0,0><CordLength,0,0>,.08 texture { CordTex }}//straight back
		torus {
			6,.08 texture { CordTex }
			clipped_by {
				box { <0,-.2,5>,<6,.2,7> }}
			translate <CordLength,0,-6>
		}
		torus {
			.8,.08 texture { CordTex }
			clipped_by {
				box { <0,-.2,0>,<2,.2,2> }}
			rotate <-90,30,0> translate <CordLength+3.2,-.8,-.9>
		}
	}
#declare Cord =
	union {
		object { HalfCord }
		object { HalfCord translate <0,0,.14> }
	}

#declare Shade = //origin at bulb
	union {
		cone { //inner surface
			<0,0,0>,1.5,<0,.7,0>,1.2
			open
			texture {
				pigment { color rgb <1,1,1> }
				finish { ambient .84 }
			}
		}
		cone { //outer surface
			<0,0,0>,1.55,<0,.75,0>,1.25
			open
			texture { ShadeTexture }
		}
		disc { //cooling ring topside
			<0,.74,0>,<0,.75,0>,1.1,.8
			texture { ShadeTexture }
		}
		disc { //cooling ring underside
			<0,.73,0>,<0,.745,0>,1.105,.795
			texture {
				pigment { color rgb <1,1,1> }
				finish { ambient 0.7 }
			}
		}
		cone { //upper surface
			<0,.74,0>,.7,<0,1.7,0>,.5
			texture { ShadeTexture }
		}
	}
#declare Bulb =
	union {
	  light_source {//main filament light
  	  <0,0,0>
    	colour rgb <1.3, 1.2, 1.0>
			fade_distance 5
			fade_power 1
	    spotlight
  	  point_at <0, -4, 0>
    	radius 28    // degrees fully lit (*2)
	    falloff 46   // degrees no lighting (*2)
  	  tightness 1
	    looks_like {
				intersection {
	  	    sphere {
  	  	    <0,0,0>, .50
	  	      texture {
  	  	      pigment { color rgbf<.98,1,.99,.93> }
    	  	    finish { ambient .56 diffuse .2 refraction 1 ior 1.3 caustics 1 reflection 0.2 }
      	  	}
      		}
	  	    sphere {
  	  	    <0,0,0>, .48
	  	      texture {
  	  	      pigment { color rgbf<.98,1,.99,.93> }
    	  	    finish { ambient .56 diffuse .2 refraction 1 ior 1.3 caustics 1 reflection 0.2 }
      	  	}
						inverse
      		}
				}
	    }
	  }
		light_source {//throws sharp rim shadow
  	  <0,0,0>
    	colour rgb <.5, .5, .4>
			fade_distance 5
			fade_power 1
	    spotlight
  	  point_at <0, -4, 0>
    	radius 53    // degrees fully lit (*2)
	    falloff 56   // degrees no lighting (*2)
  	  tightness 1
	    fade_distance 8
	  }
		cylinder {//bulb base
			<0,.5,0>,<0,.8,0>,.35
			texture {
				pigment { color rgb<.9,.9,.3> }}
      	finish { ambient .99 diffuse .2 }
		}
	}
#declare BulbA = //substitute bulb with Area Light
	union {
	  light_source {//main filament light
  	  <0,0,0>
    	colour rgb <1.3, 1.2, 1.0>
			fade_distance 5
			fade_power 1
	    spotlight
  	  point_at <0, -4, 0>
    	radius 28    // degrees fully lit (*2)
	    falloff 46   // degrees no lighting (*2)
  	  tightness 1
	    looks_like {
  	    sphere {
    	    <0,0,0>, .5
	        texture {
  	        pigment { color rgbf<1,1,.92,.85> }
    	      finish { ambient .99 diffuse .2 reflection .5 }
      	  }
      	}
	    }
	  }
		light_source {//throws sharp rim shadow
  	  <0,0,0>
    	colour rgb <.5, .5, .4>
			fade_distance 5
			fade_power 1
			area_light <0,0,1>, <1,0,0>, 3,3
	    spotlight
  	  point_at <0, -4, 0>
    	radius 53    // degrees fully lit (*2)
	    falloff 56   // degrees no lighting (*2)
  	  tightness 1
	    fade_distance 8
	  }
		cylinder {//bulb base
			<0,.5,0>,<0,.8,0>,.35
			texture {
				pigment { color rgb<.9,.9,.3> }}
      	finish { ambient .99 diffuse .2 }
		}
	}

#declare HeadAssy =
	object {
		union {
			object { Bulb translate <0,.3,0>}
			object { Shade }
		}
		translate <0,-1.1,0> //new origin at pivot point
	}
#declare HeadAssyA =
	object {
		union {
			object { BulbA translate <0,.3,0>}
			object { Shade }
		}
		translate <0,-1.1,0> //new origin at pivot point
	}
#declare UpperArmAssy =
	union {
		object { HeadAssy rotate <HeadAngleX,0,HeadAngleZ> translate <-8.5,0,0>}
		object { UpperArm }
	}
#declare UpperArmAssyA =
	union {
		object { HeadAssyA rotate <HeadAngleX,0,HeadAngleZ> translate <-8.5,0,0>}
		object { UpperArm }
	}
#declare ArmAssy =
	union {
		object { UpperArmAssy rotate z*ElbowAngle*(-1) translate <6,0,0>}
		object { LowerArm }
	}
#declare ArmAssyA =
	union {
		object { UpperArmAssyA rotate z*ElbowAngle*(-1) translate <6,0,0>}
		object { LowerArm }
	}
#declare TensorLamp = // basic lamp
  union {
    object { BaseAssy }
		object { Cord rotate <0,CordAngleY,CordAngleZ> translate <1,.6,0>}
    object { ArmAssy rotate z*BaseAngle translate <0,2,0>}
  }
#declare TensorLampA = // lamp with area light
  union {
    object { BaseAssy }
		object { Cord rotate <0,CordAngleY,CordAngleZ> translate <1,.6,0>}
    object { ArmAssyA rotate z*BaseAngle translate <0,2,0>}
  }

