
// Persistence of Vision Ray Tracer Scene Description File
// File: a-cynic.pov
// Vers: 3.01
// Date: 04/29/97
// Auth: Bob Franke
//


#version 3.01

#include "colors.inc"
#include "stoneold.inc"
#include "finish.inc"
#include "metals.inc"
#include "textures.inc"



#declare True = 1
#declare False = 0
#declare testing = False

// the basic unit of measure is feet.
// objects created in inches are scaled 1/12



global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location <1.0,12,-33.5>
  direction 1*z
  right     4/3*x
  look_at  <0,12,-10>
}

light_source{ <-800,1000,-1000>  color White*1.15 }
light_source { <1.0,12,-33.5> color White*.95 shadowless }



//slightly modified Dan Farmer's Dark Oak
#declare xDMFDarkOak =  texture{pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.2, 0.2, 1>
    color_map {
        [0.0, 0.1 color rgb <0.60, 0.30, 0.18>*.75
                  color rgb <0.60, 0.30, 0.18>*.75]
        [0.1, 0.9 color rgb <0.60, 0.30, 0.18>*.75
                  color rgb <0.30, 0.15, 0.09>*.75]
        [0.9, 1.0 color rgb <0.30, 0.15, 0.09>*.75
                  color rgb <0.30, 0.15, 0.09>*.75]
    }
}
scale .25
}

//slightly modified POV T_Grnt8a
#declare GrntScale=.8
#declare T_Grnt8ab =
texture {
  pigment{
    granite
    turbulence 0.6
    color_map{
      [0.00, 0.18 color rgbf <0.84*GrntScale, 0.65*GrntScale, 0.65*GrntScale, 0.0>
                  color rgbf <0.88*GrntScale, 0.76*GrntScale, 0.62*GrntScale, 0.0>]
      [0.18, 0.37 color rgbf <0.88*GrntScale, 0.76*GrntScale, 0.62*GrntScale, 0.0>
                  color rgbf <0.90*GrntScale, 0.82*GrntScale, 0.71*GrntScale, 0.0>]
      [0.37, 0.54 color rgbf <0.90*GrntScale, 0.82*GrntScale, 0.71*GrntScale, 0.0>
                  color rgbf <0.85*GrntScale, 0.67*GrntScale, 0.67*GrntScale, 0.0>]
      [0.54, 0.85 color rgbf <0.85*GrntScale, 0.67*GrntScale, 0.67*GrntScale, 0.0>
                  color rgbf <0.89*GrntScale, 0.79*GrntScale, 0.67*GrntScale, 0.0>]
      [0.85, 0.98 color rgbf <0.89*GrntScale, 0.79*GrntScale, 0.67*GrntScale, 0.0>
                  color rgbf <0.82*GrntScale, 0.61*GrntScale, 0.61*GrntScale, 0.0>]
      [0.98, 1.01 color rgbf <0.82*GrntScale, 0.61*GrntScale, 0.61*GrntScale, 0.0>
                  color rgbf <0.84*GrntScale, 0.65*GrntScale, 0.65*GrntScale, 0.0>]
    }
  }
}


#declare WindowGlass=
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.95>
              turbulence 20
            }
    normal {bumps 0.005 scale 8}
    finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      refraction 1
      reflection 0.19
      ior 1.5
   }
}


// another modified POV granite
#declare GScale=.75
#declare Concrete3=
texture {
  pigment{
    granite
    turbulence 0.6
    color_map{
      [0.00, 0.18 color rgbf <0.8*GScale, 0.8*GScale, 0.7*GScale, 0.0>
                  color rgbf <0.8*GScale, 0.8*GScale, 0.7*GScale, 0.0>]
      [0.18, 0.37 color rgbf <0.8*GScale, 0.8*GScale, 0.7*GScale, 0.0>
                  color rgbf <0.9*GScale, 0.9*GScale, 0.8*GScale, 0.0>]
      [0.37, 0.54 color rgbf <0.9*GScale, 0.9*GScale, 0.8*GScale, 0.0>
                  color rgbf <0.8*GScale, 0.7*GScale, 0.7*GScale, 0.0>]
      [0.54, 0.85 color rgbf <0.8*GScale, 0.7*GScale, 0.7*GScale, 0.0>
                  color rgbf <0.8*GScale, 0.8*GScale, 0.7*GScale, 0.0>]
      [0.85, 0.98 color rgbf <0.8*GScale, 0.8*GScale, 0.7*GScale, 0.0>
                  color rgbf <0.8*GScale, 0.7*GScale, 0.7*GScale, 0.0>]
      [0.98, 1.01 color rgbf <0.8*GScale, 0.7*GScale, 0.7*GScale, 0.000>
                  color rgbf <0.8*GScale, 0.7*GScale, 0.8*GScale, 0.000>]
    }
  }
  scale .001
}


#declare Concrete= texture{T_Grnt9 }
#declare Concrete2=
texture{
  pigment{
    bozo
    turbulence 0.6
    omega 0.8
    lambda 3.0
    color_map{
      [0.00 color rgb<0.4, 0.4, 0.4>]
      [1.00 color rgb<.6,.6,.6>]
    }
    scale .0007
  }
  normal {bumps 0.1 scale .01}
}


#declare galvSteel=
texture {
  pigment { color rgb <0.55, 0.5, 0.45>*.8 }
  normal {bumps -0.5 scale <0.01, 0.01, 0.01> }
  finish {
    metallic
    ambient 0.1
    diffuse 0.65
    specular 0.85
    roughness 0.3
    reflection 0.1
    brilliance .25
  }
}


// seeds for random blades of grass
#declare xx = seed(244535)
#declare zz = seed(515)
#declare yy = seed(327)
#declare zswitch = seed(983)

#declare SquareOfGrass =
object{
  union{
    box{ <0,0,0><12,-1,12> pigment{DarkBrown} }
    mesh{
      #declare X = 0
      #while (X < 12 )
        #declare Z = 0
        #while (Z <12)
          #declare sw=rand(zswitch) //random z blade angle +45 deg or -45 deg
          #if (sw < .5)
            #declare zLoc = -1
          #else
            #declare zLoc = 1
          #end

          #declare moveX= rand(xx)/2  //random x location for top of blade
          #if (moveX < .25)
            #declare moveX = moveX * -1
          #end

          #declare moveY= rand(yy)/2  //random y location for top of blade
          #if (moveY < .25)
            #declare moveY = moveY * -1
          #end

          #declare moveZ= rand(zz)/2 //random z location for top of blade
          #if (moveZ < .25)
            #declare moveZ = moveZ * -1
          #end

//left half of blade
          triangle { <X-.044, 0, Z+(.044 * zLoc)>, <X+moveX,5+moveY,Z+moveZ>, <X,0,Z> }

          #declare sw=rand(zswitch) //random z blade angle +45 deg or -45 deg
          #if (sw < .5)
            #declare zLoc = -1
          #else
            #declare zLoc = 1
          #end

//right half of blade
          triangle { <X+.044, 0, Z+(.044 * zLoc)>, <X+moveX,5+moveY,Z+moveZ>, <X,0,Z>  }
          #declare Z=Z+0.5
        #end
        #declare X=X+0.5
      #end
//    texture { pigment{color rgb <0,.6,.3> } }
    } // End of mesh.
  } // End of union.
  translate <-6,0,-6>
}


// seeds for random blades of grass
#declare xx = seed(244535)
#declare zz = seed(515)
#declare yy = seed(327)
#declare zswitch = seed(983)

#declare rSquareOfGrass =
object{
  union{
    box{ <0,0,0><24,-1,24> pigment{DarkBrown} }
    mesh{
      #declare X = 0
      #while (X < 24 )
        #declare Z = 0
        #while (Z <24)
          #declare sw=rand(zswitch) //random z blade angle +45 deg or -45 deg
          #if (sw < .5)
            #declare zLoc = -1
          #else
            #declare zLoc = 1
          #end

          #declare moveX= rand(xx)/2  //random x location for top of blade
          #if (moveX < .25)
            #declare moveX = moveX * -1
          #end

          #declare moveY= rand(yy)/2  //random y location for top of blade
          #if (moveY < .25)
            #declare moveY = moveY * -1
          #end

          #declare moveZ= rand(zz)/2 //random z location for top of blade
          #if (moveZ < .25)
            #declare moveZ = moveZ * -1
          #end

//left half of blade
          triangle { <X-.044, 0, Z+(.044 * zLoc)>, <X+moveX,5+moveY,Z+moveZ>, <X,0,Z> }

          #declare sw=rand(zswitch) //random z blade angle +45 deg or -45 deg
          #if (sw < .5)
            #declare zLoc = -1
          #else
            #declare zLoc = 1
          #end

//right half of blade
          triangle { <X+.044, 0, Z+(.044 * zLoc)>, <X+moveX,5+moveY,Z+moveZ>, <X,0,Z>  }
          #declare Z=Z+0.5
        #end
        #declare X=X+0.5
      #end
    } // End of mesh.
  } // End of union.
  translate <-12,0,-12>
}

#declare QuickGrass =
  box{ <-6,0,-6><6,.5,6> pigment{color Green}}




//==================== start of parts for the fence
#declare halfLink=
merge{
  torus{  1.0, 0.1
    clipped_by{ plane {x,0 } rotate<0,45,0>}
    clipped_by{ plane {x,0 } rotate<0,-45,0>}
    rotate <90,0,0>
  }
  cylinder { <0,0,0>, <2,0,0>,.1
    rotate <0,0,45>
    translate <cos(radians(45))*-1,cos(radians(45)),0>
  }
  cylinder { <0,0,0>, <2,0,0>,.1
    rotate <0,0,-45>
    translate <cos(radians(45))*-1,cos(radians(45))*-1,0>
  }
}

#declare oneLink =
object{
  union{
    object{halfLink rotate<-3,0,0> rotate<0,0,0>  }
    object{halfLink rotate<0,180,0> rotate<3,0,0> translate<-1.8,0,0> rotate<0,0,0>}
  }
  translate<0.9,0,0>
  scale <1,.85,1>
}

#declare RailEndCap=
merge{
  object{
    superellipsoid{ <1,.2> rotate<90,0,0> scale <.9375,1.25,.9375>
    clipped_by{ plane {y,0 inverse}}
    }
  }
  torus{0.9375, 0.06 }
  box{<-.875,1,-.0625>,<-.125,2.25,.0625>}
  texture{galvSteel scale 1}
  scale 1/12
}

#declare SmallCenterBand=
difference{
  merge{
    cylinder{<0,0,0>,<0,.75,0>,.9375}
    box{<-1.9375,0,-.125>,<0,0.75-.0625>}
    box{<-1.9375,0,.125>,<0,0.75.0625>}
    texture{galvSteel scale 1}
  }
  box{<-2.5,-1,-.031258>,<0,1.0,.03125>}
  texture{galvSteel scale .5}
  scale 1/12
}

#declare BigCenterBand=
difference{
  merge{
    cylinder{<0,0,0>,<0,.75,0>,1.3125}
    box{<-2.3125,0,-.125>,<0,0.75-.0625>}
    box{<-2.3125,0,.125>,<0,0.75.0625>}
    texture{galvSteel scale .3}
  }
  box{<-2.5,-1,-.031258>,<0,1.0,.03125>}
  texture{galvSteel scale .5}
  scale 1/12
}

#declare MainPost=
union{
  merge{
    object{
      superellipsoid{ <1,.2> rotate<90,0,0> scale 1.3125}
      clipped_by{ plane {y,0 inverse}}
      translate<0,101,0>
    }
    torus{1.3125, 0.0625 translate <0,101,0>}
  texture{galvSteel scale .5}
  }
  cylinder{<0,-24,0>,<0,101,0>,1.25
    texture{galvSteel scale.5}
  }
  scale 1/12
}

#declare frontStretchBar=
  box{<0,5.5,-.25>,<1.5,92.5,.25>
    texture{galvSteel }
    scale 1/12
  }


#declare BigHinge=
union{
  difference{
    cylinder{<72,0,0>,<72,-1.5,0>,1.375}
    cylinder{<72,1,0>,<72,-2.50,0>,1.375}
  }

  difference{
    cylinder{<69.75,0,0>,<69.75,-3,0>,1.375}
    cylinder{<69.75,1,0>,<69.75,-5,0>,1.375}
  }
}


#declare stretchBar=
  box{<0,5.5,-.25>,<1.5,92.5,.25>
    texture{galvSteel }
    scale 1/12
  }

#declare QuarterRound=
  torus{  2.25 1.25
  clipped_by{ plane {x,0 } }
  clipped_by{ plane {x,0 } rotate<0,90,0>}
  rotate<90,0,0>
}
//=========================== end of fence parts


// add chain link fence
#declare frontFence=
union{
  #declare xLoc = 3.2*1.5
  #declare yLoc = 4.23*.85*1.5
  #declare xCount=0       // x location
  #if (testing = True)
    #declare yCount=100
  #else
    #declare yCount=0    // y location
  #end
  #while (yCount< 18)
    #while (xCount< 9)
       object{ oneLink scale 1/12*1.5
               translate  <(xCount*xLoc+76.5), (yCount*yLoc+1.7),-121>/12
               texture{galvSteel scale 1/12}
               translate<0.1,0,0>
       }
       #declare xCount=xCount+1
    #end
      #declare xCount=0
      #declare yCount=yCount+1
  #end
  object{MainPost translate<10.17,0,-10>}
  object{MainPost translate<6,0,-10>}
  object{BigCenterBand rotate<0,0,0> translate<10.17,8,-10>}
  object{RailEndCap rotate<180,0,90> translate<9.92,7.98925,-10>}
  object{RailEndCap rotate<0,180,90> translate<6.25,7.98925,-10>}
  cylinder{<6.25,7.98925,-10>,<9.95,7.98925,-10>, .875/12 texture{galvSteel scale .5}}
  object{frontStretchBar translate<74.25,0,-121.5>/12}
  object{frontStretchBar translate<118,0,-121.5>/12}
}


//===================== start right fence assembly
#declare rightFence=
union{
  #declare xLoc = 3.2*1.5
  #declare yLoc = 4.23*.85*1.5
  #declare xCount=1       // x location
  #if (testing = True)
    #declare yCount=100
  #else
    #declare yCount=0
  #end
  #while (yCount< 18)
    #while (xCount< 21)
       object{ oneLink scale 1/12*1.5
               translate  <(xCount*xLoc), (yCount*yLoc+1.7),-1>/12
               texture{galvSteel scale 1/12}
       }
       #declare xCount=xCount+1
    #end
      #declare xCount=1
      #declare yCount=yCount+1
  #end

  object{MainPost translate<0,0,0>}
  object{MainPost translate<8.5,0,0>}
  object{BigCenterBand rotate<0,180,0> translate<0,7.917,0>}
  object{BigCenterBand rotate<0,0,0> translate<8.5,8,0>}
  object{RailEndCap rotate<0,180,90> rotate<180,0,0> translate<.25,7.98925,0>}
 object{RailEndCap rotate<0,180,90> rotate<0,180,0> translate<8.25,7.98925,0>}
 cylinder{<.25,7.98925,0>,<8.25,7.98925,0>, .875/12 texture{galvSteel scale .5}}
}
//===================== end right fence assembly


//===================== start left fence assembly
#declare leftFence=
union{
  #declare xLoc = 3.2*1.5
  #declare yLoc = 4.23*.85*1.5
  #declare xCount=1       // x location
  #if (testing = True)
    #declare yCount=100
  #else
    #declare yCount=0    // y location
  #end
  #while (yCount< 18)
    #while (xCount< 21)
       object{ oneLink scale 1/12*1.5
               translate  <(xCount*xLoc), (yCount*yLoc+1.7),1>/12
               texture{galvSteel scale 1/12}
       translate<-.1,0,0>
       }
       #declare xCount=xCount+1
    #end
      #declare xCount=1
      #declare yCount=yCount+1
  #end

  object{MainPost translate<8.5,0,0>}
  object{BigCenterBand rotate<0,180,0> translate<0,7.917,0>}
  object{BigCenterBand rotate<0,0,0> translate<8.5,8,0>}
  object{RailEndCap rotate<0,180,90> rotate<180,0,0> translate<.25,7.98925,0>}
  object{RailEndCap rotate<0,180,90> rotate<0,180,0> translate<8.25,7.98925,0>}
  cylinder{<.25,7.98925,0>,<8.25,7.98925,0>, .875/12 texture{galvSteel scale .5}}
}
//===================== end left fence assembly


#declare fenceDoorFrame=
object{
  union{
    cylinder{<1.75,2,0>,<1.75,92.5,0>,1.25}
    cylinder{<69.75,2,0>,<69.75,92.5,0>,1.25}
    cylinder{<1.75,3.25,0>,<69.75,3.25,0>,1.25}
    cylinder{<4,94.75,0>,<67.5,94.75,0>,1.25}
    object{QuarterRound rotate<180,0,0>translate<4,92.5,0> }
    object{QuarterRound rotate<180,180,0>translate<67.5,92.5,0> }
    object{BigHinge translate<0,22,0>}
    object{BigHinge translate<0,78,0>}
  }
  texture{galvSteel scale 1/12}
  translate<-72,0,0>
  scale 1/12
}


//========================== start of rh front door assy
#declare rhFenceDoorAssy=
union{
  #declare xLoc = 3.2*1.5
  #declare yLoc = 4.23*.85*1.5
  #declare xCount=-14      // x location
  #if (testing = True)
    #declare yCount=100
  #else
    #declare yCount=1    // y location
  #end
  #while (yCount< 18)
    #while (xCount< -1)
       object{ oneLink scale 1/12*1.5
               translate  <(xCount*xLoc+2.25), (yCount*yLoc+2.25),-1.5>/12
               texture{galvSteel scale 1/12}
       }
       #declare xCount=xCount+1
    #end
      #declare xCount=-14
      #declare yCount=yCount+1
  #end
  object{fenceDoorFrame}
  object{stretchBar translate<-5.75,0,-1.25>/12}
  object{stretchBar translate<-68.0,0,-1.25>/12}
}
//========================== end of rh front fence door assy


//========================== start of lh front fence door assy
#declare lhFenceDoorAssy=
union{
  #declare xLoc = 3.2*1.5
  #declare yLoc = 4.23*.85*1.5
  #declare xCount=-14      // x location
  #if (testing = True)
    #declare yCount=100
  #else
    #declare yCount=1    // y location
  #end
  #while (yCount< 18)
    #while (xCount< -1)
       object{ oneLink scale 1/12*1.5
               translate  <(xCount*xLoc+2.25), (yCount*yLoc+1.7),1.5>/12
               texture{galvSteel scale 1/12}
       }
       #declare xCount=xCount+1
    #end
      #declare xCount=-14
      #declare yCount=yCount+1
  #end
  object{fenceDoorFrame}
  object{stretchBar translate<-5.75,0,1.75>/12}
  object{stretchBar translate<-68.75,0,1.75>/12}
}
//========================== end of lh front fence door assy


#declare SideWalk=
  superellipsoid { <1/12,1/24>
    scale <5.6667,1/3,2>
    clipped_by{ plane {y,0 inverse}}
    #if (testing = True)
      pigment {Gray90}
    #else
      texture{Concrete scale .001}
    #end
  }


//========================== start of window parts and assembly


#declare PaneOfGlass =
  box{<0,0,0>,<13,22,.125>
      #if (testing = True)
      pigment{color red 1.00 green 0.11 blue 0.68}
    #else
      texture{WindowGlass}
    #end
  }


// This is one window assembly which includes the outer frame,
// the lower and upper sliding frames and 16 panes of glass.
// To reduce the big sectional mirror effect, each pane of glass is randomly
// rotated on the z,y & z axis from 0 to .3 degrees.
// The unit of measure is inches, so the object is scaled 1/12

#declare Window=
union{
  merge{
    difference{
       box{<0,50,0-6>,<60,102,2-6>}
       box{<4,54,-10>,<56,98,10>}
    }
    difference{
       box{<0,2,2-6>,<60,54,4-6>}
       box{<4,6,-10>,<56,50,10>}
    }
    box{<3.5,51,1>,<4.5,101,1> translate <13,0,0-6>}
    box{<3.5,51,1>,<4.5,101,1> translate <13*2,0,0-6>}
    box{<3.5,51,1>,<4.5,101,1> translate <13*3,0,0-6>}
    box{<3,75.5,1-6>,<57,76.5,1-6>}

    box{<3.5,5,3>,<4.5,51,3> translate <13,0,0-6>}
    box{<3.5,5,3>,<4.5,51,3> translate <13*2,0,0-6>}
    box{<3.5,5,3>,<4.5,51,3> translate <13*3,0,0-6>}
    box{<3,27.5,3-6>,<57,28.5,3-6>}

    #declare xx = seed(123654)
    #declare yy = seed(988511)
    #declare zz = seed(753159)
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4,6+22,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+13,6+22,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+26,6+22,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+39,6+22,3.2-6>}

    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4,54+22,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+13,54+22,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+26,54+22,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+39,54+22,1.2-6>}

    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4,6,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+13,6,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+26,6,3.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+39,6,3.2-6>}

    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4,54,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+13,54,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+26,54,1.2-6>}
    object{PaneOfGlass  rotate<rand(xx)*.3,rand(yy)*.3,rand(zz)*.3> translate<4+39,54,1.2-6>}
  }


  box{<-5,0,-15>,<65,2,12>}
  box{<-4,.01,-14>,<0.1,106,12>}
  box{<59.9,0,-14>,<64,106,12>}
  box{<-4,101.9,-14>,<64,106,12>}

  scale 1/12
  #if (testing = True)
       pigment {color rgb <.25,.4,.5>*1.15 }
  #else
       pigment {color rgb <.25,.4,.5>*1.15}
  #end
}
//========================== end of window parts and assembly



//========================= start of front steps and stoop
#declare StepCount = 0
#declare StepTop = 8
#declare StepBottom = 0
#declare StepFront = 0
#declare StepBack = 12
#declare FrontSteps=
union{
  merge{
    #while (StepCount < 5)
      box{<-60, StepBottom , StepFront > < 60, StepTop ,  StepBack > }
      #declare StepCount = StepCount +1
      #declare StepTop = StepTop + 8
      #declare StepFront = StepFront + 12
      #declare StepBack = StepBack + 12
    #end
    #if (testing = True)
      pigment {Gray70}
    #else
      texture{Concrete3}
    #end
  }

  #declare StepCount = 0
  #declare StepTop = 8
  #declare StepBottom = 0
  #declare StepFront = 0
  #declare StepBack = 12
  #while (StepCount < 5)
    box{<-60, StepTop-1 , StepFront-0.01 > < 60, StepTop ,  StepFront+1>
        #if (testing = True)
          pigment {Gray50}
        #else
          texture{Concrete2}
        #end
    }
    #declare StepCount = StepCount +1
    #declare StepTop = StepTop + 8
    #declare StepFront = StepFront + 12
    #declare StepBack = StepBack + 12
  #end

  box{<-122, 0 , StepBack-12 > < 122, StepTop  ,  StepBack+180-12>
      #if (testing = True)
        pigment {color Cyan}
      #else
        texture{Concrete3}
      #end
    }


  box{<-120, StepTop+36  , StepBack+120-14 > < -102, 408 ,  StepBack+120-12>
    #if (testing = True)
       pigment {color Blue}
    #else
     texture{T_Grnt8ab scale .01}
    #end
  }

  box{<120, StepTop+36  , StepBack+120-14 > < 102, 408 ,  StepBack+120-12>
    #if (testing = True)
       pigment {color Blue}
     #else
     texture{T_Grnt8ab scale .01}
     #end
  }

  box{<-120, StepTop  , StepBack-12 > < -102, StepTop+36 ,  StepBack+120-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }
  box{<120, StepTop  , StepBack-12 > < 102, StepTop+36 ,  StepBack+120-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }


  box{<-120, StepTop  , StepBack-12 > < -60, StepTop+36 ,  StepBack-12+18>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
     }
  box{<120, StepTop  , StepBack-12 > < 60, StepTop+36 ,  StepBack-12+18>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }

// back of the right +22railing
  box{<60, 0 , StepBack-24> < 68, StepTop+36 , StepBack-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }

// back of the left +22railing
  box{<-60, 0  , StepBack-24> < -68, StepTop+36 ,  StepBack-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }


//bottom of the right +22railing
   box{<60, 0, 0 > < 68, +36 , StepBack-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }

// bottom of the left +22railing
  box{<-60, 0, 0 > < -68, +36 , StepBack-12>
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
    }

// setup for the +22railings
  #declare HalfOfZ = (StepBack-24) / 2
  #declare HalfOfY = (StepTop) / 2
  #declare RotationAngle = atan2(HalfOfZ,HalfOfY)

// make the right +22railing
  object{
    difference{
      box{<60, HalfOfY*-1, HalfOfZ*-1 > < 68, HalfOfY , HalfOfZ>}
      box{<50, 0, -100 > < 75, HalfOfY+50 , 100> rotate<degrees(RotationAngle)*-1,0,0>}
    }
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
      translate<0,HalfOfY+36,HalfOfZ>
  }

// make the left +22railing
  object{
    difference{
      box{<-60, HalfOfY*-1, HalfOfZ*-1 > < -68, HalfOfY , HalfOfZ>}
      box{<-50, 0, -100 > < -75, HalfOfY+50 , 100> rotate<degrees(RotationAngle)*-1,0,0>}
    }
      #if (testing = True)
        pigment {Gray70}
      #else
        texture{Concrete3}
      #end
      translate<0,HalfOfY+36,HalfOfZ>
  }
  scale 1/12
}
//========================= start of front steps and stoop

//back of stoop is at 15 feet
//front of main building is at 20 feet
//top of foundation is a 4 feet

#declare stonePlaque=
difference{
  box{<-5,0,0>,<5,6.5,.75>}
  text { ttf "cyrvetic.ttf" "P.S. 105" 1, 0  scale<2,2,1>translate<-3.5,3.7,-.9>}
  text { ttf "cyrvetic.ttf" "1997" 1, 0  scale<2,2,1> translate<-2.2,1.2,-.9>}
  #if (testing = True)
     pigment {color Gray70}
   #else
     texture{T_Grnt8ab scale .01}
   #end
  bounded_by { box{<-5.01,0,0>,<5.01,7.51,.751>} }
}

#declare frontDoorDecoration=
union{
  box{<-4.5,0,-1/12>,<4.5,1.5,2/12>}
  box{<-4.5,-.75,-1/12>,<-3.5,0,2/12>}
  box{<4.5,-.75,-1/12>,<3.5,0,2/12>}
   #if (testing = True)
     pigment {color Gray70}
  #else
     texture{T_Grnt8ab scale .01}
  #end
}


#declare Foundation =
  object{ box{ <-80.15,-1,20-.15>, <80.15,4,95.15>}
    #if (testing = True)
      pigment {Copper}
    #else
      texture{Concrete3}
    #end
  }

#declare MainShell=
difference{
  merge{  box{ <-80,4,20>, <80,34,95>}
          box{ <-10,4,15>, <10,34,20.5>}
       }
//remove inside of main building
  box{ <-78,0,22>, <78,50,93>}

//cutout for front door
  box{ <-5,3.99,14>, <5,12,25>}
  cylinder { <0,12,14>, <0,12,25>,5 }


// ========== start cutout the holes for the windows
  #declare xOffset = 13
  #declare xCount = 0
  #declare outerLoop = 0
  #while (outerLoop < 2)
    #while (xCount < 4)
      box{ <0,0,15>, <5,8.5,30>  translate<xOffset,7,0>}
      box{ <0,0+13,15>, <5,8.5+13,30>  translate<xOffset,7,0>}
      #declare xOffset = xOffset + 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset + 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end

  #declare xOffset = -18
  #declare xCount = 0
  #declare outerLoop = 0
  #while (outerLoop < 2)
    #while (xCount < 4)
      box{ <0,0,15>, <5,8.5,30>  translate<xOffset,7,0>}
      box{ <0,0+13,15>, <5,8.5+13,30>  translate<xOffset,7,0>}
      #declare xOffset = xOffset - 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset - 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end
//========= end cutout the holes for the windows

  #if (testing = True)
    pigment {Red}
  #else
    texture {
      brick texture{pigment{color Gray50}
               normal{granite 0.7}
            },
            texture{ pigment{color Firebrick}
              normal {bumps 0.5
                scale <1, 0.001, 0.01>
                rotate<0,0,90>
                translate<-1500,0,0>
              }
            }
     scale .2
    }
  #end
}


#declare DoorReinf=
object{
   difference{
      cylinder { <0,12,15>, <0,12,25>,5 +(3/12) }
      cylinder { <0,12,5>, <0,12,50>,4.98 }
   }
   clipped_by{ plane {y,12 inverse}}
  texture{pigment{color Gray20}}
}

#declare GlassOverDoors=
union{
  object{
    cylinder { <0,12*12,-.125>, <0,12*12,.125,>,59.9 }
    clipped_by{ plane {y,12*12 inverse}}
    #if (testing = True)
      pigment{color red 1.00 green 0.11 blue 0.68}
    #else
      texture{WindowGlass}
    #end
  }
  union{
    object{
      difference{
        cylinder { <0,12*12,-2>, <0,12*12,2>,60 }
        cylinder { <0,12*12,-20>, <0,12*12,50>,58 }
      }
      clipped_by{ plane {y,12*12 inverse}}
    }
    box{<-60,144,-.5>,<60,146,.5>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-30> translate<0,145,0>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-90> translate<0,145,0>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-150> translate<0,145,0>}
    pigment {color Gray20}
  }
  scale 1/12
}

// ===================start of front door handle
#declare handle=
merge{
  object{
    torus{.75,.5}
      clipped_by{ plane {x,0 }}
      clipped_by{ plane {x,0 inverse} rotate<0,90,0>}
   rotate<90,0,0>
   }
  object{
    torus{.75,.5}
      clipped_by{ plane {x,0 inverse}}
      clipped_by{ plane {x,0 } rotate<0,-90,0>}
      rotate<90,0,0>
      translate<12,0,0>
  }
  cylinder{<0,0.75,0>,<12,0.75,0> .5}
  cylinder{<-.75,0,0>,<-.75,-2.25,0> .5}
  cylinder{<12.75,0,0>,<12.75,-2.25,0> .5}
  box{<-2,-2.25,-2>,<14,-2.125,2>}
  translate<0,2.25,0>
  rotate<-90,0,-90>
  texture{T_Brass_3B}
}
// =================== end of front door handle



#declare frontDoorAssy=
union{
  box{<-60,138,-1>,<60,144,1>
      texture{xDMFDarkOak  rotate<0,-90,0> }
  }
  box{<-60,36,-1>,<-54,144,1>
      texture{xDMFDarkOak  rotate<88,0,0>}
  }
  box{<60,36,-1>,<54,144,1>
      texture{xDMFDarkOak  rotate<87,0,0>}
  }
  box{<-53.5,36.5,-1>,<-.5,137.5,1>
      texture{xDMFDarkOak  rotate<89.25,0,0> translate <-25,0,0>}
  }
  box{<53.5,36.5,-1>,<.5,137.5,1>
      texture{xDMFDarkOak  rotate<89.25,0,0> translate <20,-10,0>}
  }

  object{handle translate<-5,96,-1>}
  object{handle translate<5,96,-1>}
scale 1/12
}

//===================start of trim at the top of the building
#declare topDecTrm=
union{
  difference{
     box{ <-80.5,32,19.5>, <80.5,34,95.5>}
     box{ <-80,20,20>, <80,50,95>}
  }
  difference{
     box{ <-81.5,33.5,18.5>, <80.5,34,96.5>}
     box{ <-80.5,30,19.5>, <80.5,50,95.5>}
  }
  difference{
     box{ <-81,33,19>, <80,33.5,96>}
     box{ <-80.5,30,19.5>, <80.5,50,95.5>}
  }
  difference{
    box{ <-10.5,32,14.5>, <10.5,34,20.5>}
    box{ <-10,4,15>, <10,50,20>}
  }


  difference{
    box{ <-11.5,33.5,13.5>, <11.5,34,21.5>}
    box{ <-10,4,15>, <10,50,20>}
}
  difference{
    box{ <-11,33,14>, <11,33.5,21>}
    box{ <-10,4,15>, <10,50,20>}
}
  #if (testing = True)
     pigment {color Gray70}
   #else
     texture{T_Grnt8ab scale .01}
   #end
}
//===================end of trim at the top of the building


#declare FlatRoof=
  box{ <-80,33.5,20>, <80,34,95>
      pigment{color Black}
  }

// make some black walls inside the building
// otherwise I'll have to model the inside of the school
#declare BlackWall=
  box{ <-78,0,92.5>, <78,33.5,93>
    pigment{color Black}
  }

#declare leftBlackWall  =
   box{ <-78,0,22>, <78.25,33.5,93>
     pigment{color Black}
   }

#declare windowDecoration=
  box{<1.8,9.0,-1/12>,<3.2,11.0,2/12>
    #if (testing = True)
       pigment {color Goldenrod*.8 }
    #else
      texture{T_Grnt8ab scale .01}
    #end
  }


//===================== start building the school
#declare School  =
union{
  object{stonePlaque translate<0,23,14.9>}
  object{FrontSteps}
  object{Foundation}
  object{MainShell}
  object{FlatRoof}
  object{BlackWall}
  object{leftBlackWall}
  object{topDecTrm}
  object{DoorReinf}
  object{frontDoorDecoration translate<0,18,15>}
  object{GlassOverDoors translate <0,0,19.8>}
  object{frontDoorAssy translate <0,0,19.8>}


//===================== start add the windows
  #declare xOffset = 13
  #declare xCount = 0
  #declare outerLoop = 0


  #while (outerLoop < 2)
    #while (xCount < 4)
      object{Window translate<xOffset,7,21>}
      object{Window translate<xOffset,7+13,21>}
      #declare xOffset = xOffset + 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset + 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end

  #declare xOffset = -18
  #declare xCount = 0
  #declare outerLoop = 0
  #while (outerLoop < 2)
    #while (xCount < 4)
      object{Window translate<xOffset,7,21>}
      object{Window translate<xOffset,7+13,21>}
      #declare xOffset = xOffset - 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset - 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end
//===================== start add the windows

// add four window shades
  box{<4,2,-6>,<60,102,-5.75> scale 1/12 pigment{color  Goldenrod*.75 } translate <20,7+13,21.4>}
  box{<4,60,-6>,<60,102,-5.75> scale 1/12 pigment{color  Goldenrod*.75 } translate <27,7,21.4>}

  box{<4,2,-6>,<60,102,-5.75> scale 1/12 pigment{color Goldenrod*.75 } translate <-18,7+13,21.4>}
  box{<4,40,-6>,<60,102,-5.75> scale 1/12 pigment{color Goldenrod*.75 } translate <-32,7,21.4>}



//==========================start add windowDecoration
  #declare xOffset = 13
  #declare xCount = 0
  #declare outerLoop = 0

  #while (outerLoop < 2)
    #while (xCount < 4)
      object{windowDecoration translate<xOffset,7,20>}
      object{windowDecoration translate<xOffset,7+13,20>}
      #declare xOffset = xOffset + 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset + 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end

  #declare xOffset = -18
  #declare xCount = 0
  #declare outerLoop = 0
  #while (outerLoop < 2)
    #while (xCount < 4)
      object{windowDecoration translate<xOffset,7,20>}
      object{windowDecoration translate<xOffset,7+13,20>}
      #declare xOffset = xOffset - 7
      #declare xCount = xCount + 1
    #end
    #declare xOffset = xOffset - 4
    #declare xCount = 0
    #declare outerLoop = outerLoop + 1
  #end
//========================== end add windowDecoration
}
//=============================== end building the school


#declare weaponSign=
object{
  union{
    box{<0,0,0>,<36,40,.0625> pigment {color White*.85}}
    text { ttf "cyrvetic.ttf" "Weapons" 1, 0  scale 7 translate<4,29.5,0> pigment { Black}}
    text { ttf "cyrvetic.ttf" "Returned " 1, 0  scale 7 translate<4.25,21.5,0> pigment { Black}}
    text { ttf "cyrvetic.ttf" "After" 1, 0  scale 7 translate<10,13.5,0> pigment { Black}}
    text { ttf "cyrvetic.ttf" "School" 1, 0  scale 7 translate<6.5,5.5,0> pigment { Black}}
    sphere { <18,2,0>, 1
      clipped_by{ plane {z,-.25}}
      texture {galvSteel}
      translate<0,0,.25>
    }
    sphere { <18,38,0>, 1
      clipped_by{ plane {z,-.25}}
      texture {galvSteel}
      translate<0,0,.25>
    }
  }
  scale 1/12
}


#declare detector=
union{
  union{
    box{<0,0,0>,<3,102,24>}
    box{<35,0,0>,<38,102,24>}
    box{<3,100,0.5>,<35,102,24>}
    box{<3,90,0.5>,<35,92,24>}
    texture{
     pigment{DarkWood}
    }
  }
  box{<3,92,0.4>,<35,100,.45>
    texture{
      pigment{SteelBlue*.5}
    }
  }
  cylinder{<8,96,0>,<8,96,.45>,.7 texture{pigment{color Cyan}}}
  cylinder{<26,98,0>,<31,98,.45>,1 texture{pigment{color Red*.75}}}
  cylinder{<26,94,0>,<31,94,.45>,1 texture{pigment{color Green}}}
  scale 1/12
}


#declare tray=
object{
  difference{
    superellipsoid{ <0.375,  .375>}
    superellipsoid{ <0.375,  .375> scale .98}
    plane {y,-.75 inverse }
  }
  texture{
    pigment{MediumGoldenrod}
    finish {Dull}
  }
  translate<0,1,0>
}


#declare detectorTable=
  union{
    box{<38.5,30,0>,<68,31,24>}
    box{<39,0,.5>,<41,30,2.5>}
    box{<39,0,.5>,<41,30,2.5> translate<26.5,0,0>}
    box{<39,0,.5>,<41,30,2.5> translate<26.5,0,21>}
    box{<39,0,.5>,<41,30,2.5> translate<0,0,21>}
      texture{
       pigment{color DarkWood }
      }

  scale 1/12
}


//======================< start of scene build >====================

object{weaponSign translate <-4.375,4,-10.19>}
object{detector translate<0,0,-10>}
object{detectorTable translate<0,0,-10>}
object{tray scale .5 rotate<0,75,0> translate<4.5,31/12,-9> }

object{School rotate <0,0,0>}

//add school sidewalk
#declare Count = 0
#while (Count < 10)
  object{SideWalk translate<0,-3.8/12,-2-(4*Count)>}
  #declare Count=Count+1
#end

// add outside sidewalk
#declare Count = -40
#while (Count < 40)
  object{SideWalk rotate<0,90,0> translate<0+(4*Count),-4/12,-45.6667>}
  #declare Count=Count+1
#end


// ============== start build fence
object{frontFence translate<0, 0, 0>}
object{frontFence translate<-16.17, 0, 0>}

object{rightFence rotate<0,-90,0> translate<10.17,0,-10> }
object{rightFence rotate<0,-90,0> translate<10.17,0,-10+8.5> }
object{rightFence rotate<0,-90,0> translate<10.17,0,-10+17> }

object{leftFence rotate<0,-90,0> translate<-10.17,0,-10> }
object{leftFence rotate<0,-90,0> translate<-10.17,0,-10+8.5> }
object{leftFence rotate<0,-90,0> translate<-10.17,0,-10+17> }
object{rhFenceDoorAssy rotate<0,-135,0> translate<6,0,-10>}
object{lhFenceDoorAssy rotate<0,180,0> translate<-6,0,-10>}
// ============== end build fence


// ===================== start plant the grass
#declare X = 0
#while (X < 40)
  #declare Z = -12
  #while (Z <= 20)
    #declare yyRotate= rand(yy)
    #switch (yyRotate)
      #range (0,.25)
        #declare yRotate=0
      #break  //Third case ends
      #range (.26,.50)
        #declare yRotate= 90
      #break
      #range (.51,.75)
        #declare yRotate= 180
      #break
      #range (.76,1.0)
        #declare yRotate= 270
      #break
      #else
        #declare yRotate= 0
    #end
    #if (testing = True)
      object{QuickGrass scale 1/12 translate<5.667+.5+X,0,Z>}
      object{QuickGrass scale 1/12 translate<-5.667-.5+(X*-1),0,Z>}
    #else
      object{rSquareOfGrass texture { pigment{color rgb <0,.8,.25>*.35 } finish{Dull}}  scale <1/24,1/12,1/24> rotate<0,yRotate,0> translate<5.667+.5+X,0,Z>}
      object{SquareOfGrass texture { pigment{color rgb <0,.75,.35>*.7 } finish{Dull}}   scale 1/8 rotate<0,yRotate,0> translate<-5.667-.75+(X*-1.5),-.2,Z*(1.5)>}
    #end
    #declare Z=Z+1
  #end
  #declare X=X+1
#end
// ===================== start plant the grass

/*

// slightly modified cloud texture by Jussi Kantola
#declare CloudColors =
color_map{
  [0.0 0.4 color SkyBlue*.8 color SkyBlue*.8]
  [0.70 color rgb <4/5, 4/5, 5/6>]
  [1.0 color White]
}
*/


// slightly modified cloud texture by Jussi Kantola
#declare CloudTexture = texture {
   pigment{
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map{
        [0.0 0.4 color SkyBlue*.8 color SkyBlue*.8]
        [0.70 color rgb <4/5, 4/5, 5/6>]
        [1.0 color White]
      }
   }
   finish {Luminous}
   scale 1/12
}


#if (testing < True)
  sphere {<0, 0, 0>, 1
    texture { CloudTexture }
    scale <23000, 2300, 23000>
    rotate<-11,0,0>
  }
#end
