#declare wooden_part_of_bucket = 
difference {
   union {
      #declare B = 0
      #while (B < 360)
         object { board 
            texture { pigment { P_WoodGrain2A color_map { M_Wood1A }} 
               rotate <1,90,0>
               translate <B,0,B>
               scale .2
            }
            translate <1,0,0>
            rotate <0,0,80>
            translate <1,0,0>
            rotate <0,B,0>
         }
         #declare B = B + 16
      #end // while
      cylinder { <0,-.4,0> <0,-.3,0> .4 
         texture { pigment { P_WoodGrain2A color_map { M_Wood1A }} }
      }
   }
   cylinder { <-5,2,0> <5,2,0> .1 }
}


#declare metal_part_of_bucket =
difference {
   union {
      cylinder { <0,.2,0> <0,.4,0> 1.14}
      cylinder { <0,1.6,0> <0,1.8,0> 1.4}
   }
   cone { <0,0,0> 1 <0,2,0> 1.3}
   pigment { Gold }
   finish {Shiny }
}
#declare rope_ring =
   torus {.04,.017 
      rotate <0,75,0>
}

#declare rope =
union {
   #declare Z=0
   #while (Z < 180)
      object { rope_ring
         rotate <0,0,Z>
         translate <1,0,0>
         rotate <0,Z,0>
      }
      #declare Z=Z+4
   #end // while
   torus { .04,.03  
      rotate <0,0,90>
      translate <.8,0,0>
   }
   torus { .04,.03
      rotate <0,0,90>
      translate <-.8,0,0>
   }
   cylinder { <.8,0,0> <.6,-.2,-.1> .03 }
   cylinder { <-.8,0,0> <-.6,-.2,-.1> .03 }
   pigment {
      gradient y
      color_map {
         [0.0 Yellow]
         [0.1 Tan]
         [0.4 Brown]
         [1.0 DarkBrown]
      }
   }
}

// #declare bucket =
union {
   difference {
      object { wooden_part_of_bucket }
      object { metal_part_of_bucket
         scale 1.02
      }
   }
   object { rope
      scale 1.5
      translate <0,2,0>
   }
   object { metal_part_of_bucket }
   rotate <0,45,0>
   scale .5
   translate <-6,-1,-3>
}

#declare hair = difference {
   torus { 1, .1
      rotate <90,90,0>
      translate <0,0,1>
   }
   union {
      box {<-4,-4,-4> <4,0,4> }
      box {<-4,-4,1> <4,4,4> }
   }
}

#declare row = union {
   object { hair translate <0,1.24,0> }
   object { hair translate <-.2,1.24,0>
      rotate <0,-20,0>
   }
   object { hair translate <.2,1.24,0>
      rotate <0,20,0>
   }
   object { hair translate <-.4,1.24,0>
      rotate <0,-50,0>
   }
   object { hair translate <.4,1.24,0>
      rotate <0,50,0>
   }
}

#declare ROW_TRANS =.5

#declare rows = union {
   object { row translate z*ROW_TRANS }
   object { row translate z*2*ROW_TRANS }
   object { row translate z*3*ROW_TRANS }
   object { row translate z*4*ROW_TRANS }
   object { row translate z*5*ROW_TRANS }
   object { row }
   object { row rotate y*180 }
   object { row rotate y*180
      translate z*-1*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-2*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-3*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-4*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-5*ROW_TRANS
   }
   pigment { Gold }
   finish { Shiny }
   scale .1
}

#declare rows2 =
union {
   #declare F = 0
   #while (F < .5)
      object {rows translate <-F*2,0,0>}
      #declare F=F+.1
   #end // while F
}

#declare brush_handle =
union {
   box { <-.5,0,-.25> <.5,.1,.25> }
   cylinder { <-.5,.05,-.25> <-.5,.05,.25> .07 }
   cylinder { <.5,.05,-.25> <.5,.05,.25> .07 }
   texture { pigment { P_WoodGrain2A color_map { M_Wood1A }} 
      rotate <0,90,0>
   }
}

// #declare brush =
union {
   object { rows2 translate <.5,0,0>}
   object { brush_handle }
   translate <-3,-0.98,-3>
}

#declare mop_handle =
union {
   cylinder { <0,0,0><0,4,0> .05}
   sphere {<0,4,0> .05}
   texture { pigment { P_WoodGrain2A color_map { M_Wood1A }}
      rotate <90,0,0>
   }
}

// #declare mop = 
union {
   object { mop_handle }
   blob {
         threshold .65
         sphere { <0,-.5,0> .7 1}
         sphere { <0,-1.5,0> 2 1}
      pigment {
         gradient y
         color_map{[0.5 color Gray][0.5 color White]}
         scale .0002
      }
      scale .6
      translate <0,.8,0>
   }
   rotate <20,0,0>
   translate <-5,-1,-1.5>
}
