#!/usr/bin/perl
($outfile) = @ARGV;

open (OUTFILE, ">$outfile") || die "Could not open $outfile.\n";

$CENT="<0.5,3,-4>";
$NUM_RINGS=8;
$STRING_RAD=0.05;
$STRING_TEN=1;
# example with center <0,0,0>
#@points= ("<0,1,0>", "<.5,.5,0>", "<1,0,0>",
#          "<.5,-.5,0>", "<0,-1,0>", "<-.5,-.5,0>",
#          "<-1,0,0>", "<-.5,.5,0>");
# candle web(candweb.inc) with center <-10.3,8,6.5> moved <4,-2.5,-5.3>
#@points= ("<-11,8.5,7>","<-10,8.9,7>","<-9,8.6,7>","<-9.5,7.3,6.5>",
#          "<-9.8,7.02,6>", "<-10.5,7.3,6.5>","<-11,7.4,6.7>","<-11,8.2,6.8>");
#Forground web(forweb.inc) with center <.5,3,-4> remove last link
@points= ("<-1,6,-4>","<.6,7,-4>","<1.5,7,-4>","<3,7,-4>","<6,6,-4>",
          "<6,3.3,-4>", "<5,2,-4>", "<1,2,-4>");
#tstepweb with center <-10.3,10.1,6.5>
#@points=("<-10.3,12.5,7>","<-9.5,12,7>","<-9,7.6,7>","<-9.1,4.3,6.5>",
#         "<-9.8,4.02,6>", "<-11.5,4.3,4.5>","<-11,11.2,5.8>","<-11,13,6.4>");
#stepweb with center <6,8,6.5> translated <-1,0,0>
#@points=("<8,8.5,6.5>","<9,7.7,6.5>","<7.5,6.8,6.5>",
#         "<6.2,6.4,6.5>","<4.5,6.8,6.5>","<5,8.5,6.5>");
#grcnweb with center <-10.5,1,.1>
#@points=("<-10.5,4,.8>","<-9.5,3,.8>","<-8.8,2,.8>","<-8.3,.5,.8>",
#         "<-8.8,-1,-.4>","<-9.2,-1,-.4>","<-10.8,-1,-.4>","<-11,-1,-.4>",
#         "<-11,.5,-.8>","<-11,5.6,.0>","<-11,4.6,.8>");
#bencweb with center <2,.5,0> ## remove last link so its not a loop
# and translate <.1,-.5,-.5>
#@points=("<1.7,.1,0>","<1.7,.45,0>","<1.7,.8,0>","<1.7,1,0>",
#         "<2,1,0>", "<2.3,1,0>");

print OUTFILE "#declare CENT = $CENT\n";
print OUTFILE "#declare NUM_RINGS = $NUM_RINGS\n";
print OUTFILE "#declare STRING_RAD = $STRING_RAD\n";
print OUTFILE "#declare STRING_TEN = $STRING_TEN\n";

$i=0;
foreach (@points) {
   print OUTFILE "#declare P$i = $_\n";
   print OUTFILE "#declare D$i = (P$i - CENT ) / NUM_RINGS\n";
   $i++;
}
print OUTFILE "// #declare web =\nunion {\n";
print OUTFILE "   blob {\n";
print OUTFILE "      threshold .65\n";
$i2=0;
while ($i2 < $i) {
   print OUTFILE "      cylinder { CENT P$i2 STRING_RAD STRING_TEN }\n";
   $i2++;
}
print OUTFILE "   }\n";
print OUTFILE "   #declare Z = 1\n";
print OUTFILE "   #while ( Z < NUM_RINGS )\n";
$i2=0;
while ($i2 < $i) {
   print OUTFILE "      #declare V$i2=<CENT.x+D$i2.x*Z, CENT.y+D$i2.y*Z, CENT.z+D$i2.z*Z>\n";
   $i2++;
}  
# need to take care of last one also.
print OUTFILE "      blob {\n";
print OUTFILE "         threshold .65\n";
$i2=0;
$i--;
while ($i2 < $i) {
   print OUTFILE "         cylinder { V$i2 V";
   print OUTFILE $i2+1;
   print OUTFILE " STRING_RAD, STRING_TEN }\n";
   $i2++;
} 
print OUTFILE "         cylinder { V$i2 V0 STRING_RAD, STRING_TEN }\n";

print OUTFILE "      }\n";
print OUTFILE "      #declare Z=Z+1\n";
print OUTFILE "   #end // while\n";
print OUTFILE "   pigment { White }\n";
print OUTFILE "   finish { Shiny }\n";
print OUTFILE "}";
