#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
//  max_trace_level 20
  number_of_waves 10
/*
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
*/
}

background { color SeaGreen }
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
light_source{ <0, 50, 10> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}

#include "fish6.pov"

#end

#debug "Anim.pov.\n"
#include "fish7.pov"

#declare Stones1 =
  texture { pigment { colour red 0.96 green 0.80 blue 0.69 }           }
  texture { pigment { bozo turbulence 0.5
            color_map { [ 0  colour rgb <0.7,0.5,0.3> ]
                        [ 0.15  colour rgbt 1 ]
                        [ 0.85  colour rgbt 1 ]
                        [ 1.00  colour rgb <0.7,0.5,0.3> ] }
                             scale 0.01 }
            finish { ambient .66 diffuse .7 specular 0.009 roughness 0.5 crand .5 }
            normal { bozo 0.5 scale <0.02,0.02,50> }
}

#declare Stones2 =
  texture { pigment { DkGreenCopper  }           }
  texture { pigment { bozo turbulence 0.5
            color_map { [ 0  colour rgb <0.7,0.5,0.3> ]
                        [ 0.15  colour rgbt 1 ]
                        [ 0.85  colour rgbt 1 ]
                        [ 1.00  colour rgb <0.7,0.5,0.3> ] }
                             scale 0.01 }
            finish {  ambient .65 diffuse .6 specular 0.009 roughness 0.5 crand .5 }
            normal { bozo 0.5 scale <0.02,0.02,50> }
}


#declare Ane =
blob { threshold 0.6
#declare A = <0, 0, 0>
sphere { A, .25, 1
}

#declare X = 0 #while (X <= 360)
#declare Y = 0 #while (Y <= 360)
#declare Z = 0 #while (Z <= 360)
 cylinder { A, vrotate (< 0, 2.45, 0 >,< X, Y, Z>), .01, 1
 }

#declare Z = Z + 40 #end
#declare Y = Y + 40 #end
#declare X = X + 40 #end
sturm
scale .1
translate < 1, 0, 1>
}

#declare St1 = superellipsoid{ <0.5, 1.0> texture { Stones1 } scale .5}
#declare St2 = superellipsoid{ <0.5, 1.0> texture { Stones2 } scale .4}

#declare Piga =
  pigment { bumps
  color_map {
    [0.3 color Tan]
    [0.7 color Mica]
    }
scale .01
}
#declare Pigb =
  pigment { bumps
  color_map {
    [0.3 color OrangeRed ]
    [0.7 color Tan]
    }
scale .01
}

#declare StarTex =
texture { gradient x
   texture_map {
     [ 0.4 pigment {Piga} ]
     [ 0.7 pigment {Pigb} ]
     }
  scale .1
  }

#declare StarFish =
blob
{
  threshold 0.6
  sphere { < 0, 0, 0>, 1, 1  // body center
  texture { pigment { color Coral}}
    scale < .75, .75, .20>
      translate < 1.2, .05, 0>
  }

  #declare X=25 #while ( X <=90 )
    cylinder { <.7,.88,0>, < 0,0,0>, .25, 1
    texture { StarTex }
      rotate < 0, 0, X * -.5 >
      rotate < 180, 0, 0 >
      translate < 0, .5, 0>
    }
    cylinder { <.7,1,0>, <0,0,0>, .25, 1
    texture { StarTex }
      rotate < 0, 0, X * -.5>
      rotate < 0,0, 32 >
      translate < .35, -1.1, 0>
    }

    cylinder { <.7,.88,0>, < 0,0,0>, .25, 1
    texture { StarTex }
      rotate < 0, 0, X * -.5 >
      rotate < 180, 0, 0 >
      rotate < 0,0, 144 >
      translate < 2, -1, 0>
    }

    cylinder { <.7,.88,0>, < 0,0,0>, .25, 1
    texture { StarTex }
      rotate < 0, 0, X * -.5 >
      rotate < 180, 0, 0 >
      rotate < 0,0, 216 >
      translate < 2.5, .4, 0>
    }

    cylinder { <.7,.88,0>, < 0,0,0>, .25, 1
    texture { StarTex }
      rotate < 0, 0, X * -.5 >
      rotate < 180, 0, 0 >
      rotate < 0,0, 288 >
      translate < 1.25, 1.35, 0>
    }

  #declare X=X+25 #end
pigment { color Clear}


  finish { diffuse 0.800  ambient 0.900
          specular 0.800
          roughness 0.100
          crand .5
          phong 0.9
          phong_size 60
          metallic
          }
  scale < 1, 1, .5 >
  scale .1
}
#declare AneFin =
  finish {
          diffuse 0.600
          ambient 0.300
          specular 0.800
          roughness 0.500
          crand .6
          phong 0.9
          phong_size .6
          metallic
          }

#declare Ane1 =
object {
Ane
texture { pigment { color Tan}}
finish { AneFin }
}
#declare Ane2 =
object {
Ane
texture { pigment { color MediumGoldenrod }}
finish {  AneFin  }
}
#declare Ane3 =
object {
Ane
texture { pigment { color Thistle }}
finish {  AneFin  }
}
#declare Ane4 =
object {
Ane
texture { pigment { color Flesh }}
finish {  AneFin  }
}
#declare Ane5 =
object {
Ane
texture { pigment { color BrightGold }}
finish {  AneFin  }
}
#declare Ane6 =
object {
Ane
texture { pigment { color Wheat}}
finish {  AneFin  }
}

#declare Agroup =
union {
object { Ane1   translate < 1.25, .95, -1.05> }
object { Ane2   translate < 1.50, .95, -1.09> }
object { Ane3   translate < 1.75, .95, -1.13> }
object { Ane4   translate < 1.35, .95, -1.07> }
object { Ane5   translate < 1.60, .95, -1.11> }
object { Ane6   translate < 1.85, .95, -1.18> }
object { Fish7     rotate <0, 15, 0> translate < 2.25, 1.38, -.05>}
object { Fish7     rotate <0, 45, 0> translate < 2.52, 1.22, -.08>}
object { Fish7     rotate <0, 95, 0> translate < 2.62, 1.39, -.15>}
object { Fish7     rotate <15, 15, 15> translate < 2.42, 0.49, -.25>}
object { Fish7     rotate <45, 50, -30> translate < 2.22, 0.49, .15>}
translate <-.5,0,-1.5>
}


#declare Bwall =
union{
  #declare Z = -1 #while ( Z <= 6)
    object { St1 translate < 2, 0, Z> }   //light
    object { St2 translate < 1.5, 0, Z + 1> }
    object { St1 translate < 2.5, .5, Z+1> }
    object { St2 translate < 2, .5, Z > }
    object { St1 translate < 3, 1, Z + 2> }
    object { St2 translate < 2.5, 1, Z +2> }
    object { Ane1   translate < 1.3, 1.3, Z+1.3>}
    object { Ane2   translate < 1.5, 1.4, Z+1.4>}
    object { Ane3   translate < 1.7, 1.5, Z+1.5>}
    object { Ane4   translate < 1.9, 1.4, Z+1.4>}
    object { Ane5   translate < 2.1, 1.3, Z+1.3>}
    object { Fish7     translate < 2.4, 1.5, Z+1.3>}

    object { Ane1   translate < 1.4, 1.3, Z+1.5>}
    object { Ane2   translate < 1.6, 1.4, Z+1.6>}
    object { Ane3   translate < 1.8, 1.5, Z+1.7>}
    object { Ane4   translate < 2.0, 1.4, Z+1.6>}
    object { Ane5   translate < 2.2, 1.3, Z+1.5>}
    object { Fish7     rotate <15, 15, 0> translate < 2.7, 1.6, Z-1>}

    object { Ane1   translate < 1.2, 1.1, Z+1.7>}
    object { Ane2   translate < 1.4, 1.2, Z+1.8>}
    object { Ane3   translate < 1.6, 1.3, Z+1.9>}
    object { Ane4   translate < 1.8, 1.2, Z+1.8>}
    object { Ane5   translate < 2.0, 1.1, Z+1.7>}
    object { Fish7     rotate <15, 0, 0> translate < 2.6, 1.5, Z+1.9>}
  #declare Z= Z+2 #end

 object { St1 translate < .5, 0, 2> }
 object { St2 translate < 0, 0, 2> }

 object { St1 rotate < 0, 0, 25> translate < .75, -.2, 1> }
 object { St2 rotate < 0, 0, 25> translate < .25, -.2, 1> }

 object { St1 rotate < 0, 0, 25> translate < -.5, -.2, -1> }
 object { St2 rotate < 0, 0, 25> translate <   0, -.2, -1> }

 object { St2 rotate < 0, 30, 25> translate < -3.25, -.2, -1> }
 object { St1 rotate < 0, 30, 25> translate <  -2.75, -.2, -1> }

 object { St2 rotate < 0, 0, 25> translate < -3.25, -.2, 2> }
 object { St1 rotate < 0, 0, 25> translate < -2.75, -.2, 2> }

object { StarFish rotate < 30, -20, -20 > translate < .35, .5, -2.0> }
object { StarFish rotate < 160, -60, 110 > translate < 2.05, .8, -1.3> }

object { Ane2   translate < .1, .3, 0>}
object { Ane3   translate < .2, .3, -.5>}
object { Ane4   translate < .3, .3, -1>}
object { Ane3   translate < .5, .3, -1.5>}
object { Ane5   translate < .6, .3, -1.9>}
object { Ane2   translate < .7, .3, -2.0>}


object { Ane6   translate < 0.70, .3, -2.2>}
object { Ane2   translate < 0.90, .3, -2.3>}
object { Ane6   translate < 1.00, .3, -2.3>}
object { Ane5   translate < 1.10, .3, -2.3>}
object { Ane1   translate < 1.20, .3, -2.3>}
object { Ane2   translate < 1.45, .3, -1.7>}
object { Ane4   translate < 1.5, .3, -1.5>}

object { Agroup rotate < 0, 0, 0 >      translate <  .3, -.1,  1.7>}
object { Agroup rotate < 0, 0, 0 >      translate <  .4, -.1,   1.0>}

object { St1  rotate < -45, -45, 0 > translate < 2.6, .3, -1.1> }

//object { Agroup rotate < -10, 40, 0 >   translate < 2.1,  .0,  1.6>}
//object { Agroup rotate < -10, 40, 0 >   translate < 1.9,  .0,  2.2>}
//object { Agroup rotate < 10, -90, -40 > translate <  .4,  .0, -2.5>}

rotate < 0, 40, 0 >
translate < 1, -1, -1 >
}
#declare Erocks =
union {
 object { St2 rotate < 0, 0, 25> translate < -3.25, 1, 2> }
 object { St1 rotate < 0, 0, 25> translate < -2.75, 1, 2> }
}

object { Bwall }

object { Bwall rotate < 0, 120, 0 > translate < 1, -1, 5 >}
object { Erocks rotate <50, 10, 30 > translate < -1.1, 1.5, -1.2> }
object { Erocks rotate <50, 10, 30 > translate < -1.5, 1.5, -1.2> }
object { Erocks rotate <0, 60, 0 > translate < -1.1, -1.6, -6.5> }
object { Erocks rotate <0, 60, 0 > translate < -.6, -1.9, -6.9> }

//object { Fish7     rotate <15, 0, 0> translate < .2, -.18, -4.0>}
//object { Anemone   translate < -.1, 2, 1>}
//object { StarFish scale 3 rotate < 30, -20, -20 > translate < .35, 2, -2.9> }



