
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare ABCDE = 0


global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.6
    minimum_reuse    0.010
    nearest_count    9
    recursion_limit  2
  }
}
background { color SeaGreen }
light_source{ <1, 50, 10> color White }
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}

#include "water.pov"
#include "kelp.pov"
#include "kelp2.pov"
#include "anim.pov"
#include "shells.pov"
#include "fish1.pov"
#include "fish2.pov"
#include "fish3.pov"
#include "fish4.pov"
#include "fish5.pov"
#include "fish6.pov"


