#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#end

#debug "Fish2.pov.\n"


#declare fish2Tex =
   texture {
     pigment {
       marble
       color_map {
         [ 0.0  color Mica ]
         [ 0.1  color DarkTurquoise ]
         [ 0.3  color Yellow ]
         [ 0.7  color Blue ]
         [ 0.9  color Yellow ]
         [ 1.0  color Turquoise ]
       }
     }
     scale .5
}
#declare Fish2 =
blob
{
  threshold 0.6
  sphere { < .3, 0, 0>, .25, 1
    scale < 1, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1
    scale < 1, .75, .25>
  }
  #declare X=165 #while ( X <=195 )
    cylinder { <.25,0,0>, <.75,0,0>, .01, 1
      rotate < 0, 0, X >
      texture { pigment{color Yellow}}
    }
  #declare X=X+2 #end

  #declare X=165 #while ( X <=195 )
    cylinder { <0,.28,0>, <.7,.3,0>, .01, 1
      rotate < 0, 0, X >
      translate < .25, 0, 0>
    }
    cylinder { <0,.28,0>, <.7,.3,0>, .01, 1
      rotate < 0, 0, X >
      translate < .25, 0, 0>
      rotate < 180, 0, 0 >
    }
  #declare X=X+2 #end

  texture { fish2Tex }
  finish { diffuse 0.800  ambient 0.600    }
  scale .5
}

#declare SFish2=
union {
	#declare CNT=0
	#declare SF2=seed(2)
	#while (CNT< 25)
		#declare X2=(rand(SF2)*6)
		object {
			Fish2
			rotate <0,-X2,0>
			translate <(0-X2),(rand(SF2)*3),(rand(SF2)*2)>
			rotate <0,(-3*X2),0>
		}
		#declare CNT=CNT+1
	#end
}

object { SFish2 rotate < 0, 0, 30 > scale .4 translate < 4, 2, -3 >}

