#ifndef (ABCDE)
#declare ABCDE = 0

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}

background { color SeaGreen }
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#include "fish1.pov"
#end

#debug "Kelp.pov.\n"

#declare K3 = sphere { < -1, -1, -1 >, 1
   scale < .05, 20, .1 >
   translate < 0, 25, 250>}

#declare R2 = seed(0)
#declare Kelp =
union{
 #declare X = -125  #while (X<= 250)
   #declare Z = -100 #while (Z<=100)
      #declare X2 = X/2 + ( (rand(R2)*10 ))
//      #declare Y2 = 5 + ( (rand(R2)*5 ))
      #declare Z2 = (Z/3) + ( (rand(R2)*2 ) )
       object {K3 translate <X2, 0, Z2>   }
   #declare Z=Z+25 #end
   #declare X=X+16 #end
   texture { pigment { color DarkGreen }}
//   scale .5
}





object { Kelp  translate < -25, 0, -200> }


