#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}

plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#include "kelp.pov"
#include "fish1.pov"
#include "shells.pov"
#include "anim.inc"
#end

#debug "kelp2.pov.\n"

#declare Klp2Tex =
   texture {
     pigment {
       gradient x
       color_map {
         [ 0.000  color DarkGreen ]
         [ 1.000  color DarkOliveGreen ]
       }
     }
     finish { diffuse 0.600  ambient 0.800  specular 0.0100  roughness 0.100   }
scale 1
   }


#declare Klp2 =
blob
{
  threshold 0.6


  #declare X=0 #while ( X <=36 )
    cylinder { <-.25,0,0>, <.25,0,0>, .25, 1
      rotate < 0, X*10, 0 >
      translate < 0, X/4, 0 >
    }
  #declare X=X+1 #end

  sphere { < 0, X/4 , 0>, .5, 1
    scale < 1, 1, .25>
  }

  texture { Klp2Tex }
  scale <.1, 1, .04 >

}

#declare SKlp2  =
union {
	#declare X=0
	#declare SK5=seed(5)
	#while (X < 800)
		#declare X2= (X/25) + rand(SK5)
		object {
			Klp2
			translate <X2,(rand(SK5)*2),(rand(SK5)*5)>
            scale < .6, 1, .6>
		}
		#declare X=X+10
	#end

}

#declare SKlp3  =
union {
	#declare X=0
	#declare SK6=seed(6)
	#while (X < 8)
		#declare X2 = (X/3) + (rand(SK6))
		object {
			Klp2
			translate <X2,(rand(SK6)*2),(rand(SK6))>
		}
		#declare X=X+1
	#end
    scale .5
}


#declare FC =
blob {
cylinder { <0, .25, 0>, <0, .75, 0>, .1, 1 texture { pigment { color Brown}}}
cylinder { <0, .5, -.25>, <0, .5, .25>, .1, 1 texture { pigment { color Coral}}}
cylinder { <-.25, .5, 0>, <.25, .5, 0>, .1, 1 texture { pigment { color MediumWood }}}
sphere   { <0, .5, 0>, .35, 1.5 texture { pigment { color CoolCopper }}}
scale 6
translate < 0, -1, 250 >
}


#declare R3 = seed(30)
#declare R4 = seed(40)
#declare FarCoral =
union{
 #declare X = 40  #while (X<= 120)
   #declare Z = -10 #while (Z<=10)
      #declare RZ = rand(R3)
      #declare X2 = (X*2) + ( (RZ ))
      #declare Z2 = (Z*2) + ( (RZ*10 ) )
      #declare RD = rand(R4)
       object {FC  rotate < 0, 0, RD*300> translate <X2, 0, Z2> }
   #declare Z=Z+2 #end
   #declare X=X+3 #end
   pigment { color Clear}
scale .3
}

object { FarCoral scale .4 translate < -15, -1.2, -25>}

object { SKlp2 scale < 1, .45, 1 > translate < -6, -2, 4 >}
object { SKlp3 scale < 1, 0.35, 1 > translate < 0, -2,  -2.5 >}
object { SKlp3 scale < 1, 0.46, 1 > translate < .5, -2,  -1.5 >}
object { SKlp3 scale < 1.5, 0.59, 1 > translate < -1.5, -2,  1 >}
object { SKlp3 scale < 1.5, 0.59, 1 > translate < .5, -2,  .8 >}




