
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <-50,5, 0>
  direction 1.5*z
  right     4/3*x
  look_at   <0,8,0>
//  look_at   <-50,8,5>
//  aperture 5
//  focal_point <0,0,0>
//  blur_samples 50
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 0.5  // light's color
  translate <-30, 200, -150>
//  atmospheric_attenuation on
}

light_source
{
  0*x // light's position (translated below)
  color red 0.25  green 0.25  blue 0.75  // light's color
  translate <100, 200, -150>
//  atmospheric_attenuation on
}

light_source
{
  0*x // light's position (translated below)
  color red 0.15  green 0.25  blue 0.15  // light's color
  translate <20, -80, -40>
//  atmospheric_attenuation on
}


// ----------------------------------------

//#default{finish{phong 1.0}}
#declare fishpig=texture{pigment{gradient y color_map{[0.0 0.8 color Red color Orange][0.8 1.0 color Orange color White]} scale 10 translate y*5} finish{phong 1.0}}

#declare spike=object{
 #declare jnt_1=-4
 #declare jnt_2=jnt_1*2
 #declare jnt_3=jnt_2*2
 #declare jnt_4=jnt_3*2
 #declare apex_rad=0
 #declare base_rad=0.125
 #declare rad_3=(apex_rad+base_rad)/2
 #declare rad_2=(rad_3+base_rad)/2
 #declare rad_4=(rad_3+apex_rad)/2
 union{union{union{union{      cone{<0,0,0>,rad_4,<0,1,0>,apex_rad} sphere{<0,0,0>,rad_4}
  rotate z*jnt_4 translate y*1} cone{<0,0,0>,rad_3,<0,1,0>,rad_4} sphere{<0,0,0>,rad_3}
  rotate z*jnt_3 translate y*1} cone{<0,0,0>,rad_2,<0,1,0>,rad_3} sphere{<0,0,0>,rad_2}
  rotate z*jnt_2 translate y*1} cone{<0,0,0>,base_rad,<0,1,0>,rad_2} sphere{<0,0,0>,base_rad}
  rotate<0,0,jnt_1>
 }
}

#declare tail_spike_1=object{
 #declare jnt_1=60
 #declare jnt_2=10
 #declare jnt_3=15
 #declare jnt_4=15
 #declare apex_rad=0
 #declare base_rad=0.05
 #declare rad_3=(apex_rad+base_rad)/2
 #declare rad_2=(rad_3+base_rad)/2
 #declare rad_4=(rad_3+apex_rad)/2
 union{union{union{union{      cone{<0,0,0>,rad_4,<0,1,0>,apex_rad} sphere{<0,0,0>,rad_4}
  rotate z*jnt_4 translate y*1} cone{<0,0,0>,rad_3,<0,1,0>,rad_4} sphere{<0,0,0>,rad_3}
  rotate z*jnt_3 translate y*1} cone{<0,0,0>,rad_2,<0,1,0>,rad_3} sphere{<0,0,0>,rad_2}
  rotate z*jnt_2 translate y*1} cone{<0,0,0>,base_rad,<0,1,0>,rad_2} sphere{<0,0,0>,base_rad}
  rotate<0,0,jnt_1>
 }
}

#declare side_fin=object{
 union{
  #declare cur_rot=140
  #declare cur_scale=1
  #while(cur_rot>=90)
   object{spike scale<cur_scale,cur_scale,0.25> rotate<0,0,cur_rot>}
   #declare cur_rot=cur_rot-5
   #declare cur_scale=cur_scale*0.85
  #end
 }
}

#declare fin_comp=object{
 union{
  union{
   cylinder{<0,0,0>,<0,2,0>,0.15 pigment{Orange}}
   cone{<0,2,0>,0.15,<0,5,0>,0 pigment{Orange}}
   polygon{6,<0,4.5>,<-2,3>,<-2,0>,<0,0>,<0,2>,<0,4.5> pigment{White}}
   rotate z*30
   translate y*2
  }
  cylinder{<0,0,0>,<0,2,0>,0.15 pigment{Orange}}
  polygon{5,<0,0>,<-2,0>,<-2,2>,<0,2>,<0,0> pigment{White}}
  rotate z*10
 }
}

#declare back_fin=object{
 union{
  object{fin_comp scale 0.8}
  object{fin_comp scale 0.95 rotate z*5 translate<-1,0,0>}
  object{fin_comp scale 0.9 rotate z*11 translate<-2,0,0>}
  object{fin_comp scale 0.85 rotate z*17 translate<-3,0,0>}
  object{fin_comp scale 0.8 rotate z*23 translate<-4,0,0>}
  object{fin_comp scale 0.75 rotate z*29 translate<-5,0,0>}
  object{fin_comp scale 0.7 rotate z*35 translate<-6,0,0>}
  object{fin_comp scale 0.6 rotate z*41 translate<-7,0,0>}
  object{fin_comp scale 0.5 rotate z*47 translate<-8,0,0>}
  object{fin_comp scale 0.4 rotate z*53 translate<-9,0,0>}
  object{fin_comp scale 0.3 rotate z*59 translate<-10,0,0>}
 }
}

#declare spike_15=object{
 union{
  union{
   union{
    union{
     cone{<0,0,0>,0.01,<0,1,0>,0 rotate z*15 translate y*1}
     cone{<0,0,0>,0.01,<0,1,0>,0.01}
     rotate z*15
     translate y*1
    }
    cone{<0,0,0>,0.05,<0,1,0>,0.01}
    rotate z*15
    translate y*1
   }
   cylinder{<0,0,0>,<0,1,0>,0.05}
   rotate z*15
   translate y*1
  }
  cylinder{<0,0,0>,<0,1,0>,0.05}
  rotate z*15
 }
}

#declare spike_10=object{
 union{
  union{
   union{
    union{
     cone{<0,0,0>,0.01,<0,1,0>,0 rotate z*10 translate y*1}
     cone{<0,0,0>,0.01,<0,1,0>,0.01}
     rotate z*10
     translate y*1
    }
    cone{<0,0,0>,0.05,<0,1,0>,0.01}
    rotate z*10
    translate y*1
   }
   cylinder{<0,0,0>,<0,1,0>,0.05}
   rotate z*10
   translate y*1
  }
  cylinder{<0,0,0>,<0,1,0>,0.05}
  rotate z*10
 }
}

#declare spike_5=object{
 union{
  union{
   union{
    union{
     cone{<0,0,0>,0.01,<0,1,0>,0 rotate z*5 translate y*1}
     cone{<0,0,0>,0.01,<0,1,0>,0.01}
     rotate z*5
     translate y*1
    }
    cone{<0,0,0>,0.05,<0,1,0>,0.01}
    rotate z*5
    translate y*1
   }
   cylinder{<0,0,0>,<0,1,0>,0.05}
   rotate z*5
   translate y*1
  }
  cylinder{<0,0,0>,<0,1,0>,0.05}
  rotate z*5
 }
}

#declare spike_0=object{
 union{
  union{
   union{
    union{
     cone{<0,0,0>,0.01,<0,1,0>,0 rotate z*0 translate y*1}
     cone{<0,0,0>,0.01,<0,1,0>,0.01}
     rotate z*0
     translate y*1
    }
    cone{<0,0,0>,0.05,<0,1,0>,0.01}
    rotate z*0
    translate y*1
   }
   cylinder{<0,0,0>,<0,1,0>,0.05}
   rotate z*0
   translate y*1
  }
  cylinder{<0,0,0>,<0,1,0>,0.05}
  rotate z*0
 }
}

#declare spike_n5=object{
 union{
  union{
   union{
    union{
     cone{<0,0,0>,0.01,<0,1,0>,0 rotate z*-5 translate y*1}
     cone{<0,0,0>,0.01,<0,1,0>,0.01}
     rotate z*-5
     translate y*1
    }
    cone{<0,0,0>,0.05,<0,1,0>,0.01}
    rotate z*-5
    translate y*1
   }
   cylinder{<0,0,0>,<0,1,0>,0.05}
   rotate z*-5
   translate y*1
  }
  cylinder{<0,0,0>,<0,1,0>,0.05}
  rotate z*-5
 }
}

#declare pnt_1=0
#declare pnt_2=2
#declare pnt_3=3
#declare pnt_4=3.5
#declare pnt_5=4
#declare pnt_6=4.35
#declare pnt_7=4.65
#declare pnt_8=4.8
#declare pnt_9=4.9
#declare pnt_10=5
#declare pnt_11=4.95
#declare pnt_12=4.75
#declare pnt_13=4.5
#declare pnt_14=4.15
#declare pnt_15=3.9
#declare pnt_16=3.5
#declare pnt_17=3
#declare pnt_18=2.6
#declare pnt_19=2.15
#declare pnt_20=1.6
#declare pnt_21=1
#declare pnt_22=0

#declare fishy=object{
union{
  union{
   cone{<0,0,0>,pnt_1,<-1,0,0>,pnt_2}
   cone{<-1,0,0>,pnt_2,<-2,0,0>,pnt_3}
   cone{<-2,0,0>,pnt_3,<-3,0,0>,pnt_4}
   cone{<-3,0,0>,pnt_4,<-4,0,0>,pnt_5}
   cone{<-4,0,0>,pnt_5,<-5,0,0>,pnt_6}
   cone{<-5,0,0>,pnt_6,<-6,0,0>,pnt_7}
   cone{<-6,0,0>,pnt_7,<-7,0,0>,pnt_8}
   cone{<-7,0,0>,pnt_8,<-8,0,0>,pnt_9}
   cone{<-8,0,0>,pnt_9,<-9,0,0>,pnt_10}
   cylinder{<-9,0,0>,<-15,0,0>,pnt_10}
   cone{<-15,0,0>,pnt_10,<-16,0,0>,pnt_11}
   cone{<-16,0,0>,pnt_11,<-17,0,0>,pnt_12}
   cone{<-17,0,0>,pnt_12,<-18,0,0>,pnt_13}
   cone{<-18,0,0>,pnt_13,<-19,0,0>,pnt_14}
   cone{<-19,0,0>,pnt_14,<-20,0,0>,pnt_15}
   cone{<-20,0,0>,pnt_15,<-21,0,0>,pnt_16}
   cone{<-21,0,0>,pnt_16,<-22,0,0>,pnt_17}
   cone{<-22,0,0>,pnt_17,<-23,0,0>,pnt_18}
   cone{<-23,0,0>,pnt_18,<-24,0,0>,pnt_19}
   cone{<-24,0,0>,pnt_19,<-30,0,0>,pnt_20}
   sphere{<-15,0,0>,pnt_20 scale<2,1,1>}
   torus{2.5, 1.75 rotate x*90  translate x*-20}
   torus{1.5, 0.5 rotate z*45 translate<-1.5,-1,0>}
   torus{1.5, 0.5 rotate z*45 translate<-1.5,-2,0>}
   sphere{<-2.5,-1,0>,2 scale<1,0.35,1> rotate z*45}
   union{
    object{tail_spike_1 scale 5 rotate x*0 translate<-30,1.5,0>}
    object{tail_spike_1 scale 5 rotate x*180 translate<-30,-1.5,0>}
    object{tail_spike_1 scale 4 rotate x*0 translate<-31,1.25,0>}
    object{tail_spike_1 scale 4 rotate x*180 translate<-31,-1.25,0>}
    object{tail_spike_1 scale 3 rotate x*0 translate<-32,1,0>}
    object{tail_spike_1 scale 3 rotate x*180 translate<-32,-1,0>}
    object{tail_spike_1 scale 2 rotate x*0 translate<-33,0.75,0>}
    object{tail_spike_1 scale 2 rotate x*180 translate<-33,-0.75,0>}
    pigment{gradient x color_map{[0.0 1.0 color Orange color Red]} scale 20 translate x*-10}
   }
   scale<1.5,1,0.5>
   texture{fishpig}
   }
 cylinder{<-4.5,1,pnt_6/2>,<-4.5,1,-pnt_6/2>,1.75 texture{fishpig}}
 sphere{<-4.5,1,pnt_6/2>,1.75 scale<1,1,0.8> texture{pigment{gradient z color_map{
[0.0 0.7 color Orange color Red]
[0.7 1.0 color Black color Black]} scale 1.75}}}
 sphere{<-4.5,1,-pnt_6/2>,1.75 scale<1,1,0.8> texture{pigment{gradient z color_map{
[0.0 0.65 color Orange color Red]
[0.65 1.0 color Black color Black]} scale 1.75}}}
 object{back_fin scale 1.5 translate<-10.75,4.25,0> pigment{Orange}}
 union{
  object{spike_15 rotate z*10 scale 5 translate<-28,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-29,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-30,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-31,1,0>}
  object{spike_5 rotate z*26 scale 3 translate<-32,1,0>}
  object{spike_5 rotate z*26 scale 3 translate<-33,1,0>}
  object{spike_0 rotate z*34 scale 2 translate<-34,1,0>}
  object{spike_0 rotate z*34 scale 2 translate<-35,1,0>}
  object{spike_n5 rotate z*40 scale 1 translate<-36,1,0>}
  object{spike_n5 rotate z*38 scale 0.8 translate<-37,1,0>}
  pigment{gradient y color_map{[0.0 1.0 color Orange color Red]} scale 15.5}
 }
  union{
  object{spike_15 rotate z*10 scale 5 translate<-28,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-29,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-30,1,0>}
  object{spike_10 rotate z*18 scale 4 translate<-31,1,0>}
  object{spike_5 rotate z*26 scale 3 translate<-32,1,0>}
  object{spike_5 rotate z*26 scale 3 translate<-33,1,0>}
  object{spike_0 rotate z*34 scale 2 translate<-34,1,0>}
  object{spike_0 rotate z*34 scale 2 translate<-35,1,0>}
  object{spike_n5 rotate z*40 scale 1 translate<-36,1,0>}
  object{spike_n5 rotate z*38 scale 0.8 translate<-37,1,0>}
  pigment{gradient y color_map{[0.0 1.0 color Orange color Red]} scale 15.5}
  scale 0.75
  rotate x*180
  translate x*-8
 }
 object{side_fin scale 2.85 rotate<45,-45,0> translate<-10,-2,-2.5> pigment{gradient y color_map{[0.0 1.0 color Orange color Red]} scale 5.5}}
 object{side_fin scale 2.85 rotate<-45,45,0> translate<-10,-2,2.5> pigment{gradient y color_map{[0.0 1.0 color Orange color Red]} scale 5.5}}
}
}
