/*
an octelipps consists of 8 ellips-parts scaled diffently
on the positive and negative sides of the three axis.

you must have the following declarations in your scene file 
   #declare posx = 2
   #declare negx = 1.35
   #declare posy = 1
   #declare negy = 0.5
   #declare posz = 1.25
   #declare negz = 0.4

to use this generic include put the following in you scene file :
   
   object
   {
      #include "octelips.inc"
      texture {...}
   }
   
*/

// ----------------- generic include part -------------------------

union
{
   intersection
   {
      sphere {<0,0,0> 1}
      box {<0,0,0> <1,1,1>}
      scale <posx,posy,posz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<-1,0,0> <0,1,1>}
      scale <negx,posy,posz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<0,-1,0> <1,0,1>}
      scale <posx,negy,posz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<-1,-1,0> <0,0,1>}
      scale <negx,negy,posz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<0,0,-1> <1,1,0>}
      scale <posx,posy,negz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<-1,0,-1> <0,1,0>}
      scale <negx,posy,negz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<0,-1,-1> <1,0,0>}
      scale <posx,negy,negz>
   }
   intersection
   {
      sphere {<0,0,0> 1}
      box {<-1,-1,-1> <0,0,0>}
      scale <negx,negy,negz>
   }
}

