#version 3.0
global_settings { 
   assumed_gamma 2.2 
   max_trace_level 12
}

#include "colors.inc"
// #include "textures.inc"

#declare cm = 1
#declare m = 100
#declare km = 1000 * m
#declare TRUE = 1
#declare FALSE = 0

#include "brain.inc"
#include "table.inc"
#include "blackb.inc"
#include "can.inc"
#include "tl.inc"

// room cam
/*
#declare CameraPos = <-300, 175, -500>      
camera {  
   location CameraPos
   direction <0, 0,  1.3>
   look_at <400,0,600>
}
*/

// STUDENT CAM                            
#declare CameraPos = <385, 130, 35>
camera {               
   location CameraPos
   direction <0, 0,  1.3>
   look_at <-300,60,600>
}


// ---------------------------------------------------------------------
// --------------------------- lighting --------------------------------
// ---------------------------------------------------------------------


// ----- inside (invisible) lights ----
/*
object {light_source {<-200, 240, -300> color rgb 0.25}}
object {light_source {<200, 240, -300> color rgb 0.25}}
object {light_source {<-200, 240, 300> color rgb 0.25}}
object {light_source {<200, 240, 300> color rgb 0.25}}
*/

// ------------- window lights:high Q ---------------
/*
object { 
   light_source 
   {
      <400,160,250> 
      color rgb 0.45
      area_light <0,60,0>, <0,0,80>, 2, 2
   }
}
object { 
   light_source 
   {
      <400,160,-250> 
      color rgb 0.45
      area_light <0,60,0>, <0,0,80>, 2, 2
   }
}
object { 
   light_source 
   {
      <-400,160,250> 
      color rgb 0.45
      area_light <0,60,0>, <0,0,80>, 2, 2
   }
}
object { 
   light_source 
   {
      <-400,160,-250> 
      color rgb 0.45
      area_light <0,60,0>, <0,0,80>, 2, 2
   }
}
*/

// ----------------- window lights : low Q ---------------
object {light_source { <-400,160,-250> color rgb 0.35 }}
object {light_source { <400,160,-250> color rgb 0.35 }}
object {light_source { <-400,160,250> color rgb 0.35 }}
object {light_source { <400,160,250> color rgb 0.35 }}

// --------- sun -----------
object {light_source {<-1000*km,2000*km,-1000*km> color White}}

// ---------------------------------------------------------------------
// --------------------------- textures --------------------------------
// ---------------------------------------------------------------------

#declare WindowWood = texture
{
   pigment {
      wood
      turbulence 0.1
      ramp_wave
      color_map
      {
         [0 color rgb<0.6,0.5,0.1>]
         [0.5 color rgb<0.5,0.4,0.1>]
         [0.5 color rgb<0.7,0.6,0.1>]
         [0.6 color rgb<0.5,0.4,0.1>]
         [0.8 color rgb<0.6,0.5,0.1>]
         [0.9 color rgb<0.4,0.2,0>]
         [1.0 color rgb<0.6,0.5,0>]
      }
      scale 5
      rotate <0,12,0>
      rotate <0,0,45>
   }
   finish {
      ambient 0.15
      diffuse 0.7
      brilliance 0.5
   }
}

#declare Brick1 = texture
{
   pigment {color rgb <0.7,0,0>}
   normal {bumps 0.3 scale 2}
   finish {ambient 0.1 diffuse 0.8}
}

#declare Mortar1 = texture
{
   pigment {color rgb <0.7,0.7,0.7>}
   normal {bumps 0.6 scale 0.05}
   finish {ambient 0.1 diffuse 0.8}
}

#declare BrickWall = texture
{                    
   brick texture {Mortar1}, texture {Brick1}
   brick_size <20,8,10>
   mortar 1

   // pigment {color rgb <0.7,0,0>}
}

#declare FloorTexture = texture
{
   pigment
   {
      spotted
      turbulence 0.5
      color_map {
         [0.0 color rgb<0.7,0.7,0.7>]
         [0.2 color rgb<0.5,0.5,0.45>]
         [0.5 color rgb<0.6,0.6,0.6>]
         [0.7 color rgb<0.5,0.45,0.45>]
         [0.9 color rgb<0.7,0.7,0.65>]
         [1.0 color rgb<0.6,0.55,0.55>]
      }
      scale 22
   }
   finish
   {
      ambient 0.2
      diffuse 1
      brilliance 0.7
   }
}

// ---------------------------------------------------------------------
// --------------------------- room ------------------------------------
// ---------------------------------------------------------------------


/* -------------  SCHOOLROOM -------------
   numbers : <-400,0,-600> - <400,300,600>
*/

#declare WindowCut = object
{
   box {<-100,0,-125> <100,140,125>}
}

#declare WindowBorder = object
{
   difference
   {
      box {<-5,-5,-130> <5,145,130>}
      box {<-100,5,-120> <100,135,120>}
   }
   texture {WindowWood}
}

#declare Nwall = object
{
   box {<-410,0,600> <410,300,610>}
   texture {BrickWall rotate <0,0,0>}
}

#declare Swall = object
{
   box {<-410,0,-600> <410,300,-610>}
   texture {BrickWall rotate <0,0,0>}
}

#declare Ewall = object
{
   difference
   {
      box {<400,0,-610> <410,300,610>}
      object {WindowCut translate <400,90,250>}
      object {WindowCut translate <400,90,-250>}
   }
   texture {BrickWall rotate <0,90,0>}
}

#declare Wwall = object
{
   difference
   {
      box {<-400,0,-610> <-410,300,610>}
      object {WindowCut translate <-400,90,250>}
      object {WindowCut translate <-400,90,-250>}
   }
   texture {BrickWall rotate <0,90,0>}
}

#declare Floor = object
{
   box {<-400,0,-600> <400,10,600>}
   texture {FloorTexture}
}

#declare Ceiling = object
{
   box {<-400,300,-600> <400,310,600>}
   pigment {color White}
}

object
{
   union
   {
      object {Nwall}
      object {Swall}
      object {Ewall}
      object {Wwall}
      object {Floor}
      object {Ceiling}
      object {WindowBorder translate <400,90,250>}
      object {WindowBorder translate <400,90,-250>}
      object {WindowBorder translate <-400,90,250>}
      object {WindowBorder translate <-400,90,-250>}
   }
}

// -----------------------------------------------------
// -------------------- float a brain ------------------
// -----------------------------------------------------

#declare Stream1 = seed(0);

#declare RowCount = -1
#while (RowCount < 2)

   #declare PairCount = 0
   #while (PairCount < 5)

      #declare TableCount = -1;
      #while (TableCount < 2)
         #declare xpos = (RowCount * 280) + (TableCount * 51.5)
         #declare ypos = 80 + 30
         #declare zpos = 300 - (PairCount * 175)

         #declare xangle = rand(Stream1) * 12 - 6;

         #declare yangle = -degrees(atan2(CameraPos.z - zpos, CameraPos.x - xpos))
         
         #declare zangle = rand(Stream1) * 30 - 15
     
         object { BrainCritter 
            rotate <xangle,0,0>
            rotate <0,0,zangle>
            rotate <0,yangle,0>
            translate <xpos,ypos,zpos>
         }

         #declare TableCount = TableCount + 2
      #end

      #declare PairCount = PairCount + 1;
   #end
   #declare RowCount = RowCount + 1;

#end


// ---------------------------------------------------------
// ----------------------- tables ---------------------------
// ---------------------------------------------------------

#declare Pair = object
{
   union
   {
      object {Table translate <51.5,10,0>}
      object {Canister translate <51.5, 85, 0>}
      object {Table translate <-51.5,10,0>}
      object {Canister translate <-51.5, 85, 0>}
   }
}

#declare Row = object
{
   union
   {
      object {Pair translate <0,0,0>} 
      object {Pair translate <0,0,-175>} 
      object {Pair translate <0,0,-350>} 
      object {Pair translate <0,0,-525>} 
      object {Pair translate <0,0,-700>} 
   }
   translate <0,0,300>
}

#declare AllTables = object
{
   union
   {
      object {Row translate <-280,0,0>}
      object {Row translate <-0,0,0>}
      object {Row translate <280,0,0>}
   }
}

object {AllTables}

// ---------------------------------------------------------
// ---------------------- blackboard -----------------------
// ---------------------------------------------------------

object {BlackBoard translate <0,170,560>}
   
// ---------------------------------------------------------
// ---------------------- TL tubes -------------------------
// ---------------------------------------------------------

#declare TL_quad = object
{
   union
   {
      object { TL_Light rotate <0,90,0> translate <-4.5,300,-51.5>}
      object { TL_Light rotate <0,90,0> translate <4.5,300,-51.5>}
      object { TL_Light rotate <0,90,0> translate <-4.5,300,51.5>}
      object { TL_Light rotate <0,90,0> translate <4.5,300,51.5>}

   }
}

#declare TL_col = object
{
   union
   {
      object {TL_quad translate <0,0,-450>}
      object {TL_quad translate <0,0,-200>}
      object {TL_quad translate <0,0,200>}
      object {TL_quad translate <0,0,450>}
   }
}

#declare TL_all = object
{
   union
   {
      object {TL_col translate <-300,0,0>}
      object {TL_col translate <0,0,0>}
      object {TL_col translate <300,0,0>}
   }
}

object {TL_all}

// ---------------------------------------------------------
// --------------------------- outside ---------------------
// ---------------------------------------------------------

object      // ground
{
   plane {<0,1,0> 0}
   pigment { color rgb<0.4,0.2,0.1> }
   finish {ambient 0.2 brilliance 0.5}
}

object      // sky
{
   plane {<0,-1,0> 0 translate <0,500*m,0>}
   pigment {
      spotted
      turbulence 0.2
      color_map
      {
         [0 color rgb <0,0.65,1>]
         [0.5 color rgb <0,0.65,1>]
         [0.8 color rgb <1,1,1>]
         [1 color rgb <0.8,0.8,0.8>]
      }
      scale 500*m
   }
   finish {
      ambient 1 
      diffuse 0
   }
   no_shadow
}


