#version 3

/* description 

   TL-tube light in metal holder.
   hanging from ceiling, tube at -y side.
   length of tube in x direction
   <0,0,0> = center top of metal holder.
   diensions : box {<-50,0,-3> <50,-6,3>}
*/

#declare WhiteMetal = texture
{
   pigment {color rgb<1,1,0.8>}
   finish {
      ambient 0.1
      diffuse 0.9
      brilliance 1.5
      reflection 0.3
      phong 1
   }
   
}

#declare WhiteGlass = texture
{
   pigment {color rgb<1,1,1>}
   finish
   {
      ambient 0.2
      diffuse 1
      brilliance 0.4
      phong 0.4
   }
}

#declare ParaboolCylinder = object     // y = z^2
{
   // oftewel, z^2 - y = 0
   quadric
   {
      <0,0,1>           // x^2, y^2, z^2
      <0,0,0>           // xy, xz, yz
      <0,-1,0>          // x, y, z
      0                 // +t             = 0
   }
}

#declare TL_Casing = object            // casing
{
   intersection
   {
      object {ParaboolCylinder 
         scale <1,6/9,1> 
         translate <0,-6,0>
      }
      union
      {
         box {<-50,0,-3> <50,-1.5,3>}
         box {<-50,-1.5,-3> <-49,-6,3>}
         box {<50,-1.5,-3> <49,-6,3>}
      }
   }
   texture {WhiteMetal}
}

#declare TL_Tube = object            // tube
{
   cylinder {<-43,-4.5,0> <49,-4.5,0> 1.5 }
   texture {WhiteGlass}
}

#declare TL_Starter = object         // starter
{
   cylinder {<-49,-4.5,0> <-43,-4.5,0> 1.5 }
   texture {ChromeMetal}
}

#declare TL_Light = object
{
   union
   {
      object {TL_Casing}
      object {TL_Tube}
      object {TL_Starter}
   }
}
