
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth:

#include "machine2.inc"
#include "head.inc"

sky_sphere
{
  pigment
  {
    agate
    color_map { [0.0 color rgb< 0.6,.6,.1>] [1.0 color rgb <.01,.02,.1>] }
    scale 3
  }
}
global_settings {
      radiosity {
        count 800                // Ensure that we get good, accurate samples
        error_bound 0.2          // And calculate lots of them.  (more important than count)
        gray_threshold 0.5
        distance_maximum 20      // Scene-dependant!
        low_error_factor 0.7     // force many extra samples to be calculated...
        nearest_count 9          // so we can average them together for smoothness
        minimum_reuse 0.01       // get quite tightly into corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // Try this = 2, but drop the count to maybe 300
   }
}
camera {  //  Camera Camera01
  location  <20.039, -6.024, 5.374>
  //direction <0.0,     0.0,  5.8663>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0, 0, 3>
  aperture 15
  focal_point <0, 0, 3>
  confidence .95
}

plane { x, -30 texture { Brass_Valley1 } }
#declare SpotL001 = light_source {   // Spotlight SpotL001
  <27.694, 0.000, 140.051>
  color  rgb <0.804, 0.804, 0.804>
  spotlight
    point_at  <12.492, 0.878, 68.726>
    falloff   18.6  // outer radius (in deg)
      radius    12.1  // inner radius
}

object { SpotL001 }

#declare roller = object {
  cylinder { // roller
    <0,0,1>, <0,0,0>, 1
    texture {
      Roller_tex
    }
    scale <0.9, 1.0, 5.0>
    rotate <-180.0, -90.0, -90.0>
    translate  1.0*x
  }
}
#declare roller1 = object {
  object { // roller1->roller
    roller
    translate  2.0*x
  }
}
#declare roller2 = object {
  object { // roller2->roller1
    roller1
    translate  2.0*x
  }
}
#declare roller3 = object {
  object { // roller3->roller2
    roller2
    translate  2.0*x
  }
}
#declare roller4 = object {
  object { // roller4->roller3
    roller3
    translate  2.0*x
  }
}
#declare roller5 = object {
  object { // roller5->roller4
    roller4
    translate  2.0*x
  }
}
#declare roller6 = object {
  object { // roller6->roller5
    roller5
    translate  2.0*x
  }
}
#declare roller7 = object {
  object { // roller7->roller6
    roller6
    translate  2.0*x
  }
}
#declare roller8 = object {
  object { // roller8->roller7
    roller7
    translate  2.0*x
  }
}
#declare Rollers = union {
  object { // roller9->roller8
    roller8
    translate  2.0*x
  }
  object { roller8 }
  object { roller7 }
  object { roller6 }
  object { roller5 }
  object { roller4 }
  object { roller3 }
  object { roller2 }
  object { roller1 }
  object { roller }
  translate  2.5*y
}


#declare Furnace_Button = object {
  cylinder { // Furnace_Button
    <0,0,1>, <0,0,0>, 1
    texture {
      RedButton_Tex
    }
    scale 0.247931
    rotate <180.0, -90.0, 180.0>
    translate  <-14.850303, -3.230267, 8.350994>
  }
}
#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      pigment { color rgbt<1,1,1,.95> } finish { reflection .2 phong 1}
    }
    rotate <180.0, -90.0, 180.0>
    translate  <-14.286279, 0.0, 8.919314>
  }
}


#declare bracket = object {
  box { // bracket
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Brass_Valley1
    }
    scale <1.0, 1.0, 0.236808>
    translate  <0.0, -4.0, -3.732514>
  }
}
#declare Support = object {
  cylinder { // Support
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.312281, 0.313758, 13.278578>
    translate  <0.0, -4.0, -3.817175>
  }
}
#declare Holder_right = object {
  cylinder { // Holder_right
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    rotate 90.0*x
    translate  <0.0, -3.5, 10.5>
  }
}

#declare Cap_Sub = difference {
  sphere { // Cap_Sphere
    <0,0,0>,1
    texture {
      Grad_Cap_Tex
    }
    translate  <0.018713, 0.0, -1.00117>
  }
  sphere { // Cap_Sub_Sphere
    <0,0,0>,1
    texture {
      Clear
    }
    scale 1.05614
    translate  <0.018713, 0.0, -1.197661>
  }
}
#declare Hat = union { // Hat
  sphere { // Cap_Tip
    <0,0,0>,1
    texture {
      Grad_Cap_Tex
    }
    scale 0.134594
  }
  object { Cap_Sub }
  box { // cap_board
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grad_Cap_Tex
    }
    scale <1.935579, 2.029131, 0.008187>
  }
  texture {
    Grad_Cap_Tex
  }
  scale 0.614286

}
#declare Cap_Sub1 = difference {
  sphere { // Cap_Sphere1
    <0,0,0>,1
    texture {
      Grad_Cap_Tex
    }
    translate  <0.018713, 0.0, -1.00117>
  }
  sphere { // Cap_Sub_Spher1
    <0,0,0>,1
    texture {
      Clear
    }
    scale 1.05614
    translate  <0.018713, 0.0, -1.197661>
  }
}
object { Hat  rotate -84.38459*y
  translate  <12.55344, 0.173736, 5.183014>}
#declare FaceWithHat = union
{
    object { Hollowface translate < 0,1.5,0> scale 1.25 rotate -90*z rotate -90*y}
  union { // hat
  sphere { // Cap_Tip1
    <0,0,0>,1
    texture {
      Grad_Cap_Tex
    }
    scale 0.134594
  }
  object { Cap_Sub1 }
  box { // cap_board1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grad_Cap_Tex
    }
    scale <1.935579, 2.029131, 0.008187>
  }
  texture {
    Grad_Cap_Tex
  }
  scale 0.614286
  rotate -2.435788*y
  translate  <-0.029298, -0.034629, 4.024649>
}

}
sphere { // small5
  <0,0,0>,1
  texture {
    Brass_Valley1
  }
  scale 0.077173
  translate  <13.278898, -0.989889, 6.939874>
}


cone { // Cone2
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    Nozzle_Tex
  }
  scale <0.045259, 0.065215, 0.990181>
  rotate <-7.305218, 35.888668, -6.160694>
  translate  <12.67472, -1.120581, 6.089717>
}


sphere { // small2
  <0,0,0>,1
  texture {
    Brass_Valley1
  }
  scale 0.077173
  translate  <12.321022, -1.100717, 6.774343>
}


cone { // Cone001
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    Brass_Valley1
  }
  scale <0.065707, 0.073157, 0.894619>
  rotate <23.930151, -20.351847, -7.994864>
  translate  <12.625391, -0.722618, 6.030602>
}


#declare Finger1 = union {
  cylinder { // small4
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.04, 0.04, 0.075261>
    rotate -23.031851*x
    translate  <0.0, 0.39674, 0.913508>
  }
  cylinder { // Small_hand2
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <-0.010105, -0.003172, 0.363617>
    rotate <-25.516541, 0.0, 0.0>
    translate  <0.115289, 0.327199, 0.756638>
  }
  cylinder { // Small_hand3
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <-0.010105, -0.003172, 0.363617>
    rotate <-25.744659, 0.0, 0.0>
    translate  <-0.112102, 0.325975, 0.75577>
  }
  sphere { // hand3
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale -0.103676
    translate  <0.0, 0.467275, 1.051369>
  }
  cylinder { // hand4
    <0,0,1>, <0,0,0>, 1
    texture {
      Roller_tex
    }
    scale <0.1, 0.1, 1.0>
    rotate -23.360868*x
  }
  rotate <-10.882528, -16.605341, 33.93021>
  translate  <0.924441, 0.105823, 0.165039>
}
#declare Finger = union {
  cylinder { // small3
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.04, 0.04, 0.075261>
    rotate -23.031851*x
    translate  <0.0, 0.39674, 0.913508>
  }
  cylinder { // Small_hand1
    <0,0,1>, <0,0,0>, 1
    texture {
      Nozzle_Tex
    }
    scale <-0.010105, -0.003172, 0.363617>
    rotate <-25.516541, 0.0, 0.0>
    translate  <0.115289, 0.327199, 0.756638>
  }
  cylinder { // Small_hand
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <-0.010105, -0.003172, 0.363617>
    rotate <-25.744659, 0.0, 0.0>
    translate  <-0.112102, 0.325975, 0.75577>
  }
  sphere { // hand2
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale -0.103676
    translate  <0.0, 0.467275, 1.051369>
  }
  cylinder { // hand1
    <0,0,1>, <0,0,0>, 1
    texture {
      Roller_tex
    }
    scale <0.1, 0.1, 1.0>
    rotate -23.360868*x
  }
}
union { // Hand
  object { Finger1 }
  sphere { // Hand_Big
    <0,0,0>,1
    texture {
      Roller_tex
    }
    scale 0.302023
    translate  <0.156498, 0.488758, 1.343812>
  }
  object { Finger }
  translate  <12.331664, -1.067097, 6.81784>
}


box { // Extra2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rubber
  }
  scale <0.256056, 1.994341, 0.034369>
  rotate -90.05777*z
  translate  <12.443156, 11.222961, 11.763396>
}


torus { // Extra
  1.175, 0.1  rotate -x*90
  texture {
    Rubber
  }
  scale 1.711111
  translate  <12.445857, 11.214906, 11.765806>
}


cylinder { // Cap_Arm3
  <0,0,1>, <0,0,0>, 1
  texture {
    Roller_tex
  }
  scale <0.38923, 0.38923, 7.006138>
  rotate -11.654122*x
  translate  <12.459992, -0.392316, 8.310147>
}


cylinder { // arm7
  <0,0,1>, <0,0,0>, 1
  texture {
    Roller_tex
  }
  scale <0.046415, 0.051378, 0.951779>
  rotate 90.0*x
  translate  <12.270475, 2.062752, 15.394775>
}


cylinder { // arm6
  <0,0,1>, <0,0,0>, 1
  texture {
    Roller_tex
  }
  scale <0.046415, 0.051378, 0.951779>
  rotate 90.0*x
  translate  <12.635602, 2.067204, 15.394775>
}


union { // Joint1
  sphere { // Arm6
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale 0.146716
    translate  <12.31467, 2.075906, 15.386292>
  }
  sphere { // Arm7
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale 0.146716
    translate  <12.583188, 2.075906, 15.386292>
  }
  sphere { // Arm8
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale <0.470034, 0.147145, 0.219211>
    rotate -90.082382*z
    translate  <12.460808, 2.098507, 15.387504>
  }
  rotate 75.0*x
  translate  <-0.003547, 15.451023, 9.407663>
}


union { // Joint
  sphere { // Arm5
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale 0.146716
    translate  <12.31467, 2.075906, 15.386292>
  }
  sphere { // Arm4
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale 0.146716
    translate  <12.583188, 2.075906, 15.386292>
  }
  sphere { // Arm3
    <0,0,0>,1
    texture {
      Brass_Valley1
    }
    scale <0.470034, 0.147145, 0.219211>
    rotate -90.082382*z
    translate  <12.460808, 2.098507, 15.387504>
  }
}


cylinder { // Cap_Arm2
  <0,0,1>, <0,0,0>, 1
  texture {
    Roller_tex
  }
  scale <0.5, 0.5, 9.0>
  rotate -90.0*x
  translate  <12.432196, 2.23679, 15.374496>
}


sphere { // Cap_Arm1
  <0,0,0>,1
  texture {
    Roller_tex
  }
  translate  <12.441552, 11.213157, 15.387504>
}


#declare Cap_Machine_B = lathe {
  linear_spline
  12  // control points
  <0.008087, -1.002943>,
  <0.500256, -1.001894>,
  <0.315918, -0.720638>,
  <0.526398, -0.621902>,
  <0.302958, -0.499045>,
  <0.541536, -0.40792>,
  <0.284486, -0.289185>,
  <0.574182, -0.205613>,
  <0.489397, 0.007455>,
  <0.0768, 0.009409>,
  <0.029374, 0.508518>,
  <0.176203, 0.766537>
  rotate <90,0,90>
  texture {
    Furnace_Tex
  }
  scale <7.386231, 7.036735, 12.748712>
  translate  <12.432702, 11.226368, 7.713887>
}
difference { // Cap_Machine_Dif
  object { Cap_Machine_B }
  cylinder { // Base_Cap
    <0,0,1>, <0,0,0>, 1
    texture {
      Clear
    }
    scale <3.336711, 3.470237, 4.404922>
    translate  <12.313535, 11.240516, -8.278633>
  }
}


#declare Rollers5 = union {
  object { // roller20->roller8
    roller8
    translate  2.0*x
  }
  object { // roller21->roller7
    roller7
    translate  2.0*x
  }
  object { // roller22->roller6
    roller6
    translate  2.0*x
  }
  object { // roller23->roller5
    roller5
    translate  2.0*x
  }
  object { // roller24->roller4
    roller4
    translate  2.0*x
  }
  object { // roller25->roller3
    roller3
    translate  2.0*x
  }
  object { // roller26->roller2
    roller2
    translate  2.0*x
  }
  object { // roller27->roller1
    roller1
    translate  2.0*x
  }
  object { // roller28->roller
    roller
    translate  2.0*x
  }
  cylinder { // roller29
    <0,0,1>, <0,0,0>, 1
    texture {
      Roller_tex
    }
    scale <0.9, 1.0, 5.0>
    rotate <-180.0, -90.0, -90.0>
    translate  1.0*x
  }
  translate  2.5*y
}
#declare Belt_diff2 = difference {
  box { // belt2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <19.863157, 2.500313, 0.982697>
  }
  box { // belt_sub2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <20.180401, 2.918484, 0.87467>
  }
}
#declare belt_end_diff5 = difference {
  cylinder { // BeltEnd4
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  rotate -180.0*y
  translate  -10.0*x
}
#declare belt_end_diff6 = difference {
  cylinder { // BeltEnd5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  translate  10.0*x
}
union { // Conveyor2
  cylinder { // belt_support_2
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.3, 0.3, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  object { // Rollers4->Rollers
    Rollers
    translate  -20.042105*x
  }
  object { Rollers5 }
  object { Belt_diff2 }
  object { belt_end_diff5 }
  object { belt_end_diff6 }
  scale <0.453036, 0.528542, 0.528542>
  translate  22.81816*x
}


#declare Rollers3 = union {
  object { // roller10->roller8
    roller8
    translate  2.0*x
  }
  object { // roller11->roller7
    roller7
    translate  2.0*x
  }
  object { // roller12->roller6
    roller6
    translate  2.0*x
  }
  object { // roller13->roller5
    roller5
    translate  2.0*x
  }
  object { // roller14->roller4
    roller4
    translate  2.0*x
  }
  object { // roller15->roller3
    roller3
    translate  2.0*x
  }
  object { // roller16->roller2
    roller2
    translate  2.0*x
  }
  object { // roller17->roller1
    roller1
    translate  2.0*x
  }
  object { // roller18->roller
    roller
    translate  2.0*x
  }
  cylinder { // roller19
    <0,0,1>, <0,0,0>, 1
    texture {
      Roller_tex
    }
    scale <0.9, 1.0, 5.0>
    rotate <-180.0, -90.0, -90.0>
    translate  1.0*x
  }
  translate  2.5*y
}
#declare Belt_diff1 = difference {
  box { // belt1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <19.863157, 2.500313, 0.982697>
  }
  box { // belt_sub1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <20.180401, 2.918484, 0.87467>
  }
}
#declare belt_end_diff3 = difference {
  cylinder { // BeltEnd2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  rotate -180.0*y
  translate  -10.0*x
}
#declare belt_end_diff4 = difference {
  cylinder { // BeltEnd3
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  translate  10.0*x
}
union { // Conveyor1
  cylinder { // belt_support_1
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.3, 0.3, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  object { // Rollers2->Rollers
    Rollers
    translate  -20.042105*x
  }
  object { Rollers3 }
  object { Belt_diff1 }
  object { belt_end_diff3 }
  object { belt_end_diff4 }
  scale <0.453036, 0.528542, 0.528542>
  translate  6.159518*x
}


#declare Belt_diff = difference {
  box { // belt
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    hollow
    scale <19.863157, 2.500313, 0.982697>
  }
  box { // belt_sub
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rubber
    }
    scale <20.180401, 2.918484, 0.87467>
  }
}
#declare belt_end_diff2 = difference {
  cylinder { // BeltEnd1
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  rotate -180.0*y
  translate  -10.0*x
}
#declare belt_end_diff1 = difference {
  cylinder { // BeltEnd
    <0,0,1>, <0,0,0>, 1
    hollow
    scale <1.0, 1.0, 5.0>
    rotate 90.0*x
    translate  <10.0, 2.5, 0.0>
  }
  box { // belt_end_subt
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 1.0>
    translate  8.454496*x
  }
  texture {
    Rubber
  }
  translate  10.0*x
}
union { // Conveyor
  cylinder { // belt_support_h
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <0.3, 0.3, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  object { // Rollers1->Rollers
    Rollers
    translate  -20.042105*x
  }
  object { Rollers }
  object { Belt_diff }
  object { belt_end_diff2 }
  object { belt_end_diff1 }
  scale <0.453036, 0.528542, 0.528542>
  translate  -10.084018*x
}

#declare Furnace_Main = difference {
  superellipsoid { // Furnace_out
    <0.3, 0.2>
    texture {
      Furnace_Tex
    }
    scale <5.101857, 6.947692, 7.357878>
    translate  <-20.076267, 0.0, 3.281757>
  }
  superellipsoid { // SuprQ001
    <0.25, 0.15>
    texture {
      Clear
    }
    scale <4.389793, 4.70314, 7.417957>
    translate  -17.985424*x
  }
}
#declare Pointer_Raw = union {
    smooth_triangle {
      <0.00681, -1.51727, 1.00000>, <0.99648, -0.08380, 1.00000>,
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 1.00000>,
      <0.17502, 0.48300, 1.00000>, <0.99945, 0.03312, 1.00000>    }
    smooth_triangle {
      <0.00681, -1.51727, 1.00000>, <0.99648, -0.08380, 1.00000>,
      <0.00704, -1.63387, 0.99000>, <0.99648, -0.08380, 1.00000>,
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 1.00000>    }
    smooth_triangle {
      <0.00681, -1.51727, 0.00000>, <0.99648, -0.08380, -1.00000>,
      <0.17502, 0.48300, 0.00000>, <0.99945, 0.03312, -1.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, -1.00000>    }
    smooth_triangle {
      <0.00681, -1.51727, 0.00000>, <0.99648, -0.08380, -1.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, -1.00000>,
      <0.00704, -1.63387, 0.01000>, <0.99648, -0.08380, -1.00000>    }
    smooth_triangle {
      <0.00704, -1.63387, 0.99000>, <0.99648, -0.08380, 0.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, 0.00000>,
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 0.00000>    }
    smooth_triangle {
      <0.00704, -1.63387, 0.99000>, <0.99648, -0.08380, 0.00000>,
      <0.00704, -1.63387, 0.01000>, <0.99648, -0.08380, 0.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, 0.00000>    }
    smooth_triangle {
      <0.17502, 0.48300, 1.00000>, <0.99945, 0.03312, 1.00000>,
      <-0.00009, 1.70725, 0.99000>, <0.98875, 0.14960, 1.00000>,
      <0.00000, 1.63978, 1.00000>, <0.98875, 0.14960, 1.00000>    }
    smooth_triangle {
      <0.17502, 0.48300, 1.00000>, <0.99945, 0.03312, 1.00000>,
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 1.00000>,
      <-0.00009, 1.70725, 0.99000>, <0.98875, 0.14960, 1.00000>    }
    smooth_triangle {
      <0.17502, 0.48300, 0.00000>, <0.99945, 0.03312, -1.00000>,
      <0.00000, 1.63978, 0.00000>, <0.98875, 0.14960, -1.00000>,
      <-0.00009, 1.70725, 0.01000>, <0.98875, 0.14960, -1.00000>    }
    smooth_triangle {
      <0.17502, 0.48300, 0.00000>, <0.99945, 0.03312, -1.00000>,
      <-0.00009, 1.70725, 0.01000>, <0.98875, 0.14960, -1.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, -1.00000>    }
    smooth_triangle {
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 0.00000>,
      <-0.00009, 1.70725, 0.01000>, <0.98875, 0.14960, 0.00000>,
      <-0.00009, 1.70725, 0.99000>, <0.98875, 0.14960, 0.00000>    }
    smooth_triangle {
      <0.18508, 0.48334, 0.99000>, <0.99945, 0.03312, 0.00000>,
      <0.18508, 0.48334, 0.01000>, <0.99945, 0.03312, 0.00000>,
      <-0.00009, 1.70725, 0.01000>, <0.98875, 0.14960, 0.00000>    }
    smooth_triangle {
      <0.00000, 1.63978, 1.00000>, <-0.98916, 0.14686, 1.00000>,
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 1.00000>,
      <-0.17024, 0.49315, 1.00000>, <-0.99956, 0.02977, 1.00000>    }
    smooth_triangle {
      <0.00000, 1.63978, 1.00000>, <-0.98916, 0.14686, 1.00000>,
      <-0.00009, 1.70725, 0.99000>, <-0.98916, 0.14686, 1.00000>,
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 1.00000>    }
    smooth_triangle {
      <0.00000, 1.63978, 0.00000>, <-0.98916, 0.14686, -1.00000>,
      <-0.17024, 0.49315, 0.00000>, <-0.99956, 0.02977, -1.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, -1.00000>    }
    smooth_triangle {
      <0.00000, 1.63978, 0.00000>, <-0.98916, 0.14686, -1.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, -1.00000>,
      <-0.00009, 1.70725, 0.01000>, <-0.98916, 0.14686, -1.00000>    }
    smooth_triangle {
      <-0.00009, 1.70725, 0.99000>, <-0.98916, 0.14686, 0.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, 0.00000>,
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 0.00000>    }
    smooth_triangle {
      <-0.00009, 1.70725, 0.99000>, <-0.98916, 0.14686, 0.00000>,
      <-0.00009, 1.70725, 0.01000>, <-0.98916, 0.14686, 0.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, 0.00000>    }
    smooth_triangle {
      <-0.17024, 0.49315, 1.00000>, <-0.99956, 0.02977, 1.00000>,
      <0.00704, -1.63387, 0.99000>, <-0.99614, -0.08772, 1.00000>,
      <0.00681, -1.51727, 1.00000>, <-0.99614, -0.08772, 1.00000>    }
    smooth_triangle {
      <-0.17024, 0.49315, 1.00000>, <-0.99956, 0.02977, 1.00000>,
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 1.00000>,
      <0.00704, -1.63387, 0.99000>, <-0.99614, -0.08772, 1.00000>    }
    smooth_triangle {
      <-0.17024, 0.49315, 0.00000>, <-0.99956, 0.02977, -1.00000>,
      <0.00681, -1.51727, 0.00000>, <-0.99614, -0.08772, -1.00000>,
      <0.00704, -1.63387, 0.01000>, <-0.99614, -0.08772, -1.00000>    }
    smooth_triangle {
      <-0.17024, 0.49315, 0.00000>, <-0.99956, 0.02977, -1.00000>,
      <0.00704, -1.63387, 0.01000>, <-0.99614, -0.08772, -1.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, -1.00000>    }
    smooth_triangle {
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 0.00000>,
      <0.00704, -1.63387, 0.01000>, <-0.99614, -0.08772, 0.00000>,
      <0.00704, -1.63387, 0.99000>, <-0.99614, -0.08772, 0.00000>    }
    smooth_triangle {
      <-0.18030, 0.49345, 0.99000>, <-0.99956, 0.02977, 0.00000>,
      <-0.18030, 0.49345, 0.01000>, <-0.99956, 0.02977, 0.00000>,
      <0.00704, -1.63387, 0.01000>, <-0.99614, -0.08772, 0.00000>    }
    triangle { <   0.00681,   -1.51727,    1.00000>, <   0.17502,    0.48300,    1.00000>, <   0.00000,    1.63978,    1.00000> }
    triangle { <   0.00681,   -1.51727,    0.00000>, <   0.17502,    0.48300,    0.00000>, <   0.00000,    1.63978,    0.00000> }
    triangle { <   0.00681,   -1.51727,    1.00000>, <   0.00000,    1.63978,    1.00000>, <  -0.17024,    0.49315,    1.00000> }
    triangle { <   0.00681,   -1.51727,    0.00000>, <   0.00000,    1.63978,    0.00000>, <  -0.17024,    0.49315,    0.00000> }
}


#declare Pointer = object {
  Pointer_Raw
  texture {
    Rubber
  }
  scale <0.339708, 0.470686, 0.005004>
  rotate <90.0, -40.67519, 90.0>
  translate  <-14.952969, 0.0, 8.930976>
}
#declare Gauge = union {
  object { Pointer }
  object { Cylndr001 }
  object { // Cylndr2->Cylndr001
    Cylndr001
    texture {
      Grout
    }
    scale <0.310637, 1.0, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  -10.524604*x
  }
}
union { // Furnace_Whole
  object { // Furnace_Butto1->Furnace_Button
    Furnace_Button
    texture {
      RedButton_Tex
    }
    rotate <0.0, 0.0, 0.0>
    translate  6.460533*y
  }
  object { Furnace_Button }
  object { Furnace_Main }
  object { Gauge }
}


#declare Hose = blob {
  threshold 0.3
  component 1.0, 0.538371, <-0.267834, 0.0, 0.185423>
  component 1.0, 0.538371, <-0.020603, 0.0, 0.72109>
  component 1.0, 0.538371, <-0.061808, 0.0, 1.339168>
  component 1.0, 0.538371, <0.226628, 0.0, 1.91604>
  component 1.0, 0.538371, <0.020603, 0.0, 2.616528>
  component 1.0, 0.538371, <-0.309039, 0.0, -0.515065>
  component 1.0, 0.538371, <-0.144218, 0.0, -1.215552>
  component 1.0, 0.538371, <0.020603, 0.0, -1.874835>
  component 1.0, 0.538371, <0.185423, 0.0, -2.492913>
  component 1.0, 0.538371, <0.350244, 0.0, -3.152195>
  component 1.0, 0.538371, <0.473859, 0.0, -3.893888>
  component 1.0, 0.538371, <0.63868, 0.0, -4.594376>
  component 1.0, 0.538371, <0.267834, 0.0, 3.399426>
  component 1.0, 0.538371, <0.597475, 0.0, 4.099914>
  component 1.0, 0.538371, <0.309039, 0.0, 4.635581>
  texture {
    Hose_Tex
  }
  scale <1.424822, 1.0, 3.690537>
  translate  <-0.979808, -0.113351, 29.807895>
}

#declare Goo = blob {
  threshold 0.6
  component 1.0, 0.541471, <-0.008439, 0.970464, 0.0>
  component 1.0, 0.476944, <-0.362869, 0.582278, 0.0>
  component 1.0, 0.428071, <0.0, 0.767932, 0.514768>
  component 1.0, 0.303734, <0.0, 0.075949, -0.616034>
  component 1.0, 0.405325, <0.0, -0.514768, -0.531646>
  component 1.0, 0.605383, <0.0, -0.987342, 0.075949>
  component 1.0, 0.428071, <0.0, -0.447257, 0.447257>
  component 1.0, 0.505251, <0.0, -1.206751, -0.227848>
  component 1.0, 0.366003, <0.0, -1.443038, 0.126582>
  component 1.0, 0.562084, <0.312236, -0.767932, 0.0>
  component 1.0, 0.505251, <-0.345992, -0.78481, 0.0>
  component 1.0, 0.335372, <-0.244726, -1.291139, 0.0>
  component 1.0, 0.317963, <0.0, 0.227848, 0.042194>
  component 1.0, 0.384525, <0.0, -0.14346, -0.43038>
  component 1.0, 0.224834, <0.0, 1.392405, -0.075949>
  component 1.0, 0.146574, <0.0, 1.611814, -0.075949>

sturm
  texture {
    Goo_tex
  }
  scale <0.783517, 0.891758, 1.0>
  rotate 90.0*x
  translate  <-0.011943, -0.031908, 4.021225>
}

#declare GooShooter = union {
  object { // Support1->Support
    Support
    translate  <0.0, 8.0, 0.0>
  }
  object { Support }
  object { // Holder_left->Holder_right
    Holder_right
    texture {
      Brass_Valley1
    }
    rotate 0.0*x
    translate  <0.0, 8.0, 0.0>
  }
  object { Holder_right }
  cylinder { // Res2
    <0,0,1>, <0,0,0>, 1
    texture {
      Brass_Valley1
    }
    scale <3.5, 3.5, 1.0>
    translate  10.0*z
  }
  superellipsoid { // GooHolder
    <0.5, 0.5>
    texture {
      Roller_tex
    }
    scale 2.0
    translate  10.0*z
  }
  cone { // nozzle2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Rubber
    }
    hollow
    scale <0.410883, 0.357998, 0.921085>
    translate  5.0*z
  }
  cone { // Nozzle
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Nozzle_Tex
    }
    hollow
    scale <1.29545, 1.0, 4.594643>
    translate  5.0*z
  }
}
union { // Goo_Shooter
  object { Hose }
  cylinder { // RedButton
    <0,0,1>, <0,0,0>, 1
    texture {
      RedButton_Tex
    }
    scale 0.1
    rotate 90.0*x
    translate  <0.0, -4.75, 3.2>
  }
  box { // Control_Box_Goo
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Brass_Valley1
    }
    scale <0.218189, 0.279532, 0.553898>
    translate  <0.0, -4.467344, 3.011189>
  }
  object { Goo }
  object { // bracket1->bracket
    bracket
    translate  <0.0, 8.0, 0.0>
  }
  object { bracket }
  object { GooShooter }
}




object { // SpotL4->SpotL001
  SpotL001
  rotate <82.539795, 0.644692, 0.046383>
  translate  <102.094504, -105.492166, 26.207846>
}


object { // SpotL3->SpotL001
  SpotL001
  rotate <-95.642494, -0.337937, -0.039308>
  translate  <31.630924, 114.989855, 32.111271>
}


object { // SpotL2->SpotL001
  SpotL001
  rotate <179.983963, -78.308914, -179.346588>
  translate  <-107.215495, 20.151567, 48.711997>
}




cylinder { // Pipe
  <0,0,1>, <0,0,0>, 1
  texture {
    Roller_tex
  }
  scale <3.0, 3.0, 100.0>
  rotate -90.0*x
  translate  <0.0, -44.955104, 48.600112>
}


plane { // Under_Floor
  z,-2.1
  texture {
    Grout
  }

}

object { Hollowface translate < 0,1.5,0> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,-4> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,-8> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,-12> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,-16> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,-20> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,4> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,8> scale 1.25 rotate -90*z rotate -90*y}
object { Hollowface translate < 0,1.5,12> scale 1.25 rotate -90*z rotate -90*y}


