//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------

#declare Wood1=
texture
{ pigment
  { wood
    turbulence 0.04
    octaves 10
    scale <.1, .1, 1>
    color_map
    {   [0.0, 0.1 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.888, 0.600, 0.3>]
        [0.1, 0.9 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.600, 0.400, 0.2>*1.1]
        [0.9, 1.0 color rgb <0.600, 0.400, 0.2>*1.1
                  color rgb <0.600, 0.400, 0.2>*1.1]
    }
  }
  finish
  { specular .5 roughness .05
//    reflection .1
  }
}

#declare Wood2=
texture
{ pigment
  { wood
    turbulence 0.1
    octaves 4
    scale <1, 1, 1>*4
    rotate <45,0,0>
    color_map
    { [0.0, 0.1 color rgb <0.52, 0.37, 0.26>
                color rgb <0.52, 0.37, 0.26>]
      [0.1, 0.9 color rgb <0.52, 0.37, 0.26>
                color rgb <0.42, 0.26, 0.15>]
      [0.9, 1.0 color rgb <0.42, 0.26, 0.15>
                color rgb <0.42, 0.26, 0.15>]
    }
  }
  finish
  { specular .5 roughness .05
//    reflection .1
  }
}

#declare Tan_Wood =
pigment {
    wood
    turbulence 0.1
    color_map {
        [0.0, 0.8 color rgb <0.88, 0.60, 0.30>
                  color rgb <0.88, 0.60, 0.30>]
        [0.8, 1.0 color rgb <0.60, 0.40, 0.20>
                  color rgb <0.40, 0.30, 0.20>]
    }
}

#declare Metal1=
texture
{ pigment { color <.7,.75,.8> }
  finish { specular 1 roughness .05 reflection .1 }
}

#declare Metal2=
texture
{ pigment { color <.8,.75,.6> }
  finish { specular 1 roughness .03 }
}

#declare WindowGlass=
texture
{ pigment { color rgbf <1,1,1,1> }
  finish { reflection .2 }
}

#declare Grass=
texture
{ pigment { color <0,1,0> }
  normal { bumps .05 scale 10 }
  finish { crand .1 ambient off }
}

//-----------------------------------------------------------------------------
// Objects
//-----------------------------------------------------------------------------

#declare Table=
union
{ difference
  { union
    { difference
      { box { <2,0,0>,<68,20,60> }
        box
        { 0,<70,20,-60>
          rotate <-11.3,0,0>
          translate <0,20,50>
        }
      }
      superellipsoid
      { <.1,.1> translate <1,1,1>
        scale <70,-3,-53>*.5
        rotate <-11.3,0,0>
        translate <0,20.1,50>
      }
    }
    cylinder { <-1,20-1.4,50><71,20-1.4,50>,1.4 }

    texture { Wood1 scale 3 rotate <30,20,30> }
  }

  difference
  { cylinder { <0,20-1.4,50><70,20-1.4,50>,1.4 }
    difference
    { cylinder { <-1,20-1.4,50><.2,20-1.4,50>,1 }
      cylinder { <-1,20-1.4,50><.2,20-1.4,50>,.7 }
    }
    difference
    { cylinder { <71,20-1.4,50><69.8,20-1.4,50>,1 }
      cylinder { <71,20-1.4,50><69.8,20-1.4,50>,.7 }
    }

    texture { Metal1 }
  }

  union
  { cylinder { <7,0,12><7,-50,12>,2 }
    cylinder { <63,0,12><63,-50,12>,2 }
    cylinder { <7,0,48><7,-50,48>,2 }
    cylinder { <63,0,48><63,-50,48>,2 }
    union
    { cone { <7,-55,12>2.2<7,-50,12>,2.1 }
      cone { <63,-55,12>2.2<63,-50,12>,2.1 }
      cone { <7,-55,48>2.2<7,-50,48>,2.1 }
      cone { <63,-55,48>2.2<63,-50,48>,2.1 }
      pigment { color <0,0,0> }
      finish { specular .5 roughness .05 }
    }
    cylinder { <7,-8,48><63,-8,48>,2 }
    cylinder { <7,-42,48><63,-42,48>,2 }
    cylinder { <7,-12,12><7,-12,48>,2 }
    cylinder { <63,-12,12><63,-12,48>,2 }

    texture { Metal2 }
  }
}

#declare Chair=
union
{ union
  { superellipsoid
    { <.1,.1> translate <1,1,1> scale <35,2,35>*.5 translate y*-20
    }
    superellipsoid
    { <.2,.2> translate <1,1,1> scale <35,15,2>*.5
    }
    texture { Wood2 scale .5 }
  }

  union
  { difference
    { torus { 5,1 rotate <90,0,0> }
      box { <0,-6,-2><6,6,2> }
      box { <-6,0,-2><0,-6,2> }
      translate <10,4,-1>
    }
    difference
    { torus { 5,1 rotate <90,0,0> }
      box { <0,-6,-2><-6,6,2> }
      box { <6,0,-2><0,-6,2> }
      translate <25,4,-1>
    }
    cylinder { <10,9,-1><25,9,-1>,1 }
    cylinder { <5,4,-1><5,-50,-1>,1 }
    cylinder { <30,4,-1><30,-50,-1>,1 }
    cylinder { <5,-25,-1><30,-25,-1>,1 }
    cylinder { <5,-31,-1><5,-31,29>,1 }
    cylinder { <30,-31,-1><30,-31,29>,1 }
    cylinder { <5,-20,29><5,-50,29>,1 }
    cylinder { <30,-20,29><30,-50,29>,1 }

    texture { Metal2 }
  }

  union
  { cone { <5,-55,-1>,1.2,<5,-50,-1>,1.1 }
    cone { <30,-55,-1>,1.2,<30,-50,-1>,1.1 }
    cone { <5,-55,29>,1.2,<5,-50,29>,1.1 }
    cone { <30,-55,29>,1.2,<30,-50,29>,1.1 }

    pigment { color <0,0,0> }
    finish { specular .5 roughness .05 }
  }
}

#declare Tree=
union
{ intersection
  { torus { 500,480 inverse translate y*30 }
    cylinder { <0,-60,0><0,100,0>,70 }

    pigment { color <.4,.2,.05> }
    normal { bumps .8 scale <2,8,2> }
    finish { ambient off }
  }
  sphere
  { <0,0,0>,150 scale <1,.8,1> translate y*220

    pigment { color <0,.9,0> }
    normal { bumps .6 scale 12 }
    finish { crand .3 ambient off }
  }
}

#declare Pen=
  union
  {  difference
     {  union
        {  difference
           {  box { <-13,-1,-1>,<10,1,1> }
              box
              {  <-13,-1.01,-1.01>,<10,1.01,1.01>
                 rotate <45,0,0>
                 inverse
              }
              box
              {  <-13,-1,-1>,<10,1,1>
                 rotate <45,0,0>
              }
              pigment { color 0 }
           }

           difference
           {  box
              {  <-13,-1,-1>,<10,1,1>
                 pigment { color rgb <.6,.5,0> }
              }
              box
              {  <-13,-1,-1>,<10,1,1>
                 rotate <45,0,0>
                 inverse
              }
           }
        }

        difference
        {  box { <-10,-2,-2>,<-13.1,2,2> }
           cone { <-10,0,0>,1.2,<-12.5,0,0>,.25 }
        }
        pigment { Tan_Wood scale .3 rotate <80,45,30>}
     }

     cone
     { <-12.5,0,0>,.25,<-13.5,0,0>,0
       pigment { color 0 }
     }

     difference
     { box { <10,-1,-1>,<11,1,1> }
       box
       { <10,-1,-1>,<11,1,1>
         rotate <45,0,0>
         inverse
       }
       sphere { <9,0,0>,2 inverse }
       pigment { color rgb <.4,0,0> }
       finish { specular .8 roughness .05 }
     }
  }

#declare TeacherTable=
union
{ union
  { box { <0,-40,0><160,30,80> }
    superellipsoid
    { <.1,.1> translate <1,1,1>
      scale <170,5,90>*.5
      translate <-5,30,-5>
    }

    texture { Wood2 }
  }

  union
  { cylinder { <12.5,-40,7.5><12.5,-50,7.5>,2.5 }
    cylinder { <147.5,-40,7.5><147.5,-50,7.5>,2.5 }
    cylinder { <12.5,-40,72.5><12.5,-50,72.5>,2.5 }
    cylinder { <147.5,-40,72.5><147.5,-50,72.5>,2.5 }

    texture { Metal2 }
  }
  union
  { cone { <12.5,-55,7.5>2.7<12.5,-50,7.5>,2.6 }
    cone { <147.5,-55,7.5>2.7<147.5,-50,7.5>,2.6 }
    cone { <12.5,-55,72.5>2.7<12.5,-50,72.5>,2.6 }
    cone { <147.5,-55,72.5>2.7<147.5,-50,72.5>,2.6 }

    pigment { color <0,0,0> }
    finish { specular .8 roughness .05 }
  }

  superellipsoid
  { <.1,.2> translate <1,1,1>
    scale <90,.1,50>*.5
    translate <40,35,20>

    pigment { color <.5,.5,.5> }
  }

  difference
  { box { <65,35,0><95,40,5> }
    cylinder { <68,40,2.5><92,40,2.5>,2 }

    pigment { color <.5,.3,.1> }
  }

  union
  { box { <-10,0,0><10,25,1> }
    box { <-3,0,0><3,-25,-1> rotate <35,0,0> translate y*20 }
    rotate <-28,-20,0>
    translate <130,35,15>
    pigment { color <.4,.7,.9> }
  }

  union
  { difference
    { cylinder { 0,y*15,7 }
      cylinder { 0,y*16,6.7 }
      pigment { color <.8,.4,.3> }
      finish { specular .5 roughness .05 }
    }
    object
    { Pen
      rotate <0,0,-75>
      translate <-4,10,0>
    }
    object
    { Pen
      rotate <0,0,-75>
      translate <-4,10,0>
      rotate <0,100,0>
    }

    translate <35,35,8>
  }

  object
  { Pen rotate <0,-15,0>
    translate <60,36,40>
  }

  box
  { <0,35,10><20,43.09,35>
    pigment
    { gradient y
      scale .1
      color_map
      { [0.0 color <.8,.8,.8> ]
        [0.5 color <.8,.8,.8> ]
        [0.51 color <1,1,1> ]
        [1 color <1,1,1> ]
      }
    }
  }
}

//=============================================================================
// Main scene
//=============================================================================

global_settings
{ ambient_light <1,1,1>*4
  radiosity
  { brightness 3
    count 250
    distance_maximum 1000
    error_bound .33
    gray_threshold .5
    low_error_factor .7
    minimum_reuse .015
    nearest_count 7
    recursion_limit 1
  }
}

camera
{ location <30,180,-145>
  look_at <280,0,500>
  angle 55
}

light_source
{ <3000,1000,0>
  color <1,1,1>*2
  area_light z*400,y*400,10,10
  adaptive 1
  jitter
}

//-----------------------------------------------------------------------------
// Furniture
#declare R1=seed(1)
#declare IndX=0
#while (IndX<4)
  #declare IndZ=0
  #while (IndZ<6)
    #if((IndZ<5)+(IndX=0)+(IndX=3))
      union
      { object { Table }
        object { Chair translate <17+rand(R1),0,-20+rand(R1)*10> }
        translate <IndX*160+rand(R1)*2,0,IndZ*150+rand(R1)*2>
      }
    #end
    #declare IndZ=IndZ+1
  #end
  #declare IndX=IndX+1
#end

object
{ TeacherTable
  translate <200,0,750>
}

union
{ difference
  { box { <270-200,70-70,1000><270+200,70+70,995> }
    box { <270-195,70-65,1001><270+195,70+65,994> }

    pigment { color <0,.2,0> }
    finish { specular .8 roughness .01 }
  }
  box
  { <270-195,70-65,1000><270+195,70+65,998>
    pigment { color <0,.1,0> }
    finish { specular .8 roughness .05 }
  }
  box
  { <270-200,70-70,1000><270+200,70-75,980>
    pigment { color <0,.2,0> }
    finish { specular .8 roughness .01 }
  }

  translate y*30
}

union
{ #declare IndZ=0
  #while (IndZ<1000)
    superellipsoid
    { <1,.3> rotate <90,0,0>
      scale <20,10,20>
      translate <270,190,IndZ>
    }
    #declare IndZ=IndZ+400
  #end

  pigment { color <1,1,1> }
  finish { specular 1 roughness .05 }
}

box
{ <-1,-1,0><1,1,-.1>

  pigment
  { mandel 80
    color_map
    { [0.0 color <0,0,.5>]
      [0.25 color <0,.5,1>]
      [0.5 color <0,1,1>]
      [1 color <1,1,1>]
    }
    translate <.1,-1,0>
    scale 10
  }
  rotate <0,-90,0>
  scale <1,80,100>
  translate <-10,100,400>
}

//-----------------------------------------------------------------------------
// Room
difference
{ box { <-20,-70,-160><570,210,1010> }
  box { <-10,-60,-150><550,200,1000> }
  #declare IndZ=-140
  #while (IndZ<900)
    box { <549,0,IndZ><571,180,IndZ+160> }
    #declare IndZ=IndZ+180
  #end

  pigment { color <1,1,1> }
}

//-----------------------------------------------------------------------------
// Windows
#declare IndZ=-140
#while (IndZ<900)
  union
  { difference
    { box { <551,0,IndZ><556,180,IndZ+160> }
      box { <550,5,IndZ+5><557,175,IndZ+155> }

      pigment { color <1,.7,.4> }
    }
    union
    { cylinder { <550,45,IndZ+.5><550,35,IndZ+.5>,.5 }
      cylinder { <550,135,IndZ+.5><551,145,IndZ+.5>,.5 }

      texture { Metal1 }
    }
    box
    { <552,5,IndZ+5><553,175,IndZ+155>

      texture { WindowGlass }
    }
  }
  #declare IndZ=IndZ+180
#end

//-----------------------------------------------------------------------------
// floor
intersection
{ plane { y,-55 }
  plane { x,560 }

  pigment { checker <1,1,1>,<.8,.8,.8> scale 40 }
}

//-----------------------------------------------------------------------------
// Sky
sphere
{ 0,40000 inverse
  pigment
  { bozo
    turbulence .5
    color_map
    { [0.0 color <0,.9,1>]
      [0.8 color <0,1,1>]
      [0.9 color <1,1,1>]
      [1.0 color <1,1,1>]
    }
    scale 8000
  }
  finish { ambient off }
}

//-----------------------------------------------------------------------------
// Grass
intersection
{ plane { <.1,10,0>,-40 }
  plane { -x,-560 }

  texture { Grass }
}
intersection
{ plane { y,-50.9 }
  plane { -x,-1600 }

  texture { Grass }
}
sphere
{ <10000,-38000,4000>,38800

  texture { Grass }
}

//-----------------------------------------------------------------------------
// Road
union
{ box { <1050,-50,-1000><1150,-60,10000> }
  box { <1550,-50,-1000><1650,-60,10000> }

  pigment { brick <.55,.55,.55>,<.7,.7,.7> mortar .2 scale 30 translate -x*25}
  finish { ambient off }
}
intersection
{ plane { y,-51 }
  plane { -x,-1100 }

  pigment { color <.1,.1,.1> }
  normal { bumps .5 }
  finish { ambient off specular .5 roughness .05 }
}
union
{ #declare IndZ=1000
  #while (IndZ<3000)
    box { <1340,-50.9,IndZ><1360,-52,IndZ+80> }
    #declare IndZ=IndZ+200
  #end

  pigment { color <1,1,1>*.7 }
  normal { bumps .5 }
}

object
{ Tree
  translate <1000,0,1400>
}
object
{ Tree
  translate <1700,0,1470>
}
object
{ Tree
  translate <1700,0,1900>
}
object
{ Tree
  translate <1700,0,2250>
}

