// create a smooth blobby shape
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components

#declare dough=
 blob{
  threshold 0.6
  cylinder{
   <0.0, 0.0, -1.0>, <0.0, 0.0, 1.0>,  StrengthVal, RadiusVal
   scale <4.0, 0.25, 2.0>
  }
  cylinder{
   <0.0, 0.0, -1.0>, <0.0, 0.0, 1.0>,  StrengthVal, RadiusVal
   translate <2.0, 0.0, 0.0>
   scale <0.95, 0.65, 1.75>
  }
  sphere{
   <0.0, 0.0, 0.0>, StrengthVal, 3*RadiusVal
   translate <1.5, 0.0, -3.0>
   scale <0.8, 0.13, 1.0>
  }
 }


//////////////////////////////////////////

#declare cookie_man_shape=
union{
 //hat
 box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{color <0.121555, 0.060733, 0.945234>}
   scale     <1.56, 0.50, 1.00>
   rotate    <0.00, 0.00, 18.00>
   translate <-0.16, 1.61, 0.00>
 }
 //tassle
 sphere{
  <0.0, 0.0, 0.0>, 0.25
  pigment{color rgb <0.2, 0.0, 0.5>}
  translate <-0.18, 2.11, -0.14>
 }

  //left arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, -30.0>
   }
   scale     <1.20, 2.30, 1.00>
   rotate    <0.00, 0.00, 30.00>
   translate <1.01, -0.77, 0.01>
  }
  //right arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, 30.0>
   }
   scale     <1.20, 2.30, 1.00>
   rotate    <0.00, 0.00, -30.00>
   translate <-1.01, -0.77, 0.01>
  }

  //body
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient x
    color_map{
     [0.0 color rgb <0.0, 0.5, 0.5>]
     [0.1 color rgb <0.0, 0.3, 0.7>]
     [0.4 color rgb <0.0, 0.1, 0.9>]
     [0.6 color rgb <0.0, 0.6, 0.4>]
     [0.8 color rgb <0.0, 0.4, 0.6>]
     [1.0 color rgb <0.0, 0.2, 0.8>]
    }
    scale 0.5
    turbulence 0.2
   }
   scale     <2.10, 3.70, 1.00>
   translate <0.00, -1.28, 0.00>
  }

 //right foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color<0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, -30.00>
//  translate <-0.57, -3.58, 0.00>
  translate <-0.63, -3.5, 0.00>
 }
 //left foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color <0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, 30.00>
//  translate <0.63, -3.59, 0.00>
  translate <0.63, -3.50, 0.00>
 }
 //head
 union{
  cylinder {
   <0, 0, 0.5>,
   <0, 0, -0.5>,
   0.5
   pigment{color rgb <0.46, 0.25, 0.16>}
   scale     <1.10, 1.20, 1.00>
   translate <0.00, 1.03, 0.00>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <-0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <1.0, 0.0, 0.0>}
   translate <0.0, 0.75, -0.3>
  }
 }
 rotate<90, 0.0, 0.0>
}

/////////////////////////////////////////

#declare cookie_shape=
union{
 //hat
 box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   scale     <1.56, 0.50, 1.00>
   rotate    <0.00, 0.00, 18.00>
   translate <-0.16, 1.61, 0.00>
 }
 //left arm
 box {
  <-0.5, -0.5, -0.5>,
  <0.5, 0.5, 0.5>
  scale     <1.20, 2.30, 1.00>
  rotate    <0.00, 0.00, 30.00>
  translate <1.01, -0.77, 0.00>
 }
 //body
 box {
  <-0.5, -0.5, -0.5>,
  <0.5, 0.5, 0.5>
  scale     <2.10, 3.70, 1.00>
  translate <0.00, -1.28, 0.00>
 }
 //right arm
 box {
  <-0.5, -0.5, -0.5>,
  <0.5, 0.5, 0.5>
  scale     <1.20, 2.30, 1.00>
  rotate    <0.00, 0.00, -30.00>
  translate <-1.07, -0.71, 0.00>
 }
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, -30.00>
//  translate <-0.57, -3.58, 0.00>
  translate <-0.63, -3.5, 0.00>
 }
 //foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, 30.00>
//  translate <0.63, -3.59, 0.00>
  translate <0.63, -3.50, 0.00>
 }
 //foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  scale     <1.10, 1.20, 1.00>
  translate <0.00, 1.03, 0.00>
 }
 rotate<90, 0.0, 0.0>
}

////////////////////////////////////////////

#declare cookie_cutter=
 difference{
  object{
   cookie_shape
   scale <0.25, 0.75, 0.25>
  }
  object{
   cookie_shape
    scale <0.249, 0.80, 0.249>
  }
  scale <1.0, 0.5, 1.0>
 }

////////////////////////////////////////////

#declare cookie=
 object{cookie_shape
   scale <0.25, 0.5, 0.25>
 }

////////////////////////////////////////////

#declare cookie_man=
 object{cookie_man_shape
  scale <0.25, 0.25, 0.25>
 }

////////////////////////////////////////////

///////////////////////////////////////////////////////
////////        The March of the Cookie Graduates
///////////////////////////////////////////////////////
//1 front center
#debug " Cookie 1"
object{
 cookie_man
 normal{
  crackle
  turbulence 0.5
 }
 scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -45.0, 0.0>
 translate <45.5, 1.0+Floor_Down, -45.0>
 translate<30.0, 0.0, -30.0>
}
#debug " Cookie 2"
//2 under table
object{
 cookie_man
 normal{
  crackle
  turbulence 0.5
 }
 scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -25.0, 0.0>
 translate <43.5, 1.0 + Floor_Down, -40.5>
 translate <30.0, 0.0, -30.0>
}
#debug " Cookie 3"
//3 - on table
object{
 cookie_man
 normal{
  crackle
  turbulence 0.5
 }
 scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -30.0, 0.0>
 translate <41.5, 1.0, -40.5>
 translate<30.0, 0.0, -30.0>
}
#debug concat(" Cookie 4", chr(10))
//4 looking at cutter
object{
 cookie_man
 normal{
  crackle
  turbulence 0.5
 }
 scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -50.0, 0.0>
 translate <47.5, 1.0 + Floor_Down, -41.0>
 translate<30.0, 0.0, -30.0>
}

//////////////////////////////////////////////////////

#declare cookie_2_man_shape=
union{
 //hat
 box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{color <0.121555, 0.060733, 0.945234>}
   scale     <1.56, 0.50, 1.00>
   rotate    <0.00, 0.00, 18.00>
   translate <-0.16, 1.61, 0.00>
 }
 //tassle
 sphere{
  <0.0, 0.0, 0.0>, 0.25
  pigment{color rgb <0.2, 0.0, 0.5>}
  translate <-0.18, 2.11, -0.14>
 }

  //left arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, -60.0>
   }
   rotate <0.00, 0.00, 90.00>
   scale <1.20, 2.30, 1.00>
   rotate <0.0, 0.0, -45.0>
   translate <1.55, 0.72, 0.001>
  }
  //right arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, 60.0>
   }
   rotate <0.00, 0.00, 90.00>
   scale <1.20, 2.30, 1.00>
   rotate <0.0, 0.0, 45.0>
   translate <-1.55, 0.72, 0.001>
  }

  //body
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient x
    color_map{
     [0.0 color rgb <0.0, 0.5, 0.5>]
     [0.1 color rgb <0.0, 0.3, 0.7>]
     [0.4 color rgb <0.0, 0.1, 0.9>]
     [0.6 color rgb <0.0, 0.6, 0.4>]
     [0.8 color rgb <0.0, 0.4, 0.6>]
     [1.0 color rgb <0.0, 0.2, 0.8>]
    }
    scale 0.5
    turbulence 0.2
   }
   scale     <2.10, 3.70, 1.00>
   translate <0.00, -1.28, 0.00>
  }

 //right foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color<0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, -30.00>
//  translate <-0.57, -3.58, 0.00>
  translate <-0.63, -3.5, 0.00>
 }
 //left foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color <0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, 30.00>
//  translate <0.63, -3.59, 0.00>
  translate <0.63, -3.50, 0.00>
 }
 //head
 union{
  cylinder {
   <0, 0, 0.5>,
   <0, 0, -0.5>,
   0.5
   pigment{color rgb <0.46, 0.25, 0.16>}
   scale     <1.10, 1.20, 1.00>
   translate <0.00, 1.03, 0.00>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <-0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <1.0, 0.0, 0.0>}
   translate <0.0, 0.75, -0.3>
  }
 }
 rotate<90, 0.0, 0.0>
}
///////////////////////////////////////////////

#declare cookie_2_man=
 object{cookie_2_man_shape
  scale <0.25, 0.25, 0.25>
 }

///////////////////////////////////////////////

#debug concat(" Cookie 5", chr(10))
//5 both arms raised
object{
 cookie_2_man
 normal{
  crackle
  turbulence 0.5
 }
 //scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -90.0, 0.0>
 translate <36.5, 1.0 + Floor_Down, -47.0>
 translate<30.0, 0.0, -30.0>
}

//////////////////////////////////////////////

#declare cookie_3_man_shape=
union{
 //hat
 box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{color <0.121555, 0.060733, 0.945234>}
   scale     <1.56, 0.50, 1.00>
   rotate    <0.00, 0.00, 18.00>
   translate <-0.16, 1.61, 0.00>
 }
 //tassle
 sphere{
  <0.0, 0.0, 0.0>, 0.25
  pigment{color rgb <0.2, 0.0, 0.5>}
  translate <-0.18, 2.11, -0.14>
 }

  //left arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, -30.0>
   }
 //  rotate <0.00, 0.00, 90.00>
   scale <1.20, 2.30, 1.00>
 //  rotate <0.0, 0.0, -45.0>
 //  translate <1.55, 0.72, 0.001>
   rotate    <0.00, 0.00, 30.00>
   translate <1.01, -0.77, 0.00>

  }
  //right arm
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient y
    color_map{
     [0.0 color rgb <0.0, 0.2, 0.8>]
     [0.1 color rgb <0.0, 0.4, 0.6>]
     [0.4 color rgb <0.0, 0.6, 0.4>]
     [0.6 color rgb <0.0, 0.1, 0.9>]
     [0.8 color rgb <0.0, 0.3, 0.7>]
     [1.0 color rgb <0.0, 0.5, 0.5>]
    }
    turbulence 0.2
    scale 0.3
    rotate <0.0, 0.0, 60.0>
   }
   rotate <0.00, 0.00, 90.00>
   scale <1.20, 2.30, 1.00>
   rotate <0.0, 0.0, 60.0>
   translate <-1.55, 0.72, 0.001>
  }

  //body
  box {
   <-0.5, -0.5, -0.5>,
   <0.5, 0.5, 0.5>
   pigment{
    gradient x
    color_map{
     [0.0 color rgb <0.0, 0.5, 0.5>]
     [0.1 color rgb <0.0, 0.3, 0.7>]
     [0.4 color rgb <0.0, 0.1, 0.9>]
     [0.6 color rgb <0.0, 0.6, 0.4>]
     [0.8 color rgb <0.0, 0.4, 0.6>]
     [1.0 color rgb <0.0, 0.2, 0.8>]
    }
    scale 0.5
    turbulence 0.2
   }
   scale     <2.10, 3.70, 1.00>
   translate <0.00, -1.28, 0.00>
  }

 //right foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color<0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, -30.00>
//  translate <-0.57, -3.58, 0.00>
  translate <-0.63, -3.5, 0.00>
 }
 //left foot
 cylinder {
  <0, 0, 0.5>,
  <0, 0, -0.5>,
  0.5
  pigment{color <0.38628, 0.23, 0.18>}
  scale     <0.50, 1.00, 1.00>
  rotate    <0.00, 0.00, 30.00>
//  translate <0.63, -3.59, 0.00>
  translate <0.63, -3.50, 0.00>
 }
 //head
 union{
  cylinder {
   <0, 0, 0.5>,
   <0, 0, -0.5>,
   0.5
   pigment{color rgb <0.46, 0.25, 0.16>}
   scale     <1.10, 1.20, 1.00>
   translate <0.00, 1.03, 0.00>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <-0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <0.0, 0.0, 0.0>}
   translate <0.18, 1.17, -0.3>
  }
  sphere{<0.0, 0.0, 0.0>, 0.25
   pigment{color rgb <1.0, 0.0, 0.0>}
   translate <0.0, 0.75, -0.3>
  }
 }
 rotate<90, 0.0, 0.0>
}
///////////////////////////////////////////////

#declare cookie_3_man=
 object{cookie_3_man_shape
  scale <0.25, 0.25, 0.25>
 }

///////////////////////////////////////////////

#debug concat(" Cookie 6", chr(10))
//6 pointing at the cookie maker
object{
 cookie_3_man
 normal{
  crackle
  turbulence 0.5
 }
 //scale <1.0, 1.0, 1.0>
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -30.0, 0.0>
 translate <41.5, 1.0, -42.0>
 translate<30.0, 0.0, -30.0>
}

