
#declare ltSW1=off
#declare ltSW2=off
#declare ltSW3=off
#declare ltSWcloud=off
#declare ltSWstar=off
#declare ShowSun=off

#declare Marker_Radius= 1.0
#declare MarkScale= <1.0, 1.0, 1.0>
#declare HaloTextur =
texture {
   pigment {colour Clear}
   halo {
      cubic
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 0.5
      colour_map {
         [0 color rgbt <1,0,0,1>]
         [1 color rgbt <1,1,0,1>]
      }
      samples 10
   }
}

//1       ceiling
//2       back
//3       fore
//4       star sphere illumination
//99      cloud
//999     SUN
//12      ceiling/back
//13      ceiling/fore
//23      back/fore
//1999    ceiling/SUN
//2999    back/SUN
//3999    fore/SUN
//4999    star/SUN
//123     ceiling/back/fore
//12999   ceiling/back/SUN
//13999   ceiling/fore/SUN
//14999   ceiling/star/SUN
//23999   back/fore/SUN
//99999   cloud/SUN
//123999  ceiling/back/fore/SUN
//124999  ceiling/back/star/SUN
//1234999 ceiling/back/fore/star/SUN

#debug concat(" Light_Bank = ", str(Light_Bank, 0, 0), chr(10))

#switch (Light_Bank)
 #case (1)
  #declare ltSW1=on
 #break
 #case (2)
  #declare ltSW2=on
 #break
 #case (3)
  #declare ltSW3=on
 #break
 #case (4)
  #declare ltSWstar=on
 #break
 #case (12)
  #declare ltSW1=on
  #declare ltSW2=on
 #break
 #case (13)
  #declare ltSW1=on
  #declare ltSW3=on
 #break
 #case (23)
  #declare ltSW2=on
  #declare ltSW3=on
 #break
 #case (99)
  #declare ltSWstar=on
 #break
 #case (123)
  #declare ltSW1=on
  #declare ltSW2=on
  #declare ltSW3=on
 #break
 #case (4999)
  #declare ShowSun=on
  #declare ltSWstar=on
 #break
 #case (999)
  #declare ShowSun=on
 #break
 #case (1999)
  #declare ltSW1=on
  #declare ShowSun=on
 #break
 #case (2999)
  #declare ltSW2=on
  #declare ShowSun=on
 #break
 #case (3999)
  #declare ltSW3=on
  #declare ShowSun=on
 #break
 #case (12999)
  #declare ltSW1=on
  #declare ltSW2=on
  #declare  ShowSun=on
 #break
 #case (13999)
  #declare ltSW1=on
  #declare ltSW3=on
  #declare  ShowSun=on
 #break
 #case (14999)
  #declare ltSW1=on
  #declare ltSWstar=on
  #declare ShowSun=on
 #break
 #case (23999)
  #declare ltSW2=on
  #declare ltSW3=on
  #declare  ShowSun=on
 #break
 #case (99999)
  #declare ltSWstar=on
  #declare ShowSun=on
 #break
 #case (123999)
  #declare ltSW1=on
  #declare ltSW2=on
  #declare ltSW3=on
  #declare ShowSun=on
 #break
 #case (124999)
  #declare ltSW1=on
  #declare ltSW2=on
  #declare ltSWstar=on
  #declare ShowSun=on
 #break
 #case (1234999)
  #declare ltSW1=on
  #declare ltSW2=on
  #declare ltSW3=on
  #declare ltSWstar=on
  #declare ShowSun=on
 #break
#end

//////////////////////////////////////
// 1 ceiling light
 #declare ltCOL1=<1.0, 1.0, 1.0>
 #declare ltLOC1=<60.0+30.0, 20.0, -60.0-30.0>
 #declare ltPtAt1=<0.0+30.0, Floor_Down, 0.0-30.0>
 #declare ltRad1=75.0
 #declare ltFall1=85.0

 #declare ltFade1=0.01
 #declare ltFadeDist1=vlength(ltLOC1-ltPtAt1)
#if (ltSW1=on)
 #debug concat(" ltSW1 = ON ")
 #debug concat(" vlength lt1 ", str(vlength(ltLOC1-ltPtAt1),2,0),chr(10))
 light_source{
   ltLOC1
   color rgb ltPW1*ltCOL1
   //#debug concat(chr(10), " ltPw1 ", str(ltPW1,0,2), " ltCOL1 ", str(ltCOL1.x,0,2),str(ltCOL1.y,0,2),str(ltCOL1.z,0,2), chr(10))
   shadowless
   spotlight
   point_at ltPtAt1
   radius ltRad1
   falloff ltFall1
   tightness 0.00005
   //looks_like {Object}
   fade_distance ltFadeDist1
   fade_power ltFade1
   //atmospheric_attenuation bol
 }
#if (ShowSight=on)
   #debug concat(chr(10), " ShowSight = on ")
    cylinder{
     ltLOC1, ltPtAt1, 0.25
     open
     pigment{color Clear}
     hollow
     no_shadow
     halo{
      emitting
      linear
      cylindrical_mapping
       color_map{
        [0.0 rgbt ltPW1*ltCOL1]
        [1.0 rgbt ltPW1*ltCOL1/8]
       }
     }
    }
#end

 #if (ShowHalo=on)
     cone{
      <0.0, 100.0, 0.1>, 0.0, <0.0, 0.0, 0.0>, 20.0//ltLOC1, 0.0, ltPtAt1, ltFadeDist1
      open
     //sphere{<0.0, 10.0, 0.0>, 30.0
      hollow
     // texture{HaloTextur}
     // scale 4.0
     //}

       pigment{color Clear}
       halo{
        linear
        max_value 3.0
        spherical_mapping
        emitting
        color_map{
         [0.0 color rgbt <1.0, 0.0, 0.0, 1.0>]//ltPW1*ltCOL1*0.125]
         [1.0 color rgbt <1.0, 1.0, 0.0, 0.0>]//ltPW1*ltCOL1*ltFade1*<1.0, 1.0, 0.0, 0.0, 0.25>]
        }
       turbulence 0.5
       samples 10
       /*
       aa_level 3
       aa_threshold 0.2
       jitter 0.1
       */
       }
      }



 #end


 #if (ShowMark = on)
  cylinder{<0.0, 0.0+Floor_Down, -1.0>,
           <0.0, 0.01+Floor_Down, -1.0>,
           (Marker_Radius * (40.0+abs(Floor_Down)))
   no_shadow
   pigment{color rgbft <1.0, 0.85, 1.0, (5*40.0)/100, 1.5-((5*40.0)/100)>
   }
   scale MarkScale
  }
 #end
#end
//////////////////////////////////////////////////

// 2 back light
#if (ltSW2=on)
#debug concat(" ltSW2 = ON ")
 #declare ltCOL2=<1.0, 1.0, 1.0>
 #declare ltLOC2=<60.0+30.0, 6.0, -60.0-30.0>
 #declare ltPtAt2=<42.0+30.0, 0.0, -42.0-30.0>
 #declare ltRad2=15.0
 #declare ltFall2=25.0
 #declare ltFade2=0.1
 #declare ltFadeDist2=vlength(ltLOC2-ltPtAt2)

  light_source{
   ltLOC2
   color rgb ltPW2*ltCOL2
   spotlight
   point_at ltPtAt2
   radius ltRad2
   falloff ltFall2
   tightness 0.01
   //looks_like {Object}
   fade_distance ltFadeDist2
   fade_power ltFade2
#debug concat(" vlength lt2 ", str(vlength(ltLOC2-ltPtAt2),2,0),chr(10))

   //atmospheric_attenuation bol
   //
  }
  #if (ShowSight=on)
   cylinder{
    <45.0, (20.0 + 0.25), -45.0>, <45.0, (0.0+Floor_Down + 0.25), -45.0>, 0.25
     open
     pigment{color White}
     finish{ambient 1.0 reflection 0.5 diffuse 0.0}
     hollow
    }
  #end
  #if (ShowMark = on)
  cylinder{<18.5, 0.0+Floor_Down, -18.5>,
           <18.5, 0.01+Floor_Down, -18.5>,
           (Marker_Radius * (13.0+abs(Floor_Down)))
   pigment{color rgbft <0.75, 0.75, 0.75, (5*13.0)/100, 1.5-((5*13.0)/100)>
   }
   scale MarkScale
  }
 #end
#end
////////////////////////////////////////

// 3 light
#if (ltSW3=on)
#debug concat (" ltSW3 = ON ")
 light_source{
  <-15, 15.0, 0.0>
  color rgb ltPW3*<1.0, 1.0, 1.0>
  spotlight
  point_at <-45.0, Floor_Down, 45.0>
  radius 40.0
  falloff 45.0
  tightness 5
  //looks_like {Object}
  fade_distance vlength(ltLOC3-ltPtAt3)
  fade_power 0.1
#debug concat(" vlength lt3 ", str(vlength(ltLOC3-ltPtAt3),2,0),chr(10))
  //atmospheric_attenuation bol
   //
  }
#end
//////////////////////////////////////////////////////

//4 star sphere illumination

 #declare ltCOLstar=<1.0, 1.0, 1.0>
 //#declare ltLOCstar=<-Floor_Span-100.0, 100.0, Floor_Span-100.0>
 #declare ltLOCstar=<-60.0, -0.00001, 60.0>
 #declare ltPtAtstar=<-Star_Radius, 0.0, Star_Radius>
 #declare ltRadstar=40
 #declare ltFallstar=45
 #declare ltFadestar=0.01
 #declare ltFadeDiststar=3*Star_Radius
#if (ltSWstar=on)
 #debug concat(" ltSWstar = ON ")
 light_source{
   ltLOCstar
   color rgb ltPWstar*ltCOLstar
   /*
   #debug concat(chr(10), " ltPwstar ", str(ltPWstar,0,2), " ltCOLstar ", str(ltCOLstar.x,0,2),str(ltCOLstar.y,0,2),str(ltCOLstar.z,0,2), chr(10))
   */
   shadowless
   /*
   spotlight
   point_at ltPtAtstar
   radius ltRadstar
   falloff ltFallstar
   tightness 5
   //looks_like {Object}
   fade_distance ltFadeDiststar
   fade_power ltFadestar
   //atmospheric_attenuation bol
   */
 }
#if (ShowSight=on)
   #debug concat(chr(10), " ShowSight = on ")
    cylinder{
     ltLOCstar, ltPtAtstar, 0.25
     open
     pigment{color Clear}
     hollow
     no_shadow
     halo{
      emitting
      linear
      cylindrical_mapping
       color_map{
        [0.0 rgbt ltPWstar*ltCOLstar]
        [1.0 rgbt ltPWstar*ltCOLstar/8]
       }
     }
    }
#end

 #if (ShowHalo=on)
     cone{
      <0.0, 100.0, 0.1>, 0.0, <0.0, 0.0, 0.0>, 20.0//ltLOC1, 0.0, ltPtAt1, ltFadeDist1
      open
     //sphere{<0.0, 10.0, 0.0>, 30.0
      hollow
     // texture{HaloTextur}
     // scale 4.0
     //}

       pigment{color Clear}
       halo{
        linear
        max_value 3.0
        spherical_mapping
        emitting
        color_map{
         [0.0 color rgbt <1.0, 0.0, 0.0, 1.0>]//ltPW1*ltCOL1*0.125]
         [1.0 color rgbt <1.0, 1.0, 0.0, 0.0>]//ltPW1*ltCOL1*ltFade1*<1.0, 1.0, 0.0, 0.0, 0.25>]
        }
       turbulence 0.5
       samples 10
       /*
       aa_level 3
       aa_threshold 0.2
       jitter 0.1
       */
       }
      }



 #end


 #if (ShowMark = on)
  cylinder{<0.0, 0.0+Floor_Down, -1.0>,
           <0.0, 0.01+Floor_Down, -1.0>,
           (Marker_Radius * (40.0+abs(Floor_Down)))
   no_shadow
   pigment{color rgbft <1.0, 0.85, 1.0, (5*40.0)/100, 1.5-((5*40.0)/100)>
   }
   scale MarkScale
  }
 #end
#end


//////////////////////////////////////////////////////

//99 starlight
#if (ltSWcloud=on)
 light_source{
  <50.0, 24.0, 50.0>
  color rgb 10*<1.0, 1.0, 1.0>
 }
#end

/////////////////////////////////////////////////////
//#debug concat(chr(10), " ")
#include "UNIVERSE.INC"
