
// Persistence of Vision Ray Tracer Scene Description File
// File: room.inc
// Vers: 3
// Desc:
// Date:
// Auth:

#declare ShowFloorFog=on
#declare ShowTreeFog=on
#declare Wall_Span=60.0
#declare ShowCeiling=on
#declare ShowFloor=on
#declare Floor_Down= -2.5
#declare Floor_Span= 120.0
#declare ShowWalls=on
#declare ShowBlock=on
#declare Scene_Caustics=0.5//0.000005
#declare ShowObj=off

#if (ShowWalls=on)
//Quick n & w walls to contrast trees
#debug concat(" ShowWalls ", chr(10))
#declare SF_Glass4 =
finish {
    ambient 0.1
    diffuse 0.1
    reflection 0.00001
    refraction on
    ior 1.5
    specular 1
    roughness 0.001
}



#declare ST_Glass1 =                                //T_Emerald_Glass?
 texture{
  hexagon
  texture{
   pigment{ color rgbft <0.1, 0.9, 0.2, 0.05, 0.7>}
   finish{SF_Glass4}
  },
  texture{                                           //T_Ruby_Glass
   pigment{ color rgbft <0.9, 0.1, 0.2, 0.05, 0.7>}
   finish{SF_Glass4}
  },
  texture{                                           //T_Yellow_Glass
   pigment { color rgbft <0.8, 0.8, 0.2, 0.005, 0.7>}
   finish{SF_Glass4}
  }
  //rotate <0.00, 90.00, 0.00>
  scale 0.125

 }


#declare WestAStandard_Block=
union{
 ////DIF
 difference{
 ////INT
  intersection{
   box{
    <0.0, 0.0, 0.0>, <1.0, 1.0, 1.0>
   }
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.45
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.45
   }
  }
 ////ENDINT
 ////UNI
  union{
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.42
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.42
   }
  }
 ////ENDUNI
 }
 ////ENDDIF
//west
 object{
  difference{
   cylinder{
    < -0.005, 0.00, 0.00>,
    <  0.005, 0.00, 0.00>,
     0.3
    texture{ST_Glass1
    rotate <0.00, 0.00, -90.00>
    }
   // rotate <0.0, 0.0, -45.00>
    translate <0.50, 0.50, 0.50>
   }//endcylinder

   sphere{
    <0.00, 0.00, 0.00>,
     0.3
    texture{ST_Glass1
    //rotate <0.00, 0.00, -90.00>
    }
    //rotate <0.0, 0.0, 45.00>
    translate <0.25, 0.50, 0.35>
  //  rotate <0.0, 0.0, -45.00>
   }//endsphere

  //hollow
  }//end dif
 }//endobject

}//endunion

#declare BStandard_Block=
 difference{
  box{
   <0.0, 0.0, 0.0>, <1.0, 1.0, 1.0>
  }
  union{
   box{<-0.1, 0.1, 0.05>, <1.1, 0.9, 0.95>
   }
   box{<0.05, 0.1, -0.1>, <0.95, 0.9, 1.1>
   }
   box{<0.05, -0.1, 0.05>, <0.95, 1.1, 0.95>
   }
  }
 }

#declare WestStandard_Block=
 union{
  object{
   WestAStandard_Block
  }
  object{
   BStandard_Block
  }
 }

//west wall
#debug " West wall "

#declare Blocks=2.0
#declare Left_Wall_Height=36.0
#declare Left_Wall_Rows=2
#declare Block_Length=(2*Wall_Span)/Blocks
#declare Block_Height=(Left_Wall_Height/Left_Wall_Rows)
#declare Block_Thick=20.0
#declare Block_Mortar=Block_Length*0.015
#declare Left_Block=
 object{WestStandard_Block
  //texture{T_Stone15}
  texture{T_Stone28}
  hollow
  scale <Block_Thick, Block_Height-Block_Mortar, Block_Length-Block_Mortar>
 }

///////////////////////////////////////////////
#declare Block_Pattern=0
#declare CountR=0


 #while (CountR<Left_Wall_Rows)
 #debug concat(chr(10), " Layer ", chr(10))
  #switch (Block_Pattern)
   #case (0)// first, third, etc. layer
    #declare CountB=-Floor_Span
     #while (CountB<Floor_Span)
      object{
       Left_Block
       //no_shadow
       translate <-Floor_Span, Floor_Down+(CountR*Block_Height), CountB>
      }
      #debug concat(" Block ", " ")

     #declare CountB=CountB + (Block_Length)
     #end
     #declare Block_Pattern=1
   #break
   #case (1)// second, fourth, etc. layer
    #declare CountB=-Floor_Span
    object{
    union{
     #while (CountB<Floor_Span)//(CountB<Floor_Span+Block_Length)
      object{
       Left_Block
       //no_shadow
       translate <-Floor_Span, Floor_Down+(CountR*Block_Height), CountB-(Block_Length/2)>
      }
      #debug concat(" Block ", " ")

     #declare CountB=CountB + (Block_Length)
     #end
    }
    clipped_by{plane{<0.0, 0.0, 1.0>, Floor_Span}}
    }
    #declare Block_Pattern=0
   #break
  #end// end of switch
  /*
  box{
   <-Floor_Span, ((CountR + 0.25) * Block_Height), -Floor_Span>,
   <-Floor_Span + Block_Thick, ((CountR + 0.4) * Block_Height), Floor_Span>
   pigment{color Green}
  }
  */
  #declare CountR=CountR+1
 #end // finish of row laying


///////////////////////////////////////////////
//north wall
#debug concat(chr(10), " North wall ")

#declare Blocks=2.0
//12 blks per wall span=60
#declare Right_Wall_Height=36.0
#declare Right_Wall_Rows=2//each 18.0
#declare Block_Length=(2*Wall_Span)/Blocks//24
#declare Block_Height=(Right_Wall_Height/Right_Wall_Rows)//18.0
#declare Block_Thick=20.0
#declare Block_Mortar=Block_Length*0.015
#declare NorthAStandard_Block=
union{
 ////DIF
 difference{
 ////INT
  intersection{
   box{
    <0.0, 0.0, 0.0>, <1.0, 1.0, 1.0>
   }
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.45
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.45
   }
  }
 ////ENDINT
 ////UNI
  union{
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.42
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.42
   }
  }
 ////ENDUNI
 }
 ////ENDDIF
//north
 object{
  difference{

    cylinder{
     <0.000, 0.00, -0.005>,
     <0.000, 0.00, 0.005>,
     0.3
     texture{ST_Glass1
      rotate <  0.00, -90.00, 0.00>
      rotate <-90.00,   0.00, 0.00>
     }
    // rotate <-45.00, 0.0, 0.0>
     translate <0.5, 0.50, 0.50>
    }//endcylinder

    sphere{
     <0.00, 0.00, 0.00>,
     0.3
     texture{ST_Glass1
      rotate <  0.00, -90.00, 0.00>
      rotate <-90.00,   0.00, 0.00>
     }
     //rotate <45.00, 0.0, 0.0>
     translate <0.65, 0.50, 0.25>
    // rotate <-45.00, 0.0, 00>
    }//endsphere

   }//end dif
  }//endobject

}//endunion

#declare NorthStandard_Block=
 merge{
  object{
   NorthAStandard_Block
  }
  object{
   BStandard_Block
  }
 }

#declare Right_Block=
 object{NorthStandard_Block
  //texture{T_Stone15}
  texture{T_Stone28}
/*
  pigment{color White}
  normal{
   crackle
    normal_map{
     [0.0  bumps 0.8]
     [0.5  granite turbulence 0.9]
    }
   turbulence 0.5
  }
*/
  hollow
  scale <Block_Length-Block_Mortar, Block_Height-Block_Mortar,  Block_Thick>
 }

#declare Block_Pattern=1
#declare CountR=0


 #while (CountR<Right_Wall_Rows)
 #debug concat(chr(10), " Layer ", chr(10))
  #switch (Block_Pattern)
   #case (0)// second, fourth, etc. layer
    #declare CountB=-Floor_Span
    object{
    union{
     #while (CountB<Floor_Span)//(CountB<Floor_Span+Block_Length)
      object{
       Right_Block
       //no_shadow
       translate <CountB+(Block_Length/2), Floor_Down+(CountR*Block_Height), Floor_Span-Block_Thick>
       //translate <CountB, Floor_Down+(CountR*Block_Height), Floor_Span>
      }
      #debug concat(" Block ", " ")

     #declare CountB=CountB + (Block_Length)
     #end
    }
    //clipped_by{plane{<1.0, 0.0, 0.0>, -Floor_Span}}
    }
    #declare Block_Pattern=1
   #break
   #case (1)// first, third, etc. layer
    #declare CountB=-Floor_Span
     #while (CountB<Floor_Span)
      object{
       Right_Block
       //no_shadow
       translate <CountB, Floor_Down+(CountR*Block_Height), Floor_Span-Block_Thick>
      }
      #debug concat(" Block ", " ")

     #declare CountB=CountB + (Block_Length)
     #end
     #declare Block_Pattern=0
   #break
  #end// end of switch
  #declare CountR=CountR+1
 #end // finish of row laying
#end // end of if showwalls

/////////////////////////////////////
#if (ShowObj=on)
#declare obj_violet1 = colour rgbf<1.0, 0.5, 1.0, 0.9>//0.1>
#declare obj_violet2 = colour rgbf<1.0, 0.3, 1.0, 0.9>//0.1>
#declare obj_indigo  = colour rgbf<0.5, 0.5, 1.0, 0.9>//0.2>
#declare obj_blue    = colour rgbf<0.2, 0.2, 1.0, 0.9>//0.2>
#declare obj_cyan    = colour rgbf<0.2, 1.0, 1.0, 0.9>//0.2>
#declare obj_green   = colour rgbf<0.2, 1.0, 0.2, 0.9>//0.2>
#declare obj_yellow  = colour rgbf<1.0, 1.0, 0.2, 0.9>//0.2>
#declare obj_orange  = colour rgbf<1.0, 0.5, 0.2, 0.9>//0.1>
#declare obj_red1    = colour rgbf<1.0, 0.2, 0.2, 0.9>//0.1>
#declare obj_red2    = colour rgbf<1.0, 0.2, 0.0, 0.9>//0.1>

//far corner wall object
#declare Deco=
object{
 intersection{
  union{
   torus{1.00, 0.05 pigment{color obj_violet1 transmit 0.2}}//0.90}}
   torus{0.90, 0.05 pigment{color obj_violet2 transmit 0.2}}//0.90}}
   torus{0.80, 0.05 pigment{color obj_indigo  transmit 0.2}}//0.80}}
   torus{0.70, 0.05 pigment{color obj_blue    transmit 0.3}}//0.95}}
   torus{0.60, 0.05 pigment{color obj_cyan    transmit 0.35}}//0.75}}
   torus{0.50, 0.05 pigment{color obj_green   transmit 0.55}}//0.75}}
   torus{0.40, 0.05 pigment{color obj_yellow  transmit 0.60}}//0.75}}
   torus{0.30, 0.05 pigment{color obj_orange  transmit 0.55}}//0.75}}
   torus{0.20, 0.05 pigment{color obj_red1    transmit 0.4}}//0.85}}
   torus{0.10, 0.05 pigment{color obj_red2    transmit 0.4}}//0.80}}
  }//end uni
  sphere{
   <0.0, 0.0, 0.0>, 5.00
   texture{pigment{color Clear}}
  }//end sphere
 }//end dif
 finish{   //fglass4
  ambient 1.0
  diffuse 0.1
  reflection .95
  refraction 1
  ior 2.5
  specular 1
  roughness 0.001
 }
 rotate <-90.0, 0.0, 0.0>
 rotate <0.0, -45.0, 0.0>
 scale <10.0, 10.0, 10.0>
 translate <-50, 25.00, 50>
}

object{Deco}

#debug concat(chr(10), " Deco ", chr(10))
#end


////////////////////////////////////////




///////////////////////////////////////
#if (ShowBlock=on)
#declare SoloAStandard_Block=

 ////DIF
 difference{
 ////INT
  intersection{
   box{
    <0.0, 0.0, 0.0>, <1.0, 1.0, 1.0>
   }
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.45
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.45
   }
  }
 ////ENDINT
 ////UNI
  union{
   cylinder{<0.5, 0.5, -0.1>, <0.5, 0.5, 1.1>,
    0.42
   }
   cylinder{<-0.1, 0.5, 0.5>, <1.1, 0.5, 0.5>,
    0.42
   }
  }
 ////ENDUNI
 }
 ////ENDDIF



#declare T_Block=
 merge{
  object{
   SoloAStandard_Block
  }
  object{
   BStandard_Block
  }
 }


#declare TBlocks=20
#declare T_Wall_Height=12.0
#declare T_Wall_Rows=3//6
#declare TBlock_Length=(2*Wall_Span)/TBlocks
#declare TBlock_Height=(T_Wall_Height/T_Wall_Rows)
#declare TBlock_Thick=2.0
#declare TBlock_Mortar=TBlock_Length*0.1
#declare Temple_Block=
 object{T_Block
  //texture{T_Stone15}
  texture{T_Stone28}
  hollow
 }
/*
object{
 Temple_Block
 //rotate <0.0, 45.0, 0.0>
  scale <(1.5 * TBlock_Thick), ((TBlock_Height-TBlock_Mortar) * 1.5), (1.5 * (TBlock_Length-TBlock_Mortar))>
  //translate <40.0, (Floor_Down), -25.0>
  //translate<30.0, 0.0, -30.0>
  translate <41.0, Floor_Down, -55>
}
*/
#debug concat(" Solo Block ", chr(10))
object{
 Temple_Block
  scale <(9.5 * TBlock_Thick), ((TBlock_Height-TBlock_Mortar) * 8.0), (3.75 * (TBlock_Length-TBlock_Mortar))>
  translate <-Floor_Span, 14.5, Floor_Span-20>
}

#end
///////////////////////////////////////////////



#if (ShowFloor=on)
#debug concat (" Floor ", chr(10))
#declare Floor=
 box{
  <-Floor_Span, Floor_Down-0.01, -Floor_Span>,
  <Floor_Span, Floor_Down, Floor_Span>
  pigment{
   image_map {tga "parque55.tga"}
    scale   <8.0, 8.0, 1.0>
    rotate <90.0, 0.0, 0.0>
  }
  no_shadow
  hollow
 }

object{Floor}
#end

//////////////////////////////////////////////

#declare S_Cloud1 =
texture {
    pigment {
        bozo
        turbulence 0.2
        octaves 1
        omega .5
        lambda 2.5
        color_map {
         [0.0 color rgbf<.75, .75, .75, 0.0>]
         [0.3 color rgbf<.9, .9, .9, .9>]
         [0.5 color rgbf<1, 1, 1, 1>]
         [1.0 color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 1.0
        diffuse 0.0

    }
  scale 16
}
texture {
    pigment {
        bozo
        turbulence 0.9
        octaves 10
        omega .5
        lambda 2.5
        color_map{
         [0.0 color rgbf<.75, .75, .75, 0>]
         [0.4 color rgbf<.9, .9, .9, .9>]
         [0.8 color rgbf<1.00, 1.00, 1.00, 1.00>]
         [1.0 color rgbf<1.00, 1.00, 1.00, 1.00>]
        }
    }
    finish {
        ambient 0.95
        diffuse 0.0
    }
scale 8
translate <0.0, 1.0, 0.0>*-0.15
}

#declare S_Cloud2 =
texture {
    pigment {
        bozo
        turbulence 0.88//0.2
        octaves 1
        omega .5
        lambda 2.5
        color_map {
         [0.0 color rgbf<.75, .75, .75, 0.65>]
         [0.3 color rgbf<.9, .9, .9, .9>]
         [0.5 color rgbf<1, 1, 1, 1>]
         [1.0 color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 1.0
        diffuse 0.0
    }
  scale 16
}
texture {
    pigment {
        bozo
        turbulence 0.9
        octaves 10
        omega .5
        lambda 2.5
        color_map{
         [0.0 color rgbf<.75, .75, .75, .65>]
         [0.4 color rgbf<.9, .9, .9, .9>]
         [0.8 color rgbf<1.00, 1.00, 1.00, 1.00>]
         [1.0 color rgbf<1.00, 1.00, 1.00, 1.00>]
        }
    }
    finish {
     ambient 0.95
     diffuse 0.0
    }
scale 8
translate <0.0, 1.0, 0.0>*-0.15
}

#declare Sky1_Radius=5000.0
#declare Sky2_Radius=3000.0
#if (ShowCeiling =on)
#debug concat( " Ceiling ", chr(10))

#declare Ceiling=

union{
 sphere{<0.0, 0.0, 0.0>, Sky1_Radius
  texture{S_Cloud1
   scale <16.0, 1.0, 16.0>
   finish{ caustics Scene_Caustics}
   }
  //rotate <0.0, 45.0, 0.0>
  translate <0.0, -(Sky1_Radius-100.0), 0.0>
 }
#debug concat(" Sky1 ", chr(10))

 sphere{<0.0, 0.0, 0.0>, Sky2_Radius
  texture{S_Cloud1
   scale <8.0, 1.0, 8.0>
   finish{ caustics Scene_Caustics}
  }
  translate <0.0, -(Sky2_Radius-100.0), 0.0>
 }
#debug concat(" Sky2 ", chr(10))

 clipped_by{
  plane{
  <tan(radians(0.0)), -1, -tan(radians(0.0))>, 0.0
  hollow
  }
 }
 #debug concat(" Clip plane ", chr(10))

}//end union

object{Ceiling}
#end //end of ShowCeiling)

/////////////////////////////////////////////////
//fog
#declare Tree_Fog=
 object{
  box{
   <(2*(-Floor_Span)), 16, (2*(-Floor_Span))>, <2*Floor_Span, 35.00, 2*Floor_Span>
   texture{S_Cloud1
    scale <2.0, 1.0, 2.0>
    finish{
     caustics Scene_Caustics
    }
   }
   //rotate <0.0, 90.0, 0.0>
  }
 }

#declare Floor_Fog=
 object{
  box{
   <(2*(-Floor_Span)), Floor_Down, (2*(-Floor_Span))>, <2*Floor_Span, Floor_Down + 0.07, Floor_Span*2>
   texture{S_Cloud2
    //scale <2.0, 1.0, 2.0>
    finish{
     caustics Scene_Caustics
    }
   }
   rotate <0.0, 45.0, 0.0>
  }
 }


#if (ShowTreeFog=on)
 object{Tree_Fog}
 #debug concat(" Tree fog ", chr(10))
#end

#if (ShowFloorFog=on)
 object{Floor_Fog}
 #debug concat(" Floor fog ", chr(10))
#end

#declare Bulb=
 sphere{
   <0.00, 0.00, 0.00>, 1.5
   texture{
    pigment { color Clear
    }
    finish  {
     specular 1
     roughness 0.001
     ambient 0
     diffuse 0
     refraction 1
     reflection 0.1
     ior 1.5
    }
   }
   //scale <3.0, 0.005, 3.0>
  }
