#declare ShowRainbow=off
#declare Sky_Switch=0
#declare StarfieldTextureScale=1.0 //blue
#debug concat(" Universe ", chr(10))


#declare Starfield =
 texture{
  pigment {
   granite
   color_map {
    [0.000 color rgb <0.5, 0.5, 0.8>]
    [0.270 color rgb <0.5, 0.5, 0.9>]
    [0.270 color rgb <0.8, 0.8, 0.9>]
    [0.285 color rgb <0.7, 0.7, 0.9>]
    [0.285 color rgb <0.5, 0.5, 0.8>]
    [0.470 color rgb <0.65, 0.65, 0.7>]
    [0.470 color rgb <0.4, 0.4, 0.6>]
    [0.485 color rgb <0.4, 0.4, 0.8>]
    [0.485 color rgb <0.4, 0.4, 0.6>]
    [0.680 color rgb <0.5, 0.5, 0.6>]
    [0.680 color rgb <0.5, 0.4, 0.8>]
    [0.695 color rgb <0.5, 0.5, 0.7>]
    [0.695 color rgb <0.6, 0.6, 0.9>]
    [0.880 color rgb <0.4, 0.4, 0.8>]
    [0.880 color rgb <0.5, 0.5, 0.5>]
    [0.895 color rgb <1.0, 1.0, 1.0>]
    [0.895 color rgb <0.6, 0.6, 0.9>]
    [1.000 color rgb <0.7, 0.7, 1.0>]
   }
   turbulence 1.0
   sine_wave
   }
  //finish{ diffuse 0.0 ambient 1.0 reflection 0.0}
  scale StarfieldTextureScale
 }
#if (ShowSky=on)
#debug concat(" ShowSky ", chr(10))

#switch (Sky_Switch)
 #case (0)

  sky_sphere{
   pigment{
    gradient y
    color_map {
     [0.00 color rgb <0.35, 0.35, 0.35>]
     [0.10 color rgb <0.55, 0.55, 0.75>]
     [0.25 color rgb <0.3, 0.3, 1.0>]
     [0.55 color rgb <0.5, 0.5, 1.0>]
     [0.65 color rgb <0.6, 0.6, 1.0>]
    }
   }
   scale 0.5
   //translate -1
  }
/*
  sphere{<0.0, 0.0, 0.0>, Star_Radius
   hollow
   texture{
    Starfield
   }
*/
/*
   clipped_by{
    plane{<tan(radians(0.0)), -tan(radians(0.0)), -1.0>, 0.0
    hollow
    }
   }
*/
/*
   clipped_by{
    plane{<tan(radians(0.0)), -1, -tan(radians(-90.0))>, 0.0
    hollow
    }
   }
*/
/*
   clipped_by{
    plane{<1.0, -tan(radians(90)), -tan(radians(0.0))>, 0.0}
   }
*/
/*
   rotate <0.0, -45.0, 0.0>
   translate <0.0, -100.0, 0.0>
   //rotate <0.0, 0.0, 45.0>
   }
*/
 #break

 #case (1)
  sky_sphere{
   pigment{
    gradient y
    color_map {
     [0.0 color rgb <0.75, 0.75, 0.95>]
     [1.0 color rgb 1]
    }
   }
  scale 2
  translate -0.5
 }
 #break

 #case (2)
  sphere{<0.0, 0.0, 0.0>, 200
   texture{
    Starfield
   }
   hollow
   clipped_by{
    plane{z, 0.0}
   }
   rotate <0.0, 180.0, 0.0>
  }
 #break

 #case(3)

  sky_sphere{

   pigment{
    gradient y
    color_map {
     [0.00 color rgb <0.35, 0.35, 0.35>]
     [0.30 color rgb <0.55, 0.55, 0.75>]
     [0.45 color rgb <0.0, 0.0, 1.0>]
     [0.95 color rgb <0.5, 0.5, 1.0>]
    }
   }

  scale 0.40
  }

  sphere{<0.0, 0.0, 0.0>, Star_Radius
   hollow
   texture{
    Starfield
   }

   clipped_by{
    plane{<tan(radians(0.0)), -tan(radians(-90.0)), -1.0>, 0.0
    hollow
    }
   }
   clipped_by{
    plane{<tan(radians(0.0)), -1, -tan(radians(0.0))>, 0.0
    hollow
    }
   }
/*
   clipped_by{
    plane{<1.0, -tan(radians(90)), -tan(radians(0.0))>, 0.0}
   }
*/
   rotate <0.0, -45.0, 0.0>
   //rotate <0.0, 0.0, 45.0>
   }

 #break
 #end
#end
////////////////////////////////////////////////////

#if (ShowRainbow=on)
#debug concat(" Rainbow ", chr(10))

#declare r_violet1 = colour rgbf<1.0, 0.5, 1.0, 0.4>
#declare r_violet2 = colour rgbf<1.0, 0.5, 1.0, 0.5>
#declare r_indigo  = colour rgbf<0.5, 0.5, 1.0, 0.6>
#declare r_blue    = colour rgbf<0.2, 0.2, 1.0, 0.6>
#declare r_cyan    = colour rgbf<0.2, 1.0, 1.0, 0.6>
#declare r_green   = colour rgbf<0.2, 1.0, 0.2, 0.6>
#declare r_yellow  = colour rgbf<1.0, 1.0, 0.2, 0.6>
#declare r_orange  = colour rgbf<1.0, 0.5, 0.2, 0.6>
#declare r_red1    = colour rgbf<1.0, 0.2, 0.2, 0.5>
#declare r_red2    = colour rgbf<1.0, 0.2, 0.2, 0.4>


#declare Rainbow_Color_Map=
colour_map {
      [0.000  colour r_violet1 transmit 0.93]
      [0.100  colour r_violet2 transmit 0.92]
      [0.214  colour r_indigo  transmit 0.91]
      [0.328  colour r_blue    transmit 0.90]
      [0.442  colour r_cyan    transmit 0.88]
      [0.556  colour r_green   transmit 0.90]
      [0.670  colour r_yellow  transmit 0.91]
      [0.784  colour r_orange  transmit 0.92]
      [0.900  colour r_red1    transmit 0.93]
    }
 rainbow {
    direction <-2.00, 0.37, 2.0>
    angle 2.9
    width 20.0
    distance 65
    //jitter 0.03
    color_map { Rainbow_Color_Map }
    up <0, 1, 0>
    arc_angle 360
    falloff_angle 0.0
   }
#end

///////////// SUN ///////////////
#debug concat(" vlength SUN -> floor center ", str(vlength(<XSun, YSun, ZSun>-<0.0, Floor_Down, 0.0>),0, 2), chr(10))
#declare Sun_Sphere=
  sphere{<0.0, 0.0, 0.0>, Sun_Radius
  texture{T_Yellow_Glass}
  }
#declare ltPtAtSUN= <0.0, Floor_Down, 0.0>
#declare ltRadSUN= 20
#declare ltFallSUN= 30.0
#declare ltFadeDistSUN=vlength(<XSun, YSun, ZSun>-<0.0, Floor_Down, 0.0>)
#declare ltFadeSUN= 1.0
#declare Sun=
  object{
   light_source{
    <XSun, YSun, ZSun>
    color rgb Sunshine*<1.0, 1.0, 0.0>
    /*
    spotlight
     point_at ltPtAtSUN
     radius ltRadSUN
     falloff ltFallSUN
     tightness 5
     looks_like {Sun_Sphere}
     fade_distance ltFadeDistSUN
     fade_power ltFadeSUN
     //atmospheric_attenuation bol
    */
   }
  }

#if (ShowSun = on)
 object{Sun}
#debug concat(" Sun is Shining ", chr(10))

#end
