// Detention
// Created for the March/April 1997
// Internet Raytracing Competition
// By The Butter-Fingered Juggler

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "school.inc"
#include "dolphin.inc"
#include "galleon.inc"

camera {
   location  <-5, 6, -10>
   look_at   <0, 3, 0.01>
}

// Bright light to left and above main screen
light_source {<-5, 15, -20> color White}

// ---------------------------------------

background {color rgb <0.7, 0.9, 0.8>}

// blur background
// ground fog used to allow background color to show
// through at top - to lighten the fog at the top

fog {
    fog_type 2
    distance 30
    color rgb <0.3, 0.5, 0.4>
    turbulence 0.6
    turb_depth 0.3
    fog_offset 8
    fog_alt 3
}

// ---------------------------------------
// scene

object {Blackboard
       translate <0, 5.25, 5>
}

object {Desk
       translate <-2, 0, -4>
}
object {Lid2
       translate <-2, 0, -4>
}
object {Pencil
       scale 0.9
       rotate <0, 50, 0>
       translate <-1.7, 1.9, -4>
}
object {Pencil
       scale 0.9
       rotate <0, 0, 4>
       rotate <0, 80, 0>
       translate <-1.8, 2, -3.8>
}
object {Banana
       rotate <180, 40, 0>
       translate <-2.4, 2, -3.5>
}
object {Paper
       rotate <0, 10, 0>
       translate <-1.7, 1.83, -4>
}
object {Drawing
       rotate <5, 0, 0>
       rotate <0, -12, 0>
       translate <-2.21, 1.91, -4.3>
}

object {Desk
       rotate <0, 3, 0>
       translate <0.5, 0, -4.1>
}
object {Lid1
       rotate <0, 3, 0>
       translate <0.5, 0, -4.1>
}
object {Paper
      rotate <-20, 0, 0>
      rotate <0, 3, 0>
      translate <0.3, 2.3, -4.1>
}

object {Desk
       translate <3, 0, -4.05>
}
object {Lid1
       translate <3, 0, -4.05>
}

// teacher
object {Dolphin
       scale 1.7
       rotate <0, 135, 0>
       translate <-2, 1.5, 1>
}

// pupil 1
object {Dolphin
        rotate <0, 100, 0>
        rotate <0, 0, -15>
        scale 1.3
        translate <-2.5, -0.3, -4.3>
}
// pupil 2
object {Dolphin
        rotate <0, 90, 0>
        scale 1.3
        translate <0, -1.1, -4>
}
// pupil 3
object {Dolphin
        rotate <0, 75, 0>
        scale 1.3
        translate <2.5, -1.1, -4>
}

// Sea Bed
height_field {gif "floor.gif"
             scale <40, 10, 35>
             translate <-15, 0, -13>
texture {
        gradient y
        texture_map {
                    [0.04 Sand]
                    [0.06 Rocks] }
        scale 10.5
        }
}
// to hide edges of height_field !
plane { y, 0
      hollow
      texture {Sand}
}

#declare R1 = seed (34730)
#declare N = 0

#while (N < 500)
       object {Pebble
       rotate <0, rand (R1) * 360, 0>
              translate < (30-rand(R1)*40), 0.4 , (5 - rand(R1)*15) >
              }
       object {Seaweed
       rotate <0, rand (R1) * 360, 0>
              pigment {color rgb <0.3-rand(R1)/2, 0.7-rand(R1)/2, 0.4-rand(R1)/2>}
              normal {crackle 0.5}
              translate < (30-rand(R1)*40), rand(R1) , (10 - rand(R1)*15) >
              }

#declare N = N +1
#end

object {Galleon
       rotate <-30, -100, 0>
       scale 0.2
       translate <28, 0, 18>
}
object {Fish_School
       rotate <0, 120, 0>
       translate <4, 3.5, 0>
}
object {Fish_School
       translate <-4, 1, -3>
}



