// Dolphin.inc
// Include file for Detention March/April
// Internet Raytracing Competition
// Created by The Butter-Fingered Juggler



#declare Fin = union {
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.5, 0.6, 0> <0.25, 0.6, -0.2> <0.1, 0.6, -0.2> <0, 0.6, 0>
  <0.5, 0.5, 0> <0.35, 0.5, -0.1> <0.25, 0.5, -0.1> <0.1, 0.5, 0>
  <0.35, 0.15, 0> <0.25, 0.15, -0.1> <0.15, 0.15, -0.1> <0.1, 0.15, 0>
  <0, 0, 0> <0, 0, 0> <0, 0, 0> <0, 0, 0>
}
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.5, 0.6, 0> <0.25, 0.6, 0.2> <0.1, 0.6, 0.2> <0, 0.6, 0>
  <0.5, 0.5, 0> <0.35, 0.5, 0.1> <0.25, 0.5, 0.1> <0.1, 0.5, 0>
  <0.35, 0.15, 0> <0.25, 0.15, 0.1> <0.15, 0.15, 0.1> <0.1, 0.15, 0>
  <0, 0, 0> <0, 0, 0> <0, 0, 0> <0, 0, 0>
}

}

#declare Dolphin = union {
// left half body
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.05, 2, 0>, <2.9, 1.75, -0.4>, <2.7, 1.5, -0.4>, <2.5, 1.4, 0>
  <3.35, 1.5, 0>, <3.25, 1.25, -0.3>, <3.1, 1.05, -0.3>, <2.9, 0.95, 0>
  <3.65, 0.8, 0>, <3.55, 0.7, -0.2>, <3.45, 0.65, -0.2>, <3.35, 0.55,  0>
  <3.75, 0.4, 0>, <3.7, 0.3, 0>, <3.65, 0.25, 0>, <3.6, 0.2, 0>
}

bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.05, 2, 0>, <2.9, 1.75, -0.4>, <2.7, 1.5, -0.4>, <2.5, 1.4, 0>
  <2.75, 2.5, 0>, <2.6, 2.15, -0.5>, <2.4, 1.9, -0.5>, <2.1, 1.7, 0>
  <2.3, 2.8, 0>, <2.2, 2.55, -0.5>, <2, 2.25, -0.5>, <1.95, 1.8, 0>
  <1.85, 3.1, 0>, <1.7, 2.9, -0.4>, <1.5, 2.4, -0.4>, <1.45, 2.15, 0>
}

// neck
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <1.85, 3.1, 0>, <1.7, 2.9, -0.4>, <1.5, 2.4, -0.4>, <1.45, 2.15, 0>
  <1.6, 3.05, -0.3>, <1.45, 2.8, -0.3>, <1.2, 2.5, -0.3>, <1.2, 2.35, 0>
  <1.05, 3, -0.3>, <1.05, 2.8, -0.3>, <1.05, 2.6, -0.2>, <1.05, 2.45, 0>
  <0.8, 3, -0.2>, <0.8, 2.85, -0.2>, <0.8, 2.7, -0.1>, <0.8, 2.6, 0>
}
// head
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.8, 3, -0.2>, <0.6, 3.1, -0.15>, <0.45, 3.1, -0.075>, <0.3, 3, 0>
  <1.05, 3, -0.3>, <0.9, 3.2, -0.2>, <0.8, 3.3, -0.1>, <0.7, 3.4, 0>
  <1.6, 3.05, -0.3>, <1.6, 3.15, -0.25>, <1.45, 3.2, -0.2>, <1.3, 3.3, 0>
  <1.85, 3.1, 0>, <1.85, 3.1, 0>,<1.85, 3.1, 0>,<1.85, 3.1, 0>
}

// chin
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.8, 3, -0.2>, <0.8, 2.85, -0.2>, <0.8, 2.7, -0.1>, <0.8, 2.6, 0>
  <0.5, 3, -0.18>, <0.5, 2.9, -0.2>, <0.5, 2.8, -0.1>, <0.5, 2.75, 0>
  <0.2, 3, -0.09>, <0.2, 2.95, -0.1>, <0.2, 2.9, -0.05>, <0.2, 2.85, 0>
  <0.05, 3, 0>, <0, 2.97, 0>, <0, 2.94, 0>, <0.05, 2.9, 0>

}

// nose
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.08, 2.99, -0.01>, <0.1, 3.05, -0.03>, <0.1, 3.05, 0.03>, <0.08, 2.99, 0.01>
  <0.2, 2.99, -0.09>, <0.15, 3.1, -0.05>, <0.15, 3.1, 0.05>, <0.2, 2.99, 0.09>
  <0.5, 2.99, -0.18>, <0.5, 3.15, -0.1>, <0.5, 3.15, 0.1>, <0.5, 2.99, 0.18>
  <0.8, 2.99, -0.2>, <0.8, 3.2, -0.1>, <0.8, 3.2, 0.1>, <0.8, 2.99, 0.2>
}

// right half body

bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.05, 2, 0>, <2.9, 1.75, 0.4>, <2.7, 1.5, 0.4>, <2.5, 1.4, 0>
  <3.35, 1.5, 0>, <3.25, 1.25, 0.3>, <3.1, 1.05, 0.3>, <2.9, 0.95, 0>
  <3.65, 0.8, 0>, <3.55, 0.7, 0.2>, <3.45, 0.65, 0.2>, <3.35, 0.55,  0>
  <3.75, 0.4, 0>, <3.7, 0.3, 0>, <3.65, 0.25, 0>, <3.6, 0.2, 0>
}
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.05, 2, 0>, <2.9, 1.75, 0.4>, <2.7, 1.5, 0.4>, <2.5, 1.4, 0>
  <2.75, 2.5, 0>, <2.6, 2.15, 0.5>, <2.4, 1.9, 0.5>, <2.1, 1.7, 0>
  <2.3, 2.8, 0>, <2.2, 2.55, 0.5>, <2, 2.25, 0.5>, <1.95, 1.8, 0>
  <1.85, 3.1, 0>, <1.7, 2.9, 0.4>, <1.5, 2.4, 0.4>, <1.45, 2.15, 0>
}
// neck
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <1.85, 3.1, 0>, <1.7, 2.9, 0.4>, <1.5, 2.4, 0.4>, <1.45, 2.15, 0>
  <1.6, 3.05, 0.3>, <1.45, 2.8, 0.3>, <1.2, 2.5, 0.3>, <1.2, 2.35, 0>
  <1.05, 3, 0.3>, <1.05, 2.8, 0.3>, <1.05, 2.6, 0.2>, <1.05, 2.45, 0>
  <0.8, 3, 0.2>, <0.8, 2.85, 0.2>, <0.8, 2.7, 0.1>, <0.8, 2.6, 0>
}

// chin
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.8, 3, 0.2>, <0.8, 2.85, 0.2>, <0.8, 2.7, 0.1>, <0.8, 2.6, 0>
  <0.5, 3, 0.18>, <0.5, 2.9, 0.2>, <0.5, 2.8, 0.1>, <0.5, 2.75, 0>
  <0.2, 3, 0.09>, <0.2, 2.95, 0.1>, <0.2, 2.9, 0.05>, <0.2, 2.85, 0>
  <0.05, 3, 0>, <0, 2.97, 0>, <0, 2.94, 0>, <0.05, 2.9, 0>
}

// head
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <0.8, 3, 0.2>, <0.6, 3.1, 0.15>, <0.45, 3.1, 0.075>, <0.3, 3, 0>
  <1.05, 3, 0.3>, <0.9, 3.2, 0.2>, <0.8, 3.3, 0.1>, <0.7, 3.4, 0>
  <1.6, 3.05, 0.3>, <1.6, 3.15, 0.25>, <1.45, 3.2, 0.2>, <1.3, 3.3, 0>
  <1.85, 3.1, 0>, <1.85, 3.1, 0>,<1.85, 3.1, 0>,<1.85, 3.1, 0>
}

// tail fin
cone { <3.6, 0.4, 0>, 0.1
       <3.7, 0, 0>, 0
       scale <1, 1, 0.45>
}

bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.6, 0.3, 0>, <3.7, 0.1, 0>, <3.75, -0.1, 0>, <3.8, -0.2, 0>
  <3.6, 0.3, -0.1>, <3.7, 0.2, -0.1>, <3.75, -0.1, -0.1>, <3.8, -0.25, -0.1>
  <3.6, 0, -0.5>, <3.7, -0.05, -0.5>, <3.75, -0.07, -0.5>, <3.8, -0.25, -0.5>
  <3.6, -0.1, -0.7>, <3.7, -0.15, -0.7>, <3.75, -0.2, -0.7>, <3.8, -0.28, -0.7>
}

bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <3.6, 0.3, 0>, <3.7, 0.1, 0>, <3.75, -0.1, 0>, <3.8, -0.2, 0>
  <3.6, 0.3, 0.1>, <3.7, 0.2, 0.1>, <3.75, -0.1, 0.1>, <3.8, -0.25, 0.1>
  <3.6, 0, 0.5>, <3.7, -0.05, 0.5>, <3.75, -0.07, 0.5>, <3.8, -0.25, 0.5>
  <3.6, -0.1, 0.7>, <3.7, -0.15, 0.7>, <3.75, -0.2, 0.7>, <3.8, -0.28, 0.7>
}

// dorsal fin
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <2.3, 2.7, 0>, <2.45, 2.65, -0.05>, <2.6, 2.4, -0.05>, <2.8, 2.2, 0>
  <2.5, 2.75, 0>, <2.6, 2.7, -0.05>, <2.6, 2.65, -0.05>, <2.75, 2.4, 0>
  <2.7, 2.8, 0>, <2.8, 2.75, -0.05>, <2.85, 2.7, -0.05>, <2.9, 2.6, 0>
  <3.1, 2.7, 0>, <3.1, 2.7, 0>, <3.1, 2.7, 0>, <3.1, 2.7, 0>
  }
bicubic_patch
{
  type 1
  flatness 0.0
  u_steps 4
  v_steps 4
  <2.3, 2.7, 0>, <2.45, 2.65, 0.05>, <2.6, 2.4, 0.05>, <2.8, 2.2, 0>
  <2.5, 2.75, 0>, <2.6, 2.7, 0.05>, <2.6, 2.65, 0.05>, <2.75, 2.4, 0>
  <2.7, 2.8, 0>, <2.8, 2.75, 0.05>, <2.85, 2.7, 0.05>, <2.9, 2.6, 0>
  <3.1, 2.7, 0>, <3.1, 2.7, 0>, <3.1, 2.7, 0>, <3.1, 2.7, 0>
  }

object {Fin
       scale <-1,1,1> // to get orientation correct
       rotate <30, 0, 0>
       translate <1.5, 2, -0.43>
}

object {Fin
       scale <-1,1,1> // to get orientation correct
       rotate <-30, 0, 0>
       translate <1.5, 2, 0.43>
}


// eyes
sphere {<0.6, 3.75, -0.46>, 0.07
       scale <1.7, 0.8, 0.5>
       pigment {color Black}
       finish {Shiny}
}
sphere {<0.6, 3.75, 0.46>, 0.07
       scale <1.7, 0.8, 0.5>
       pigment {color Black}
       finish {Shiny}
}
texture {
        pigment {color Gray70}
        normal {bumps 0.05 scale 0.03}
        finish {Dull}
        }

} // end Dolphin union


