// School.inc
// For the Internet Raytracing Competition March/April 1997
// Created by The Butter-Fingered Juggler


// -------------------------------------------------------
// Textures etc

// used for blackboard
#declare Old_Wood1 = texture {
        pigment {
                wood
                turbulence 0.15
                color_map {
                [0.0, 0.2 color rgb <0.5, 0.4, 0.2> color rgb <0.4, 0.3, 0.4> ]
                [0.2, 0.6 color rgb <0.6, 0.3, 0.4> color rgb <0.5, 0.5, 0.1> ]
                [0.6, 1.0 color Tan color Tan] }
                }
        finish {Dull}
        }

// used for desks
#declare Old_Wood2 = texture {
        pigment {
                wood
                turbulence 0.15
                color_map {
                [0.0, 0.2 color rgb <0.5, 0.4, 0.2> color rgb <0.4, 0.3, 0.4> ]
                [0.2, 0.6 color rgb <0.6, 0.3, 0.4> color rgb <0.5, 0.5, 0.1> ]
                [0.6, 1.0 color Tan color Tan] }
                }
        normal {wrinkles 0.5 scale 10}
        finish {Dull}
        }

#declare Sand = texture {
         pigment {
                 marble
                 turbulence 1
                 color_map {
                 [0.3 color rgb <0.969, 0.767, 0.313>]
                 [0.5 color rgb <0.988, 0.848, 0.414>]
                 [0.7 color rgb <0.953, 0.750, 0.324>]}
                 }
         scale 0.05
         rotate <0, -50, 0>
         finish {crand 0.1}
}

#declare Rocks = texture {
         pigment {
                 granite
                 turbulence 0.2
                 color_map {
                 [0.3 color Gray50]
                 [0.5 color Gray70]
                 [0.7 color Gray40] }
                 }
         finish {crand 0.5}
}

// ------------------------------------------------------------
// sea bed items
#declare Pebble =
         blob {
              threshold 0.6
              sphere {<0, 0, 0>, 0.2, 1 scale <1.1, 0.5, 0.5>}
              sphere {<0, 0, -0.1>, 0.1, 1 scale <0.8, 0.3, 2>}

         pigment {
                 agate
                 color_map {
                 [0.5 color Pink]
                 [0.8 color rgb <0.65, 0.66, 0.32>] }
                 scale 0.4
                 }
}

#declare Seaweed =
bicubic_patch
{
  type 1
  flatness 0.1
  u_steps 3
  v_steps 3
  <0, 0, 0>, <0.05, 0, 0>, <0.1, 0, 0>, <0.15, 0, 0>
  <0.00, 0.8, -0.3>, <0.17, 0.8, -0.3>, <0.25, 0.8, -0.25>, <0.35, 0.8, -0.2>
  <0, 2, 0>, <0.03, 2, 0>, <0.6, 2, 0>, <0.1, 2,  0>
  <0, 2.5, 0.2>, <0.1, 2.2, 0.2>, <0.15, 2.2, 0.2>, <0.3, 2.7, 0.2>
  scale 0.5
}

#declare Bubble = 
sphere {
       <0, 0, 0>, 0.2
       texture {
               pigment {color Clear}
               finish {
                      irid {
                      0.4
                      thickness 0.2
                      turbulence 0.7 }
                      }
               }
}                                     

// ---------------------------------------
#declare Fish = union {
sphere { <0.08, 0.04, 0>, 0.015
         scale <1, 1, 2.6>
         pigment {color Gray40}
}         
sphere { <0, 0, 0>, 0.1
       scale <2, 1, 0.3> }
cone { <0, 0, 0>, 0.1
       <-0.05, 0.15, 0>, 0
       scale <1, 1, 0.3>}       
cone { <0.03, 0, 0>, 0.1
       <-0.08, -0.15, 0>, 0
       scale <1, 1, 0.3>}       
cone { <-0.15, 0, 0>, 0.02
       <-0.25, 0, 0>, 0.1
       scale <1, 1, 0.3>}       
} // end fish union

#declare R1=seed (7421)
#declare Count = 0
#declare Fish_School = union {
#while (Count < 7)
         object { Fish
                rotate <0, 20 - (rand (R1)*40), 0>
                translate < rand (R1)*5, rand (R1)*4, rand (R1)*5>
                pigment {
                        granite
                                turbulence 0.3
                                color_map {
                                [0.3 color Gray80]
                                [0.7 color Red]
                                [0.9 color rgb <0.8, 0.8, 1>]}
                                scale 0.07 - (rand (R1) / 10)
                        }
                finish {Phong_Dull}        
                }

#declare Count = Count + 1
#end


} // fish_school


// ------------------------------------------------------------
// Today's subject - detention again !

#declare Words = text {
     ttf "befrisky.ttf",
     "I must not draw in class",
     0.5, 0
     scale  .5
     translate <0, 0, -0.05> // to make text appear on blackboard
     pigment {color White}
}

#declare Blackboard = union {

// Heightfield used to give a rough surface, so that text
// looks like chalk

height_field { gif "blackb.gif"
             rotate <-90, 0, 0>
             translate <-0.5, -0.5, 0>
             scale <10, 6, 1>
             pigment {color Gray20}
}

// randomise sizes / orientations of text a little to make it
// look more like handwriting

#declare R1 = seed (3536)

object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, 2.3, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, 1.5, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, 0.7, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, 0, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, -1, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, -1.7, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <-4.5, -2.6, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, 2.1, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, 1.2, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, 0.5, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, -0.2, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, -1.1, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, -2, 0>}
object {Words
       scale <1.2 - (rand(R1) / 2.5), 1.2 - (rand (R1) / 2.5), 1> // range 1.2 to 0.8
       rotate <0, 0, 2 - (rand (R1) * 4)> // range 2 to -2
       translate <0.5, -2.8, 0>}

// frame
box { <-5.25, 3.25, 0.2>, <5.25, 3, -0.2>
texture { Old_Wood1
          rotate <5, 50, 0>
          scale 0.05
          }
}
box { <-5.25, -3.25, 0.2>, <5.25, -3, -0.2>
texture { Old_Wood1
          rotate <5, -40, 0>
          scale 0.05
          }
}
box { <-5.25, -3.25, 0.2>, <5.25, -3.2, -0.5>
texture { Old_Wood1
          rotate <5, -40, 0>
          scale 0.05
          }
}
box { <-5.25, -3.2, -0.4>, <5.25, -3.1, -0.5>
texture { Old_Wood1
          rotate <5, -40, 0>
          scale 0.05
          }
}
box { <-5, 3, 0.2>, <-5.25, -3, -0.2>
texture { Old_Wood1
          rotate <130, 0, 0>
          scale 0.05
          }
}
box { <5, 3, 0.2>, <5.25, -3, -0.2>
texture { Old_Wood1
          rotate <130, 0, 0>
          scale 0.05
          }
}

// chalks
cylinder { <-3, -3.05, -0.45>, <-2.5, -3.05, -0.43>, 0.05
         pigment {color White}
         finish {diffuse 0.8}
}
cylinder { <-1, -3.05, -0.43>, <-0.65, -3.05, -0.45>, 0.05
         pigment {color White}
         finish {diffuse 0.8}
}
//duster



} // end blackboard union

// ----------------------------------------------
// Bits and pieces

// sheet of paper
#declare Paper =
box { <-0.4, 0, -0.5>, <0.5, 0.01, 0.5>
      pigment {color White}
      finish {diffuse 0.8}
}

// Art !
#declare Drawing = union {
object {Paper}

disc { <-0.05, 0.012, 0.1>, y, 0.2
       pigment {
               gradient <1, 0, 1>
               color_map {
               [0.3 color Black]
               [0.7 color White]}
               scale 0.5
               }
}
box {<0.1, 0.012, -0.1>, <0.4, 0.01, -0.3>
    rotate <0, 36, 0>
    pigment {
            hexagon
                   color Gray70
                   color Gray50
                   color Gray30
                   scale 0.15
            }
}

} // end drawing union


// pencil
#declare Pencil = intersection {
#declare Count = 0
#while (Count < 6)
       plane { z, 0.05
              rotate <60 * Count, 0, 0>
              }
       plane { <1.25, 0, 4> , 0.15
              rotate <60 * Count, 0, 0>
              pigment {
                      gradient x
                      color_map {
                      [0.45 color Tan]
                      [0.45 color Black]}
              }
              }
#declare Count = Count + 1
#end
plane {x, 0.5}
plane {x, -0.4 inverse}

texture {
        pigment {color Red}
        finish {Glossy}
        }


} // end pencil intersection

// lunch time
#declare Banana = union {

cone { <-0.5, 0, 0>, 0.05
       <-0.4, 0, 0>, 0.1
       pigment {color Black}
}
cone { <-0.4, 0, 0>, 0.1
       <0, 0, 0>, 0.12}
sphere { <0, 0, 0>, 0.12}
cone { <0, 0, 0>, 0.12
       <0.3, 0, 0.1>, 0.1}
sphere { <0.3, 0, 0.1>, 0.1}
cone { <0.3, 0, 0.1>, 0.1
       <0.5, 0, 0.25>, 0.05}

texture {
        pigment {
                bozo
                turbulence 0.7
                color_map {
                [0.6 color Yellow]
                [0.8 color Brown]
                [0.9 color Black]}
                }
                scale 0.09
        }

} // end banana union



// ----------------------------------------------
// Old style school desk

#declare Leg =  intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, 40>}
   plane { < 0, 0,  1>, 1  rotate <40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate <-40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   plane { <0, 1, 0>, 0.66}
   scale <0.07, 2.7, 0.07>

texture {Old_Wood2
        scale 0.02
        rotate <87, 0, 0>
        }
}

#declare Lid1 =
difference {
box { <-1.1, 0, -0.9>, <1.1, 0.1, 0.9>
      texture {Old_Wood2
            rotate <0, 10, 15>
            scale 0.03
      }
}
cylinder { <-1, 0.1, 0.7>, <1, 0.1, 0.7>, 0.05
         texture {Old_Wood2
                 scale 0.02
         }
}

rotate <-20, 0, 0>
translate <0, 2.2, 0>

} // end lid diff


#declare Lid2 =
difference {
box { <-1.1, 0, -0.9>, <1.1, 0.1, 0.9>
      texture {Old_Wood2
            rotate <0, 10, 15>
            scale 0.03
      }
}
cylinder { <-1, 0.1, 0.7>, <1, 0.1, 0.7>, 0.05
         texture {Old_Wood2
                 scale 0.02
         }
}
rotate <20, 0, 0>
translate <0, 2.8, 0>

} // end lid diff

#declare Desk = union {

box { <-1, 1.83, -0.8>, <1, 1.78, 0.8>
      texture {Old_Wood2
            rotate <0, 10, 15>
            scale 0.03
      }
}

// sides
difference {    // diff used instead of clipping to get solid shapes

union {

box { <-1, 1.83, -0.8>, <1, 3, -0.7>
    texture {Old_Wood2
            scale 0.03
            }
}
box { <-1, 1.83, 0.8>, <1, 3, 0.7>
    texture {Old_Wood2
            scale 0.03
            }
}
box { <-1, 1.83, -0.8>, <-0.9, 3, 0.8>
    texture {Old_Wood2
            scale 0.03
            }
}
box { <1, 1.83, -0.8>, <0.9, 3, 0.8>
    texture {Old_Wood2
            scale 0.03
            }
}
} // end union

plane {y,0 inverse
      rotate <-20, 0,0>
      translate <0, 2.2, 0>
      texture {Old_Wood2
               scale 0.02
              }
}

} // end sides diff

object {Leg
       translate <-0.8, 0, -0.7>
}
object {Leg
       translate <0.8, 0, -0.7>
}
object {Leg
       translate <-0.8, 0, 0.7>
}
object {Leg
       translate <0.8, 0, 0.7>
}

} // end desk union

