// Andr Mecteau  ** ultramec@videotron.ca  ** 06-04-97  theme: "School"


                      // Kid's desk
#declare Desk =
union {
difference {
   box {<1.5,1.6,1> <-1.5,0.6,-1.5>}
   box {<1.3,1.45,0.8> <-1.3,0.8,-1.3> }
   box {<1.55,2.5,1.1> <-1.55,1.5,-1.55> rotate -15*x}
   cone {2*y,0.2,-2*y,0.2 translate <1.1,0,0.65>}
   cylinder {0.8*x,-0.8*x,0.13 translate <0,1.71,0.33>} }
   box {<1.51,1.5,0.5> <-1.51,1.4,-1.31> rotate -15*x }
union {
   box {<1.4,-2,-0.4> <1.45,0.64,-0.6>}
   box {<1.5,-2,0.8> <1.32,-1.9,-1.4>}
   box {<-1.4,-2,-0.4> <-1.45,0.64,-0.6>}
   box {<-1.5,-2,0.8> <-1.32,-1.9,-1.4>}
	texture {Chrome_Texture} }
 }

                       // Kid's desk with open cover

#declare Desk_L =
union {
difference {
   box {<1.5,1.6,1> <-1.5,0.6,-1.5>}
   box {<1.3,1.45,0.8> <-1.3,0.8,-1.3> }
   box {<1.55,2.5,1.1> <-1.55,1.5,-1.55> rotate -15*x}
   cone {2*y,0.2,0.7*y,0.2 translate <1.1,0,0.65>}
   cylinder {0.8*x,-0.8*x,0.13 translate <0,1.71,0.33>} }
   box {<1.51,1.5,0.5> <-1.51,1.4,-1.31> rotate 50*x translate <0,1,-1.4>}
union {
   box {<1.4,-2,-0.4> <1.45,0.64,-0.6>}
   box {<1.5,-2,0.8> <1.32,-1.9,-1.4>}
   box {<-1.4,-2,-0.4> <-1.45,0.64,-0.6>}
   box {<-1.5,-2,0.8> <-1.32,-1.9,-1.4>}
	texture {Chrome_Texture} }
 }
                      // The Chair

#declare Chair =
union {
   superellipsoid {<0.3, 0.2> scale <1,0.16,1> }
   cone {<-0.9,1.78,-0.8>, 0.05 <-0.8,0,-0.7> 0.1}
   cone {<0.9,1.78,-0.8>, 0.05 <0.8,0,-0.7> 0.1 }
   cone {<0.6,1.78,-0.85>, 0.025 <0.55,0,-0.75> 0.05 }
   cone {<-0.6,1.78,-0.85>, 0.025 <-0.55,0,-0.75> 0.05 }
   cone {<0.3,1.78,-0.85>, 0.020 <0.25,0,-0.88> 0.045 }
   cone {<-0.3,1.78,-0.85>, 0.020 <-0.25,0,-0.88> 0.045 }
   cone {<0,1.78,-0.88>, 0.020 <0,0,-0.88> 0.045 }
difference {
superellipsoid {<0.5, 0.2> scale <1.05,0.22,0.1> translate <0,1.9,-0.82> }
superellipsoid {<0.5, 0.2> scale <0.75,0.1,0.9> translate <0,1.9,-0.82> } }
   cone {<-1,-2,-1>, 0.07 <-0.8,0,-0.7> 0.12}
   cone {<1,-2,-1>, 0.07 <0.8,0,-0.7> 0.12}
   cone {<-1,-2,1>, 0.07 <-0.8,0,0.7> 0.12}
   cone {<1,-2,1>, 0.07 <0.8,0,0.7> 0.12}
         scale 0.9}

                      // The Broken Chair

#declare Broken_Chair =
union {
   superellipsoid {<0.3, 0.2> scale <1,0.16,1> }
   cone {<-0.9,1.78,-0.8>, 0.05 <-0.8,0,-0.7> 0.1}
   cone {<0.9,1.78,-0.8>, 0.05 <0.8,0,-0.7> 0.1 }
   cone {<0.6,1.78,-0.85>, 0.025 <0.55,0,-0.75> 0.05 }
   cone {<-0.6,1.78,-0.85>, 0.025 <-0.55,0,-0.75> 0.05 }
cone {<0.3,1.78,-0.85>, 0.020 <0.25,1,-1.1> 0.045 }
cone {<0.3,0.9,-1.2>, 0.020 <0.25,0.1,-0.9> 0.045 }
cone {<-0.3,1.78,-0.85>, 0.020 <-0.25,1.1,-1.2> 0.045}
cone {<-0.3,0.7,-1.3>, 0.020 <-0.25,0.1,-0.9> 0.045}
cone {<0,1.78,-0.88>, 0.020 <0,1.6,-0.1> 0.045 }
cone {<0.1,0.7,-0.99>, 0.020 <0,0.1,-0.9> 0.045 }
difference {
superellipsoid {<0.5, 0.2> scale <1.05,0.22,0.1> translate <0,1.9,-0.82> }
superellipsoid {<0.5, 0.2> scale <0.75,0.1,0.9> translate <0,1.9,-0.82> } }
   cone {<-1,-2,-1>, 0.07 <-0.8,0,-0.7> 0.12}
   cone {<1,-2,-1>, 0.07 <0.8,0,-0.7> 0.12}
   cone {<-1,-2,1>, 0.07 <-0.8,0,0.7> 0.12}
   cone {<1,-2,1>, 0.07 <0.8,0,0.7> 0.12}
      texture {DMFWood6 rotate 5*x scale 1.4} scale 0.9 }

#declare Broken_Chair_2 =
union {
   superellipsoid {<0.3, 0.2> scale <1,0.16,1> }
   cone {<-0.9,1.78,-0.8>, 0.05 <-0.8,0,-0.7> 0.1}
   cone {<0.9,1.78,-0.8>, 0.05 <0.8,0,-0.7> 0.1 }
   cone {<0.6,1.78,-0.85>, 0.025 <0.55,0,-0.75> 0.05 }
   cone {<-0.6,1.78,-0.85>, 0.025 <-0.55,0,-0.75> 0.05 }
cone {<0.3,1.78,-0.85>, 0.020 <0.25,1,-0.6> 0.045 }
cone {<0.3,0.9,-0.36>, 0.020 <0.25,0.1,-0.9> 0.045 }
cone {<-0.3,1.78,-0.85>, 0.020 <-0.25,1.1,-0.64> 0.045}
cone {<-0.3,0.7,-0.45>, 0.020 <-0.25,0.1,-0.9> 0.045}
cone {<0,1.78,-0.88>, 0.020 <0,1,-0.41> 0.045 }
cone {<0.1,1.1,-0.39>, 0.020 <0,0.1,-0.83> 0.045 }
difference {
superellipsoid {<0.5, 0.2> scale <1.05,0.22,0.1> translate <0,1.9,-0.82> }
superellipsoid {<0.5, 0.2> scale <0.75,0.1,0.9> translate <0,1.9,-0.82> } }
   cone {<-1,-2,-1>, 0.07 <-0.8,0,-0.7> 0.12}
   cone {<1,-2,-1>, 0.07 <0.8,0,-0.7> 0.12}
   cone {<-1,-2,1>, 0.07 <-0.8,0,0.7> 0.12}
   cone {<1,-2,1>, 0.07 <0.8,0,0.7> 0.12}
      texture {DMFWood6 rotate 5*x scale 1.4} scale 0.9}

	                   // The blackboard

#declare Blackboard =
   box {<-12,14,5.8> <12,4,6> pigment { image_map {tga "3x7.tga"}
       scale <21.5,12,1> translate <8,2.3,0>}
               finish {phong_size 33 phong 0.2} }
   box {<-12.5,14.5,5.9> <12.5,3.5,6> texture {Silver1}}
   box {<-12.5,4,5.4> <12.5,3.5,6> texture {Silver1}}

                      // The rock poster

#declare Poster =
 box {<4.5,0,0> <-4.5,9,0.05> pigment { image_map {tga "ram-lead.tga"}
	       scale <9,9,9> translate <-4.5,0,0>}
	finish {phong_size 130 phong 0.7 ambient 0.3}
	normal { dents 2 turbulence 4.1 scale 2.1} }

                      // The other rock poster

#declare Poster_2 =
    box {<4.5,0,0> <-4.5,9,0.05> pigment { image_map {tga "ramon1.tga"}
	       scale <9,9,9> translate <-4.5,0,0>}
	finish {phong_size 130 phong 0.7 ambient 0.3} }

                      // Teacher's floor

#declare Floor =
union {
   box {<22,0,6> <-32,-1,-4> texture {DMFWood6 scale 0.3 rotate <0.1,90,0>}}
   cylinder {22*x, -22*x, 0.1 translate <0,-0.5,-4.1>}
   cylinder {22*x, -22*x, 0.1 translate <0,0,5.9>}
        texture {DMFWood6 scale 0.4 rotate 20*y}}

                      // Garbage

#declare Garb =
difference {
    cone {1.8*y,  0.8, 0*y, 0.6 }
    cone {1.9*y,  0.78, 0.02*y, 0.58 open}
	pigment {White} finish {phong 0.8 phong_size 144}}


                      // teacher's desk
#declare Desk1 =
union {
   box {<3,4,1> <-3,0.5,-3>}
   box {<3.2,4.1,1.1> <-3.2,4,-3.1>}
   box {<3.2,4.1,-3.2> <2.8,0,-2.9>}
   box {<-3.2,4.1,-3.2> <-2.8,0,-2.9>}
   box {<3.2,4.1,1.2> <2.8,0,0.9>}
   box {<-3.2,4.1,1.2> <-2.8,0,0.9>}
       texture {DMFWood6 scale 0.1 rotate <0,88,0>}}

                      // Clock
#declare Clock =
union {
difference {
    cone {0.5*z,  1, 0*z, 1 }
    cone {0.25*z,  0.9, -0.2*z, 0.9 open}
    cone {0.25*z,  0.9, 0.05*z, 0.93 open}
  	pigment {White} finish {phong 1} }
    cone {<-0.05,0,0.219>,0.05,<0.05,0,0.22>, 0.05 texture {Chrome_Texture} }
	cone {<0,0,0.23>,0.04,<0,0.8,0.23>, 0.04 pigment {Black} rotate 0*z }
    cone {<0,0,0.235>,0.047,<0,0.5,0.235>, 0.047 pigment {Black} rotate 148*z }
    cone {<0,-0.45,0.225>,0.025,<0,0.85,0.225>, 0.006 pigment {Red} rotate 70*z }
text { ttf "timrom.ttf" "12" 0.1, 0 pigment { Black }
  scale 0.4 translate <-0.175,0.6,0.4>}
text { ttf "timrom.ttf" "6" 0.1, 0 pigment { Black }
  scale 0.4 translate <-0.1,-0.87,0.4>}
text { ttf "timrom.ttf" "9" 0.1, 0 pigment { Black }
  scale 0.4 translate <-0.8,-0.1,0.4>}
text { ttf "timrom.ttf" "3" 0.1, 0 pigment { Black }
  scale 0.4 translate <0.7,-0.12,0.4>} }


                      // Walls'n ceiling

#declare Wall_L =
union {
difference {
   box {<-16,25,6> <-13.9,-3,-72>}
   box {<-17,23,-4> <-12,2,-17>}
   box {<-17,23,-19> <-12,2,-33>}
   box {<-17,23,-35> <-12,2,-48>} }
   box {<-14,1,6> <-13.4,-3,-72>}
   box {<-15,25,5> <-13.4,19,-4>} }
difference {
   box {<0.1,1,1> <-0.1,-1,-1> pigment {White} }
   box {<0.8,0.9,0.9> <-0.5,-0.9,-0.9> pigment {White} }
        scale <2,11,7> translate <-21.3,13,-11>}

difference {
   box {<0.1,1,1> <-0.1,-1,-1> pigment {White} }
   box {<0.8,0.9,0.9> <-0.5,-0.9,-0.9> pigment {White} }
        scale <2,11,7> translate <-21.3,13,-26>}

difference {
   box {<0.1,1,1> <-0.1,-1,-1> pigment {White} }
   box {<0.8,0.9,0.9> <-0.5,-0.9,-0.9> pigment {White} }
        scale <2,11,7> translate <-21.3,13,-41>}

#declare Wall_R =
union {
difference {
   box {<12.5,25,6> <13,-3,-72>}
   box {<12,10,-7> <16,-1,-12>}
   box {<12,15,-8> <16,18,-11>}
   box {<12,15,-12> <16,18,-15>}
   box {<12,15,-16> <16,18,-19>} }
   box {<12,25,6> <14,19,-72>}
difference {
   box {<12.3,1,6> <13,-3,-72>}
   box {<12,12,-7> <17,-1,-12>} }
   box {<12.3,1,-5.5> <13,11.5,-7>}
   box {<12.3,1,-12> <13,11.5,-13.5>}
   box {<12.3,10,-7> <13,11.5,-12>}

                    // The door
difference {
   box {<12.55,9.9,-7.1> <13,-0.4,-11.9>}
   box {<12,9,-7.5> <14,8,-11.5>}
   box {<12,6.8,-7.5> <14,7.8,-11.5>}
       texture {DMFWood6 scale 4 rotate <90,4,0>} }
   box {<12.5,4,-11.2> <12.4,3,-11.7> texture {Silver2} }
   sphere {0, 1 scale <0.1,0.2,0.2> translate <12.3,3.7,-11.45>
		texture {Silver1} }
	}


#declare Wall_F =
union {
   box {<-25,25,6> <25,-3,7>}
   box {<-25,25,5> <25,19,6>}
   box {<-25,1,5.5> <25,-3,7>} }

#declare Ceiling =
union {
   box {<-36,25,7> <36,27,-72> }
   box {<-22,24,7> <-20,27,-72> }
   box {<22,24,7> <18,27,-72> }
   box {<-36,24,4> <36,27,5.5> }
}

		         // Neon box

#declare Neon_lite =
union {
   cylinder {2.05*x, -2.05*x, 0.06 pigment {White }
     finish { ambient 0.1 diffuse 0.9 phong 0.8 phong_size 150} }
   cylinder {2*x, 2.12*x, 0.062 texture {Silver_Texture} }
   cylinder {-2*x, -2.12*x, 0.062 texture {Silver_Texture} }
   cylinder {-2.12*x, -2.14*x, 0.008 texture {Silver1} }
   cylinder {2.12*x, 2.14*x, 0.008 texture {Silver1} } }

#declare Neon =
union {
difference {
   box { <-2.15,-0.6,-1> <2.15,0,0> }
   box { <-2.13,-0.7,-0.97> <2.13,-0.1,-0.07> }
   box { <-2.13,-0.7,-1.1> <2.13,-0.3,0.1> }
	pigment {rgb <0.979,0.898,0.979>} finish {Shiny}}
   object {Neon_lite  translate <0,-0.5,-0.2>}
   object {Neon_lite  translate <0,-0.5,-0.4>}
   object {Neon_lite  translate <0,-0.5,-0.6>}
   object {Neon_lite  translate <0,-0.5,-0.8>} }

#declare Neon_Box =
difference {
   box { <-2.15,-0.6,-1> <2.15,0,0> }
   box { <-2.13,-0.65,-0.97> <2.13,-0.05,-0.07> }
   box { <-2.13,-0.7,-1.1> <2.13,-0.3,0.1> }
	pigment {rgb <0.979,0.898,0.979>} finish {Shiny}}



#declare Ss =
union {
   box {<-23,3,-4.1> <-24,3.02,-16.9> }
   box {<-23.5,25,-10.5> <-23.51,3,-10.556> }
   box {<-23.5,25,-4.5> <-23.51,3,-4.556> }
   box {<-23.5,25,-16.4> <-23.51,3,-16.455> } }

#declare Store =
union {
   object {Ss}
   object {Ss translate y*1*0.5}
   object {Ss translate y*1*1}
   object {Ss translate y*1*1.5}
   object {Ss translate y*1*2}
   object {Ss translate y*1*2.5}
   object {Ss translate y*1*3}
   object {Ss translate y*1*3.5}
   object {Ss translate y*1*4}
   object {Ss translate y*1*4.5}
   object {Ss translate y*1*5}
   object {Ss translate y*1*5.5}
   object {Ss translate y*1*6}
   object {Ss translate y*1*6.5}
   object {Ss translate y*1*7}
   object {Ss translate y*1*7.5}
   object {Ss translate y*1*8}
   object {Ss translate y*1*8.5}
   object {Ss translate y*1*9}
   object {Ss translate y*1*9.5}
   object {Ss translate y*1*10}
   object {Ss translate y*1*10.5}
   object {Ss translate y*1*11}
   object {Ss translate y*1*11.5}
   object {Ss translate y*1*12}
   object {Ss translate y*1*12.5}
   object {Ss translate y*1*13}
   object {Ss translate y*1*13.5}
   object {Ss translate y*1*14}
   object {Ss translate y*1*14.5}
   object {Ss translate y*1*15}
   object {Ss translate y*1*15.5}
   object {Ss translate y*1*16}
   object {Ss translate y*1*16.5}
   object {Ss translate y*1*17}
   object {Ss translate y*1*17.5}
   object {Ss translate y*1*18}
   object {Ss translate y*1*18.5}
   object {Ss translate y*1*19}
   object {Ss translate y*1*19.5}
   object {Ss translate y*1*20}
   object {Ss translate y*1*20.5}
   object {Ss translate y*1*21}
   object {Ss translate y*1*21.5}
   object {Ss translate y*1*22}
   object {Ss translate y*1*22.5}
   object {Ss translate y*1*23}
   object {Ss translate y*1*23.5}
   object {Ss translate y*1*24}
   object {Ss translate y*1*24.5} }


#declare Sky =
pigment { wrinkles turbulence 0.62 octaves 6 omega 0.71 lambda 2
    color_map { [0.0, 0.12   color red 0.85 green 0.85 blue 0.85
                             color red 0.75 green 0.75 blue 0.75]
                [0.12, 0.5   color red 0.75 green 0.75 blue 0.75
                             color rgb <0.227, 0.257, 0.433>]
                [0.5, 1.001  color rgb <0.227, 0.257, 0.433>
                             color rgb <0.217, 0.267, 0.333>] }
    scale <6.09, 1.102, 6.022>}


                      // Broken glass


#declare Violenced_Neon =
union {

#declare Broken_Neon =

union {
difference {
   cylinder {2.05*x, 0*x, 0.06  }
   sphere {0, 1 scale <1,0.08,1> } pigment {White}}
   cylinder {2*x, 2.12*x, 0.062 texture {Silver_Texture} }
   cylinder {2.12*x, 2.14*x, 0.008 texture {Silver1} } }

   object {Broken_Neon}
   object {Broken_Neon rotate <45,59,0>}

#declare Little_Piece_Of_Glass =

union {
#declare Broken_Glass =
difference {
   cylinder {0.8*x, 0*x, 0.06 pigment {White }
      finish { ambient 0.1 diffuse 0.9 phong 0.8 phong_size 150} }
   sphere {0, 1 scale <1,0.08,1> pigment {White }
      finish { ambient 0.1 diffuse 0.9 phong 0.8 phong_size 150} }
      rotate 90*x translate -0.06*y}

#declare Piece_Of_Glass =

union {
   object {Broken_Glass}
   object {Broken_Glass scale 2 translate <-1,0,-1>}
   object {Broken_Glass rotate 45*y scale 0.3 translate <-1.3,0,-0.1>}
   object {Broken_Glass rotate 20*y scale 0.8 translate <-0.5,0,0.1>}
   object {Broken_Glass rotate 40*y scale 0.7 translate <-0.5,0,-0.3>}
   object {Broken_Glass rotate 60*y scale 0.6 translate <0.3,0,-0.1>}
   object {Broken_Glass rotate 190*y scale 0.4 translate <0.2,0,-0.2>}
   object {Broken_Glass rotate 290*y scale 0.1 translate <-0.2,0,0.37>}
   object {Broken_Glass rotate 10*y scale 0.5 translate <-0.1,0,0.19>}
   object {Broken_Glass rotate 11*y scale 0.2 translate <-0.3,0,0.17>}
   object {Broken_Glass rotate 16*y scale 0.6 translate <-0.1,0,0.15>}
   object {Broken_Glass rotate 12*y scale 0.3 translate <0.1,0,0.8>} }

   object {Piece_Of_Glass}
   object {Piece_Of_Glass rotate 45*y translate -1*x} }

#declare Very_Little_Piece_Of_Glass =

union {
   object {Little_Piece_Of_Glass}
   object {Little_Piece_Of_Glass translate <0,0,-0.4>}
   object {Little_Piece_Of_Glass  rotate 22*y translate <1,0,0>} }

   object { Very_Little_Piece_Of_Glass }
   object { Very_Little_Piece_Of_Glass rotate -45*y scale 0.8  } }

// The color of file
#declare Lite_Yl =
pigment {rgb <0.992,0.979,0.522>}

#declare File =
union {
difference {
   box {<-1.2,-0.5,-3> <1.2,8.6,0>}
   box {<-1.02,-0.25,-4> <1.02,8.35,-0.15>}
   box {<-1.19,-0.46,-1.9> <1.19,8.57,-0.1>}  }
		   box {<-1.2,1.77,-3> <1.2,1.94,0>}
		   box {<-1.2,3.97,-3> <1.2,4.14,0>}
		   box {<-1.2,6.17,-3> <1.2,6.33,0>}
        pigment {rgb <0.992,0.979,0.522>}
        finish {Shiny}
}

           // The drawer
#declare Drawer =
union {
difference {
   box {<-1,0,-3> <1,2,0>}
   sphere {y, 1 scale <0.06,0.09,0.02> translate <0,0.37,-2.99>}
   box {<-2,1.1,-2.8> <2,3,1>}
   box {<-0.98,0.1,-2.98> <0.98,1.98,-0.18>}
   box {<-0.98,0.1,-0.18> <0.98,1,-0.08>}
        pigment {Lite_Yl} finish {Shiny}
		}

           // Handle

difference {
   box {<-0.3,0.64,-3.23> <0.3,0.7,-2.9>}
   box {<-0.28,-0.9,-3.21> <0.28,0.9,-2.99>}
         texture {Aluminum} }

          // Sticker
difference {
   box {<-0.35,1.3,-3.01> <0.35,1.65,-3>}
   box {<-0.3,1.35,-3.2> <0.3,1.6,-2.99>}
         texture {Aluminum} }

   sphere {y, 1 scale <0.06,0.05,0.06> translate <0,0.44,-3.01>
          texture {Aluminum} }
union {
   cylinder {<0.9,1.5,-2.89>,<0.9,1.5,-0.22>,0.03}
   cylinder {<0.9,1.5,-0.22>,<0.9,0.1,-0.22>,0.03}
   cylinder {<-0.9,1.5,-2.89>,<-0.9,1.5,-0.22>,0.03}
   cylinder {<-0.9,1.5,-0.22>,<-0.9,0.1,-0.22>,0.03}
   cylinder {<-0.9,0.1,-0.22>,<0.9,0.1,-0.22>,0.03}
   cylinder {<-0.9,1.5,-2.89>,<0.9,1.5,-2.89>,0.03}
             pigment {Black} finish {Metal} }
	 }


#declare File_1 =

union {
object {File}
object {Drawer translate <0,-0.24,-2.7>}
object {Drawer translate <0,1.96,-1>}
object {Drawer translate <0,6.35,-0.4>}
}

                   //   terrestrial globe
#declare Earth =
union {
   sphere {y, 1.9 pigment { image_map {tga "earth.tga" map_type 1}
    rotate <125,0,0> scale <2,2,3> translate <0,0,0>}
   finish {phong 0.1 phong_size 0.6 reflection 0.15 refraction 0.21}
   translate <0,-1,0> }
union {
difference {
   torus {2.4,0.1}
   box {<4,1,4> <0,-1,-4>}
   box {<-4,1,4> <0,0.02,-4>}
   box {<-4,-1,4> <0,-0.02,-4>}
    }
   sphere {y, 0.1 translate <-0.04,-1,2.4> }
   cone {<-0.04,0,2.4>, 0.1 <-0.04,0,2>, 0.05}
   cone {<-0.04,0,2>, 0.06 <-0.04,0,1.9>, 0.3 texture {Aluminum}}
   cone {<-0.04,0,-2.4>, 0.1 <-0.04,0,-2>, 0.05}
   cone {<-0.04,0,-2>, 0.06 <-0.04,0,-1.9>, 0.3 texture {Aluminum}}
   cone {<-0.04,0,-2.4>, 0.1 <-0.04,0,-3>, 0.12}
   cone {<-0.04,0,-3>, 0.12 <-0.04,0,-3.2>, 0.5}
   cone {<-0.04,0,-3.2>, 0.5 <-0.04,0,-3.25>, 0.5 open }
   cone {<-0.04,0,-3.25>, 0.5 <-0.04,0,-3.4>, 1.2 open}
   cone {<-0.04,0,-3.4>, 1.2 <-0.04,0,-3.6>, 1.2 open}
          texture {Bronze_Metal} } rotate <-26.55,0,30>}

			  // Books

#declare Book_A =
union {
difference {
   cone {<0,0,1>,0.1 <0,0,0>,0.1 open }
   cone {<0,0,1>,0.1 <0,0,-1>,0.1 open translate 0.03*x} }
   cone {<-0.01,0,0.75>,0.1 <-0.01,0,0.76>,0.1 texture {Silver1} }
   cone {<-0.01,0,0.84>,0.1 <-0.01,0,0.85>,0.1 texture {Silver1} }
   box {<0,-0.1,1> <0.95,-0.11,0>}
   box {<0,0.1,1> <0.95,0.11,0>}
difference {
   box {<0.2,0.112,0.8> <0.65,0.1121,0.6> }
   box {<0.22,0.2,0.78> <0.63,0,0.62> } texture {Silver1}}
difference {
   box {<0,-0.09,0.05> <0.95,0.09,0.98> }
   cone {<0.98,0,1>,0.1 <0.98,0,0>,0.1} pigment {White}} }

#declare Red_Book =
   object {Book_A pigment {rgb <0.80,0.25,0.20>}
           scale <0.7,0.7,0.7> finish {phong 0.3 phong_size 14} }

#declare Green_Book =
    object {Book_A scale 1.1 pigment {rgb <0.20,0.45,0.20>} }

#declare Pale_Blue_Book =
    object {Book_A  scale <1,1.3,1.1> pigment {rgb <0.80,0.87,0.94>} }

#declare Blue_Book =
    object {Book_A  scale <1,1.3,1.1> pigment {rgb <0.20,0.27,0.34>} }

#declare Open_Book =
union {
difference {
   cone {<0,0,1>,0.3 <0,0,0>,0.3 open }
   cone {<0,0,1>,0.3 <0,0,-1>,0.3 open translate 0.03*x}
   box {<1,0.02,2> <-1,-2,-2> } pigment {White}}
   box {<0,0.3,1> <0.95,0.2999,0> pigment {White}}
difference {
   cone {<0,0,1>,0.299 <0,0,0>,0.299 pigment {White}}
   box {<1,0.02,2> <-1,-2,-2> } pigment {White} }
difference {
   box {<0.1,0.01,1> <1.2,0.3,0>}
   cone {<0.77,0.25,1.2>,0.3 <0.77,0.25,-0.2>,0.3
         scale <2,1.1,1>} pigment {White} }
difference {
   cone {<-0.6,0,1>,0.3 <-0.6,0>,0.3 open}
   cone {<0,0,1>,0.3 <0,0,-1>,0.3 open translate -0.63*x}
   box {<1,0.02,2> <-1,-2,-2> } pigment {White}}
   box {<-0.6,0.3,1> <-1.55,0.2999,0> pigment {White}}
   box {<-0.2,-0.01,1.05> <1.2,-0.02,-0.05> pigment {Green}}
difference {
   cone {<-0.6,0,1>,0.299 <-0.6,0,0>,0.299 pigment {White}}
   box {<1,0.02,2> <-1,-2,-2> } pigment {White} }
difference {
   box {<-0.6,0.01,1> <-1.75,0.3,0>}
   cone {<-1.06,0.25,1.2>,0.3 <-1.06,0.25,-0.2>,0.3
         scale <2,1.1,1>} pigment {White} }
   box {<-0.4,-0.01,1.05> <-1.8,-0.02,-0.05> pigment {Green}}
difference {
   cone {<-0.3,0.13,-0.05>,0.2 <-0.3,0.13,1.05>,0.2 open }
   box {<-1.4,-0.019,2> <1.4,1.1,-1>}
   cone {<-0.3,0.136,-1>,0.2 <-0.3,0.136,2>,0.2} pigment {Green}} }


#declare Open_Book_2 =
union {
difference {
   cone {<-0.6,0,1>,0.3 <-0.6,0>,0.3 open}
   cone {<0,0,1>,0.3 <0,0,-1>,0.3 open translate -0.63*x}
   box {<1,0.02,2> <-1,-2,-2> } }
   box {<-0.6,0.3,1> <-1.55,0.2999,0>}
   box {<-0.2,-0.01,1.05> <1.2,-0.02,-0.05> pigment {Red}}
difference {
   cone {<-0.6,0,1>,0.299 <-0.6,0,0>,0.299}
   box {<1,0.02,2> <-1,-2,-2> } }
difference {
   box {<-0.6,0.01,1> <-1.75,0.3,0>}
   cone {<-1.06,0.25,1.2>,0.3 <-1.06,0.25,-0.2>,0.3
         scale <2,1.1,1>} }
   box {<-0.4,-0.01,1.05> <-1.8,-0.02,-0.05> pigment {Red}}
difference {
   cone {<-0.3,0.13,-0.05>,0.2 <-0.3,0.13,1.05>,0.2 open}
   box {<-1.2,-0.012,2> <1.2,1.1,-1>}
   cone {<-0.3,0.136,-1>,0.2 <-0.3,0.136,2>,0.2} pigment {Red} }
difference {
   cone {<-0.15,0.1,1.15>,0.2 <-0.15,0.1,-0.05>,0.2 open}
   box {<-1.2,-0.02,2> <1.2,0.4,-1>}
   cone {<-0.15,0.1,2>,0.199 <-0.15,0.1,-2>,0.199} pigment {Red} }
   box {<-1.8,-0.01,-0.05> <-0.3,-0.02,1.15> pigment {Red}}
   box {<-0.1,-0.01,-0.05> <1.5,-0.02,1.15> pigment {Red}}
difference {
   cone {<0.2,0,1>,0.29 <0.2,0,0>,0.29 scale <3,1,1>}
   box {<2,0,2> <-2,-2,-2> }
   cone {<1.7,0,-0.3>,0.5 <1.7,0,1>,0.5 translate 0.45*y} }
difference {
   cone {<-0.3,0,1>,0.29 <-0.3,0,0>,0.29 scale <3,1,1>}
   box {<2,0,2> <-2,-2,-2> }
   cone {<-2,0,-0.3>,0.5 <-2,0,1>,0.5 translate 0.45*y} }
difference {
   cone {<-0.86,0,1>,0.7 <-0.86,0,0>,0.7 open}
   cone {<-0.86,0,1.1>,0.699 <-0.86,0,-0.1>,0.699}
   box {<-4,6,1.5> <-1.3,-6,-0.3>}
   box {<4,-4,3> <-4,0,-3>} }
difference {
   cone {<0.47,0,1>,0.7 <0.47,0,0>,0.7 open}
   cone {<0.47,0,1.1>,0.699 <0.47,0,-0.1>,0.699}
   box {<4,6,-2> <0.9,-6,2>}
   box {<-4,-5,-3> <4,0,3>} }
difference {
   cone {<-1.15,0,1>,1 <-1.15,0,0>,1 open}
   cone {<-1.15,0,1.1>,1 <-1.15,0,-0.1>,0.999}
   box {<-4,6,1.5> <-1.25,-6,-0.3>}
   box {<4,-4,3> <-4,0,-3>} }
difference {
   cone {<0.85,0,1>,1 <0.85,0,0>,1 open}
   cone {<0.85,0,1.1>,1 <0.85,0,-0.1>,0.999}
   box {<4,6,-2> <0.85,-6,2>}
   box {<-4,-5,-3> <4,0,3>} }
difference {
   cone {<1.14,0,1>,1.3 <1.14,0,0>,1.3 open}
   cone {<1.14,0,1.1>,1.299 <1.14,0,-0.1>,1.299}
   box {<4,6,-2> <0.75,-6,2>}
   box {<-4,-5,-3> <4,0,3>} }
difference {
   cone {<-1.44,0,1>,1.3 <-1.44,0,0>,1.3 open}
   cone {<-1.44,0,1.1>,1.299 <-1.44,0,-0.1>,1.299}
   box {<-8,6,-2> <-1.05,-6,2>}
   box {<-5,-8,5> <1,0,-5>} }
difference {
   cone {<-1.73,0,1>,1.6 <-1.73,0,0>,1.6}
   cone {<-1.73,0,1.1>,1.599 <-1.73,0,-0.1>,1.599}
   box {<-8,6,-2> <-0.8,-6,2>}
   box {<-5,-8,5> <1,0,-5>} }
difference {
   cone {<1.43,0,1>,1.6 <1.43,0,0>,1.6 open}
   cone {<1.43,0,1.1>,1.599 <1.43,0,-0.1>,1.599}
   box {<4,6,-2> <0.55,-6,2>}
   box {<-9,-8,-3> <9,0,3>} }
difference {
   cone {<-2.31,0,1>,2.2 <-2.31,0,0>,2.2}
   cone {<-2.31,0,1.1>,2.199 <-2.31,0,-0.1>,2.199}
   box {<-8,6,-2> <-0.58,-6,2>}
   box {<-9,-8,5> <9,0,-5>} }
difference {
   cone {<2.01,0,1>,2.2 <2.01,0,0>,2.2}
   cone {<2.01,0,1.1>,2.199 <2.01,0,-0.1>,2.199}
   box {<11,6,-2> <0.33,-6,2>}
   box {<-9,-8,-3> <9,0,3>} }
   box {<-0.15,1.5,1> <-0.1501,0,0>} pigment {White} }

#declare Open_Book_3 =
union {
difference {
   cone {<0,0,1>,0.1 <0,0,0>,0.1 open }
   cone {<0,0,1>,0.1 <0,0,-1>,0.1 open translate 0.03*x} }
   cone {<-0.01,0,0.75>,0.1 <-0.01,0,0.76>,0.1 texture {Bronze_Metal} }
   cone {<-0.01,0,0.84>,0.1 <-0.01,0,0.85>,0.1 texture {Bronze_Metal} }
   box {<0,-0.1,1> <0.95,-0.11,0>}
union {
   box {<0,0.1,1> <0.95,0.11,0>}
difference {
   box {<0.2,0.112,0.8> <0.65,0.1121,0.6> }
   box {<0.22,0.2,0.78> <0.63,0,0.62> } texture {Bronze_Metal}}
    rotate 193*z translate 0.2*y}
difference {
   box {<0,-0.09,0.05> <0.95,0.09,0.98>}
   cone {<0.98,0,1>,0.1 <0.98,0,0>,0.1} pigment {White}}
difference {
   cone {<0,0,1>,1 <0,0,0>,1 open}
   box {<1,0.1,2> <-1,-3,-1>}
   box {<-0.7,-9,-2> <3,9,2>}
   cone {<0,0,2>,0.999 <0,0,-2>,0.999}
         pigment {White} translate <1.01,0,0>}
         pigment {rgb <0.491,0.430,0.577>} }

                // Smashed mirror

#declare T =
triangle {<-1,  0, -0.8> < 0.9,  0, -1.1> < 0,  0,  1>
		  translate 0.02*y}

#declare BM =
union {
object {T scale <0.2,1,0.1> translate <0,0,-0.3>}
object {T scale <0.1,1,0.1> translate <-0.5,0,0.3>}
object {T scale <0.2,1,0.3> translate <-0.3,0,0.6>}
object {T scale <0.1,1,0.3> translate <-0.7,0,-0.1>}
object {T scale <0.2,1,0.1> translate <0,0,0.2>}
object {T scale <0.05,1,0.1> translate <0.2,0,0>}
object {T scale <0.3,1,0.15> translate <0.5,0,-0.2>}
object {T scale <0.1,1,0.11> translate <0.6,0,-0.5>}
object {T scale <0.3,1,0.07> translate <0.8,0,-0.8>}
}

#declare Smashed_Mirror =
union {
object {BM}
object {BM scale 0.5 rotate 55*y}
object {BM scale 0.4 rotate 155*y translate <0.6,0,0.4>}
object {BM scale 0.3 rotate 15*y translate <-0.6,0,-0.4>}
object {BM scale 0.2 rotate 190*y translate <0.1,0,0.2>}
object {BM scale 0.6 rotate 85*y translate <-1,0,-1>}
}

